/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.integration.ar.AccountsReceivableMilestoneSchedule;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class MilestoneSchedule
extends PersistableBusinessObjectBase
implements AccountsReceivableMilestoneSchedule {
    private static final String MILESTONE_SCHEDULE_INQUIRY_TITLE_PROPERTY = "message.inquiry.milestone.schedule.title";
    private String proposalNumber;
    private String chartOfAccountsCode;
    private String accountNumber;
    private List<Milestone> milestones = new ArrayList<Milestone>();
    private Account account;
    private Chart chart;
    private ContractsAndGrantsBillingAward award;
    private ContractsAndGrantsBillingAwardAccount awardAccount;
    private transient String proposalNumberForAwardAccountLookup;
    private transient String chartOfAccountsCodeForAwardAccountLookup;
    private transient String accountNumberForAwardAccountLookup;

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public KualiDecimal getTotalAmountScheduled() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (Milestone milestone : this.milestones) {
            if (!ObjectUtils.isNotNull((Object)milestone.getMilestoneAmount()) || !milestone.isActive()) continue;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)milestone.getMilestoneAmount());
        }
        return total;
    }

    public KualiDecimal getTotalAmountRemaining() {
        KualiDecimal total = KualiDecimal.ZERO;
        if (ObjectUtils.isNotNull((Object)this.award) && ObjectUtils.isNotNull((Object)this.award.getAwardTotalAmount())) {
            total = (KualiDecimal)this.award.getAwardTotalAmount().subtract((AbstractKualiDecimal)this.getTotalAmountScheduled());
        }
        return total;
    }

    public String getMilestoneScheduleInquiryTitle() {
        return ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString(MILESTONE_SCHEDULE_INQUIRY_TITLE_PROPERTY);
    }

    public List<Milestone> getMilestones() {
        return this.milestones;
    }

    public void setMilestones(List<Milestone> milestones) {
        this.milestones = milestones;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        this.chart = chart;
    }

    public ContractsAndGrantsBillingAward getAward() {
        return ((ContractsAndGrantsModuleBillingService)SpringContext.getBean(ContractsAndGrantsModuleBillingService.class)).updateAwardIfNecessary(this.proposalNumber, this.award);
    }

    public void setAward(ContractsAndGrantsBillingAward award) {
        this.award = award;
    }

    public ContractsAndGrantsBillingAwardAccount getAwardAccount() {
        return ((ContractsAndGrantsModuleBillingService)SpringContext.getBean(ContractsAndGrantsModuleBillingService.class)).updateAwardAccountIfNecessary(this.proposalNumber, this.chartOfAccountsCode, this.accountNumber, this.awardAccount);
    }

    public void setAwardAccount(ContractsAndGrantsBillingAwardAccount awardAccount) {
        this.awardAccount = awardAccount;
    }

    public String getProposalNumberForAwardAccountLookup() {
        return StringUtils.isNotBlank((CharSequence)this.proposalNumberForAwardAccountLookup) ? this.proposalNumberForAwardAccountLookup : this.proposalNumber;
    }

    public void setProposalNumberForAwardAccountLookup(String proposalNumberForAwardAccountLookup) {
        this.proposalNumberForAwardAccountLookup = proposalNumberForAwardAccountLookup;
    }

    public String getChartOfAccountsCodeForAwardAccountLookup() {
        return StringUtils.isNotBlank((CharSequence)this.chartOfAccountsCodeForAwardAccountLookup) ? this.chartOfAccountsCodeForAwardAccountLookup : this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCodeForAwardAccountLookup(String chartOfAccountsCodeForAwardAccountLookup) {
        this.chartOfAccountsCodeForAwardAccountLookup = chartOfAccountsCodeForAwardAccountLookup;
    }

    public String getAccountNumberForAwardAccountLookup() {
        return StringUtils.isNotBlank((CharSequence)this.accountNumberForAwardAccountLookup) ? this.accountNumberForAwardAccountLookup : this.accountNumber;
    }

    public void setAccountNumberForAwardAccountLookup(String accountNumberForAwardAccountLookup) {
        this.accountNumberForAwardAccountLookup = accountNumberForAwardAccountLookup;
    }
}

