/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.businessobject.ContractsAndGrantsAgingReport;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsAgingOpenInvoicesReport;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAgingReportDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.CustomerCreditMemoDocument;
import org.kuali.kfs.module.ar.document.service.CustomerCreditMemoDocumentService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsAgingReportService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.report.service.CustomerAgingReportService;
import org.kuali.kfs.module.ar.web.struts.ContractsGrantsAgingReportForm;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.web.format.DateFormatter;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kew.impl.document.search.DocumentSearchCriteriaBo;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.beans.factory.InitializingBean;

public class ContractsGrantsAgingReportLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl
implements InitializingBean {
    protected DateTimeService dateTimeService;
    protected ContractsGrantsAgingReportService contractsGrantsAgingReportService;
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;
    protected KualiModuleService moduleService;
    protected CustomerAgingReportService customerAgingReportService;
    protected CustomerCreditMemoDocumentService customerCreditMemoDocumentService;
    private String customerNameLabel;
    private String customerNumberLabel;
    private String cutoffdate30Label;
    private String cutoffdate60Label;
    private String cutoffdate90Label;
    private KualiDecimal total0to30 = KualiDecimal.ZERO;
    private KualiDecimal total31to60 = KualiDecimal.ZERO;
    private KualiDecimal total61to90 = KualiDecimal.ZERO;
    private KualiDecimal total91toSYSPR = KualiDecimal.ZERO;
    private KualiDecimal totalSYSPRplus1orMore = KualiDecimal.ZERO;
    private KualiDecimal totalOpenInvoices = KualiDecimal.ZERO;
    private KualiDecimal totalCredits = KualiDecimal.ZERO;
    private KualiDecimal totalWriteOffs = KualiDecimal.ZERO;
    private String reportOption;
    private java.util.Date reportRunDate;
    private String customerNumber;
    private String customerName;
    private String accountNumber;
    private String accountChartCode;
    private String fundManager;
    private String proposalNumber;
    private String collector;
    private String awardDocumentNumber;
    private String markedAsFinal;
    private Date awardEndDate;
    private String invoiceAmountFrom;
    private String invoiceAmountTo;
    private String invoiceNumber;
    private String orgCode;
    private String chartCode;
    private String nbrDaysForLastBucket;
    private String cutoffdate91toSYSPRlabel;
    private String cutoffdateSYSPRplus1orMorelabel;
    private String agencyShortName = "Agency Short Name";
    private List<String> customers;

    public List getSearchResults(Map fieldValues) {
        ArrayList<ContractsAndGrantsAgingReport> results = new ArrayList<ContractsAndGrantsAgingReport>();
        this.setBackLocation((String)fieldValues.get("backLocation"));
        this.setDocFormKey((String)fieldValues.get("docFormKey"));
        this.total0to30 = KualiDecimal.ZERO;
        this.total31to60 = KualiDecimal.ZERO;
        this.total61to90 = KualiDecimal.ZERO;
        this.total91toSYSPR = KualiDecimal.ZERO;
        this.totalSYSPRplus1orMore = KualiDecimal.ZERO;
        this.totalOpenInvoices = KualiDecimal.ZERO;
        this.totalWriteOffs = KualiDecimal.ZERO;
        this.totalCredits = KualiDecimal.ZERO;
        HashMap<String, ContractsAndGrantsAgingReport> knownCustomers = new HashMap<String, ContractsAndGrantsAgingReport>();
        try {
            java.util.Date today = this.getDateTimeService().getCurrentDate();
            String reportRunDateStr = (String)fieldValues.get("reportRunDate");
            this.reportRunDate = ObjectUtils.isNull((Object)reportRunDateStr) || reportRunDateStr.isEmpty() ? today : this.getDateTimeService().convertToDate(reportRunDateStr);
            Map<String, List<ContractsGrantsInvoiceDocument>> cgMapByCustomer = this.getContractsGrantsAgingReportService().filterContractsGrantsAgingReport(fieldValues, null, new Date(this.reportRunDate.getTime()));
            java.util.Date cutoffdate30 = DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-30);
            java.util.Date cutoffdate31 = DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-31);
            java.util.Date cutoffdate60 = DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-60);
            java.util.Date cutoffdate61 = DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-61);
            java.util.Date cutoffdate90 = DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-90);
            java.util.Date cutoffdate91 = DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-91);
            java.util.Date cutoffdate120 = DateUtils.addDays((java.util.Date)this.reportRunDate, (int)(-1 * Integer.parseInt(this.nbrDaysForLastBucket)));
            java.util.Date cutoffdate121 = DateUtils.addDays((java.util.Date)cutoffdate120, (int)-1);
            if (!MapUtils.isEmpty(cgMapByCustomer)) {
                this.computeFor0To30DaysByBillingChartAndOrg(cgMapByCustomer, new Date(cutoffdate30.getTime()), new Date(this.reportRunDate.getTime()), knownCustomers);
                this.computeFor31To60DaysByBillingChartAndOrg(cgMapByCustomer, new Date(cutoffdate60.getTime()), new Date(cutoffdate31.getTime()), knownCustomers);
                this.computeFor61To90DaysByBillingChartAndOrg(cgMapByCustomer, new Date(cutoffdate90.getTime()), new Date(cutoffdate61.getTime()), knownCustomers);
                this.computeFor91ToSYSPRDaysByBillingChartAndOrg(cgMapByCustomer, new Date(cutoffdate120.getTime()), new Date(cutoffdate91.getTime()), knownCustomers);
                this.computeForSYSPRplus1orMoreDaysByBillingChartAndOrg(cgMapByCustomer, null, new Date(cutoffdate121.getTime()), knownCustomers);
                this.calculateTotalCreditsForCustomers(cgMapByCustomer, knownCustomers);
            }
            for (ContractsAndGrantsAgingReport detail : knownCustomers.values()) {
                ContractsAndGrantsBillingAgency agencyObj = this.getAgencyByCustomer(detail.getCustomerNumber());
                if (ObjectUtils.isNotNull((Object)agencyObj)) {
                    detail.setReportingName(agencyObj.getReportingName());
                    detail.setAgencyNumber(agencyObj.getAgencyNumber());
                }
                KualiDecimal amount = (KualiDecimal)((KualiDecimal)((KualiDecimal)detail.getUnpaidBalance0to30().add((AbstractKualiDecimal)detail.getUnpaidBalance31to60())).add((AbstractKualiDecimal)detail.getUnpaidBalance61to90())).add(detail.getUnpaidBalance91toSYSPR().add((AbstractKualiDecimal)detail.getUnpaidBalanceSYSPRplus1orMore()));
                detail.setTotalOpenInvoices(amount);
                this.totalOpenInvoices = (KualiDecimal)this.totalOpenInvoices.add((AbstractKualiDecimal)amount);
                KualiDecimal writeOffAmt = this.getCustomerAgingReportService().findWriteOffAmountByCustomerNumber(detail.getCustomerNumber());
                if (ObjectUtils.isNotNull((Object)writeOffAmt)) {
                    this.totalWriteOffs = (KualiDecimal)this.totalWriteOffs.add((AbstractKualiDecimal)writeOffAmt);
                } else {
                    writeOffAmt = KualiDecimal.ZERO;
                }
                detail.setTotalWriteOff(writeOffAmt);
                results.add(detail);
            }
        }
        catch (NumberFormatException | ParseException ex) {
            throw new RuntimeException("Could not parse report run date for lookup", ex);
        }
        return new CollectionIncomplete(results, Long.valueOf(results.size()));
    }

    public List getReturnKeys() {
        return new ArrayList(this.fieldConversions.keySet());
    }

    protected Properties getParameters(BusinessObject bo, Map fieldConversions, String lookupImpl, List pkNames) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", "refresh");
        parameters.put("docFormKey", this.getDocFormKey());
        parameters.put("refreshCaller", lookupImpl);
        if (ObjectUtils.isNotNull((Object)this.getReferencesToRefresh())) {
            parameters.put("referencesToRefresh", this.getReferencesToRefresh());
        }
        for (Object o : this.getReturnKeys()) {
            String fieldNm = (String)o;
            Object fieldVal = ObjectUtils.getPropertyValue((Object)bo, (String)fieldNm);
            if (ObjectUtils.isNull((Object)fieldVal)) {
                fieldVal = "";
            }
            if (fieldConversions.containsKey(fieldNm)) {
                fieldNm = (String)fieldConversions.get(fieldNm);
            }
            if (this.getBusinessObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(bo.getClass(), fieldNm)) {
                // empty if block
            }
            if (fieldVal instanceof java.util.Date) {
                DateFormatter dateFormatter = new DateFormatter();
                fieldVal = dateFormatter.format(fieldVal);
            }
            parameters.put(fieldNm, fieldVal.toString());
        }
        return parameters;
    }

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        List displayList = this.getSearchResults(lookupForm.getFieldsForLookup());
        if (bounded) {
            HashMap propertyTypes = new HashMap();
            boolean hasReturnableRow = false;
            Person user = GlobalVariables.getUserSession().getPerson();
            for (Object aDisplayList : displayList) {
                BusinessObject element = (BusinessObject)aDisplayList;
                BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)element, user);
                if (ObjectUtils.isNotNull((Object)this.getColumns())) {
                    List columns = this.getColumns();
                    this.populateCutoffdateLabels();
                    for (Object column : columns) {
                        Column col = (Column)column;
                        Formatter formatter = col.getFormatter();
                        Object prop = ObjectUtils.getPropertyValue((Object)element, (String)col.getPropertyName());
                        String propValue = ObjectUtils.getFormattedPropertyValue((BusinessObject)element, (String)col.getPropertyName(), (Formatter)col.getFormatter());
                        Class propClass = this.getPropertyClass(element, col.getPropertyName());
                        if (ObjectUtils.isNotNull((Object)prop)) {
                            propValue = this.getContractsGrantsReportHelperService().formatByType(prop, formatter);
                        }
                        col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                        col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                        propValue = super.maskValueIfNecessary(element, col.getPropertyName(), propValue, businessObjectRestrictions);
                        col.setPropertyValue(propValue);
                        if (StringUtils.equals((CharSequence)"unpaidBalance91toSYSPR", (CharSequence)col.getPropertyName())) {
                            col.setColumnTitle(this.cutoffdate91toSYSPRlabel);
                        }
                        if (StringUtils.equals((CharSequence)"unpaidBalanceSYSPRplus1orMore", (CharSequence)col.getPropertyName())) {
                            col.setColumnTitle(this.cutoffdateSYSPRplus1orMorelabel);
                        }
                        if (StringUtils.equals((CharSequence)"reportingName", (CharSequence)col.getPropertyName())) {
                            col.setColumnTitle(this.agencyShortName);
                        }
                        if (!StringUtils.isNotBlank((CharSequence)propValue)) continue;
                        if (StringUtils.equals((CharSequence)this.customerNameLabel, (CharSequence)col.getColumnTitle())) {
                            col.setPropertyURL(this.getCustomerLookupUrl(element, col.getColumnTitle()));
                            continue;
                        }
                        if (StringUtils.equals((CharSequence)this.customerNumberLabel, (CharSequence)col.getColumnTitle())) {
                            col.setPropertyURL(this.getCustomerOpenInvoicesReportUrl(element, col.getColumnTitle(), lookupForm.getFieldsForLookup()));
                            continue;
                        }
                        if (StringUtils.equals((CharSequence)"Total Credits", (CharSequence)col.getColumnTitle())) {
                            col.setPropertyURL(this.getCreditMemoDocSearchUrl(element, col.getColumnTitle()));
                            continue;
                        }
                        if (StringUtils.equals((CharSequence)"Total Write-Off", (CharSequence)col.getColumnTitle())) {
                            col.setPropertyURL(this.getCustomerWriteoffSearchUrl(element, col.getColumnTitle()));
                            continue;
                        }
                        if (StringUtils.equals((CharSequence)"Agency Short Name", (CharSequence)col.getColumnTitle())) {
                            col.setPropertyURL(this.getAgencyInquiryUrl(element, col.getColumnTitle()));
                            continue;
                        }
                        col.setPropertyURL(this.getCustomerOpenInvoicesReportUrl(element, col.getColumnTitle(), lookupForm.getFieldsForLookup()));
                    }
                    ResultRow row = new ResultRow(columns, "", "");
                    if (element instanceof PersistableBusinessObject) {
                        row.setObjectId(((PersistableBusinessObject)element).getObjectId());
                    }
                    boolean rowReturnable = this.isResultReturnable(element);
                    row.setRowReturnable(rowReturnable);
                    if (rowReturnable) {
                        hasReturnableRow = true;
                    }
                    resultTable.add(row);
                }
                lookupForm.setHasReturnableRow(hasReturnableRow);
            }
            if (displayList.size() != 0) {
                ((ContractsGrantsAgingReportForm)lookupForm).setTotal0to30(this.total0to30.toString());
                ((ContractsGrantsAgingReportForm)lookupForm).setTotal31to60(this.total31to60.toString());
                ((ContractsGrantsAgingReportForm)lookupForm).setTotal61to90(this.total61to90.toString());
                ((ContractsGrantsAgingReportForm)lookupForm).setTotal91toSYSPR(this.total91toSYSPR.toString());
                ((ContractsGrantsAgingReportForm)lookupForm).setTotalSYSPRplus1orMore(this.totalSYSPRplus1orMore.toString());
                ((ContractsGrantsAgingReportForm)lookupForm).setTotalOpenInvoices(this.totalOpenInvoices.toString());
                ((ContractsGrantsAgingReportForm)lookupForm).setTotalCredits(this.totalCredits.toString());
                ((ContractsGrantsAgingReportForm)lookupForm).setTotalWriteOffs(this.totalWriteOffs.toString());
            }
        }
        return displayList;
    }

    protected String getCustomerOpenInvoicesReportUrl(BusinessObject bo, String columnTitle, Map<String, String> fieldsMap) {
        Properties parameters = new Properties();
        ContractsAndGrantsAgingReport detail = (ContractsAndGrantsAgingReport)bo;
        parameters.put("businessObjectClassName", ContractsGrantsAgingOpenInvoicesReport.class.getName());
        parameters.put("lookupableImplementaionServiceName", "arContractsGrantsAgingOpenInvoicesReportLookupable");
        parameters.put("methodToCall", "search");
        parameters.put("reportName", "Contracts & Grants Open Invoices Report");
        parameters.put("docFormKey", "88888888");
        if (ObjectUtils.isNotNull(fieldsMap) && !fieldsMap.isEmpty()) {
            for (String key : fieldsMap.keySet()) {
                String val = fieldsMap.get(key);
                if (!ObjectUtils.isNotNull((Object)val) || !StringUtils.isNotEmpty((CharSequence)val)) continue;
                parameters.put(key.toString(), fieldsMap.get(key).toString());
            }
        }
        parameters.put("customerNumber", detail.getCustomerNumber());
        parameters.put("customerName", detail.getCustomerName());
        if (ObjectUtils.isNotNull((Object)this.reportOption)) {
            parameters.put("reportOption", this.reportOption);
        }
        parameters.put("reportRunDate", this.getDateTimeService().toDateString(this.reportRunDate));
        if (StringUtils.equals((CharSequence)columnTitle, (CharSequence)this.customerNumberLabel)) {
            parameters.put("columnTitle", "All days");
            parameters.put("startDate", "");
            parameters.put("endDate", this.getDateTimeService().toDateString(this.reportRunDate));
        } else {
            if (StringUtils.equals((CharSequence)columnTitle, (CharSequence)this.cutoffdate30Label)) {
                parameters.put("startDate", this.getDateTimeService().toDateString(DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-30)));
                parameters.put("endDate", this.getDateTimeService().toDateString(this.reportRunDate));
            } else if (StringUtils.equals((CharSequence)columnTitle, (CharSequence)this.cutoffdate60Label)) {
                parameters.put("startDate", this.getDateTimeService().toDateString(DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-60)));
                parameters.put("endDate", this.getDateTimeService().toDateString(DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-31)));
            } else if (StringUtils.equals((CharSequence)columnTitle, (CharSequence)this.cutoffdate90Label)) {
                parameters.put("startDate", this.getDateTimeService().toDateString(DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-90)));
                parameters.put("endDate", this.getDateTimeService().toDateString(DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-61)));
            } else if (StringUtils.equals((CharSequence)columnTitle, (CharSequence)this.cutoffdate91toSYSPRlabel)) {
                parameters.put("startDate", this.getDateTimeService().toDateString(DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-120)));
                parameters.put("endDate", this.getDateTimeService().toDateString(DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-91)));
            } else if (StringUtils.equals((CharSequence)columnTitle, (CharSequence)this.cutoffdateSYSPRplus1orMorelabel)) {
                parameters.put("startDate", "");
                parameters.put("endDate", this.getDateTimeService().toDateString(DateUtils.addDays((java.util.Date)this.reportRunDate, (int)-121)));
                columnTitle = Integer.toString(Integer.parseInt(this.nbrDaysForLastBucket) + 1) + " days and older";
            } else {
                parameters.put("startDate", "");
                parameters.put("endDate", this.getDateTimeService().toDateString(this.reportRunDate));
            }
            parameters.put("columnTitle", columnTitle);
        }
        return UrlFactory.parameterizeUrl((String)"arContractsGrantsAgingOpenInvoicesReportLookup.do", (Properties)parameters);
    }

    protected String getCreditMemoDocSearchUrl(BusinessObject bo, String columnTitle) {
        Properties params = new Properties();
        ContractsAndGrantsAgingReport detail = (ContractsAndGrantsAgingReport)bo;
        params.put("businessObjectClassName", DocumentSearchCriteriaBo.class.getName());
        params.put("methodToCall", "start");
        params.put("docFormKey", "88888888");
        params.put("hideReturnLink", "true");
        params.put("docTypeFullName", "CRM");
        params.put("customerNumber", detail.getCustomerNumber());
        return UrlFactory.parameterizeUrl((String)"kr/lookup.do", (Properties)params);
    }

    protected String getCustomerWriteoffSearchUrl(BusinessObject bo, String columnTitle) {
        Properties params = new Properties();
        ContractsAndGrantsAgingReport detail = (ContractsAndGrantsAgingReport)bo;
        params.put("businessObjectClassName", DocumentSearchCriteriaBo.class.getName());
        params.put("methodToCall", "start");
        params.put("docFormKey", "88888888");
        params.put("hideReturnLink", "true");
        params.put("docTypeFullName", "INVW");
        params.put("customerNumber", detail.getCustomerNumber());
        return UrlFactory.parameterizeUrl((String)"kr/lookup.do", (Properties)params);
    }

    protected String getCustomerLookupUrl(BusinessObject bo, String columnTitle) {
        Properties params = new Properties();
        ContractsAndGrantsAgingReport detail = (ContractsAndGrantsAgingReport)bo;
        params.put("businessObjectClassName", Customer.class.getName());
        params.put("returnLocation", "portal.do");
        params.put("methodToCall", "start");
        params.put("docFormKey", "88888888");
        params.put("hideReturnLink", "true");
        params.put("customerNumber", detail.getCustomerNumber());
        params.put("customerName", detail.getCustomerName());
        return UrlFactory.parameterizeUrl((String)"kr/lookup.do", (Properties)params);
    }

    protected String getAgencyInquiryUrl(BusinessObject bo, String columnTitle) {
        Properties params = new Properties();
        ContractsAndGrantsAgingReport detail = (ContractsAndGrantsAgingReport)bo;
        params.put("businessObjectClassName", ContractsAndGrantsBillingAgency.class.getName());
        params.put("methodToCall", "continueWithInquiry");
        params.put("docFormKey", "88888888");
        params.put("hideReturnLink", "true");
        params.put("agencyNumber", detail.getAgencyNumber());
        return UrlFactory.parameterizeUrl((String)"kr/inquiry.do", (Properties)params);
    }

    protected void populateCutoffdateLabels() {
        this.customerNameLabel = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(ContractsAndGrantsAgingReport.class.getName()).getAttributeDefinition("customerName").getLabel();
        this.customerNumberLabel = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(ContractsAndGrantsAgingReport.class.getName()).getAttributeDefinition("customerNumber").getLabel();
        this.cutoffdate30Label = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(ContractsAndGrantsAgingReport.class.getName()).getAttributeDefinition("unpaidBalance0to30").getLabel();
        this.cutoffdate60Label = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(ContractsAndGrantsAgingReport.class.getName()).getAttributeDefinition("unpaidBalance31to60").getLabel();
        this.cutoffdate90Label = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(ContractsAndGrantsAgingReport.class.getName()).getAttributeDefinition("unpaidBalance61to90").getLabel();
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public KualiDecimal getTotal0to30() {
        return this.total0to30;
    }

    public void setTotal0to30(KualiDecimal total0to30) {
        this.total0to30 = total0to30;
    }

    public KualiDecimal getTotal31to60() {
        return this.total31to60;
    }

    public void setTotal31to60(KualiDecimal total31to60) {
        this.total31to60 = total31to60;
    }

    public KualiDecimal getTotal61to90() {
        return this.total61to90;
    }

    public void setTotal61to90(KualiDecimal total61to90) {
        this.total61to90 = total61to90;
    }

    public KualiDecimal getTotal91toSYSPR() {
        return this.total91toSYSPR;
    }

    public void setTotal91toSYSPR(KualiDecimal total91toSYSPR) {
        this.total91toSYSPR = total91toSYSPR;
    }

    public KualiDecimal getTotalSYSPRplus1orMore() {
        return this.totalSYSPRplus1orMore;
    }

    public void setTotalSYSPRplus1orMore(KualiDecimal totalSYSPRplus1orMore) {
        this.totalSYSPRplus1orMore = totalSYSPRplus1orMore;
    }

    protected ContractsAndGrantsAgingReport pickContractsGrantsAgingReportDetail(Map<String, ContractsAndGrantsAgingReport> knownCustomers, String customer) {
        ContractsAndGrantsAgingReport agingReportDetail = null;
        agingReportDetail = knownCustomers.get(customer);
        if (ObjectUtils.isNull((Object)((Object)agingReportDetail))) {
            agingReportDetail = new ContractsAndGrantsAgingReport();
            agingReportDetail.setCustomerNumber(customer.substring(0, customer.indexOf(45)));
            agingReportDetail.setCustomerName(customer.substring(customer.indexOf(45) + 1));
            knownCustomers.put(customer, agingReportDetail);
        }
        return agingReportDetail;
    }

    protected void computeFor0To30DaysByBillingChartAndOrg(Map<String, List<ContractsGrantsInvoiceDocument>> cgMapByCustomer, Date begin, Date end, Map<String, ContractsAndGrantsAgingReport> knownCustomers) {
        Set<String> customerIds = cgMapByCustomer.keySet();
        for (String customer : customerIds) {
            ContractsAndGrantsAgingReport agingReportDetail = this.pickContractsGrantsAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = this.calculateInvoiceAmountForCustomer((Collection<ContractsGrantsInvoiceDocument>)cgMapByCustomer.get(customer), begin, end);
            agingReportDetail.setUnpaidBalance0to30(amount);
            this.total0to30 = (KualiDecimal)this.total0to30.add((AbstractKualiDecimal)amount);
        }
    }

    protected void computeFor31To60DaysByBillingChartAndOrg(Map<String, List<ContractsGrantsInvoiceDocument>> cgMapByCustomer, Date begin, Date end, Map<String, ContractsAndGrantsAgingReport> knownCustomers) {
        Set<String> customerIds = cgMapByCustomer.keySet();
        for (String customer : customerIds) {
            ContractsAndGrantsAgingReport agingReportDetail = this.pickContractsGrantsAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = this.calculateInvoiceAmountForCustomer((Collection<ContractsGrantsInvoiceDocument>)cgMapByCustomer.get(customer), begin, end);
            KualiDecimal paymentAmt = this.calculatePaymentAmountForCustomer((Collection<ContractsGrantsInvoiceDocument>)cgMapByCustomer.get(customer), begin, end);
            agingReportDetail.setUnpaidBalance31to60((KualiDecimal)amount.subtract((AbstractKualiDecimal)paymentAmt));
            this.total31to60 = (KualiDecimal)this.total31to60.add((AbstractKualiDecimal)amount);
        }
    }

    protected void computeFor61To90DaysByBillingChartAndOrg(Map<String, List<ContractsGrantsInvoiceDocument>> cgMapByCustomer, Date begin, Date end, Map<String, ContractsAndGrantsAgingReport> knownCustomers) {
        Set<String> customerIds = cgMapByCustomer.keySet();
        for (String customer : customerIds) {
            ContractsAndGrantsAgingReport agingReportDetail = this.pickContractsGrantsAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = this.calculateInvoiceAmountForCustomer((Collection<ContractsGrantsInvoiceDocument>)cgMapByCustomer.get(customer), begin, end);
            KualiDecimal paymentAmt = this.calculatePaymentAmountForCustomer((Collection<ContractsGrantsInvoiceDocument>)cgMapByCustomer.get(customer), begin, end);
            agingReportDetail.setUnpaidBalance61to90((KualiDecimal)amount.subtract((AbstractKualiDecimal)paymentAmt));
            this.total61to90 = (KualiDecimal)this.total61to90.add((AbstractKualiDecimal)amount);
        }
    }

    protected void computeFor91ToSYSPRDaysByBillingChartAndOrg(Map<String, List<ContractsGrantsInvoiceDocument>> cgMapByCustomer, Date begin, Date end, Map<String, ContractsAndGrantsAgingReport> knownCustomers) {
        Set<String> customerIds = cgMapByCustomer.keySet();
        for (String customer : customerIds) {
            ContractsAndGrantsAgingReport agingReportDetail = this.pickContractsGrantsAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = this.calculateInvoiceAmountForCustomer((Collection<ContractsGrantsInvoiceDocument>)cgMapByCustomer.get(customer), begin, end);
            KualiDecimal paymentAmt = this.calculatePaymentAmountForCustomer((Collection<ContractsGrantsInvoiceDocument>)cgMapByCustomer.get(customer), begin, end);
            agingReportDetail.setUnpaidBalance91toSYSPR((KualiDecimal)amount.subtract((AbstractKualiDecimal)paymentAmt));
            this.total91toSYSPR = (KualiDecimal)this.total91toSYSPR.add((AbstractKualiDecimal)amount);
        }
    }

    protected void computeForSYSPRplus1orMoreDaysByBillingChartAndOrg(Map<String, List<ContractsGrantsInvoiceDocument>> cgMapByCustomer, Date begin, Date end, Map<String, ContractsAndGrantsAgingReport> knownCustomers) {
        Set<String> customerIds = cgMapByCustomer.keySet();
        for (String customer : customerIds) {
            ContractsAndGrantsAgingReport agingReportDetail = this.pickContractsGrantsAgingReportDetail(knownCustomers, customer);
            KualiDecimal amount = this.calculateInvoiceAmountForCustomer((Collection<ContractsGrantsInvoiceDocument>)cgMapByCustomer.get(customer), begin, end);
            KualiDecimal paymentAmt = this.calculatePaymentAmountForCustomer((Collection<ContractsGrantsInvoiceDocument>)cgMapByCustomer.get(customer), begin, end);
            agingReportDetail.setUnpaidBalanceSYSPRplus1orMore((KualiDecimal)amount.subtract((AbstractKualiDecimal)paymentAmt));
            this.totalSYSPRplus1orMore = (KualiDecimal)this.totalSYSPRplus1orMore.add((AbstractKualiDecimal)amount);
        }
    }

    protected KualiDecimal calculateInvoiceAmountForCustomer(Collection<ContractsGrantsInvoiceDocument> cgDocs, Date begin, Date end) {
        KualiDecimal invoiceAmt = KualiDecimal.ZERO;
        if (!CollectionUtils.isEmpty(cgDocs)) {
            for (ContractsGrantsInvoiceDocument cgDoc : cgDocs) {
                if (!ObjectUtils.isNotNull((Object)cgDoc.getBillingDate())) continue;
                if (ObjectUtils.isNotNull((Object)begin)) {
                    if (!KfsDateUtils.isSameDayOrLater((java.util.Date)cgDoc.getBillingDate(), (java.util.Date)begin) || !KfsDateUtils.isSameDayOrEarlier((java.util.Date)cgDoc.getBillingDate(), (java.util.Date)end)) continue;
                    invoiceAmt = (KualiDecimal)invoiceAmt.add((AbstractKualiDecimal)cgDoc.getTotalDollarAmount());
                    continue;
                }
                if (!KfsDateUtils.isSameDayOrEarlier((java.util.Date)cgDoc.getBillingDate(), (java.util.Date)end)) continue;
                invoiceAmt = (KualiDecimal)invoiceAmt.add((AbstractKualiDecimal)cgDoc.getTotalDollarAmount());
            }
        }
        return invoiceAmt;
    }

    protected KualiDecimal calculatePaymentAmountForCustomer(Collection<ContractsGrantsInvoiceDocument> cgDocs, Date begin, Date end) {
        KualiDecimal invoiceAmt = KualiDecimal.ZERO;
        if (!CollectionUtils.isEmpty(cgDocs)) {
            for (ContractsGrantsInvoiceDocument cgDoc : cgDocs) {
                if (!ObjectUtils.isNotNull((Object)cgDoc.getBillingDate())) continue;
                if (ObjectUtils.isNotNull((Object)begin)) {
                    if (!KfsDateUtils.isSameDayOrLater((java.util.Date)cgDoc.getBillingDate(), (java.util.Date)begin) || !KfsDateUtils.isSameDayOrEarlier((java.util.Date)cgDoc.getBillingDate(), (java.util.Date)end)) continue;
                    invoiceAmt = (KualiDecimal)invoiceAmt.add((AbstractKualiDecimal)cgDoc.getPaymentAmount());
                    continue;
                }
                if (!KfsDateUtils.isSameDayOrEarlier((java.util.Date)cgDoc.getBillingDate(), (java.util.Date)end)) continue;
                invoiceAmt = (KualiDecimal)invoiceAmt.add((AbstractKualiDecimal)cgDoc.getPaymentAmount());
            }
        }
        return invoiceAmt;
    }

    protected ContractsAndGrantsBillingAgency getAgencyByCustomer(String customerNumber) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("customerNumber", customerNumber);
        return (ContractsAndGrantsBillingAgency)this.getModuleService().getResponsibleModuleService(ContractsAndGrantsBillingAgency.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAgency.class, args);
    }

    protected void calculateTotalCreditsForCustomers(Map<String, List<ContractsGrantsInvoiceDocument>> cgMapByCustomer, Map<String, ContractsAndGrantsAgingReport> knownCustomers) {
        Set<String> customerIds = cgMapByCustomer.keySet();
        KualiDecimal credits = KualiDecimal.ZERO;
        for (String customer : customerIds) {
            ContractsAndGrantsAgingReport agingReportDetail = this.pickContractsGrantsAgingReportDetail(knownCustomers, customer);
            List<ContractsGrantsInvoiceDocument> cgDocs = cgMapByCustomer.get(customer);
            if (!CollectionUtils.isEmpty(cgDocs)) {
                credits = KualiDecimal.ZERO;
                for (ContractsGrantsInvoiceDocument cgDoc : cgDocs) {
                    Collection<CustomerCreditMemoDocument> creditDocs = this.customerCreditMemoDocumentService.getCustomerCreditMemoDocumentByInvoiceDocument(cgDoc.getDocumentNumber());
                    if (!ObjectUtils.isNotNull(creditDocs) || creditDocs.isEmpty()) continue;
                    for (CustomerCreditMemoDocument cm : creditDocs) {
                        for (CustomerCreditMemoDetail cmDetail : cm.getCreditMemoDetails()) {
                            if (!ObjectUtils.isNotNull((Object)cmDetail.getCreditMemoItemTotalAmount())) continue;
                            credits = (KualiDecimal)credits.add((AbstractKualiDecimal)cmDetail.getCreditMemoItemTotalAmount());
                        }
                    }
                }
            }
            agingReportDetail.setTotalCredits(credits);
            this.totalCredits = (KualiDecimal)this.totalCredits.add((AbstractKualiDecimal)credits);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.nbrDaysForLastBucket = this.getParameterService().getParameterValueAsString(CustomerAgingReportDetail.class, "CUSTOMER_INVOICE_AGE");
        this.cutoffdate91toSYSPRlabel = "91-" + this.nbrDaysForLastBucket + " days";
        this.cutoffdateSYSPRplus1orMorelabel = Integer.toString(Integer.parseInt(this.nbrDaysForLastBucket) + 1) + "+ days";
    }

    public ContractsGrantsAgingReportService getContractsGrantsAgingReportService() {
        return this.contractsGrantsAgingReportService;
    }

    public void setContractsGrantsAgingReportService(ContractsGrantsAgingReportService contractsGrantsAgingReportService) {
        this.contractsGrantsAgingReportService = contractsGrantsAgingReportService;
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }

    public KualiModuleService getModuleService() {
        return this.moduleService;
    }

    public void setModuleService(KualiModuleService moduleService) {
        this.moduleService = moduleService;
    }

    public CustomerCreditMemoDocumentService getCustomerCreditMemoDocumentService() {
        return this.customerCreditMemoDocumentService;
    }

    public void setCustomerCreditMemoDocumentService(CustomerCreditMemoDocumentService customerCreditMemoDocumentService) {
        this.customerCreditMemoDocumentService = customerCreditMemoDocumentService;
    }

    public CustomerAgingReportService getCustomerAgingReportService() {
        return this.customerAgingReportService;
    }

    public void setCustomerAgingReportService(CustomerAgingReportService customerAgingReportService) {
        this.customerAgingReportService = customerAgingReportService;
    }
}

