/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.integration.ar.AccountsReceivableBillingFrequency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.lookup.LookupUtils;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceLookupResult;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceLookupResultAward;
import org.kuali.kfs.module.ar.businessobject.lookup.AccountsReceivableLookupableHelperServiceImplBase;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsInvoiceReportService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.web.ui.ContractsGrantsLookupResultRow;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.IdentityManagementService;
import org.kuali.rice.krad.bo.BusinessObject;

public class ContractsGrantsInvoiceLookupableHelperServiceImpl
extends AccountsReceivableLookupableHelperServiceImplBase {
    private static final Logger LOG = LogManager.getLogger(ContractsGrantsInvoiceLookupableHelperServiceImpl.class);
    protected ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService;
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;
    protected ContractsGrantsInvoiceReportService contractsGrantsInvoiceReportService;
    private IdentityManagementService identityManagementService;

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        List<? extends BusinessObject> displayList = this.getSearchResultsUnbounded(lookupForm.getFieldsForLookup());
        List pkNames = this.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(this.getBusinessObjectClass());
        List returnKeys = this.getReturnKeys();
        Person user = GlobalVariables.getUserSession().getPerson();
        for (BusinessObject businessObject : displayList) {
            LOG.debug("Doing lookup for " + businessObject.getClass());
            ContractsGrantsInvoiceLookupResult result = (ContractsGrantsInvoiceLookupResult)businessObject;
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)result, user);
            List<ResultRow> subResultRows = this.buildSubResultRows(result, businessObjectRestrictions);
            Collection<Column> columns = this.getColumns(businessObject, businessObjectRestrictions);
            ContractsGrantsLookupResultRow row = new ContractsGrantsLookupResultRow((List)columns, subResultRows, "", this.getActionUrls(businessObject, pkNames, businessObjectRestrictions));
            resultTable.add(row);
        }
        return displayList;
    }

    protected List<ResultRow> buildSubResultRows(ContractsGrantsInvoiceLookupResult result, BusinessObjectRestrictions businessObjectRestrictions) {
        ArrayList<ResultRow> subResultRows = new ArrayList<ResultRow>();
        ArrayList<String> subResultRowProposalNumbers = new ArrayList<String>();
        for (ContractsGrantsInvoiceLookupResultAward lookupResultAward : result.getLookupResultAwards()) {
            ArrayList<Column> subResultColumns = new ArrayList<Column>();
            for (String propertyName : result.getAwardAttributesForDisplay()) {
                subResultColumns.add(this.setupResultsColumn((BusinessObject)lookupResultAward, propertyName, businessObjectRestrictions));
            }
            ResultRow subResultRow = new ResultRow(subResultColumns, "", "");
            if (this.needsObjectIdForCheckbox(subResultRowProposalNumbers, lookupResultAward)) {
                subResultRow.setObjectId(lookupResultAward.getObjectId());
                subResultRowProposalNumbers.add(lookupResultAward.getProposalNumber());
            }
            subResultRows.add(subResultRow);
        }
        return subResultRows;
    }

    private boolean needsObjectIdForCheckbox(List<String> subResultRowProposalNumbers, ContractsGrantsInvoiceLookupResultAward lookupResultAward) {
        return this.isScheduledBilling(lookupResultAward) || !subResultRowProposalNumbers.contains(lookupResultAward.getProposalNumber());
    }

    private boolean isScheduledBilling(ContractsGrantsInvoiceLookupResultAward result) {
        return ArConstants.BillingFrequencyValues.isMilestone(result) || ArConstants.BillingFrequencyValues.isPredeterminedBilling(result);
    }

    public List<? extends BusinessObject> getSearchResultsUnbounded(Map<String, String> fieldValues) {
        Collection<Object> searchResultsCollection = this.getSearchResultsHelper(LookupUtils.forceUppercase((Class)this.getBusinessObjectClass(), fieldValues), true);
        searchResultsCollection = this.getContractsGrantsInvoiceReportService().getPopulatedContractsGrantsInvoiceLookupResults(searchResultsCollection);
        this.filterSearchResults(searchResultsCollection);
        return this.buildSearchResultList(searchResultsCollection, new Long(searchResultsCollection.size()));
    }

    protected List buildSearchResultList(Collection searchResultsCollection, Long actualSize) {
        CollectionIncomplete results;
        CollectionIncomplete searchResults = results = new CollectionIncomplete(searchResultsCollection, actualSize);
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            Collections.sort(results, new BeanPropertyComparator(defaultSortColumns, true));
        }
        return searchResults;
    }

    protected List<? extends BusinessObject> getSearchResultsHelper(Map<String, String> fieldValues, boolean unbounded) {
        return this.contractsAndGrantsModuleBillingService.lookupAwards(fieldValues, unbounded);
    }

    void filterSearchResults(Collection<ContractsGrantsInvoiceLookupResult> searchResultsCollection) {
        for (ContractsGrantsInvoiceLookupResult lookupResult2 : searchResultsCollection) {
            lookupResult2.setLookupResultAwards(this.removeAwardsIfNotAuthorized(lookupResult2));
        }
        searchResultsCollection.removeIf(lookupResult -> lookupResult.getLookupResultAwards().size() == 0);
    }

    private List<ContractsGrantsInvoiceLookupResultAward> removeAwardsIfNotAuthorized(ContractsGrantsInvoiceLookupResult lookupResult) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("documentTypeName", "CINV");
        HashMap qualificationDetails = new HashMap();
        return lookupResult.getLookupResultAwards().stream().filter(lookupResultAward -> {
            qualificationDetails.put("proposalNumber", lookupResultAward.getProposalNumber());
            return this.identityManagementService.isAuthorizedByTemplateName(GlobalVariables.getUserSession().getPrincipalId(), "KR-SYS", "Initiate Document", permissionDetails, qualificationDetails);
        }).collect(Collectors.toList());
    }

    protected Column setupResultsColumn(BusinessObject element, String attributeName, BusinessObjectRestrictions businessObjectRestrictions) {
        Column col = new Column();
        col.setPropertyName(attributeName);
        String columnTitle = this.getDataDictionaryService().getAttributeLabel(element.getClass(), attributeName);
        if (StringUtils.isBlank((CharSequence)columnTitle)) {
            columnTitle = this.getDataDictionaryService().getCollectionLabel(element.getClass(), attributeName);
        }
        col.setColumnTitle(columnTitle);
        col.setMaxLength(this.getDataDictionaryService().getAttributeMaxLength(element.getClass(), attributeName).intValue());
        try {
            Class formatterClass = this.getDataDictionaryService().getAttributeFormatter(element.getClass(), attributeName);
            Formatter formatter = null;
            if (formatterClass != null) {
                formatter = (Formatter)formatterClass.newInstance();
                col.setFormatter(formatter);
            }
            String propValue = "";
            Object prop = ObjectUtils.getPropertyValue((Object)element, (String)attributeName);
            Class<?> propClass = null;
            PropertyDescriptor propDescriptor = PropertyUtils.getPropertyDescriptor((Object)element, (String)col.getPropertyName());
            if (propDescriptor != null) {
                propClass = propDescriptor.getPropertyType();
            }
            if (prop != null) {
                propValue = this.getContractsGrantsReportHelperService().formatByType(prop, formatter);
            }
            col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass(propClass));
            col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass(propClass));
            propValue = super.maskValueIfNecessary(element, col.getPropertyName(), propValue, businessObjectRestrictions);
            col.setPropertyValue(propValue);
            if (StringUtils.isNotBlank((CharSequence)propValue)) {
                col.setColumnAnchor(this.getInquiryUrl(element, col.getPropertyName()));
            }
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Unable to get new instance of formatter class for property " + col.getPropertyName(), ie);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("Cannot access PropertyType for property '" + col.getPropertyName() + "'  on an instance of '" + element.getClass().getName() + "'.", ex);
        }
        return col;
    }

    @Override
    public HtmlData getInquiryUrl(BusinessObject bo, String propertyName) {
        if ("billingFrequencyCode".equals(propertyName)) {
            return this.buildInquiryUrl(AccountsReceivableBillingFrequency.class.getName(), "frequency", ((ContractsGrantsInvoiceLookupResultAward)bo).getBillingFrequencyCode());
        }
        if ("proposalNumber".equals(propertyName)) {
            return this.buildInquiryUrl(ContractsAndGrantsBillingAward.class.getName(), "proposalNumber", ((ContractsGrantsInvoiceLookupResultAward)bo).getProposalNumber());
        }
        return super.getInquiryUrl(bo, propertyName);
    }

    private HtmlData buildInquiryUrl(String className, String parameterKey, String parameterValue) {
        HtmlData.AnchorHtmlData inquiryHref = new HtmlData.AnchorHtmlData("", "");
        Properties parameters = new Properties();
        parameters.put("businessObjectClassName", className);
        parameters.put("methodToCall", "start");
        parameters.put(parameterKey, parameterValue);
        inquiryHref.setHref(UrlFactory.parameterizeUrl((String)"kr/inquiry.do", (Properties)parameters));
        return inquiryHref;
    }

    protected Collection<Column> getColumns(BusinessObject bo, BusinessObjectRestrictions businessObjectRestrictions) {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String attributeName : this.getBusinessObjectDictionaryService().getLookupResultFieldNames(bo.getClass())) {
            columns.add(this.setupResultsColumn(bo, attributeName, businessObjectRestrictions));
        }
        return columns;
    }

    public ContractsAndGrantsModuleBillingService getContractsAndGrantsModuleBillingService() {
        return this.contractsAndGrantsModuleBillingService;
    }

    public void setContractsAndGrantsModuleBillingService(ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService) {
        this.contractsAndGrantsModuleBillingService = contractsAndGrantsModuleBillingService;
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }

    public ContractsGrantsInvoiceReportService getContractsGrantsInvoiceReportService() {
        return this.contractsGrantsInvoiceReportService;
    }

    public void setContractsGrantsInvoiceReportService(ContractsGrantsInvoiceReportService contractsGrantsInvoiceReportService) {
        this.contractsGrantsInvoiceReportService = contractsGrantsInvoiceReportService;
    }

    public IdentityManagementService getIdentityManagementService() {
        return this.identityManagementService;
    }

    public void setIdentityManagementService(IdentityManagementService identityManagementService) {
        this.identityManagementService = identityManagementService;
    }
}

