/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CollectionEvent;
import org.kuali.kfs.module.ar.businessobject.TicklersReport;
import org.kuali.kfs.module.ar.businessobject.lookup.CollectionsReportLookupableHelperServiceImplBase;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsCollectionActivityDocumentService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.BusinessObject;

public class TicklersReportLookupableHelperServiceImpl
extends CollectionsReportLookupableHelperServiceImplBase {
    protected ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    protected DateTimeService dateTimeService;
    protected PersonService personService;
    protected ContractsGrantsCollectionActivityDocumentService contractsGrantsCollectionActivityDocumentService;

    public void validateSearchParameters(Map<String, String> fieldValues) {
        super.validateSearchParameters(fieldValues);
        if (!ObjectUtils.isNull((Object)fieldValues.get("rangeLowerBoundKeyPrefix_followupDate"))) {
            String dateFromFieldValues = fieldValues.get("rangeLowerBoundKeyPrefix_followupDate").toString();
            this.validateDateField(dateFromFieldValues, "rangeLowerBoundKeyPrefix_followupDate From", this.getDateTimeService());
        }
        if (!ObjectUtils.isNull((Object)fieldValues.get("followupDate"))) {
            String dateToFieldValues = fieldValues.get("followupDate").toString();
            this.validateDateField(dateToFieldValues, "followupDate To", this.getDateTimeService());
        }
    }

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        String proposalNumber;
        Map lookupFormFields = lookupForm.getFieldsForLookup();
        this.setBackLocation((String)lookupForm.getFieldsForLookup().get("backLocation"));
        this.setDocFormKey((String)lookupForm.getFieldsForLookup().get("docFormKey"));
        ArrayList<TicklersReport> displayList = new ArrayList<TicklersReport>();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        String principalId = (String)lookupFormFields.get("principalId");
        String collectorPrincName = (String)lookupFormFields.get("collector.principalName");
        String activityCode = (String)lookupFormFields.get("activityCode");
        if (!StringUtils.isBlank((CharSequence)activityCode)) {
            fieldValues.put("activityCode", activityCode);
        }
        if (!StringUtils.isBlank((CharSequence)(proposalNumber = (String)lookupFormFields.get("proposalNumber")))) {
            fieldValues.put("invoiceDocument.invoiceGeneralDetails.proposalNumber", proposalNumber);
        }
        String completed = (String)lookupFormFields.get("completed");
        fieldValues.put("followup", "true");
        String dateFromFieldValues = ObjectUtils.isNull(lookupFormFields.get("rangeLowerBoundKeyPrefix_followupDate")) ? "" : lookupFormFields.get("rangeLowerBoundKeyPrefix_followupDate").toString();
        String dateToFieldValues = ObjectUtils.isNull(lookupFormFields.get("followupDate")) ? "" : lookupFormFields.get("followupDate").toString();
        String followUpDateCriteria = this.getContractsGrantsReportHelperService().fixDateCriteria(dateFromFieldValues, dateToFieldValues, false);
        if (!StringUtils.isBlank((CharSequence)followUpDateCriteria)) {
            fieldValues.put("followupDate", followUpDateCriteria);
        }
        Collection collectionEvents = this.getLookupService().findCollectionBySearchUnbounded(CollectionEvent.class, fieldValues);
        String agencyNumber = (String)lookupFormFields.get("agencyNumber");
        for (CollectionEvent event : collectionEvents) {
            ContractsGrantsInvoiceDocument invoice;
            boolean isValid = true;
            if (StringUtils.isNotBlank((CharSequence)completed)) {
                if (StringUtils.equalsIgnoreCase((CharSequence)completed, (CharSequence)"Y")) {
                    isValid = event.isCompleted();
                } else if (StringUtils.equalsIgnoreCase((CharSequence)completed, (CharSequence)"N")) {
                    boolean bl = isValid = !event.isCompleted();
                }
            }
            if (!(invoice = event.getInvoiceDocument()).isOpenInvoiceIndicator()) {
                isValid = false;
            }
            if (!StringUtils.isBlank((CharSequence)agencyNumber) && isValid && (ObjectUtils.isNull((Object)event.getInvoiceDocument().getInvoiceGeneralDetail().getAward()) || !StringUtils.equals((CharSequence)agencyNumber, (CharSequence)event.getInvoiceDocument().getInvoiceGeneralDetail().getAward().getAgencyNumber()))) {
                isValid = false;
            }
            if (isValid && StringUtils.isNotEmpty((CharSequence)collectorPrincName)) {
                Person collUser = this.personService.getPersonByPrincipalName(collectorPrincName);
                isValid = ObjectUtils.isNotNull((Object)collUser) ? (!StringUtils.isBlank((CharSequence)(principalId = collUser.getPrincipalId())) ? this.contractsGrantsInvoiceDocumentService.canViewInvoice(event.getInvoiceDocument(), principalId) : false) : false;
            }
            if (isValid) {
                Person user = GlobalVariables.getUserSession().getPerson();
                isValid = this.contractsGrantsInvoiceDocumentService.canViewInvoice(event.getInvoiceDocument(), user.getPrincipalId());
            }
            if (!isValid) continue;
            TicklersReport ticklerReport = new TicklersReport();
            ticklerReport.setEventId(event.getId());
            ticklerReport.setProposalNumber(invoice.getInvoiceGeneralDetail().getProposalNumber());
            ticklerReport.setActivityCode(event.getActivityCode());
            if (ObjectUtils.isNotNull((Object)invoice.getInvoiceGeneralDetail().getAward()) && ObjectUtils.isNotNull((Object)invoice.getInvoiceGeneralDetail().getAward().getAgency())) {
                ticklerReport.setAgencyNumber(invoice.getInvoiceGeneralDetail().getAward().getAgency().getAgencyNumber());
                ticklerReport.setAgencyName(invoice.getInvoiceGeneralDetail().getAward().getAgency().getFullName());
            }
            if (CollectionUtils.isNotEmpty(invoice.getAccountDetails())) {
                ticklerReport.setAccountNumber(invoice.getAccountDetails().get(0).getAccountNumber());
            }
            ticklerReport.setFollowupDate(event.getFollowupDate());
            ticklerReport.setInvoiceNumber(event.getInvoiceNumber());
            ticklerReport.setActivityText(event.getActivityText());
            ticklerReport.setInvoiceAmount(invoice.getSourceTotal());
            ticklerReport.setBalanceDue((KualiDecimal)invoice.getSourceTotal().subtract((AbstractKualiDecimal)invoice.getPaymentAmount()));
            if (ObjectUtils.isNotNull((Object)((Object)event.getCollectionActivityType()))) {
                ticklerReport.setActivityDescription(event.getCollectionActivityType().getActivityDescription());
            }
            ticklerReport.setActivityDate(event.getActivityDate());
            ticklerReport.setCompletedDate(event.getCompletedDate());
            ticklerReport.setUser(event.getUser().getName());
            displayList.add(ticklerReport);
        }
        this.buildResultTable(lookupForm, displayList, resultTable);
        return displayList;
    }

    @Override
    protected void buildResultTable(LookupForm lookupForm, Collection displayList, Collection resultTable) {
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean hasReturnableRow = false;
        List pkNames = this.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(this.getBusinessObjectClass());
        for (BusinessObject element : displayList) {
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)element, user);
            List columns = this.getColumns();
            for (Column col : columns) {
                String propValue = ObjectUtils.getFormattedPropertyValue((BusinessObject)element, (String)col.getPropertyName(), (Formatter)col.getFormatter());
                Class propClass = this.getPropertyClass(element, col.getPropertyName());
                col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                String propValueBeforePotientalMasking = propValue;
                propValue = this.maskValueIfNecessary(element, col.getPropertyName(), propValue, businessObjectRestrictions);
                col.setPropertyValue(propValue);
                if (col.getPropertyName().equals("invoiceNumber")) {
                    String url = this.contractsGrantsReportHelperService.getDocSearchUrl(propValue);
                    HashMap<String, String> fieldList = new HashMap<String, String>();
                    fieldList.put("invoiceNumber", propValue);
                    HtmlData.AnchorHtmlData a = new HtmlData.AnchorHtmlData(url, "");
                    a.setTitle(HtmlData.getTitleText((String)this.getContractsGrantsReportHelperService().createTitleText(this.getBusinessObjectClass()), (Class)this.getBusinessObjectClass(), fieldList));
                    col.setColumnAnchor((HtmlData)a);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)propValue)) continue;
                col.setColumnAnchor(this.getInquiryUrl(element, col.getPropertyName()));
            }
            ResultRow row = new ResultRow(columns, "", this.getActionUrls(element, pkNames, businessObjectRestrictions));
            if (this.getBusinessObjectDictionaryService().isExportable(this.getBusinessObjectClass()).booleanValue()) {
                row.setBusinessObject(element);
            }
            boolean isRowReturnable = this.isResultReturnable(element);
            row.setRowReturnable(isRowReturnable);
            if (isRowReturnable) {
                hasReturnableRow = true;
            }
            resultTable.add(row);
        }
        lookupForm.setHasReturnableRow(hasReturnableRow);
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public ContractsGrantsInvoiceDocumentService getContractsGrantsInvoiceDocumentService() {
        return this.contractsGrantsInvoiceDocumentService;
    }

    public void setContractsGrantsInvoiceDocumentService(ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }

    public ContractsGrantsCollectionActivityDocumentService getContractsGrantsCollectionActivityDocumentService() {
        return this.contractsGrantsCollectionActivityDocumentService;
    }

    public void setContractsGrantsCollectionActivityDocumentService(ContractsGrantsCollectionActivityDocumentService contractsGrantsCollectionActivityDocumentService) {
        this.contractsGrantsCollectionActivityDocumentService = contractsGrantsCollectionActivityDocumentService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

