/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.TransmitContractsAndGrantsInvoicesLookupDataHolder;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.report.service.TransmitContractsAndGrantsInvoicesService;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.BusinessObject;

public class TransmitContractsAndGrantsInvoicesLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final Logger LOG = LogManager.getLogger(TransmitContractsAndGrantsInvoicesLookupableHelperServiceImpl.class);
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;
    protected PersonService personService;
    protected TransmitContractsAndGrantsInvoicesService transmitContractsAndGrantsInvoicesService;

    public List getSearchResultsUnbounded(Map fieldValues) {
        Collection<ContractsGrantsInvoiceDocument> list;
        ArrayList<TransmitContractsAndGrantsInvoicesLookupDataHolder> results = new ArrayList<TransmitContractsAndGrantsInvoicesLookupDataHolder>();
        this.setBackLocation((String)fieldValues.get("backLocation"));
        this.setDocFormKey((String)fieldValues.get("docFormKey"));
        String invoiceTransmissionMethodCode = (String)fieldValues.get("invoiceTransmissionMethodCode");
        try {
            list = this.transmitContractsAndGrantsInvoicesService.getInvoicesByParametersFromRequest(fieldValues);
        }
        catch (ParseException | WorkflowException ex) {
            LOG.error("Problem searching for invoices ready to transmit.", ex);
            throw new RuntimeException(ex);
        }
        if (ObjectUtils.isNotNull(list)) {
            for (ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument : list) {
                TransmitContractsAndGrantsInvoicesLookupDataHolder result = this.setupResultRecord(contractsGrantsInvoiceDocument, invoiceTransmissionMethodCode);
                results.add(result);
            }
        }
        return new CollectionIncomplete(results, Long.valueOf(results.size()));
    }

    private TransmitContractsAndGrantsInvoicesLookupDataHolder setupResultRecord(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument, String invoiceTransmissionMethodCode) {
        TransmitContractsAndGrantsInvoicesLookupDataHolder result = new TransmitContractsAndGrantsInvoicesLookupDataHolder();
        result.setBillByChartOfAccountCode(contractsGrantsInvoiceDocument.getBillByChartOfAccountCode());
        result.setBilledByOrganizationCode(contractsGrantsInvoiceDocument.getBilledByOrganizationCode());
        result.setInvoiceInitiatorPrincipalName(contractsGrantsInvoiceDocument.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
        result.setProposalNumber(contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getProposalNumber());
        result.setDocumentNumber(contractsGrantsInvoiceDocument.getDocumentNumber());
        result.setInvoiceInitiatorPrincipalName(this.personService.getPerson(contractsGrantsInvoiceDocument.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId()).getPrincipalName());
        result.setInvoiceAmount(contractsGrantsInvoiceDocument.getFinancialSystemDocumentHeader().getFinancialDocumentTotalAmount().toString());
        result.setInvoiceTransmissionMethodCode(invoiceTransmissionMethodCode);
        return result;
    }

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        List displayList = this.getSearchResultsUnbounded(lookupForm.getFieldsForLookup());
        HashMap propertyTypes = new HashMap();
        boolean hasReturnableRow = false;
        Person user = GlobalVariables.getUserSession().getPerson();
        for (Object aDisplayList : displayList) {
            BusinessObject element = (BusinessObject)aDisplayList;
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)element, user);
            if (ObjectUtils.isNotNull((Object)this.getColumns())) {
                List columns = this.getColumns();
                for (Object column : columns) {
                    Column col = (Column)column;
                    Formatter formatter = col.getFormatter();
                    Object prop = ObjectUtils.getPropertyValue((Object)element, (String)col.getPropertyName());
                    String propValue = ObjectUtils.getFormattedPropertyValue((BusinessObject)element, (String)col.getPropertyName(), (Formatter)col.getFormatter());
                    Class propClass = this.getPropertyClass(element, col.getPropertyName());
                    if (ObjectUtils.isNotNull((Object)prop)) {
                        propValue = this.getContractsGrantsReportHelperService().formatByType(prop, formatter);
                    }
                    col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                    col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                    propValue = super.maskValueIfNecessary(element, col.getPropertyName(), propValue, businessObjectRestrictions);
                    col.setPropertyValue(propValue);
                    if (!col.getPropertyName().equals("documentNumber")) continue;
                    String url = this.contractsGrantsReportHelperService.getDocSearchUrl(propValue);
                    HashMap<String, String> fieldList = new HashMap<String, String>();
                    fieldList.put("invoiceNumber", propValue);
                    HtmlData.AnchorHtmlData a = new HtmlData.AnchorHtmlData(url, "");
                    a.setTitle(HtmlData.getTitleText((String)this.getContractsGrantsReportHelperService().createTitleText(this.getBusinessObjectClass()), (Class)this.getBusinessObjectClass(), fieldList));
                    col.setColumnAnchor((HtmlData)a);
                }
                ResultRow row = new ResultRow(columns, "", "");
                if (element instanceof PersistableBusinessObject) {
                    row.setObjectId(((PersistableBusinessObject)element).getObjectId());
                }
                boolean rowReturnable = this.isResultReturnable(element);
                row.setRowReturnable(rowReturnable);
                if (rowReturnable) {
                    hasReturnableRow = true;
                }
                resultTable.add(row);
            }
            lookupForm.setHasReturnableRow(hasReturnableRow);
        }
        return displayList;
    }

    public void validateSearchParameters(Map fieldValues) {
        super.validateSearchParameters(fieldValues);
        this.transmitContractsAndGrantsInvoicesService.validateSearchParameters(fieldValues);
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public TransmitContractsAndGrantsInvoicesService getTransmitContractsAndGrantsInvoicesService() {
        return this.transmitContractsAndGrantsInvoicesService;
    }

    public void setTransmitContractsAndGrantsInvoicesService(TransmitContractsAndGrantsInvoicesService transmitContractsAndGrantsInvoicesService) {
        this.transmitContractsAndGrantsInvoicesService = transmitContractsAndGrantsInvoicesService;
    }
}

