/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.dataaccess.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.ObjectCodeCurrent;
import org.kuali.kfs.coa.businessobject.ObjectLevel;
import org.kuali.kfs.gl.businessobject.Balance;
import org.kuali.kfs.module.ar.businessobject.CostCategory;
import org.kuali.kfs.module.ar.businessobject.CostCategoryDetail;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectCode;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectConsolidation;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectLevel;
import org.kuali.kfs.module.ar.dataaccess.CostCategoryDao;
import org.kuali.kfs.sys.util.TransactionalServiceUtils;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class CostCategoryDaoOjb
extends PlatformAwareDaoBaseOjb
implements CostCategoryDao {
    @Override
    public CostCategoryDetail retrieveMatchingCostCategoryConsolidationAmongConsolidations(CostCategoryObjectConsolidation objectConsolidation) {
        Criteria crit = new Criteria();
        if (!StringUtils.isBlank((CharSequence)objectConsolidation.getCategoryCode())) {
            crit.addNotEqualTo((Object)"categoryCode", (Object)objectConsolidation.getCategoryCode());
        }
        crit.addEqualTo("chartOfAccountsCode", (Object)objectConsolidation.getChartOfAccountsCode());
        crit.addEqualTo("finConsolidationObjectCode", (Object)objectConsolidation.getFinConsolidationObjectCode());
        crit.addEqualTo("active", (Object)Boolean.TRUE);
        crit.addIn((Object)"categoryCode", (Query)this.buildActiveCostCategorySubQuery());
        QueryByCriteria q = new QueryByCriteria(CostCategoryObjectConsolidation.class, crit);
        return (CostCategoryDetail)TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)q));
    }

    @Override
    public CostCategoryDetail retrieveMatchingCostCategoryConsolidationAmongLevels(CostCategoryObjectConsolidation consolidation) {
        Criteria crit = new Criteria();
        if (!StringUtils.isBlank((CharSequence)consolidation.getCategoryCode())) {
            crit.addNotEqualTo((Object)"categoryCode", (Object)consolidation.getCategoryCode());
        }
        crit.addEqualTo("chartOfAccountsCode", (Object)consolidation.getChartOfAccountsCode());
        crit.addEqualTo("objectLevel.financialConsolidationObjectCode", (Object)consolidation.getFinConsolidationObjectCode());
        crit.addEqualTo("active", (Object)Boolean.TRUE);
        crit.addIn((Object)"categoryCode", (Query)this.buildActiveCostCategorySubQuery());
        QueryByCriteria q = new QueryByCriteria(CostCategoryObjectLevel.class, crit);
        return (CostCategoryDetail)TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)q));
    }

    @Override
    public CostCategoryDetail retrieveMatchingCostCategoryConsolidationAmongCodes(CostCategoryObjectConsolidation consolidation) {
        Criteria crit = new Criteria();
        if (!StringUtils.isBlank((CharSequence)consolidation.getCategoryCode())) {
            crit.addNotEqualTo((Object)"categoryCode", (Object)consolidation.getCategoryCode());
        }
        crit.addEqualTo("chartOfAccountsCode", (Object)consolidation.getChartOfAccountsCode());
        crit.addEqualTo("objectCodeCurrent.financialObjectLevel.financialConsolidationObjectCode", (Object)consolidation.getFinConsolidationObjectCode());
        crit.addEqualTo("active", (Object)Boolean.TRUE);
        crit.addIn((Object)"categoryCode", (Query)this.buildActiveCostCategorySubQuery());
        QueryByCriteria q = new QueryByCriteria(CostCategoryObjectCode.class, crit);
        return (CostCategoryDetail)TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)q));
    }

    protected ReportQueryByCriteria buildActiveCostCategorySubQuery() {
        Criteria crit = new Criteria();
        crit.addEqualTo("active", (Object)Boolean.TRUE);
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(CostCategory.class, (Criteria)crit);
        subQuery.setAttributes(new String[]{"categoryCode"});
        return subQuery;
    }

    @Override
    public CostCategoryDetail retrieveMatchingCostCategoryLevelAmongLevels(CostCategoryObjectLevel objectLevel) {
        Criteria crit = new Criteria();
        if (!StringUtils.isBlank((CharSequence)objectLevel.getCategoryCode())) {
            crit.addNotEqualTo((Object)"categoryCode", (Object)objectLevel.getCategoryCode());
        }
        crit.addEqualTo("chartOfAccountsCode", (Object)objectLevel.getChartOfAccountsCode());
        crit.addEqualTo("financialObjectLevelCode", (Object)objectLevel.getFinancialObjectLevelCode());
        crit.addEqualTo("active", (Object)Boolean.TRUE);
        crit.addIn((Object)"categoryCode", (Query)this.buildActiveCostCategorySubQuery());
        QueryByCriteria q = new QueryByCriteria(CostCategoryObjectLevel.class, crit);
        return (CostCategoryDetail)TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)q));
    }

    @Override
    public CostCategoryDetail retrieveMatchingCostCategoryLevelAmongConsolidations(CostCategoryObjectLevel level) {
        Criteria consolidationCrit = new Criteria();
        if (!StringUtils.isBlank((CharSequence)level.getCategoryCode())) {
            consolidationCrit.addNotEqualTo((Object)"categoryCode", (Object)level.getCategoryCode());
        }
        consolidationCrit.addEqualTo("chartOfAccountsCode", (Object)level.getChartOfAccountsCode());
        consolidationCrit.addEqualTo("finConsolidationObjectCode", (Object)this.buildLevelConsolidationCodeSubQuery(level));
        consolidationCrit.addEqualTo("active", (Object)Boolean.TRUE);
        consolidationCrit.addIn((Object)"categoryCode", (Query)this.buildActiveCostCategorySubQuery());
        QueryByCriteria consolidationQuery = new QueryByCriteria(CostCategoryObjectConsolidation.class, consolidationCrit);
        return (CostCategoryDetail)TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)consolidationQuery));
    }

    protected ReportQueryByCriteria buildLevelConsolidationCodeSubQuery(CostCategoryObjectLevel level) {
        Criteria crit = new Criteria();
        crit.addEqualTo("chartOfAccountsCode", (Object)level.getChartOfAccountsCode());
        crit.addEqualTo("financialObjectLevelCode", (Object)level.getFinancialObjectLevelCode());
        crit.addEqualTo("active", (Object)Boolean.TRUE);
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(ObjectLevel.class, (Criteria)crit);
        subQuery.setAttributes(new String[]{"financialConsolidationObjectCode"});
        return subQuery;
    }

    @Override
    public CostCategoryDetail retrieveMatchingCostCategoryLevelAmongCodes(CostCategoryObjectLevel level) {
        Criteria crit = new Criteria();
        if (!StringUtils.isBlank((CharSequence)level.getCategoryCode())) {
            crit.addNotEqualTo((Object)"categoryCode", (Object)level.getCategoryCode());
        }
        crit.addEqualTo("chartOfAccountsCode", (Object)level.getChartOfAccountsCode());
        crit.addEqualTo("objectCodeCurrent.financialObjectLevel.financialObjectLevelCode", (Object)level.getFinancialObjectLevelCode());
        crit.addEqualTo("active", (Object)Boolean.TRUE);
        crit.addIn((Object)"categoryCode", (Query)this.buildActiveCostCategorySubQuery());
        QueryByCriteria q = new QueryByCriteria(CostCategoryObjectCode.class, crit);
        return (CostCategoryDetail)TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)q));
    }

    @Override
    public CostCategoryDetail retrieveMatchingCostCategoryObjectCodeAmongCodes(CostCategoryObjectCode objectCode) {
        Criteria crit = new Criteria();
        if (!StringUtils.isBlank((CharSequence)objectCode.getCategoryCode())) {
            crit.addNotEqualTo((Object)"categoryCode", (Object)objectCode.getCategoryCode());
        }
        crit.addEqualTo("chartOfAccountsCode", (Object)objectCode.getChartOfAccountsCode());
        crit.addEqualTo("financialObjectCode", (Object)objectCode.getFinancialObjectCode());
        crit.addEqualTo("active", (Object)Boolean.TRUE);
        crit.addIn((Object)"categoryCode", (Query)this.buildActiveCostCategorySubQuery());
        QueryByCriteria uniqueQuery = new QueryByCriteria(CostCategoryObjectCode.class, crit);
        return (CostCategoryDetail)TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)uniqueQuery));
    }

    @Override
    public CostCategoryDetail retrieveMatchingCostCategoryObjectCodeAmongLevels(CostCategoryObjectCode objectCode) {
        Criteria objectLevelCrit = new Criteria();
        if (!StringUtils.isBlank((CharSequence)objectCode.getCategoryCode())) {
            objectLevelCrit.addNotEqualTo((Object)"categoryCode", (Object)objectCode.getCategoryCode());
        }
        objectLevelCrit.addEqualTo("chartOfAccountsCode", (Object)objectCode.getChartOfAccountsCode());
        objectLevelCrit.addEqualTo("financialObjectLevelCode", (Object)this.buildObjectCodeLevelCodeSubQuery(objectCode));
        objectLevelCrit.addEqualTo("active", (Object)Boolean.TRUE);
        objectLevelCrit.addIn((Object)"categoryCode", (Query)this.buildActiveCostCategorySubQuery());
        QueryByCriteria objectLevelQuery = new QueryByCriteria(CostCategoryObjectLevel.class, objectLevelCrit);
        return (CostCategoryDetail)TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)objectLevelQuery));
    }

    protected ReportQueryByCriteria buildObjectCodeLevelCodeSubQuery(CostCategoryObjectCode objectCode) {
        Criteria crit = new Criteria();
        crit.addEqualTo("chartOfAccountsCode", (Object)objectCode.getChartOfAccountsCode());
        crit.addEqualTo("financialObjectCode", (Object)objectCode.getFinancialObjectCode());
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(ObjectCodeCurrent.class, (Criteria)crit);
        subQuery.setAttributes(new String[]{"financialObjectLevelCode"});
        return subQuery;
    }

    @Override
    public CostCategoryDetail retrieveCostCategoryObjectCodeAmongConsolidations(CostCategoryObjectCode objectCode) {
        Criteria objectConsolidationCrit = new Criteria();
        if (!StringUtils.isBlank((CharSequence)objectCode.getCategoryCode())) {
            objectConsolidationCrit.addNotEqualTo((Object)"categoryCode", (Object)objectCode.getCategoryCode());
        }
        objectConsolidationCrit.addEqualTo("chartOfAccountsCode", (Object)objectCode.getChartOfAccountsCode());
        objectConsolidationCrit.addEqualTo("finConsolidationObjectCode", (Object)this.buildObjectCodeConsolidationCodeSubQuery(objectCode));
        objectConsolidationCrit.addEqualTo("active", (Object)Boolean.TRUE);
        objectConsolidationCrit.addIn((Object)"categoryCode", (Query)this.buildActiveCostCategorySubQuery());
        QueryByCriteria objectConsolidationQuery = new QueryByCriteria(CostCategoryObjectConsolidation.class, objectConsolidationCrit);
        return (CostCategoryDetail)TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)objectConsolidationQuery));
    }

    protected ReportQueryByCriteria buildObjectCodeConsolidationCodeSubQuery(CostCategoryObjectCode objectCode) {
        Criteria crit = new Criteria();
        crit.addEqualTo("chartOfAccountsCode", (Object)objectCode.getChartOfAccountsCode());
        crit.addEqualTo("financialObjectCode", (Object)objectCode.getFinancialObjectCode());
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(ObjectCodeCurrent.class, (Criteria)crit);
        subQuery.setAttributes(new String[]{"financialObjectLevel.financialConsolidationObjectCode"});
        return subQuery;
    }

    @Override
    public List<Balance> getBalancesForCostCategory(Integer fiscalYear, String chartOfAccountsCode, String accountNumber, String balanceType, Collection<String> objectTypeCodes, CostCategory costCategory) {
        if (!costCategory.isActive()) {
            return new ArrayList<Balance>();
        }
        Criteria crit = new Criteria();
        crit.addEqualTo("chartOfAccountsCode", (Object)chartOfAccountsCode);
        crit.addEqualTo("accountNumber", (Object)accountNumber);
        crit.addEqualTo("universityFiscalYear", (Object)fiscalYear);
        crit.addEqualTo("balanceTypeCode", (Object)balanceType);
        crit.addIn("objectTypeCode", objectTypeCodes);
        Criteria objectCodesCollectiveCriteria = new Criteria();
        Criteria objectCodeCriteria = new Criteria();
        objectCodeCriteria.addIn((Object)"objectCode", (Query)this.buildObjectCodesOfCostCategorySubQuery(costCategory, chartOfAccountsCode));
        objectCodesCollectiveCriteria.addOrCriteria(objectCodeCriteria);
        Criteria objectLevelCriteria = new Criteria();
        objectLevelCriteria.addIn((Object)"financialObject.financialObjectLevelCode", (Query)this.buildObjectLevelsOfCostCategorySubQuery(costCategory, chartOfAccountsCode));
        objectCodesCollectiveCriteria.addOrCriteria(objectLevelCriteria);
        Criteria consolidationCriteria = new Criteria();
        consolidationCriteria.addIn((Object)"financialObject.financialObjectLevel.financialConsolidationObjectCode", (Query)this.buildObjectConsolidationsOfCostCategorySubQuery(costCategory, chartOfAccountsCode));
        objectCodesCollectiveCriteria.addOrCriteria(consolidationCriteria);
        crit.addAndCriteria(objectCodesCollectiveCriteria);
        QueryByCriteria q = new QueryByCriteria(Balance.class, crit);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)q);
    }

    protected ReportQueryByCriteria buildObjectCodesOfCostCategorySubQuery(CostCategory costCategory, String chartOfAccountsCode) {
        Criteria crit = new Criteria();
        crit.addEqualTo("categoryCode", (Object)costCategory.getCategoryCode());
        crit.addEqualTo("chartOfAccountsCode", (Object)chartOfAccountsCode);
        crit.addEqualTo("active", (Object)Boolean.TRUE);
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(CostCategoryObjectCode.class, (Criteria)crit);
        subQuery.setAttributes(new String[]{"financialObjectCode"});
        return subQuery;
    }

    protected ReportQueryByCriteria buildObjectLevelsOfCostCategorySubQuery(CostCategory costCategory, String chartOfAccountsCode) {
        Criteria crit = new Criteria();
        crit.addEqualTo("categoryCode", (Object)costCategory.getCategoryCode());
        crit.addEqualTo("chartOfAccountsCode", (Object)chartOfAccountsCode);
        crit.addEqualTo("active", (Object)Boolean.TRUE);
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(CostCategoryObjectLevel.class, (Criteria)crit);
        subQuery.setAttributes(new String[]{"financialObjectLevelCode"});
        return subQuery;
    }

    protected ReportQueryByCriteria buildObjectConsolidationsOfCostCategorySubQuery(CostCategory costCategory, String chartOfAccountsCode) {
        Criteria crit = new Criteria();
        crit.addEqualTo("categoryCode", (Object)costCategory.getCategoryCode());
        crit.addEqualTo("chartOfAccountsCode", (Object)chartOfAccountsCode);
        crit.addEqualTo("active", (Object)Boolean.TRUE);
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(CostCategoryObjectConsolidation.class, (Criteria)crit);
        subQuery.setAttributes(new String[]{"finConsolidationObjectCode"});
        return subQuery;
    }

    @Override
    public CostCategory getCostCategoryForObjectCode(Integer universityFiscalYear, String chartOfAccountsCode, String financialObjectCode) {
        Criteria crit = new Criteria();
        Criteria objectCodesCriteria = new Criteria();
        objectCodesCriteria.addEqualTo("objectCodes.chartOfAccountsCode", (Object)chartOfAccountsCode);
        objectCodesCriteria.addEqualTo("objectCodes.financialObjectCode", (Object)financialObjectCode);
        objectCodesCriteria.addEqualTo("objectCodes.active", (Object)Boolean.TRUE);
        Criteria objectLevelsCriteria = new Criteria();
        objectLevelsCriteria.addEqualTo("objectLevels.chartOfAccountsCode", (Object)chartOfAccountsCode);
        objectLevelsCriteria.addIn((Object)"objectLevels.financialObjectLevelCode", (Query)this.buildObjectCodeOfBalanceSubQuery(universityFiscalYear, chartOfAccountsCode, financialObjectCode, "financialObjectLevelCode"));
        objectLevelsCriteria.addEqualTo("objectLevels.active", (Object)Boolean.TRUE);
        Criteria objectConsolidationsCriteria = new Criteria();
        objectConsolidationsCriteria.addEqualTo("objectConsolidations.chartOfAccountsCode", (Object)chartOfAccountsCode);
        objectConsolidationsCriteria.addIn((Object)"objectConsolidations.finConsolidationObjectCode", (Query)this.buildObjectCodeOfBalanceSubQuery(universityFiscalYear, chartOfAccountsCode, financialObjectCode, "financialObjectLevel.financialConsolidationObjectCode"));
        objectConsolidationsCriteria.addEqualTo("objectConsolidations.active", (Object)Boolean.TRUE);
        crit.addOrCriteria(objectCodesCriteria);
        crit.addOrCriteria(objectLevelsCriteria);
        crit.addOrCriteria(objectConsolidationsCriteria);
        QueryByCriteria q = new QueryByCriteria(CostCategory.class, crit);
        Collection costCategories = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)q);
        if (CollectionUtils.isEmpty((Collection)costCategories)) {
            return null;
        }
        CostCategory result = (CostCategory)((Object)TransactionalServiceUtils.retrieveFirstAndExhaustIterator(costCategories.iterator()));
        return result;
    }

    protected ReportQueryByCriteria buildObjectCodeOfBalanceSubQuery(Integer universityFiscalYear, String chartOfAccountsCode, String financialObjectCode, String retrievalProperty) {
        Criteria crit = new Criteria();
        crit.addEqualTo("universityFiscalYear", (Object)universityFiscalYear);
        crit.addEqualTo("chartOfAccountsCode", (Object)chartOfAccountsCode);
        crit.addEqualTo("financialObjectCode", (Object)financialObjectCode);
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(ObjectCode.class, (Criteria)crit);
        subQuery.setAttributes(new String[]{retrievalProperty});
        return subQuery;
    }
}

