/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.dataaccess.impl;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.module.ar.businessobject.Lockbox;
import org.kuali.kfs.module.ar.dataaccess.LockboxDao;
import org.kuali.kfs.sys.util.TransactionalServiceUtils;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class LockboxDaoOjb
extends PlatformAwareDaoBaseOjb
implements LockboxDao {
    private static final Logger LOG = LogManager.getLogger(LockboxDaoOjb.class);

    @Override
    public Collection<Lockbox> getAllLockboxes() {
        LOG.debug("getAllLockboxes() started");
        Criteria criteria = new Criteria();
        QueryByCriteria query = new QueryByCriteria(Lockbox.class, criteria);
        query.addOrderByAscending("processedInvoiceDate");
        query.addOrderByAscending("batchSequenceNumber");
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public Long getMaxLockboxSequenceNumber() {
        Criteria crit = new Criteria();
        ReportQueryByCriteria reportQuery = QueryFactory.newReportQuery(Lockbox.class, (Criteria)crit);
        reportQuery.setAttributes(new String[]{"MAX(AR_INV_SEQ_NBR)"});
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)reportQuery);
        if (iter.hasNext()) {
            Object[] data = (Object[])TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)iter);
            BigDecimal max = (BigDecimal)data[0];
            if (max == null) {
                return new Long(0L);
            }
            return new Long(max.longValue());
        }
        return new Long(0L);
    }
}

