/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.service.EntryService;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.datadictionary.DocumentEntry;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.businessobject.PaymentMedium;
import org.kuali.kfs.module.ar.document.service.CashControlDocumentService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.Bank;
import org.kuali.kfs.sys.businessobject.ElectronicPaymentClaim;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AmountTotaling;
import org.kuali.kfs.sys.document.ElectronicPaymentClaiming;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.document.GeneralLedgerPostingDocument;
import org.kuali.kfs.sys.document.GeneralLedgerPostingDocumentBase;
import org.kuali.kfs.sys.service.BankService;
import org.kuali.kfs.sys.service.ElectronicPaymentClaimingService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.web.format.CurrencyFormatter;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class CashControlDocument
extends GeneralLedgerPostingDocumentBase
implements AmountTotaling,
GeneralLedgerPendingEntrySource,
ElectronicPaymentClaiming,
GeneralLedgerPostingDocument {
    protected static final String NODE_ASSOCIATED_WITH_ELECTRONIC_PAYMENT = "AssociatedWithElectronicPayment";
    protected static Logger LOG = LogManager.getLogger(CashControlDocument.class);
    protected String referenceFinancialDocumentNumber;
    protected String proposalNumber;
    protected Integer universityFiscalYear;
    protected String universityFiscalPeriodCode;
    protected String customerPaymentMediumCode;
    protected KualiDecimal cashControlTotalAmount = KualiDecimal.ZERO;
    protected String lockboxNumber;
    protected String bankCode;
    protected Bank bank;
    protected PaymentMedium customerPaymentMedium;
    protected AccountingPeriod universityFiscalPeriod;
    protected AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = new AccountsReceivableDocumentHeader();
    protected List<CashControlDetail> cashControlDetails;
    protected List<GeneralLedgerPendingEntry> generalLedgerPendingEntries;
    protected static final String GENERAL_LEDGER_POSTING_HELPER_BEAN_ID = "kfsGenericGeneralLedgerPostingHelper";
    protected List<ElectronicPaymentClaim> electronicPaymentClaims;

    public CashControlDocument() {
        this.customerPaymentMedium = new PaymentMedium();
        UniversityDateService universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
        this.universityFiscalYear = universityDateService.getCurrentUniversityDate().getUniversityFiscalYear();
        this.universityFiscalPeriod = universityDateService.getCurrentUniversityDate().getAccountingPeriod();
        this.universityFiscalPeriodCode = universityDateService.getCurrentUniversityDate().getUniversityFiscalAccountingPeriod();
        this.cashControlDetails = new ArrayList<CashControlDetail>();
        this.generalLedgerPendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
        this.electronicPaymentClaims = new ArrayList<ElectronicPaymentClaim>();
        try {
            DataDictionaryService ddService = (DataDictionaryService)SpringContext.getBean(DataDictionaryService.class);
            DocumentEntry docEntry = ddService.getDataDictionary().getDocumentEntry(ddService.getValidDocumentClassByTypeName("CTRL").getCanonicalName());
            String documentTypeCode = docEntry.getDocumentTypeName();
            if (((BankService)SpringContext.getBean(BankService.class)).isBankSpecificationEnabled()) {
                this.bankCode = ((ParameterService)SpringContext.getBean(ParameterService.class)).getSubParameterValueAsString(Bank.class, "DEFAULT_BANK_BY_DOCUMENT_TYPE", documentTypeCode);
            }
        }
        catch (Exception x) {
            LOG.error("Problem occurred setting default bank code for cash control document", (Throwable)x);
        }
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getReferenceFinancialDocumentNumber() {
        return this.referenceFinancialDocumentNumber;
    }

    public void setReferenceFinancialDocumentNumber(String referenceFinancialDocumentNumber) {
        this.referenceFinancialDocumentNumber = referenceFinancialDocumentNumber;
    }

    public Integer getUniversityFiscalYear() {
        return this.universityFiscalYear;
    }

    public void setUniversityFiscalYear(Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }

    public String getUniversityFiscalPeriodCode() {
        return this.universityFiscalPeriodCode;
    }

    public void setUniversityFiscalPeriodCode(String universityFiscalPeriodCode) {
        this.universityFiscalPeriodCode = universityFiscalPeriodCode;
    }

    public String getCustomerPaymentMediumCode() {
        return this.customerPaymentMediumCode;
    }

    public void setCustomerPaymentMediumCode(String customerPaymentMediumCode) {
        this.customerPaymentMediumCode = customerPaymentMediumCode;
    }

    public KualiDecimal getCashControlTotalAmount() {
        return this.cashControlTotalAmount;
    }

    public void setCashControlTotalAmount(KualiDecimal cashControlTotalAmount) {
        this.cashControlTotalAmount = cashControlTotalAmount;
    }

    public AccountingPeriod getUniversityFiscalPeriod() {
        return this.universityFiscalPeriod;
    }

    @Deprecated
    public void setUniversityFiscalPeriod(AccountingPeriod universityFiscalPeriod) {
        this.universityFiscalPeriod = universityFiscalPeriod;
    }

    public AccountsReceivableDocumentHeader getAccountsReceivableDocumentHeader() {
        return this.accountsReceivableDocumentHeader;
    }

    public void setAccountsReceivableDocumentHeader(AccountsReceivableDocumentHeader accountsReceivableDocumentHeader) {
        this.accountsReceivableDocumentHeader = accountsReceivableDocumentHeader;
    }

    public List<CashControlDetail> getCashControlDetails() {
        return this.cashControlDetails;
    }

    public void setCashControlDetails(List<CashControlDetail> cashControlDetails) {
        this.cashControlDetails = cashControlDetails;
    }

    public void addCashControlDetail(CashControlDetail cashControlDetail) {
        this.prepareCashControlDetail(cashControlDetail);
        if (cashControlDetail.getFinancialDocumentLineAmount() != null) {
            this.cashControlTotalAmount = (KualiDecimal)this.cashControlTotalAmount.add((AbstractKualiDecimal)cashControlDetail.getFinancialDocumentLineAmount());
        }
        this.cashControlDetails.add(cashControlDetail);
    }

    public void deleteCashControlDetail(int index) {
        CashControlDetail cashControlDetail = this.cashControlDetails.remove(index);
        this.cashControlTotalAmount = (KualiDecimal)this.cashControlTotalAmount.subtract((AbstractKualiDecimal)cashControlDetail.getFinancialDocumentLineAmount());
    }

    protected void prepareCashControlDetail(CashControlDetail cashControlDetail) {
        cashControlDetail.setDocumentNumber(this.getDocumentNumber());
    }

    public PaymentMedium getCustomerPaymentMedium() {
        return this.customerPaymentMedium;
    }

    public void setCustomerPaymentMedium(PaymentMedium customerPaymentMedium) {
        this.customerPaymentMedium = customerPaymentMedium;
    }

    public KualiDecimal getTotalDollarAmount() {
        return this.getCashControlTotalAmount();
    }

    public String getCurrencyFormattedTotalCashControlAmount() {
        return (String)new CurrencyFormatter().format((Object)this.getCashControlTotalAmount());
    }

    public CashControlDetail getCashControlDetail(int index) {
        if (index >= this.cashControlDetails.size()) {
            for (int i = this.cashControlDetails.size(); i <= index; ++i) {
                this.cashControlDetails.add(new CashControlDetail());
            }
        }
        return this.cashControlDetails.get(index);
    }

    public void addPendingEntry(GeneralLedgerPendingEntry entry) {
        this.generalLedgerPendingEntries.add(entry);
    }

    public void clearAnyGeneralLedgerPendingEntries() {
        this.generalLedgerPendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
    }

    public void customizeExplicitGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail postable, GeneralLedgerPendingEntry explicitEntry) {
        if (explicitEntry.getFinancialDocumentTypeCode().equalsIgnoreCase("GEC")) {
            explicitEntry.setTransactionLedgerEntryDescription(this.buildTransactionLedgerEntryDescriptionUsingRefOriginAndRefDocNumber(postable));
            explicitEntry.setReferenceFinancialDocumentNumber(null);
            explicitEntry.setReferenceFinancialSystemOriginationCode(null);
            explicitEntry.setReferenceFinancialDocumentTypeCode(null);
        }
    }

    protected String buildTransactionLedgerEntryDescriptionUsingRefOriginAndRefDocNumber(GeneralLedgerPendingEntrySourceDetail line) {
        String description = "";
        description = line.getReferenceOriginCode() + "-" + line.getReferenceNumber();
        description = StringUtils.isNotBlank((CharSequence)line.getFinancialDocumentLineDescription()) ? description + ": " + line.getFinancialDocumentLineDescription() : description + ": " + this.getDocumentHeader().getDocumentDescription();
        if (description.length() > 40) {
            description = description.substring(0, 37) + "...";
        }
        return description;
    }

    public boolean customizeOffsetGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail accountingLine, GeneralLedgerPendingEntry explicitEntry, GeneralLedgerPendingEntry offsetEntry) {
        return false;
    }

    public boolean generateDocumentGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        boolean success = true;
        CashControlDocumentService cashControlDocumentService = (CashControlDocumentService)SpringContext.getBean(CashControlDocumentService.class);
        if (this.getCustomerPaymentMediumCode().equalsIgnoreCase("CK")) {
            success &= cashControlDocumentService.createCashReceiptGLPEs(this, sequenceHelper);
            success &= cashControlDocumentService.createBankOffsetGLPEs(this, sequenceHelper);
        } else if (this.getCustomerPaymentMediumCode().equalsIgnoreCase("WT")) {
            success &= cashControlDocumentService.createDistributionOfIncomeAndExpenseGLPEs(this, sequenceHelper);
        } else if (this.getCustomerPaymentMediumCode().equalsIgnoreCase("CR")) {
            success &= cashControlDocumentService.createGeneralErrorCorrectionGLPEs(this, sequenceHelper);
        }
        return success;
    }

    public KualiDecimal getGeneralLedgerPendingEntryAmountForDetail(GeneralLedgerPendingEntrySourceDetail postable) {
        return (KualiDecimal)postable.getAmount().abs();
    }

    public List<GeneralLedgerPendingEntrySourceDetail> getGeneralLedgerPendingEntrySourceDetails() {
        return new ArrayList<GeneralLedgerPendingEntrySourceDetail>();
    }

    public boolean generateGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        return true;
    }

    public Integer getPostingYear() {
        return ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear();
    }

    public boolean isDebit(GeneralLedgerPendingEntrySourceDetail postable) {
        AccountingLine accountingLine = (AccountingLine)postable;
        return accountingLine.getDebitCreditCode().equalsIgnoreCase("D");
    }

    public List<GeneralLedgerPendingEntry> getGeneralLedgerPendingEntries() {
        return this.generalLedgerPendingEntries;
    }

    public void setGeneralLedgerPendingEntries(List<GeneralLedgerPendingEntry> generalLedgerPendingEntries) {
        this.generalLedgerPendingEntries = generalLedgerPendingEntries;
    }

    public void changeGeneralLedgerPendingEntriesApprovedStatusCode() {
        for (GeneralLedgerPendingEntry glpe : this.getGeneralLedgerPendingEntries()) {
            glpe.setFinancialDocumentApprovedCode("A");
        }
    }

    public GeneralLedgerPendingEntry getGeneralLedgerPendingEntry(int index) {
        while (this.generalLedgerPendingEntries.size() <= index) {
            this.generalLedgerPendingEntries.add(new GeneralLedgerPendingEntry());
        }
        return this.generalLedgerPendingEntries.get(index);
    }

    public String getLockboxNumber() {
        CashControlDocumentService cashControlDocumentService = (CashControlDocumentService)SpringContext.getBean(CashControlDocumentService.class);
        this.lockboxNumber = cashControlDocumentService.getLockboxNumber(this);
        return this.lockboxNumber;
    }

    public void populateDocumentForRouting() {
        CashControlDocumentService cashControlDocumentService = (CashControlDocumentService)SpringContext.getBean(CashControlDocumentService.class);
        this.lockboxNumber = cashControlDocumentService.getLockboxNumber(this);
        super.populateDocumentForRouting();
    }

    public void declaimElectronicPaymentClaims() {
        ((ElectronicPaymentClaimingService)SpringContext.getBean(ElectronicPaymentClaimingService.class)).declaimElectronicPaymentClaimsForDocument((Document)this);
    }

    public List<ElectronicPaymentClaim> getElectronicPaymentClaims() {
        return this.electronicPaymentClaims;
    }

    @Deprecated
    public void setElectronicPaymentClaims(List<ElectronicPaymentClaim> electronicPaymentClaims) {
        this.electronicPaymentClaims = electronicPaymentClaims;
    }

    public Document getReferenceFinancialDocument() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        Document document = null;
        try {
            document = documentService.getByDocumentHeaderId(this.getReferenceFinancialDocumentNumber());
        }
        catch (WorkflowException we) {
            LOG.warn("Unable to retreive reference financial document: " + this.getReferenceFinancialDocumentNumber(), (Throwable)we);
        }
        return document;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (NODE_ASSOCIATED_WITH_ELECTRONIC_PAYMENT.equals(nodeName)) {
            return "WT".equals(this.getCustomerPaymentMediumCode());
        }
        return super.answerSplitNodeQuestion(nodeName);
    }

    public String getChartOfAccountsCode() {
        if (this.getAccountsReceivableDocumentHeader() != null) {
            return this.getAccountsReceivableDocumentHeader().getProcessingChartOfAccountCode();
        }
        return null;
    }

    public String getOrganizationCode() {
        if (this.getAccountsReceivableDocumentHeader() != null) {
            return this.getAccountsReceivableDocumentHeader().getProcessingOrganizationCode();
        }
        return null;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public void recalculateTotals() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (CashControlDetail cashControlDetail : this.getCashControlDetails()) {
            total = (KualiDecimal)total.add((AbstractKualiDecimal)cashControlDetail.getFinancialDocumentLineAmount());
        }
        this.cashControlTotalAmount = total;
        this.getFinancialSystemDocumentHeader().setFinancialDocumentTotalAmount(total);
    }

    public void prepareForSave() {
        this.captureWorkflowHeaderInformation();
        this.deleteCashControlDetailsFromDB();
        this.recalculateTotals();
    }

    protected void deleteCashControlDetailsFromDB() {
        BusinessObjectService boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("documentNumber", this.getDocumentNumber());
        boService.deleteMatching(CashControlDetail.class, pkMap);
    }

    public Integer getGeneralLedgerEntriesPostedCount() {
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("documentNumber", this.getDocumentNumber());
        pkMap.put("universityFiscalYear", this.getPostingYear().toString());
        pkMap.put("universityFiscalPeriodCode", this.getPostingPeriodCode());
        pkMap.put("chartOfAccountsCode", this.getChartOfAccountsCode());
        Integer totalGLRecordsCreated = ((EntryService)SpringContext.getBean(EntryService.class)).getEntryRecordCount(pkMap);
        return totalGLRecordsCreated;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }
}

