/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsLetterOfCreditFund;
import org.kuali.kfs.integration.cg.ContractsAndGrantsLetterOfCreditFundGroup;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorLog;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsLetterOfCreditReviewDetail;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsLetterOfCreditReviewDocumentService;
import org.kuali.kfs.module.ar.service.ContractsGrantsInvoiceCreateDocumentService;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocumentBase;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class ContractsGrantsLetterOfCreditReviewDocument
extends FinancialSystemTransactionalDocumentBase {
    private static final Logger LOG = LogManager.getLogger(ContractsGrantsLetterOfCreditReviewDocument.class);
    private String letterOfCreditFundCode;
    private ContractsAndGrantsLetterOfCreditFund letterOfCreditFund;
    private String letterOfCreditFundGroupCode;
    private ContractsAndGrantsLetterOfCreditFundGroup letterOfCreditFundGroup;
    private List<ContractsGrantsLetterOfCreditReviewDetail> headerReviewDetails = new ArrayList<ContractsGrantsLetterOfCreditReviewDetail>();
    private List<ContractsGrantsLetterOfCreditReviewDetail> accountReviewDetails = new ArrayList<ContractsGrantsLetterOfCreditReviewDetail>();
    private static volatile transient ContractsGrantsLetterOfCreditReviewDocumentService contractsGrantsLetterOfCreditReviewDocumentService;
    private static volatile transient OptionsService optionsService;

    public String getLetterOfCreditFundGroupCode() {
        return this.letterOfCreditFundGroupCode;
    }

    public void setLetterOfCreditFundGroupCode(String letterOfCreditFundGroupCode) {
        this.letterOfCreditFundGroupCode = letterOfCreditFundGroupCode;
    }

    public String getLetterOfCreditFundCode() {
        return this.letterOfCreditFundCode;
    }

    public void setLetterOfCreditFundCode(String letterOfCreditFundCode) {
        this.letterOfCreditFundCode = letterOfCreditFundCode;
    }

    public ContractsAndGrantsLetterOfCreditFund getLetterOfCreditFund() {
        this.letterOfCreditFund = (ContractsAndGrantsLetterOfCreditFund)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsLetterOfCreditFund.class).retrieveExternalizableBusinessObjectIfNecessary((BusinessObject)this, (ExternalizableBusinessObject)this.letterOfCreditFund, "letterOfCreditFund");
        return this.letterOfCreditFund;
    }

    public void setLetterOfCreditFund(ContractsAndGrantsLetterOfCreditFund letterOfCreditFund) {
        this.letterOfCreditFund = letterOfCreditFund;
    }

    public ContractsAndGrantsLetterOfCreditFundGroup getLetterOfCreditFundGroup() {
        this.letterOfCreditFundGroup = (ContractsAndGrantsLetterOfCreditFundGroup)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsLetterOfCreditFundGroup.class).retrieveExternalizableBusinessObjectIfNecessary((BusinessObject)this, (ExternalizableBusinessObject)this.letterOfCreditFundGroup, "letterOfCreditFundGroup");
        return this.letterOfCreditFundGroup;
    }

    public void setLetterOfCreditFundGroup(ContractsAndGrantsLetterOfCreditFundGroup letterOfCreditFundGroup) {
        this.letterOfCreditFundGroup = letterOfCreditFundGroup;
    }

    public List<ContractsGrantsLetterOfCreditReviewDetail> getHeaderReviewDetails() {
        ArrayList<ContractsGrantsLetterOfCreditReviewDetail> hdrDetails = new ArrayList<ContractsGrantsLetterOfCreditReviewDetail>();
        for (ContractsGrantsLetterOfCreditReviewDetail hdrD : this.headerReviewDetails) {
            if (!ObjectUtils.isNull((Object)hdrD.getAccountDescription())) continue;
            hdrDetails.add(hdrD);
        }
        return hdrDetails;
    }

    public void setHeaderReviewDetails(List<ContractsGrantsLetterOfCreditReviewDetail> headerReviewDetails) {
        this.headerReviewDetails = headerReviewDetails;
    }

    public List<ContractsGrantsLetterOfCreditReviewDetail> getAccountReviewDetails() {
        ArrayList<ContractsGrantsLetterOfCreditReviewDetail> acctDetails = new ArrayList<ContractsGrantsLetterOfCreditReviewDetail>();
        for (ContractsGrantsLetterOfCreditReviewDetail acctD : this.accountReviewDetails) {
            if (!ObjectUtils.isNotNull((Object)acctD.getAccountDescription()) || !acctD.getAccountDescription().equalsIgnoreCase("Account") && !acctD.getAccountDescription().equalsIgnoreCase("Contract Control Account")) continue;
            acctDetails.add(acctD);
        }
        return acctDetails;
    }

    public void setAccountReviewDetails(List<ContractsGrantsLetterOfCreditReviewDetail> accountReviewDetails) {
        this.accountReviewDetails = accountReviewDetails;
    }

    public void clearInitFields() {
        LOG.debug("clearDocument() started");
        this.setLetterOfCreditFundGroupCode(null);
        this.setLetterOfCreditFundCode(null);
    }

    public boolean populateContractsGrantsLOCReviewDetails(Collection<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs) {
        boolean valid = true;
        ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService = (ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class);
        ContractsGrantsInvoiceCreateDocumentService contractsGrantsInvoiceCreateDocumentService = (ContractsGrantsInvoiceCreateDocumentService)SpringContext.getBean(ContractsGrantsInvoiceCreateDocumentService.class);
        ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService = (ContractsAndGrantsModuleBillingService)SpringContext.getBean(ContractsAndGrantsModuleBillingService.class);
        Map criteria = contractsAndGrantsModuleBillingService.getLetterOfCreditAwardCriteria(this.getLetterOfCreditFundGroupCode(), this.getLetterOfCreditFundCode());
        criteria.put("billingFrequencyCode", ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT.getCode());
        List<ContractsAndGrantsBillingAward> awards = ContractsGrantsLetterOfCreditReviewDocument.getContractsGrantsLetterOfCreditReviewDocumentService().getActiveAwardsByCriteria(criteria);
        if (CollectionUtils.isEmpty(awards)) {
            GlobalVariables.getMessageMap().putErrorForSectionId("Contracts & Grants LOC Review Initiation", "error.document.no.awards.retrieved", new String[0]);
        } else {
            List validAwards = new ArrayList();
            validAwards = (List)contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.LOC.getCode());
            if (CollectionUtils.isEmpty(validAwards)) {
                GlobalVariables.getMessageMap().putWarningForSectionId("Contracts & Grants LOC Review Initiation", "error.document.awards.invalid", new String[0]);
                valid = false;
            } else {
                for (ContractsAndGrantsBillingAward award : validAwards) {
                    Map<String, KualiDecimal> awardAccountAmountsToDraw = ContractsGrantsLetterOfCreditReviewDocument.getContractsGrantsLetterOfCreditReviewDocumentService().calculateAwardAccountAmountsToDraw(award, award.getActiveAwardAccounts());
                    KualiDecimal totalAmountToDraw = KualiDecimal.ZERO;
                    KualiDecimal amountAvailableToDraw = KualiDecimal.ZERO;
                    KualiDecimal totalClaimOnCashBalance = KualiDecimal.ZERO;
                    KualiDecimal totalAwardBudgetAmount = KualiDecimal.ZERO;
                    ContractsGrantsLetterOfCreditReviewDetail locReviewDtl = new ContractsGrantsLetterOfCreditReviewDetail();
                    locReviewDtl.setDocumentNumber(this.documentNumber);
                    locReviewDtl.setProposalNumber(award.getProposalNumber());
                    locReviewDtl.setAwardDocumentNumber(award.getAwardDocumentNumber());
                    locReviewDtl.setAgencyNumber(award.getAgencyNumber());
                    locReviewDtl.setCustomerNumber(award.getAgency().getCustomerNumber());
                    locReviewDtl.setAwardBeginningDate(award.getAwardBeginningDate());
                    locReviewDtl.setAwardEndingDate(award.getAwardEndingDate());
                    amountAvailableToDraw = ContractsGrantsLetterOfCreditReviewDocument.getContractsGrantsLetterOfCreditReviewDocumentService().getAmountAvailableToDraw(award.getAwardTotalAmount(), award.getActiveAwardAccounts());
                    locReviewDtl.setAmountAvailableToDraw(amountAvailableToDraw);
                    if (ObjectUtils.isNotNull((Object)award.getLetterOfCreditFund())) {
                        locReviewDtl.setLetterOfCreditAmount(award.getLetterOfCreditFund().getLetterOfCreditFundAmount());
                    }
                    this.headerReviewDetails.add(locReviewDtl);
                    SystemOptions systemOption = ContractsGrantsLetterOfCreditReviewDocument.getOptionsService().getCurrentYearOptions();
                    for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
                        String awardAccountKey = ContractsGrantsLetterOfCreditReviewDocument.getContractsGrantsLetterOfCreditReviewDocumentService().getAwardAccountKey(awardAccount);
                        locReviewDtl = new ContractsGrantsLetterOfCreditReviewDetail();
                        locReviewDtl.setDocumentNumber(this.documentNumber);
                        locReviewDtl.setProposalNumber(award.getProposalNumber());
                        locReviewDtl.setChartOfAccountsCode(awardAccount.getChartOfAccountsCode());
                        locReviewDtl.setAccountNumber(awardAccount.getAccountNumber());
                        locReviewDtl.setAccountExpirationDate(awardAccount.getAccount().getAccountExpirationDate());
                        locReviewDtl.setClaimOnCashBalance((KualiDecimal)awardAccountAmountsToDraw.get(awardAccountKey).negated());
                        totalClaimOnCashBalance = (KualiDecimal)totalClaimOnCashBalance.add((AbstractKualiDecimal)locReviewDtl.getClaimOnCashBalance());
                        locReviewDtl.setAwardBudgetAmount(contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, systemOption.getBudgetCheckingBalanceTypeCd(), award.getAwardBeginningDate()));
                        totalAwardBudgetAmount = (KualiDecimal)totalAwardBudgetAmount.add((AbstractKualiDecimal)locReviewDtl.getAwardBudgetAmount());
                        if (ObjectUtils.isNotNull((Object)awardAccount.getAccount().getContractControlAccountNumber()) && awardAccount.getAccountNumber().equalsIgnoreCase(awardAccount.getAccount().getContractControlAccountNumber())) {
                            locReviewDtl.setAccountDescription("Contract Control Account");
                        } else {
                            locReviewDtl.setAccountDescription("Account");
                        }
                        locReviewDtl.setAmountToDraw(awardAccountAmountsToDraw.get(awardAccountKey));
                        locReviewDtl.setHiddenAmountToDraw(awardAccountAmountsToDraw.get(awardAccountKey));
                        totalAmountToDraw = (KualiDecimal)totalAmountToDraw.add((AbstractKualiDecimal)locReviewDtl.getAmountToDraw());
                        this.accountReviewDetails.add(locReviewDtl);
                    }
                    for (ContractsGrantsLetterOfCreditReviewDetail detail : this.getHeaderReviewDetails()) {
                        if (!ObjectUtils.isNotNull((Object)detail.getAgencyNumber()) || !ObjectUtils.isNull((Object)detail.getAccountDescription()) || !detail.getProposalNumber().equals(award.getProposalNumber())) continue;
                        detail.setAmountToDraw(totalAmountToDraw);
                        detail.setHiddenAmountToDraw(totalAmountToDraw);
                        detail.setClaimOnCashBalance(totalClaimOnCashBalance);
                        detail.setAwardBudgetAmount(totalAwardBudgetAmount);
                    }
                }
            }
        }
        return valid;
    }

    public void prepareForSave() {
        super.prepareForSave();
        for (ContractsGrantsLetterOfCreditReviewDetail detail : this.getAccountReviewDetails()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("proposalNumber", detail.getProposalNumber());
            ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsBillingAward.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAward.class, map);
            if (ObjectUtils.isNull((Object)detail.getAmountToDraw())) {
                detail.setAmountToDraw(KualiDecimal.ZERO);
            }
            detail.setFundsNotDrawn((KualiDecimal)detail.getHiddenAmountToDraw().subtract((AbstractKualiDecimal)detail.getAmountToDraw()));
            if (!detail.getFundsNotDrawn().isNegative()) continue;
            GlobalVariables.getMessageMap().putError("fundsNotDrawn", "error.document.amount.to.draw.invalid", new String[0]);
            detail.setFundsNotDrawn(KualiDecimal.ZERO);
            detail.setAmountToDraw((KualiDecimal)detail.getHiddenAmountToDraw().subtract((AbstractKualiDecimal)detail.getFundsNotDrawn()));
        }
        HashSet<String> proposalNumberSet = new HashSet<String>();
        for (ContractsGrantsLetterOfCreditReviewDetail detail : this.getHeaderReviewDetails()) {
            proposalNumberSet.add(detail.getProposalNumber());
        }
        for (String proposalNumber : proposalNumberSet) {
            KualiDecimal totalAmountToDraw = KualiDecimal.ZERO;
            for (ContractsGrantsLetterOfCreditReviewDetail detail : this.getAccountReviewDetails()) {
                if (!ObjectUtils.isNotNull((Object)detail.getAccountDescription()) || !StringUtils.equals((CharSequence)detail.getProposalNumber(), (CharSequence)proposalNumber)) continue;
                totalAmountToDraw = (KualiDecimal)totalAmountToDraw.add((AbstractKualiDecimal)detail.getAmountToDraw());
            }
            for (ContractsGrantsLetterOfCreditReviewDetail detail : this.getHeaderReviewDetails()) {
                if (!ObjectUtils.isNotNull((Object)detail.getAgencyNumber()) || !ObjectUtils.isNull((Object)detail.getAccountDescription()) || !StringUtils.equals((CharSequence)detail.getProposalNumber(), (CharSequence)proposalNumber)) continue;
                detail.setAmountToDraw(totalAmountToDraw);
            }
        }
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            ContractsGrantsLetterOfCreditReviewDocument.getContractsGrantsLetterOfCreditReviewDocumentService().generateContractsGrantsInvoiceDocuments(this);
        }
    }

    public static ContractsGrantsLetterOfCreditReviewDocumentService getContractsGrantsLetterOfCreditReviewDocumentService() {
        if (contractsGrantsLetterOfCreditReviewDocumentService == null) {
            contractsGrantsLetterOfCreditReviewDocumentService = (ContractsGrantsLetterOfCreditReviewDocumentService)SpringContext.getBean(ContractsGrantsLetterOfCreditReviewDocumentService.class);
        }
        return contractsGrantsLetterOfCreditReviewDocumentService;
    }

    public static OptionsService getOptionsService() {
        if (optionsService == null) {
            optionsService = (OptionsService)SpringContext.getBean(OptionsService.class);
        }
        return optionsService;
    }
}

