/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.TransactionalDocumentBase;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.FinalBilledIndicatorEntry;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class FinalBilledIndicatorDocument
extends TransactionalDocumentBase {
    private static final Logger LOG = LogManager.getLogger(FinalBilledIndicatorDocument.class);
    private List<FinalBilledIndicatorEntry> invoiceEntries = new ArrayList<FinalBilledIndicatorEntry>();

    public List<FinalBilledIndicatorEntry> getInvoiceEntries() {
        return this.invoiceEntries;
    }

    public void setInvoiceEntries(List<FinalBilledIndicatorEntry> invoiceEntries) {
        this.invoiceEntries = invoiceEntries;
    }

    public void updateContractsGrantsInvoiceDocument() throws WorkflowException {
        for (FinalBilledIndicatorEntry entry : this.getInvoiceEntries()) {
            ContractsGrantsInvoiceDocument invoiceDocument = (ContractsGrantsInvoiceDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(entry.getInvoiceDocumentNumber());
            if (!ObjectUtils.isNotNull((Object)invoiceDocument)) continue;
            invoiceDocument.getInvoiceGeneralDetail().setFinalBillIndicator(false);
            ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService = (ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class);
            contractsGrantsInvoiceDocumentService.updateUnfinalizationToAwardAccount(invoiceDocument.getAccountDetails(), invoiceDocument.getInvoiceGeneralDetail().getProposalNumber());
            invoiceDocument.refresh();
            ((DocumentService)SpringContext.getBean(DocumentService.class)).updateDocument((Document)invoiceDocument);
        }
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        String newRouteStatus = statusChangeEvent.getNewRouteStatus();
        if (newRouteStatus.equalsIgnoreCase("P") || newRouteStatus.equalsIgnoreCase("F")) {
            try {
                this.updateContractsGrantsInvoiceDocument();
            }
            catch (WorkflowException ex) {
                LOG.error("problem during FinalBilledIndicatorAction.doProcessingAfterPost()", (Throwable)ex);
                throw new RuntimeException("Could not update Contracts & Grants Invoice Document for Final Billed Indicator Document", ex);
            }
        }
    }

    public void addInvoiceEntry(FinalBilledIndicatorEntry invoiceEntry) {
        invoiceEntry.setDocumentId(this.getDocumentNumber());
        this.invoiceEntries.add(invoiceEntry);
    }

    public void removeInvoiceEntry(int deleteIndex) {
        this.invoiceEntries.remove(deleteIndex);
    }
}

