/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.ar.businessobject.InvoiceRecurrence;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemMaintainable;
import org.kuali.kfs.sys.document.FinancialSystemMaintenanceDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.IdentityManagementService;

public class InvoiceRecurrenceMaintainable
extends FinancialSystemMaintainable {
    private static final Logger LOG = LogManager.getLogger(InvoiceRecurrenceMaintainable.class);
    private static final String INACTIVATING_NODE_NAME = "InvoiceRecurrenceIsInactivating";
    private static final String INITIATED_BY_SYSTEM_USER = "InitiatedBySystemUser";

    protected boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (StringUtils.equalsIgnoreCase((CharSequence)INACTIVATING_NODE_NAME, (CharSequence)nodeName)) {
            FinancialSystemMaintenanceDocument maintDoc = this.getParentMaintDoc();
            if (maintDoc == null || maintDoc.getOldMaintainableObject() == null || maintDoc.getOldMaintainableObject().getBusinessObject() == null) {
                return false;
            }
            boolean oldIsActive = ((InvoiceRecurrence)maintDoc.getOldMaintainableObject().getBusinessObject()).isActive();
            boolean newIsActive = ((InvoiceRecurrence)this.getBusinessObject()).isActive();
            return oldIsActive && !newIsActive;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)INITIATED_BY_SYSTEM_USER, (CharSequence)nodeName)) {
            FinancialSystemMaintenanceDocument maintDoc = this.getParentMaintDoc();
            if (maintDoc == null || maintDoc.getDocumentHeader() == null || maintDoc.getDocumentHeader().getWorkflowDocument() == null || StringUtils.isBlank((CharSequence)maintDoc.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId())) {
                return false;
            }
            String initiatorPrincipalId = maintDoc.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
            Principal principal = ((IdentityManagementService)SpringContext.getBean(IdentityManagementService.class)).getPrincipal(initiatorPrincipalId);
            return principal != null && StringUtils.equalsIgnoreCase((CharSequence)principal.getPrincipalName(), (CharSequence)"kfs");
        }
        throw new UnsupportedOperationException("InvoiceRecurrenceMaintainable does not implement the answerSplitNodeQuestion method. Node name specified was: " + nodeName);
    }

    protected FinancialSystemMaintenanceDocument getParentMaintDoc() {
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        try {
            return (FinancialSystemMaintenanceDocument)documentService.getByDocumentHeaderId(this.getDocumentNumber());
        }
        catch (WorkflowException e) {
            LOG.error("Unable to retrieve maintenance document for use in split node routing - returning null", (Throwable)e);
            return null;
        }
    }

    public void processAfterRetrieve() {
        super.processAfterRetrieve();
        ((InvoiceRecurrence)this.getBusinessObject()).setCustomerInvoiceDocument((CustomerInvoiceDocument)this.getBusinessObjectService().findBySinglePrimaryKey(CustomerInvoiceDocument.class, (Object)((InvoiceRecurrence)this.getBusinessObject()).getInvoiceNumber()));
    }
}

