/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.batch.service.CustomerInvoiceWriteoffBatchService;
import org.kuali.kfs.module.ar.batch.vo.CustomerInvoiceWriteoffBatchVO;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceWriteoffLookupResult;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.businessobject.lookup.CustomerInvoiceWriteoffLookupUtil;
import org.kuali.kfs.module.ar.document.CustomerCreditMemoDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceWriteoffDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableDocumentHeaderService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceWriteoffDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.module.ar.document.service.InvoicePaidAppliedService;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CustomerInvoiceWriteoffDocumentServiceImpl
implements CustomerInvoiceWriteoffDocumentService {
    protected ParameterService parameterService;
    protected UniversityDateService universityDateService;
    protected BusinessObjectService businessObjectService;
    protected AccountsReceivableDocumentHeaderService accountsReceivableDocumentHeaderService;
    protected CustomerInvoiceDocumentService customerInvoiceDocumentService;
    protected CustomerService customerService;
    protected DocumentService documentService;
    protected CustomerInvoiceWriteoffBatchService invoiceWriteoffBatchService;
    protected DateTimeService dateTimeService;
    protected InvoicePaidAppliedService<CustomerInvoiceDetail> paidAppliedService;
    protected FinancialSystemUserService financialSystemUserService;
    protected ObjectCodeService objectCodeService;

    @Override
    public void completeWriteoffProcess(CustomerInvoiceWriteoffDocument writeoff) {
        CustomerInvoiceDocument invoice;
        String invoiceNumber = writeoff.getFinancialDocumentReferenceInvoiceNumber();
        try {
            invoice = (CustomerInvoiceDocument)this.documentService.getByDocumentHeaderId(invoiceNumber);
        }
        catch (WorkflowException e) {
            throw new RuntimeException("A WorkflowException was generated when trying to load Customer Invoice #" + invoiceNumber + ".", e);
        }
        if (!invoice.isOpenInvoiceIndicator()) {
            throw new UnsupportedOperationException("The Invoice Writeoff Document #" + writeoff.getDocumentNumber() + " attempted to writeoff an Invoice [#" + invoiceNumber + "] that was already closed.  This is not supported.");
        }
        Integer paidAppliedItemNumber = 0;
        KualiDecimal totalApplied = KualiDecimal.ZERO;
        List<CustomerInvoiceDetail> invoiceDetails = invoice.getCustomerInvoiceDetailsWithoutDiscounts();
        for (CustomerInvoiceDetail invoiceDetail : invoiceDetails) {
            if (invoiceDetail.getAmountOpen().isZero()) continue;
            if (paidAppliedItemNumber == 0) {
                paidAppliedItemNumber = this.paidAppliedService.getNumberOfInvoicePaidAppliedsForInvoiceDetail(invoiceNumber, invoiceDetail.getInvoiceItemNumber());
            }
            InvoicePaidApplied invoicePaidApplied = new InvoicePaidApplied();
            invoicePaidApplied.setDocumentNumber(writeoff.getDocumentNumber());
            Integer n = paidAppliedItemNumber;
            Integer n2 = paidAppliedItemNumber = Integer.valueOf(paidAppliedItemNumber + 1);
            invoicePaidApplied.setPaidAppliedItemNumber(n);
            invoicePaidApplied.setFinancialDocumentReferenceInvoiceNumber(invoiceNumber);
            invoicePaidApplied.setInvoiceItemNumber(invoiceDetail.getInvoiceItemNumber());
            invoicePaidApplied.setUniversityFiscalYear(this.universityDateService.getCurrentFiscalYear());
            invoicePaidApplied.setUniversityFiscalPeriodCode(this.universityDateService.getCurrentUniversityDate().getUniversityFiscalAccountingPeriod());
            invoicePaidApplied.setInvoiceItemAppliedAmount(invoiceDetail.getAmountOpen());
            this.businessObjectService.save((PersistableBusinessObject)invoicePaidApplied);
            totalApplied = (KualiDecimal)totalApplied.add((AbstractKualiDecimal)invoicePaidApplied.getInvoiceItemAppliedAmount());
        }
        this.customerInvoiceDocumentService.addCloseNote(invoice, writeoff.getDocumentHeader().getWorkflowDocument());
        invoice.setOpenInvoiceIndicator(false);
        invoice.setClosedDate(this.dateTimeService.getCurrentSqlDate());
        this.documentService.updateDocument((Document)invoice);
        writeoff.setInvoiceWriteoffAmount(totalApplied);
        writeoff.getFinancialSystemDocumentHeader().setFinancialDocumentTotalAmount(totalApplied);
        this.documentService.updateDocument((Document)writeoff);
    }

    @Override
    public void setupDefaultValuesForNewCustomerInvoiceWriteoffDocument(CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocument) {
        customerInvoiceWriteoffDocument.setStatusCode("INPR");
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = this.accountsReceivableDocumentHeaderService.getNewAccountsReceivableDocumentHeaderForCurrentUser();
        accountsReceivableDocumentHeader.setDocumentNumber(customerInvoiceWriteoffDocument.getDocumentNumber());
        accountsReceivableDocumentHeader.setCustomerNumber(customerInvoiceWriteoffDocument.getCustomerInvoiceDocument().getAccountsReceivableDocumentHeader().getCustomerNumber());
        customerInvoiceWriteoffDocument.setAccountsReceivableDocumentHeader(accountsReceivableDocumentHeader);
        String writeoffGenerationOption = this.parameterService.getParameterValueAsString(CustomerInvoiceWriteoffDocument.class, "GLPE_WRITEOFF_GENERATION_METHOD");
        boolean isUsingOrgAcctDefaultWriteoffFAU = "2".equals(writeoffGenerationOption);
        String writeoffTaxGenerationOption = this.parameterService.getParameterValueAsString(CustomerInvoiceWriteoffDocument.class, "ALLOW_SALES_TAX_LIABILITY_ADJUSTMENT_IND");
        boolean isUsingTaxGenerationMethodDisallow = "N".equals(writeoffTaxGenerationOption);
        if (isUsingOrgAcctDefaultWriteoffFAU || isUsingTaxGenerationMethodDisallow) {
            Integer currentUniversityFiscalYear = this.universityDateService.getCurrentFiscalYear();
            ChartOrgHolder currentUser = this.financialSystemUserService.getPrimaryOrganization(GlobalVariables.getUserSession().getPerson(), "KFS-AR");
            HashMap<String, Object> criteria = new HashMap<String, Object>(3);
            criteria.put("universityFiscalYear", currentUniversityFiscalYear);
            criteria.put("chartOfAccountsCode", customerInvoiceWriteoffDocument.getCustomerInvoiceDocument().getBillByChartOfAccountCode());
            criteria.put("organizationCode", customerInvoiceWriteoffDocument.getCustomerInvoiceDocument().getBilledByOrganizationCode());
            OrganizationAccountingDefault organizationAccountingDefault = (OrganizationAccountingDefault)this.businessObjectService.findByPrimaryKey(OrganizationAccountingDefault.class, criteria);
            if (ObjectUtils.isNotNull((Object)((Object)organizationAccountingDefault))) {
                customerInvoiceWriteoffDocument.setChartOfAccountsCode(organizationAccountingDefault.getWriteoffChartOfAccountsCode());
                customerInvoiceWriteoffDocument.setAccountNumber(organizationAccountingDefault.getWriteoffAccountNumber());
                customerInvoiceWriteoffDocument.setSubAccountNumber(organizationAccountingDefault.getWriteoffSubAccountNumber());
                customerInvoiceWriteoffDocument.setFinancialObjectCode(organizationAccountingDefault.getWriteoffFinancialObjectCode());
                customerInvoiceWriteoffDocument.setFinancialSubObjectCode(organizationAccountingDefault.getWriteoffFinancialSubObjectCode());
                customerInvoiceWriteoffDocument.setProjectCode(organizationAccountingDefault.getWriteoffProjectCode());
                customerInvoiceWriteoffDocument.setOrganizationReferenceIdentifier(organizationAccountingDefault.getWriteoffOrganizationReferenceIdentifier());
            }
        }
    }

    @Override
    public boolean isCustomerInvoiceWriteoffDocumentApproved(String customerInvoiceWriteoffDocumentNumber) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("documentNumber", customerInvoiceWriteoffDocumentNumber);
        criteria.put("documentHeader.financialDocumentStatusCode", "A");
        return this.businessObjectService.countMatching(CustomerInvoiceWriteoffDocument.class, criteria) == 1;
    }

    @Override
    public Collection<CustomerInvoiceWriteoffLookupResult> getCustomerInvoiceDocumentsForInvoiceWriteoffLookup(Map<String, String> fieldValues) {
        Collection<Object> customerInvoiceDocuments;
        String customerNumber = fieldValues.get("customerNumber");
        String customerName = fieldValues.get("customerName");
        String customerTypeCode = fieldValues.get("customerTypeCode");
        String customerInvoiceNumber = fieldValues.get("customerInvoiceNumber");
        String age = fieldValues.get("age");
        if (StringUtils.isNotEmpty((CharSequence)customerInvoiceNumber)) {
            customerInvoiceDocuments = new ArrayList();
            CustomerInvoiceDocument customerInvoiceDocument = this.customerInvoiceDocumentService.getInvoiceByInvoiceDocumentNumber(customerInvoiceNumber);
            if (ObjectUtils.isNotNull((Object)customerInvoiceDocument) && customerInvoiceDocument.isOpenInvoiceIndicator()) {
                customerInvoiceDocuments.add(customerInvoiceDocument);
            }
        } else {
            customerInvoiceDocuments = StringUtils.isNotEmpty((CharSequence)customerNumber) ? this.customerInvoiceDocumentService.getOpenInvoiceDocumentsByCustomerNumber(customerNumber) : (StringUtils.isNotEmpty((CharSequence)customerName) && StringUtils.isNotEmpty((CharSequence)customerTypeCode) ? this.customerInvoiceDocumentService.getOpenInvoiceDocumentsByCustomerNameByCustomerType(customerName, customerTypeCode) : (StringUtils.isNotEmpty((CharSequence)customerName) ? this.customerInvoiceDocumentService.getOpenInvoiceDocumentsByCustomerName(customerName) : (StringUtils.isNotEmpty((CharSequence)customerTypeCode) ? this.customerInvoiceDocumentService.getOpenInvoiceDocumentsByCustomerType(customerTypeCode) : this.customerInvoiceDocumentService.getAllOpenCustomerInvoiceDocumentsWithoutWorkflow())));
        }
        customerInvoiceDocuments = this.customerInvoiceDocumentService.attachWorkflowHeadersToTheInvoices(customerInvoiceDocuments);
        Collection<CustomerInvoiceDocument> filteredCustomerInvoiceDocuments = this.filterInvoices(customerInvoiceDocuments);
        if (StringUtils.isEmpty((CharSequence)age)) {
            return CustomerInvoiceWriteoffLookupUtil.getPopulatedCustomerInvoiceWriteoffLookupResults(filteredCustomerInvoiceDocuments);
        }
        ArrayList<CustomerInvoiceDocument> eligibleInvoices = new ArrayList<CustomerInvoiceDocument>();
        for (CustomerInvoiceDocument invoice : filteredCustomerInvoiceDocuments) {
            boolean eligibleInvoiceFlag = true;
            eligibleInvoiceFlag = ObjectUtils.isNotNull((Object)invoice.getAge()) ? (eligibleInvoiceFlag &= new Integer(age).compareTo(invoice.getAge()) <= 0) : false;
            if (!eligibleInvoiceFlag) continue;
            eligibleInvoices.add(invoice);
        }
        return CustomerInvoiceWriteoffLookupUtil.getPopulatedCustomerInvoiceWriteoffLookupResults(eligibleInvoices);
    }

    @Override
    public Collection<CustomerInvoiceDocument> filterInvoices(Collection<CustomerInvoiceDocument> customerInvoiceDocuments) {
        ArrayList<CustomerInvoiceDocument> filteredInvoices = new ArrayList<CustomerInvoiceDocument>();
        for (CustomerInvoiceDocument invoice : customerInvoiceDocuments) {
            if (!invoice.getDocumentHeader().getWorkflowDocument().isFinal()) continue;
            boolean hasNoDocumentsInRouteFlag = this.checkIfThereIsNoAnotherCRMInRouteForTheInvoice(invoice.getDocumentNumber());
            if (hasNoDocumentsInRouteFlag) {
                hasNoDocumentsInRouteFlag = this.checkIfThereIsNoAnotherWriteoffInRouteForTheInvoice(invoice.getDocumentNumber());
            }
            if (!hasNoDocumentsInRouteFlag) continue;
            filteredInvoices.add(invoice);
        }
        return filteredInvoices;
    }

    @Override
    public boolean checkIfThereIsNoAnotherCRMInRouteForTheInvoice(String invoiceDocumentNumber) {
        boolean isSuccess = true;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("financialDocumentReferenceInvoiceNumber", invoiceDocumentNumber);
        Collection customerCreditMemoDocuments = this.businessObjectService.findMatching(CustomerCreditMemoDocument.class, fieldValues);
        if (customerCreditMemoDocuments.isEmpty()) {
            return isSuccess;
        }
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        for (CustomerCreditMemoDocument customerCreditMemoDocument : customerCreditMemoDocuments) {
            WorkflowDocument workflowDocument = WorkflowDocumentFactory.loadDocument((String)userId, (String)customerCreditMemoDocument.getDocumentNumber());
            if (workflowDocument.isApproved() || workflowDocument.isCanceled() || workflowDocument.isDisapproved()) continue;
            isSuccess = false;
            break;
        }
        return isSuccess;
    }

    @Override
    public boolean checkIfThereIsNoAnotherWriteoffInRouteForTheInvoice(String invoiceDocumentNumber) {
        boolean isSuccess = true;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("financialDocumentReferenceInvoiceNumber", invoiceDocumentNumber);
        Collection customerInvoiceWriteoffDocuments = this.businessObjectService.findMatching(CustomerInvoiceWriteoffDocument.class, fieldValues);
        if (customerInvoiceWriteoffDocuments.isEmpty()) {
            return isSuccess;
        }
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        for (CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocument : customerInvoiceWriteoffDocuments) {
            WorkflowDocument workflowDocument = WorkflowDocumentFactory.loadDocument((String)userId, (String)customerInvoiceWriteoffDocument.getDocumentNumber());
            if (workflowDocument.isApproved() || workflowDocument.isCanceled() || workflowDocument.isDisapproved()) continue;
            isSuccess = false;
            break;
        }
        return isSuccess;
    }

    @Override
    public String sendCustomerInvoiceWriteoffDocumentsToBatch(Person person, Collection<CustomerInvoiceWriteoffLookupResult> customerInvoiceWriteoffLookupResults) {
        CustomerInvoiceWriteoffBatchVO batch = new CustomerInvoiceWriteoffBatchVO(person.getPrincipalName());
        batch.setSubmittedOn(this.dateTimeService.getCurrentTimestamp().toString());
        String note = null;
        for (CustomerInvoiceWriteoffLookupResult customerInvoiceWriteoffLookupResult : customerInvoiceWriteoffLookupResults) {
            note = customerInvoiceWriteoffLookupResult.getCustomerNote();
        }
        if (StringUtils.isNotBlank(note)) {
            batch.setNote(note);
        }
        for (CustomerInvoiceWriteoffLookupResult customerInvoiceWriteoffLookupResult : customerInvoiceWriteoffLookupResults) {
            for (CustomerInvoiceDocument customerInvoiceDocument : customerInvoiceWriteoffLookupResult.getCustomerInvoiceDocuments()) {
                batch.addInvoiceNumber(customerInvoiceDocument.getDocumentNumber());
            }
        }
        return this.invoiceWriteoffBatchService.createBatchDrop(person, batch);
    }

    @Override
    public String createCustomerInvoiceWriteoffDocument(String invoiceNumber, String note) throws WorkflowException {
        CustomerInvoiceWriteoffDocument document = (CustomerInvoiceWriteoffDocument)this.documentService.getNewDocument(CustomerInvoiceWriteoffDocument.class);
        document.setFinancialDocumentReferenceInvoiceNumber(invoiceNumber);
        this.setupDefaultValuesForNewCustomerInvoiceWriteoffDocument(document);
        document.getDocumentHeader().setDocumentDescription("Writeoff for  " + invoiceNumber + ".");
        document.setCustomerNote(note);
        if (StringUtils.isBlank((CharSequence)note)) {
            note = "Document created by batch process.";
        } else if (note.length() <= 10) {
            note = "Document created by batch process.  " + note;
        }
        document.setCustomerNote(note);
        this.documentService.routeDocument((Document)document, "Routed by Customer Invoice Writeoff Document Batch Service", null);
        return document.getDocumentNumber();
    }

    @Override
    public Collection<CustomerInvoiceWriteoffDocument> getCustomerCreditMemoDocumentByInvoiceDocument(String invoiceNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>(1);
        fieldValues.put("financialDocumentReferenceInvoiceNumber", invoiceNumber);
        Collection writeoffs = this.businessObjectService.findMatching(CustomerInvoiceWriteoffDocument.class, fieldValues);
        return writeoffs;
    }

    @Override
    public String getFinancialObjectCode(CustomerInvoiceDetail postable, CustomerInvoiceWriteoffDocument poster, boolean isUsingOrgAcctDefaultWriteoffFAU, boolean isUsingChartForWriteoff, String chartOfAccountsCode) {
        if (isUsingOrgAcctDefaultWriteoffFAU) {
            return poster.getFinancialObjectCode();
        }
        if (isUsingChartForWriteoff) {
            return this.parameterService.getSubParameterValueAsString(CustomerInvoiceWriteoffDocument.class, "GLPE_WRITEOFF_OBJECT_CODE_BY_CHART", chartOfAccountsCode);
        }
        return postable.getAccountsReceivableObjectCode();
    }

    @Override
    public ObjectCode getObjectCode(CustomerInvoiceDetail postable, CustomerInvoiceWriteoffDocument poster, boolean isUsingOrgAcctDefaultWriteoffFAU, boolean isUsingChartForWriteoff, String chartOfAccountsCode) {
        return this.objectCodeService.getByPrimaryIdForCurrentYear(chartOfAccountsCode, this.getFinancialObjectCode(postable, poster, isUsingOrgAcctDefaultWriteoffFAU, isUsingChartForWriteoff, chartOfAccountsCode));
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setCustomerInvoiceDocumentService(CustomerInvoiceDocumentService customerInvoiceDocumentService) {
        this.customerInvoiceDocumentService = customerInvoiceDocumentService;
    }

    public void setAccountsReceivableDocumentHeaderService(AccountsReceivableDocumentHeaderService accountsReceivableDocumentHeaderService) {
        this.accountsReceivableDocumentHeaderService = accountsReceivableDocumentHeaderService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setInvoiceWriteoffBatchService(CustomerInvoiceWriteoffBatchService invoiceWriteoffBatchService) {
        this.invoiceWriteoffBatchService = invoiceWriteoffBatchService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setPaidAppliedService(InvoicePaidAppliedService<CustomerInvoiceDetail> paidAppliedService) {
        this.paidAppliedService = paidAppliedService;
    }

    public void setFinancialSystemUserService(FinancialSystemUserService financialSystemUserService) {
        this.financialSystemUserService = financialSystemUserService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        this.objectCodeService = objectCodeService;
    }
}

