/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation;

import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.integration.ar.Billable;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.module.ar.document.service.MilestoneScheduleMaintenanceService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.impl.KfsMaintenanceDocumentRuleBase;

public class MilestoneScheduleRule
extends KfsMaintenanceDocumentRuleBase {
    protected static Logger LOG = LogManager.getLogger(MilestoneScheduleRule.class);
    protected MilestoneSchedule newMilestoneScheduleCopy;
    private static volatile MilestoneScheduleMaintenanceService milestoneScheduleMaintenanceService;

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        LOG.debug("Entering PredeterminedBillingScheduleRule.processCustomAddCollectionLineBusinessRules");
        boolean isValid = true;
        isValid &= super.processCustomAddCollectionLineBusinessRules(document, collectionName, line);
        isValid &= this.checkForDuplicateBillNumber(collectionName, line);
        boolean bl = !GlobalVariables.getMessageMap().hasErrors();
        GlobalVariables.getMessageMap().removeAllErrorMessagesForProperty("document.newMaintainableObject.milestoneAmount");
        LOG.info("Leaving PredeterminedBillingScheduleRule.processCustomAddCollectionLineBusinessRules");
        return isValid &= bl;
    }

    private boolean checkForDuplicateBillNumber(String collectionName, PersistableBusinessObject line) {
        boolean isValid = true;
        if (StringUtils.equalsIgnoreCase((CharSequence)collectionName, (CharSequence)"Milestones")) {
            Milestone milestone = (Milestone)line;
            Long newMilestoneNumber = milestone.getMilestoneNumber();
            for (Milestone existingMilestone : this.newMilestoneScheduleCopy.getMilestones()) {
                if (!existingMilestone.getMilestoneNumber().equals(newMilestoneNumber)) continue;
                isValid = false;
                this.putFieldError(collectionName, "error.duplicate.milestone.number");
                break;
            }
        }
        return isValid;
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug("Entering MilestoneScheduleRule.processCustomSaveDocumentBusinessRules");
        this.processCustomRouteDocumentBusinessRules(document);
        LOG.info("Leaving MilestoneScheduleRule.processCustomSaveDocumentBusinessRules");
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug("Entering MilestoneScheduleRule.processCustomRouteDocumentBusinessRules");
        boolean success = true;
        success &= this.checkAwardBillingFrequency();
        LOG.info("Leaving MilestoneScheduleRule.processCustomRouteDocumentBusinessRules");
        return success &= this.checkForDuplicateMilestoneNumbers();
    }

    protected boolean checkAwardBillingFrequency() {
        boolean success = false;
        if (ObjectUtils.isNotNull((Object)this.newMilestoneScheduleCopy.getAward().getBillingFrequencyCode()) && ArConstants.BillingFrequencyValues.isMilestone((Billable)this.newMilestoneScheduleCopy.getAward())) {
            success = true;
        }
        if (!success) {
            this.putFieldError("proposalNumber", "error.cg.award.milestone.schedule.incorrect.billing.frequency", new String[]{this.newMilestoneScheduleCopy.getProposalNumber().toString()});
        }
        return success;
    }

    private boolean checkForDuplicateMilestoneNumbers() {
        boolean isValid = true;
        HashSet<Long> milestoneNumbers = new HashSet<Long>();
        HashSet<Long> duplicateMilestoneNumbers = new HashSet<Long>();
        for (Milestone milestone : this.newMilestoneScheduleCopy.getMilestones()) {
            if (milestoneNumbers.add(milestone.getMilestoneNumber())) continue;
            duplicateMilestoneNumbers.add(milestone.getMilestoneNumber());
        }
        if (duplicateMilestoneNumbers.size() > 0) {
            isValid = false;
            int lineNum = 0;
            for (Milestone milestone : this.newMilestoneScheduleCopy.getMilestones()) {
                boolean copiedToInvoice = false;
                if (ObjectUtils.isNotNull((Object)milestone.getMilestoneIdentifier()) && this.getMilestoneScheduleMaintenanceService().hasMilestoneBeenCopiedToInvoice(milestone.getProposalNumber(), milestone.getMilestoneIdentifier().toString())) {
                    copiedToInvoice = true;
                }
                if (!copiedToInvoice && duplicateMilestoneNumbers.contains(milestone.getMilestoneNumber())) {
                    String errorPath = "milestones[" + lineNum + "]." + "milestoneNumber";
                    this.putFieldError(errorPath, "error.duplicate.milestone.number");
                }
                ++lineNum;
            }
        }
        return isValid;
    }

    public void setupConvenienceObjects() {
        this.newMilestoneScheduleCopy = (MilestoneSchedule)((Object)super.getNewBo());
    }

    public MilestoneScheduleMaintenanceService getMilestoneScheduleMaintenanceService() {
        if (milestoneScheduleMaintenanceService == null) {
            milestoneScheduleMaintenanceService = (MilestoneScheduleMaintenanceService)SpringContext.getBean(MilestoneScheduleMaintenanceService.class);
        }
        return milestoneScheduleMaintenanceService;
    }
}

