/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.rules.TransactionalDocumentRuleBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.TransactionalDocument;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.document.CustomerCreditMemoDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.validation.ContinueCustomerCreditMemoDocumentRule;
import org.kuali.kfs.module.ar.document.validation.RecalculateCustomerCreditMemoDetailRule;
import org.kuali.kfs.module.ar.document.validation.RecalculateCustomerCreditMemoDocumentRule;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;

public class CustomerCreditMemoDocumentRule
extends TransactionalDocumentRuleBase
implements RecalculateCustomerCreditMemoDetailRule<TransactionalDocument>,
RecalculateCustomerCreditMemoDocumentRule<TransactionalDocument>,
ContinueCustomerCreditMemoDocumentRule<TransactionalDocument> {
    protected static final BigDecimal ALLOWED_QTY_DEVIATION = new BigDecimal("0.10");
    private BusinessObjectService businessObjectService;
    private CustomerInvoiceDocumentService customerInvoiceDocumentService;

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        boolean isValid = super.processCustomSaveDocumentBusinessRules(document);
        GlobalVariables.getMessageMap().addToErrorPath("document");
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return isValid &= this.processRecalculateCustomerCreditMemoDocumentRules((TransactionalDocument)document, true);
    }

    @Override
    public boolean processRecalculateCustomerCreditMemoDetailRules(TransactionalDocument document, CustomerCreditMemoDetail customerCreditMemoDetail) {
        boolean success = true;
        CustomerCreditMemoDocument customerCreditMemoDocument = (CustomerCreditMemoDocument)document;
        customerCreditMemoDocument.refreshReferenceObject("invoice");
        String inputKey = this.isQtyOrItemAmountEntered(customerCreditMemoDetail);
        customerCreditMemoDetail.setInvoiceOpenItemAmount(customerCreditMemoDetail.getCustomerInvoiceDetail().getAmountOpen());
        customerCreditMemoDetail.setInvoiceOpenItemQuantity(customerCreditMemoDocument.getInvoiceOpenItemQuantity(customerCreditMemoDetail, customerCreditMemoDetail.getCustomerInvoiceDetail()));
        if (StringUtils.equals((CharSequence)"qty", (CharSequence)inputKey)) {
            success &= this.isValueGreaterThanZero(customerCreditMemoDetail.getCreditMemoItemQuantity());
            success &= this.isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty(customerCreditMemoDetail);
        } else if (StringUtils.equals((CharSequence)"itemAmount", (CharSequence)inputKey)) {
            success &= this.isValueGreaterThanZero(customerCreditMemoDetail.getCreditMemoItemTotalAmount());
            success &= this.isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount(customerCreditMemoDocument, customerCreditMemoDetail);
        } else if (StringUtils.equals((CharSequence)"both", (CharSequence)inputKey)) {
            success &= this.isValueGreaterThanZero(customerCreditMemoDetail.getCreditMemoItemTotalAmount());
            success &= this.isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount(customerCreditMemoDocument, customerCreditMemoDetail);
            success &= this.isValueGreaterThanZero(customerCreditMemoDetail.getCreditMemoItemQuantity());
            success &= this.isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty(customerCreditMemoDetail);
            success &= this.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(customerCreditMemoDetail, customerCreditMemoDetail.getCustomerInvoiceDetail().getInvoiceItemUnitPrice());
        } else {
            success = false;
        }
        return success;
    }

    public String isQtyOrItemAmountEntered(CustomerCreditMemoDetail customerCreditMemoDetail) {
        BigDecimal customerCreditMemoItemQty = customerCreditMemoDetail.getCreditMemoItemQuantity();
        KualiDecimal customerCreditMemoItemAmount = customerCreditMemoDetail.getCreditMemoItemTotalAmount();
        String inputKey = "";
        if (ObjectUtils.isNotNull((Object)customerCreditMemoItemQty) && ObjectUtils.isNotNull((Object)customerCreditMemoItemAmount)) {
            inputKey = "both";
        } else if (ObjectUtils.isNotNull((Object)customerCreditMemoItemQty)) {
            inputKey = "qty";
        } else if (ObjectUtils.isNotNull((Object)customerCreditMemoItemAmount)) {
            inputKey = "itemAmount";
        }
        return inputKey;
    }

    public boolean isValueGreaterThanZero(BigDecimal value) {
        boolean validValue;
        boolean bl = validValue = value.compareTo(BigDecimal.ZERO) == 1;
        if (!validValue) {
            GlobalVariables.getMessageMap().putError("creditMemoItemQuantity", "error.document.customerCreditMemoDocument.invalidCustomerCreditMemoItemQuantity", new String[0]);
        }
        return validValue;
    }

    public boolean isValueGreaterThanZero(KualiDecimal value) {
        boolean validValue = value.isPositive();
        if (!validValue) {
            GlobalVariables.getMessageMap().putError("creditMemoItemTotalAmount", "error.document.customerCreditMemoDocument.invalidCustomerCreditMemoItemAmount", new String[0]);
        }
        return validValue;
    }

    public boolean isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount(CustomerCreditMemoDocument customerCreditMemoDocument, CustomerCreditMemoDetail customerCreditMemoDetail) {
        KualiDecimal invoiceOpenItemAmount = customerCreditMemoDetail.getInvoiceOpenItemAmount();
        KualiDecimal creditMemoItemAmount = customerCreditMemoDetail.getCreditMemoItemTotalAmount();
        boolean validItemAmount = creditMemoItemAmount.isLessEqual((AbstractKualiDecimal)invoiceOpenItemAmount);
        if (!validItemAmount) {
            GlobalVariables.getMessageMap().putError("creditMemoItemTotalAmount", "error.document.customerCreditMemoDocument.itemAmountGreaterThanParentItemAmount", new String[0]);
        }
        return validItemAmount;
    }

    public boolean isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty(CustomerCreditMemoDetail customerCreditMemoDetail) {
        boolean validQuantity;
        BigDecimal invoiceOpenItemQty = customerCreditMemoDetail.getInvoiceOpenItemQuantity();
        BigDecimal customerCreditMemoItemQty = customerCreditMemoDetail.getCreditMemoItemQuantity();
        boolean bl = validQuantity = customerCreditMemoItemQty.compareTo(invoiceOpenItemQty) < 1;
        if (!validQuantity) {
            GlobalVariables.getMessageMap().putError("creditMemoItemQuantity", "error.document.customerCreditMemoDocument.itemQuantityGreaterThanParentItemQuantity", new String[0]);
        }
        return validQuantity;
    }

    public boolean checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(CustomerCreditMemoDetail customerCreditMemoDetail, BigDecimal unitPrice) {
        boolean validFlag;
        KualiDecimal creditAmount = customerCreditMemoDetail.getCreditMemoItemTotalAmount();
        BigDecimal creditQuantity = customerCreditMemoDetail.getCreditMemoItemQuantity();
        if (unitPrice.compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        BigDecimal expectedCreditQuantity = creditAmount.bigDecimalValue().divide(unitPrice, ArConstants.ITEM_QUANTITY_SCALE, 4);
        if (expectedCreditQuantity.compareTo(BigDecimal.ZERO) == 0 && creditQuantity.compareTo(BigDecimal.ZERO) != 0) {
            return false;
        }
        BigDecimal deviationPercentage = creditQuantity.subtract(expectedCreditQuantity).divide(expectedCreditQuantity, ArConstants.ITEM_QUANTITY_SCALE, 4).abs();
        boolean bl = validFlag = deviationPercentage.compareTo(ALLOWED_QTY_DEVIATION) < 1;
        if (!validFlag) {
            GlobalVariables.getMessageMap().putError("creditMemoItemQuantity", "error.document.customerCreditMemoDocument.invalidDataInput", new String[0]);
            GlobalVariables.getMessageMap().putError("creditMemoItemTotalAmount", "error.document.customerCreditMemoDocument.invalidDataInput", new String[0]);
        }
        return validFlag;
    }

    @Override
    public boolean processRecalculateCustomerCreditMemoDocumentRules(TransactionalDocument document, boolean printErrMsgFlag) {
        boolean success = true;
        boolean crmDataEnteredFlag = false;
        CustomerCreditMemoDocument customerCreditMemoDocument = (CustomerCreditMemoDocument)document;
        List<CustomerCreditMemoDetail> customerCreditMemoDetails = customerCreditMemoDocument.getCreditMemoDetails();
        int i = 0;
        for (CustomerCreditMemoDetail customerCreditMemoDetail : customerCreditMemoDetails) {
            String propertyName = "creditMemoDetails[" + i + "]";
            GlobalVariables.getMessageMap().addToErrorPath(propertyName);
            if (!this.isQtyOrItemAmountEntered(customerCreditMemoDetail).equals("")) {
                crmDataEnteredFlag = true;
                success &= this.processRecalculateCustomerCreditMemoDetailRules((TransactionalDocument)customerCreditMemoDocument, customerCreditMemoDetail);
            }
            GlobalVariables.getMessageMap().removeFromErrorPath(propertyName);
            ++i;
        }
        success &= crmDataEnteredFlag;
        if (!crmDataEnteredFlag && printErrMsgFlag) {
            GlobalVariables.getMessageMap().putError("document", "error.document.customerCreditMemoDocument.noDataToSubmit", new String[0]);
        }
        return success;
    }

    @Override
    public boolean processContinueCustomerCreditMemoDocumentRules(TransactionalDocument document) {
        CustomerCreditMemoDocument customerCreditMemoDocument = (CustomerCreditMemoDocument)document;
        boolean success = this.checkIfInvoiceNumberIsFinal(customerCreditMemoDocument.getFinancialDocumentReferenceInvoiceNumber());
        if (success) {
            success = this.checkIfThereIsNoAnotherCRMInRouteForTheInvoice(customerCreditMemoDocument.getFinancialDocumentReferenceInvoiceNumber());
        }
        if (success) {
            success = this.checkInvoiceForErrorCorrection(customerCreditMemoDocument.getFinancialDocumentReferenceInvoiceNumber());
        }
        return success;
    }

    public boolean checkIfInvoiceNumberIsFinal(String invDocumentNumber) {
        boolean success = true;
        if (StringUtils.isBlank((CharSequence)invDocumentNumber)) {
            success &= false;
            GlobalVariables.getMessageMap().putError("financialDocumentReferenceInvoiceNumber", "error.document.customerCreditMemoDocument.invRefNumberIsRequired", new String[0]);
        } else {
            CustomerInvoiceDocument customerInvoiceDocument = this.getCustomerInvoiceDocumentService().getInvoiceByInvoiceDocumentNumber(invDocumentNumber);
            if (ObjectUtils.isNull((Object)customerInvoiceDocument)) {
                success &= false;
                GlobalVariables.getMessageMap().putError("financialDocumentReferenceInvoiceNumber", "error.document.customerCreditMemoDocument.invalidInvoiceDocumentNumber", new String[0]);
            } else if (!this.getCustomerInvoiceDocumentService().checkIfInvoiceNumberIsFinal(invDocumentNumber)) {
                GlobalVariables.getMessageMap().putError("financialDocumentReferenceInvoiceNumber", "error.document.customerInvoiceDocument.notFinal", new String[0]);
                success &= false;
            }
        }
        return success;
    }

    public boolean checkIfThereIsNoAnotherCRMInRouteForTheInvoice(String invoiceDocumentNumber) {
        boolean success = true;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("financialDocumentReferenceInvoiceNumber", invoiceDocumentNumber);
        Collection customerCreditMemoDocuments = this.getBusinessObjectService().findMatching(CustomerCreditMemoDocument.class, fieldValues);
        if (customerCreditMemoDocuments.isEmpty()) {
            return success;
        }
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        for (CustomerCreditMemoDocument customerCreditMemoDocument : customerCreditMemoDocuments) {
            WorkflowDocument workflowDocument = WorkflowDocumentFactory.loadDocument((String)userId, (String)customerCreditMemoDocument.getDocumentNumber());
            if (workflowDocument.isApproved() || workflowDocument.isProcessed() || workflowDocument.isCanceled() || workflowDocument.isDisapproved()) continue;
            GlobalVariables.getMessageMap().putError("financialDocumentReferenceInvoiceNumber", "error.document.customerCreditMemoDocument.onlyOneCRMInRoutePerInvoice", new String[0]);
            success = false;
            break;
        }
        return success;
    }

    public boolean checkInvoiceForErrorCorrection(String invoiceDocumentNumber) {
        CustomerInvoiceDocumentService service = this.getCustomerInvoiceDocumentService();
        CustomerInvoiceDocument customerInvoiceDocument = service.getInvoiceByInvoiceDocumentNumber(invoiceDocumentNumber);
        if (customerInvoiceDocument.hasInvoiceBeenCorrected()) {
            GlobalVariables.getMessageMap().putError("financialDocumentReferenceInvoiceNumber", "error.document.customerCreditMemoDocument.invoiceHasBeenCorrected", new String[0]);
            return false;
        }
        if (customerInvoiceDocument.isInvoiceReversal()) {
            GlobalVariables.getMessageMap().putError("financialDocumentReferenceInvoiceNumber", "error.document.customerCreditMemoDocument.invoiceCorrectsAnotherInvoice", new String[0]);
            return false;
        }
        return true;
    }

    public boolean isDocumentAttributesValid(Document document, boolean validateRequired) {
        CustomerCreditMemoDocument customerCreditMemoDocument = (CustomerCreditMemoDocument)document;
        for (CustomerCreditMemoDetail customerDetail : customerCreditMemoDocument.getCreditMemoDetails()) {
            customerDetail.getCustomerInvoiceDetail().refreshNonUpdateableReferences();
        }
        for (GeneralLedgerPendingEntry glpe : customerCreditMemoDocument.getGeneralLedgerPendingEntries()) {
            glpe.refreshNonUpdateableReferences();
        }
        return super.isDocumentAttributesValid(document, validateRequired);
    }

    private BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    private CustomerInvoiceDocumentService getCustomerInvoiceDocumentService() {
        if (this.customerInvoiceDocumentService == null) {
            this.customerInvoiceDocumentService = (CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class);
        }
        return this.customerInvoiceDocumentService;
    }

    public void setCustomerInvoiceDocumentService(CustomerInvoiceDocumentService customerInvoiceDocumentService) {
        this.customerInvoiceDocumentService = customerInvoiceDocumentService;
    }
}

