/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.service.UniversityDateService;

public class CustomerInvoiceDetailSystemInformationDiscountValidation
extends GenericValidation {
    private CustomerInvoiceDocument customerInvoiceDocument;
    private UniversityDateService universityDateService;
    private BusinessObjectService businessObjectService;

    public boolean validate(AttributedDocumentEvent event) {
        String processingChartOfAccountsCode = this.customerInvoiceDocument.getAccountsReceivableDocumentHeader().getProcessingChartOfAccountCode();
        String processingOrganizationCode = this.customerInvoiceDocument.getAccountsReceivableDocumentHeader().getProcessingOrganizationCode();
        Integer universityFiscalYear = this.universityDateService.getCurrentFiscalYear();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("universityFiscalYear", universityFiscalYear);
        criteria.put("processingChartOfAccountCode", processingChartOfAccountsCode);
        criteria.put("processingOrganizationCode", processingOrganizationCode);
        SystemInformation systemInformation = (SystemInformation)this.businessObjectService.findByPrimaryKey(SystemInformation.class, criteria);
        if (ObjectUtils.isNull((Object)((Object)systemInformation)) || StringUtils.isEmpty((CharSequence)systemInformation.getDiscountObjectCode())) {
            GlobalVariables.getMessageMap().putError("document.accountingLines", "error.document.customerInvoiceDocument.systemInformationDiscountDoesNotExist", new String[]{processingChartOfAccountsCode, processingOrganizationCode, universityFiscalYear.toString()});
            return false;
        }
        return true;
    }

    public CustomerInvoiceDocument getCustomerInvoiceDocument() {
        return this.customerInvoiceDocument;
    }

    public void setCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        this.customerInvoiceDocument = customerInvoiceDocument;
    }

    public UniversityDateService getUniversityDateService() {
        return this.universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

