/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import org.kuali.kfs.coa.businessobject.ObjectCodeCurrent;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.maintenance.MaintenanceDocumentAuthorizer;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceItemCode;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;

public class CustomerInvoiceItemCodeRule
extends MaintenanceDocumentRuleBase {
    protected CustomerInvoiceItemCode newInvoiceItemCode;

    public void setupConvenienceObjects() {
        this.newInvoiceItemCode = (CustomerInvoiceItemCode)((Object)super.getNewBo());
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = this.validateItemDefaultPrice(this.newInvoiceItemCode);
        success &= this.validateItemDefaultQuantity(this.newInvoiceItemCode);
        success &= this.validateExistenceOfOrganizationOption(this.newInvoiceItemCode);
        success &= this.isCustomerInvoiceItemCodeObjectValid(this.newInvoiceItemCode);
        return success &= this.validateBillingOrg(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        this.processCustomRouteDocumentBusinessRules(document);
        return true;
    }

    public boolean validateBillingOrg(MaintenanceDocument document) {
        boolean success = true;
        String billingChartCode = this.newInvoiceItemCode.getChartOfAccountsCode();
        String billingOrganizationCode = this.newInvoiceItemCode.getOrganizationCode();
        if (ObjectUtils.isNull((Object)billingChartCode) || ObjectUtils.isNull((Object)billingOrganizationCode)) {
            return success;
        }
        MaintenanceDocumentAuthorizer documentAuthorizer = (MaintenanceDocumentAuthorizer)this.getDocumentHelperService().getDocumentAuthorizer((Document)document);
        success = documentAuthorizer.isAuthorizedByTemplate((Object)document, "KR-NS", "Create / Maintain Record(s)", GlobalVariables.getUserSession().getPerson().getPrincipalId());
        if (!success) {
            this.putFieldError("chartOfAccountsCode", "error.invoiceItemCode.errorInvalidChartOfAccountsCode");
            this.putFieldError("organizationCode", "error.invoiceItemCode.errorInvalidOrganizationCode");
            success = false;
        }
        return success;
    }

    public boolean validateItemDefaultPrice(CustomerInvoiceItemCode customerInvoiceItemCode) {
        boolean validEntry = true;
        BigDecimal itemDefaultPrice = null;
        if (customerInvoiceItemCode.getItemDefaultPrice() != null) {
            itemDefaultPrice = customerInvoiceItemCode.getItemDefaultPrice().bigDecimalValue();
        }
        if (ObjectUtils.isNotNull(itemDefaultPrice)) {
            boolean bl = validEntry = itemDefaultPrice.compareTo(BigDecimal.ZERO) == 1;
            if (!validEntry) {
                this.putFieldError("itemDefaultPrice", "error.invoiceItemCode.nonPositiveNumericValue", "Item Default Price");
            }
        }
        return validEntry;
    }

    public boolean validateItemDefaultQuantity(CustomerInvoiceItemCode customerInvoiceItemCode) {
        boolean validEntry = true;
        BigDecimal itemDefaultQuantity = customerInvoiceItemCode.getItemDefaultQuantity();
        if (ObjectUtils.isNotNull((Object)itemDefaultQuantity) && itemDefaultQuantity.floatValue() <= 0.0f) {
            this.putFieldError("itemDefaultQuantity", "error.invoiceItemCode.nonPositiveNumericValue", "Item Default Quantity");
            validEntry = false;
        }
        return validEntry;
    }

    public boolean validateExistenceOfOrganizationOption(CustomerInvoiceItemCode customerInvoiceItemCode) {
        boolean isValid = true;
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("chartOfAccountsCode", customerInvoiceItemCode.getChartOfAccountsCode());
        criteria.put("organizationCode", customerInvoiceItemCode.getOrganizationCode());
        BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        if (businessObjectService.countMatching(OrganizationOptions.class, criteria) == 0) {
            this.putFieldError("organizationCode", "error.invoiceItemCode.orgOptionsDoesNotExistForChartAndOrg", new String[]{customerInvoiceItemCode.getChartOfAccountsCode(), customerInvoiceItemCode.getOrganizationCode()});
            isValid = false;
        }
        return isValid;
    }

    protected boolean isCustomerInvoiceItemCodeObjectValid(CustomerInvoiceItemCode customerInvoiceItemCode) {
        boolean success = true;
        Integer universityFiscalYear = ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear();
        ObjectCodeCurrent defaultInvoiceItemCodeObject = customerInvoiceItemCode.getDefaultInvoiceFinancialObject();
        if (ObjectUtils.isNotNull((Object)universityFiscalYear) && ObjectUtils.isNotNull((Object)defaultInvoiceItemCodeObject)) {
            ParameterService parameterSerivce = (ParameterService)SpringContext.getBean(ParameterService.class);
            Collection restrictedObjectConsolidations = parameterSerivce.getParameterValuesAsString(CustomerInvoiceDocument.class, "OBJECT_CONSOLIDATIONS");
            Collection restrictedObjectLevels = parameterSerivce.getParameterValuesAsString(CustomerInvoiceDocument.class, "OBJECT_LEVELS");
            if (restrictedObjectConsolidations.contains(defaultInvoiceItemCodeObject.getFinancialObjectLevel().getFinancialConsolidationObjectCode())) {
                this.putFieldError("defaultInvoiceFinancialObjectCode", "error.document.organizationAccountingDefaultMaintenance.defaultInvoiceFinancialObjectCodeInvalidRestricted", new String[]{defaultInvoiceItemCodeObject.getCode(), "Object Consolidation", restrictedObjectConsolidations.toString()});
                success = false;
            } else if (restrictedObjectLevels.contains(defaultInvoiceItemCodeObject.getFinancialObjectLevelCode())) {
                this.putFieldError("defaultInvoiceFinancialObjectCode", "error.document.organizationAccountingDefaultMaintenance.defaultInvoiceFinancialObjectCodeInvalidRestricted", new String[]{defaultInvoiceItemCodeObject.getCode(), "Object Level", restrictedObjectLevels.toString()});
                success = false;
            }
        }
        return success;
    }
}

