/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.rules.PromptBeforeValidationBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.UnknownDocumentIdException;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.InvoiceRecurrence;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class InvoiceRecurrencePreRules
extends PromptBeforeValidationBase {
    private static final Logger LOG = LogManager.getLogger(InvoiceRecurrencePreRules.class);

    public boolean doPrompts(Document document) {
        boolean preRulesOK = true;
        preRulesOK &= this.setCustomerNumberIfInvoiceIsEntered(document);
        preRulesOK &= this.setEndDateIfTotalRecurrenceNumberIsEntered(document);
        return preRulesOK &= this.setTotalRecurrenceNumberIfEndDateIsEntered(document);
    }

    protected boolean setCustomerNumberIfInvoiceIsEntered(Document document) {
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        InvoiceRecurrence newInvoiceRecurrence = (InvoiceRecurrence)maintenanceDocument.getNewMaintainableObject().getBusinessObject();
        if (ObjectUtils.isNull((Object)newInvoiceRecurrence.getInvoiceNumber()) || ObjectUtils.isNotNull((Object)newInvoiceRecurrence.getCustomerNumber())) {
            return true;
        }
        try {
            if (((DocumentService)SpringContext.getBean(DocumentService.class)).documentExists(newInvoiceRecurrence.getInvoiceNumber())) {
                CustomerInvoiceDocument customerInvoiceDocument = (CustomerInvoiceDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(newInvoiceRecurrence.getInvoiceNumber());
                newInvoiceRecurrence.setCustomerNumber(customerInvoiceDocument.getCustomer().getCustomerNumber());
            }
        }
        catch (WorkflowException ex) {
            LOG.error("Unable to retrieve document " + newInvoiceRecurrence.getInvoiceNumber() + " from workflow.", (Throwable)ex);
        }
        catch (UnknownDocumentIdException ex) {
            LOG.error("Document " + newInvoiceRecurrence.getInvoiceNumber() + " does not exist.");
        }
        return true;
    }

    protected boolean setEndDateIfTotalRecurrenceNumberIsEntered(Document document) {
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        InvoiceRecurrence newInvoiceRecurrence = (InvoiceRecurrence)maintenanceDocument.getNewMaintainableObject().getBusinessObject();
        if (ObjectUtils.isNull((Object)newInvoiceRecurrence.getDocumentTotalRecurrenceNumber())) {
            return true;
        }
        if (ObjectUtils.isNotNull((Object)newInvoiceRecurrence.getDocumentRecurrenceEndDate()) && ObjectUtils.isNotNull((Object)newInvoiceRecurrence.getDocumentTotalRecurrenceNumber())) {
            return true;
        }
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(new Timestamp(newInvoiceRecurrence.getDocumentRecurrenceBeginDate().getTime()));
        Calendar endCalendar = Calendar.getInstance();
        endCalendar = beginCalendar;
        int addCounter = 0;
        Integer documentTotalRecurrenceNumber = newInvoiceRecurrence.getDocumentTotalRecurrenceNumber();
        String intervalCode = newInvoiceRecurrence.getDocumentRecurrenceIntervalCode();
        if (intervalCode.equals("M")) {
            addCounter = -1;
            addCounter += documentTotalRecurrenceNumber * 1;
        }
        if (intervalCode.equals("Q")) {
            addCounter = -3;
            addCounter += documentTotalRecurrenceNumber * 3;
        }
        endCalendar.add(2, addCounter);
        newInvoiceRecurrence.setDocumentRecurrenceEndDate(KfsDateUtils.convertToSqlDate((Date)endCalendar.getTime()));
        return true;
    }

    protected boolean setTotalRecurrenceNumberIfEndDateIsEntered(Document document) {
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        InvoiceRecurrence newInvoiceRecurrence = (InvoiceRecurrence)maintenanceDocument.getNewMaintainableObject().getBusinessObject();
        if (ObjectUtils.isNull((Object)newInvoiceRecurrence.getDocumentRecurrenceEndDate())) {
            return true;
        }
        if (ObjectUtils.isNotNull((Object)newInvoiceRecurrence.getDocumentRecurrenceEndDate()) && ObjectUtils.isNotNull((Object)newInvoiceRecurrence.getDocumentTotalRecurrenceNumber())) {
            return true;
        }
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(newInvoiceRecurrence.getDocumentRecurrenceBeginDate());
        java.sql.Date beginDate = newInvoiceRecurrence.getDocumentRecurrenceBeginDate();
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(newInvoiceRecurrence.getDocumentRecurrenceEndDate());
        java.sql.Date endDate = newInvoiceRecurrence.getDocumentRecurrenceEndDate();
        Calendar nextCalendar = Calendar.getInstance();
        java.sql.Date nextDate = beginDate;
        int totalRecurrences = 0;
        int addCounter = 0;
        String intervalCode = newInvoiceRecurrence.getDocumentRecurrenceIntervalCode();
        if (intervalCode.equals("M")) {
            addCounter = 1;
        }
        if (intervalCode.equals("Q")) {
            addCounter = 3;
        }
        while (!beginDate.after(endDate)) {
            beginCalendar.setTime(beginDate);
            beginCalendar.add(2, addCounter);
            beginDate = KfsDateUtils.convertToSqlDate((Date)beginCalendar.getTime());
            ++totalRecurrences;
            nextDate = beginDate;
            nextCalendar.setTime(nextDate);
            nextCalendar.add(2, addCounter);
            nextDate = KfsDateUtils.convertToSqlDate((Date)nextCalendar.getTime());
            if (!endDate.after(beginDate) || !endDate.before(nextDate)) continue;
            ++totalRecurrences;
            break;
        }
        if (totalRecurrences > 0) {
            newInvoiceRecurrence.setDocumentTotalRecurrenceNumber(totalRecurrences);
        }
        return true;
    }
}

