/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.web.struts;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.SimpleBookmark;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.struts.action.KualiAction;
import org.kuali.kfs.module.ar.report.service.AccountsReceivableReportService;
import org.kuali.kfs.module.ar.web.struts.CustomerInvoiceGenerationForm;
import org.kuali.kfs.sys.context.SpringContext;

public class CustomerInvoiceGenerationAction
extends KualiAction {
    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward clear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CustomerInvoiceGenerationForm ciForm = (CustomerInvoiceGenerationForm)form;
        ciForm.setChartCode(null);
        ciForm.setOrgCode(null);
        ciForm.setOrgType(null);
        ciForm.setRunDate(null);
        ciForm.setMessage(null);
        return mapping.findForward("basic");
    }

    public ActionForward print(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CustomerInvoiceGenerationForm ciForm = (CustomerInvoiceGenerationForm)form;
        String org = ciForm.getOrgCode();
        String chart = ciForm.getChartCode();
        Date date = ciForm.getRunDate();
        StringBuilder fileName = new StringBuilder();
        AccountsReceivableReportService reportService = (AccountsReceivableReportService)SpringContext.getBean(AccountsReceivableReportService.class);
        List<Object> reports = new ArrayList();
        if (ciForm.getOrgType() != null && chart != null && org != null) {
            if (ciForm.getOrgType().equals("B")) {
                reports = reportService.generateInvoicesByBillingOrg(chart, org, date);
            } else if (ciForm.getOrgType().equals("P")) {
                reports = reportService.generateInvoicesByProcessingOrg(chart, org, date);
            }
            fileName.append(chart);
            fileName.append(org);
            if (date != null) {
                fileName.append(date);
            }
        } else if (ciForm.getUserId() != null) {
            reports = reportService.generateInvoicesByInitiator(ciForm.getUserId(), date);
            fileName.append(ciForm.getUserId());
        }
        if (reports.size() > 0) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int pageOffset = 0;
            ArrayList master = new ArrayList();
            int f = 0;
            Document document = null;
            PdfCopy writer = null;
            Iterator<Object> itr = reports.iterator();
            while (itr.hasNext()) {
                String reportName = ((File)itr.next()).getAbsolutePath();
                PdfReader reader = new PdfReader(reportName);
                reader.consolidateNamedDestinations();
                int n = reader.getNumberOfPages();
                List bookmarks = SimpleBookmark.getBookmark((PdfReader)reader);
                if (bookmarks != null) {
                    if (pageOffset != 0) {
                        SimpleBookmark.shiftPageNumbers((List)bookmarks, (int)pageOffset, null);
                    }
                    master.addAll(bookmarks);
                }
                pageOffset += n;
                if (f == 0) {
                    document = new Document(reader.getPageSizeWithRotation(1));
                    writer = new PdfCopy(document, (OutputStream)baos);
                    document.open();
                }
                int i = 0;
                while (i < n) {
                    PdfImportedPage page = writer.getImportedPage(reader, ++i);
                    writer.addPage(page);
                }
                writer.freeReader(reader);
                ++f;
            }
            if (!master.isEmpty()) {
                writer.setOutlines(master);
            }
            document.close();
            fileName.append("-InvoiceBatchPDFs.pdf");
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baos, (String)fileName.toString());
            ciForm.setMessage(reports.size() + " Reports Generated");
            return null;
        }
        ciForm.setMessage("No Reports Generated");
        return mapping.findForward("basic");
    }
}

