/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.web.struts;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.struts.action.KualiAction;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.report.service.AccountsReceivableReportService;
import org.kuali.kfs.module.ar.report.util.CustomerStatementResultHolder;
import org.kuali.kfs.module.ar.service.AccountsReceivablePdfHelperService;
import org.kuali.kfs.module.ar.web.struts.CustomerStatementForm;
import org.kuali.kfs.sys.context.SpringContext;

public class CustomerStatementAction
extends KualiAction {
    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward clear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CustomerStatementForm csForm = (CustomerStatementForm)form;
        csForm.clear();
        return mapping.findForward("basic");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward print(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String includeZeroBalanceCustomers;
        String basePath = CustomerStatementAction.getApplicationBaseUrl();
        CustomerStatementForm csForm = (CustomerStatementForm)form;
        String chartCode = csForm.getChartCode();
        chartCode = chartCode == null ? "" : chartCode;
        String orgCode = csForm.getOrgCode();
        orgCode = orgCode == null ? "" : orgCode;
        String customerNumber = csForm.getCustomerNumber();
        customerNumber = customerNumber == null ? "" : customerNumber;
        String accountNumber = csForm.getAccountNumber();
        accountNumber = accountNumber == null ? "" : accountNumber;
        String statementFormat = csForm.getStatementFormat();
        if (StringUtils.isBlank((CharSequence)statementFormat)) {
            statementFormat = "Summary";
        }
        if (StringUtils.isBlank((CharSequence)(includeZeroBalanceCustomers = csForm.getIncludeZeroBalanceCustomers()))) {
            includeZeroBalanceCustomers = "No";
        }
        AccountsReceivableReportService reportService = (AccountsReceivableReportService)SpringContext.getBean(AccountsReceivableReportService.class);
        List<Object> reports = new ArrayList();
        StringBuilder fileName = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)chartCode) && StringUtils.isNotBlank((CharSequence)orgCode)) {
            reports = reportService.generateStatementByBillingOrg(chartCode, orgCode, statementFormat, includeZeroBalanceCustomers);
            fileName.append(chartCode);
            fileName.append(orgCode);
        } else if (StringUtils.isNotBlank((CharSequence)customerNumber)) {
            reports = reportService.generateStatementByCustomer(customerNumber.toUpperCase(), statementFormat, includeZeroBalanceCustomers);
            fileName.append(customerNumber);
        } else if (StringUtils.isNotBlank((CharSequence)accountNumber)) {
            reports = reportService.generateStatementByAccount(accountNumber, statementFormat, includeZeroBalanceCustomers);
            fileName.append(accountNumber);
        }
        fileName.append("-StatementBatchPDFs.pdf");
        if (reports.size() != 0) {
            Object data;
            ArrayList<byte[]> contents = new ArrayList<byte[]>();
            for (CustomerStatementResultHolder customerStatementResultHolder : reports) {
                File file = customerStatementResultHolder.getFile();
                data = Files.readAllBytes(file.toPath());
                contents.add((byte[])data);
            }
            ByteArrayOutputStream baos = ((AccountsReceivablePdfHelperService)SpringContext.getBean(AccountsReceivablePdfHelperService.class)).buildPdfOutputStream(contents);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baos, (String)fileName.toString());
            if (statementFormat.equalsIgnoreCase("Detail")) {
                CustomerInvoiceDocumentService customerInvoiceDocumentService = (CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class);
                Iterator<Object> iterator = reports.iterator();
                while (iterator.hasNext()) {
                    data = (CustomerStatementResultHolder)iterator.next();
                    if (((CustomerStatementResultHolder)data).getInvoiceNumbers() != null) {
                        List<String> invoiceNumbers = ((CustomerStatementResultHolder)data).getInvoiceNumbers();
                        for (String number : invoiceNumbers) {
                            customerInvoiceDocumentService.updateReportedDate(number);
                        }
                    }
                    customerInvoiceDocumentService.updateReportedInvoiceInfo((CustomerStatementResultHolder)data);
                }
            }
            return null;
        }
        csForm.setMessage("No Reports Generated");
        return mapping.findForward("basic");
    }
}

