/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.integration.ar.Billable;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.bo.TransientBusinessObjectBase;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.rice.core.api.util.type.KualiDecimal;

import java.sql.Date;

/**
 * Defines an award entry for the Contracts & Grants Invoice Lookup Results
 */
public class ContractsGrantsInvoiceLookupResultAward extends TransientBusinessObjectBase implements Billable {

    private String proposalNumber;
    private String chartOfAccountsCode;
    private String accountNumber;
    private Date awardBeginningDate;
    private Date awardEndingDate;
    private String billingFrequencyCode;
    private String instrumentTypeCode;
    private String invoicingOptionDescription;
    private KualiDecimal awardTotalAmount = KualiDecimal.ZERO;

    public ContractsGrantsInvoiceLookupResultAward() {
    }

    public ContractsGrantsInvoiceLookupResultAward(ContractsAndGrantsBillingAward award,
            ContractsAndGrantsBillingAwardAccount awardAccount) {
        this.setProposalNumber(award.getProposalNumber());
        this.setChartOfAccountsCode(awardAccount.getChartOfAccountsCode());
        this.setAccountNumber(awardAccount.getAccountNumber());
        this.setAwardBeginningDate(award.getAwardBeginningDate());
        this.setAwardEndingDate(award.getAwardEndingDate());
        this.setBillingFrequencyCode(award.getBillingFrequencyCode());
        this.setInstrumentTypeCode(award.getInstrumentTypeCode());
        this.setInvoicingOptionDescription(award.getInvoicingOptionDescription());
        this.setAwardTotalAmount(award.getAwardTotalAmount());
    }

    public String getProposalNumber() {
        return proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Date getAwardBeginningDate() {
        return awardBeginningDate;
    }

    public void setAwardBeginningDate(Date awardBeginningDate) {
        this.awardBeginningDate = awardBeginningDate;
    }

    public Date getAwardEndingDate() {
        return awardEndingDate;
    }

    public void setAwardEndingDate(Date awardEndingDate) {
        this.awardEndingDate = awardEndingDate;
    }

    public String getBillingFrequencyCode() {
        return billingFrequencyCode;
    }

    public void setBillingFrequencyCode(String billingFrequencyCode) {
        this.billingFrequencyCode = billingFrequencyCode;
    }

    public String getInstrumentTypeCode() {
        return instrumentTypeCode;
    }

    public void setInstrumentTypeCode(String instrumentTypeCode) {
        this.instrumentTypeCode = instrumentTypeCode;
    }

    public String getInvoicingOptionDescription() {
        return invoicingOptionDescription;
    }

    public void setInvoicingOptionDescription(String invoicingOptionDescription) {
        this.invoicingOptionDescription = invoicingOptionDescription;
    }

    public KualiDecimal getAwardTotalAmount() {
        return awardTotalAmount;
    }

    public void setAwardTotalAmount(KualiDecimal awardTotalAmount) {
        this.awardTotalAmount = awardTotalAmount;
    }

    /**
     * The objectId is query award accounts to display based on what the user selected in the lookup. For MS or PDBS,
     * this is individual selected award accounts, but for other billing frequencies, we want all the award accounts.
     *
     * @return the objectId used for later queries
     */
    public String getObjectId() {
        if (ArConstants.BillingFrequencyValues.isMilestone(this)
                || ArConstants.BillingFrequencyValues.isPredeterminedBilling(this)) {
            return proposalNumber + "-" + chartOfAccountsCode + "-" + accountNumber;
        } else {
            return proposalNumber + "-*-*";
        }
    }
}
