/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerAddress;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerAddressType;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.module.ar.ArKeyConstants;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.location.api.LocationConstants;
import org.kuali.rice.location.framework.country.CountryEbo;

import java.sql.Date;
import java.util.HashMap;
import java.util.Map;

public class CustomerAddress extends PersistableBusinessObjectBase implements Comparable<CustomerAddress>,
        AccountsReceivableCustomerAddress {

    private String customerNumber;
    private Integer customerAddressIdentifier;
    private String customerAddressName;
    private String customerLine1StreetAddress;
    private String customerLine2StreetAddress;
    private String customerCityName;
    private String customerStateCode;
    private String customerZipCode;
    private String customerCountryCode;
    private String customerAddressInternationalProvinceName;
    private String customerInternationalMailCode;
    private String customerEmailAddress;
    private String customerAddressTypeCode;
    private Date customerAddressEndDate;

    private CustomerAddressType customerAddressType;
    private Customer customer;
    private CountryEbo customerCountry;

    // Invoice Template link

    private String customerInvoiceTemplateCode;
    private InvoiceTemplate customerInvoiceTemplate;

    // Invoice Indicator link

    private String invoiceTransmissionMethodCode;
    private InvoiceTransmissionMethod invoiceTransmissionMethod;

    private Integer customerCopiesToPrint;
    private Integer customerEnvelopesToPrintQuantity;

    public CustomerAddress() {
    }

    @Override
    public String getCustomerNumber() {
        return customerNumber;
    }

    @Override
    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    @Override
    public Integer getCustomerAddressIdentifier() {
        return customerAddressIdentifier;
    }

    public void setCustomerAddressIdentifier(Integer customerAddressIdentifier) {
        this.customerAddressIdentifier = customerAddressIdentifier;
    }

    @Override
    public String getCustomerAddressName() {
        return customerAddressName;
    }

    @Override
    public void setCustomerAddressName(String customerAddressName) {
        this.customerAddressName = customerAddressName;
    }

    @Override
    public String getCustomerLine1StreetAddress() {
        return customerLine1StreetAddress;
    }

    @Override
    public void setCustomerLine1StreetAddress(String customerLine1StreetAddress) {
        this.customerLine1StreetAddress = customerLine1StreetAddress;
    }

    @Override
    public String getCustomerLine2StreetAddress() {
        return customerLine2StreetAddress;
    }

    @Override
    public void setCustomerLine2StreetAddress(String customerLine2StreetAddress) {
        this.customerLine2StreetAddress = customerLine2StreetAddress;
    }

    @Override
    public String getCustomerCityName() {
        return customerCityName;
    }

    @Override
    public void setCustomerCityName(String customerCityName) {
        this.customerCityName = customerCityName;
    }

    @Override
    public String getCustomerStateCode() {
        return customerStateCode;
    }

    @Override
    public void setCustomerStateCode(String customerStateCode) {
        this.customerStateCode = customerStateCode;
    }

    @Override
    public String getCustomerZipCode() {
        return customerZipCode;
    }

    @Override
    public void setCustomerZipCode(String customerZipCode) {
        this.customerZipCode = customerZipCode;
    }

    @Override
    public String getCustomerAddressInternationalProvinceName() {
        return customerAddressInternationalProvinceName;
    }

    public void setCustomerAddressInternationalProvinceName(String customerAddressInternationalProvinceName) {
        this.customerAddressInternationalProvinceName = customerAddressInternationalProvinceName;
    }

    @Override
    public String getCustomerCountryCode() {
        return customerCountryCode;
    }

    @Override
    public void setCustomerCountryCode(String customerCountryCode) {
        this.customerCountryCode = customerCountryCode;
    }

    @Override
    public String getCustomerInternationalMailCode() {
        return customerInternationalMailCode;
    }

    public void setCustomerInternationalMailCode(String customerInternationalMailCode) {
        this.customerInternationalMailCode = customerInternationalMailCode;
    }

    @Override
    public String getCustomerEmailAddress() {
        return customerEmailAddress;
    }

    @Override
    public void setCustomerEmailAddress(String customerEmailAddress) {
        this.customerEmailAddress = customerEmailAddress;
    }

    @Override
    public String getCustomerAddressTypeCode() {
        return customerAddressTypeCode;
    }

    @Override
    public void setCustomerAddressTypeCode(String customerAddressTypeCode) {
        this.customerAddressTypeCode = customerAddressTypeCode;
    }

    @Override
    public Date getCustomerAddressEndDate() {
        return customerAddressEndDate;
    }

    public void setCustomerAddressEndDate(Date customerAddressEndDate) {
        this.customerAddressEndDate = customerAddressEndDate;
    }

    public CustomerAddressType getCustomerAddressType() {
        return customerAddressType;
    }

    /**
     * @deprecated
     */
    @Deprecated
    public void setCustomerAddressType(CustomerAddressType customerAddressType) {
        this.customerAddressType = customerAddressType;
    }

    public Customer getCustomer() {
        return customer;
    }

    @Deprecated
    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    @Override
    public String getInvoiceTransmissionMethodCode() {
        return invoiceTransmissionMethodCode;
    }

    public void setInvoiceTransmissionMethodCode(String invoiceTransmissionMethodCode) {
        this.invoiceTransmissionMethodCode = invoiceTransmissionMethodCode;
    }

    public CountryEbo getCustomerCountry() {
        if (StringUtils.isBlank(customerCountryCode)) {
            customerCountry = null;
        } else {
            if (customerCountry == null || !StringUtils.equals(customerCountry.getCode(), customerCountryCode)) {
                ModuleService moduleService = SpringContext.getBean(KualiModuleService.class).getResponsibleModuleService(CountryEbo.class);
                if (moduleService != null) {
                    Map<String, Object> keys = new HashMap<>(1);
                    keys.put(LocationConstants.PrimaryKeyConstants.CODE, customerCountryCode);
                    customerCountry = moduleService.getExternalizableBusinessObject(CountryEbo.class, keys);
                } else {
                    throw new RuntimeException("CONFIGURATION ERROR: No responsible module found for EBO class.  Unable to proceed.");
                }
            }
        }
        return customerCountry;
    }

    /**
     * @deprecated
     */
    @Deprecated
    public void setCustomerCountry(CountryEbo customerCountry) {
        this.customerCountry = customerCountry;
    }

    @Override
    public int compareTo(CustomerAddress address) {
        if (this.getCustomerNumber() != null && address.getCustomerNumber() != null
                && !this.getCustomerNumber().equalsIgnoreCase(address.getCustomerNumber())) {
            return -1;
        }
        if (this.getCustomerAddressName() != null && address.getCustomerAddressName() != null
                && !this.getCustomerAddressName().equalsIgnoreCase(address.getCustomerAddressName())) {
            return -1;
        }
        if (this.getCustomerLine1StreetAddress() != null && address.getCustomerLine1StreetAddress() != null
                && !this.getCustomerLine1StreetAddress().equalsIgnoreCase(address.getCustomerLine1StreetAddress())) {
            return -1;
        }
        if (this.getCustomerLine2StreetAddress() != null
                && address.getCustomerLine2StreetAddress() != null
                && !this.getCustomerLine2StreetAddress().equalsIgnoreCase(address.getCustomerLine2StreetAddress())
                || (this.getCustomerLine2StreetAddress() == null && address.getCustomerLine2StreetAddress() != null)
                || (this.getCustomerLine2StreetAddress() != null && address.getCustomerLine2StreetAddress() == null)) {
            return -1;
        }
        if (this.getCustomerCityName() != null && address.getCustomerCityName() != null
                && !this.getCustomerCityName().equalsIgnoreCase(address.getCustomerCityName())) {
            return -1;
        }
        if (this.getCustomerStateCode() != null
                && address.getCustomerStateCode() != null
                && !this.getCustomerStateCode().equalsIgnoreCase(address.getCustomerStateCode())
                || (this.getCustomerStateCode() == null && address.getCustomerStateCode() != null)
                || (this.getCustomerStateCode() != null && address.getCustomerStateCode() == null)) {
            return -1;
        }
        if (this.getCustomerZipCode() != null && address.getCustomerZipCode() != null && !this.getCustomerZipCode().equalsIgnoreCase(address.getCustomerZipCode())
            || (this.getCustomerZipCode() == null && address.getCustomerZipCode() != null) || (this.getCustomerZipCode() != null && address.getCustomerZipCode() == null)) {
            return -1;
        }
        if (this.getCustomerCountryCode() != null && address.getCustomerCountryCode() != null && !this.getCustomerCountryCode().equalsIgnoreCase(address.getCustomerCountryCode())) {
            return -1;
        }
        if (this.getCustomerAddressInternationalProvinceName() != null && address.getCustomerAddressInternationalProvinceName() != null && !this.getCustomerAddressInternationalProvinceName().equalsIgnoreCase(address.getCustomerAddressInternationalProvinceName())
            || (this.getCustomerAddressInternationalProvinceName() == null && address.getCustomerAddressInternationalProvinceName() != null) || (this.getCustomerAddressInternationalProvinceName() != null && address.getCustomerAddressInternationalProvinceName() == null)) {
            return -1;
        }
        if (this.getCustomerEmailAddress() != null && address.getCustomerEmailAddress() != null && !this.getCustomerEmailAddress().equalsIgnoreCase(address.getCustomerEmailAddress())
            || (this.getCustomerEmailAddress() == null && address.getCustomerEmailAddress() != null) || (this.getCustomerEmailAddress() != null && address.getCustomerEmailAddress() == null)) {
            return -1;
        }
        if (this.getCustomerAddressTypeCode() != null && address.getCustomerAddressTypeCode() != null && !this.getCustomerAddressTypeCode().equalsIgnoreCase(address.getCustomerAddressTypeCode())
            || (this.getCustomerAddressTypeCode() == null && address.getCustomerAddressTypeCode() != null) || (this.getCustomerAddressTypeCode() != null && address.getCustomerAddressTypeCode() == null)) {
            return -1;
        }
        if (this.getCustomerAddressIdentifier() != null && address.getCustomerAddressIdentifier() != null && this.getCustomerAddressIdentifier().compareTo(address.getCustomerAddressIdentifier()) != 0
            || (this.getCustomerAddressIdentifier() == null && address.getCustomerAddressIdentifier() != null) || (this.getCustomerAddressIdentifier() != null && address.getCustomerAddressIdentifier() == null)) {
            return -1;
        }
        return 0;
    }

    @Override
    protected void prePersist() {
        super.prePersist();
        CustomerAddressService customerAddressService = SpringContext.getBean(CustomerAddressService.class);
        int customerAddressIdentifier = customerAddressService.getNextCustomerAddressIdentifier();
        this.setCustomerAddressIdentifier(customerAddressIdentifier);
    }

    @Override
    public AccountsReceivableCustomerAddressType getAccountsReceivableCustomerAddressType() {
        return customerAddressType;
    }

    @Override
    public void setCustomerAddressTypeCodeAsPrimary() {
        setCustomerAddressTypeCode(ArKeyConstants.CustomerConstants.CUSTOMER_ADDRESS_TYPE_CODE_PRIMARY);
    }

    @Override
    public void setCustomerAddressTypeCodeAsAlternate() {
        setCustomerAddressTypeCode(ArKeyConstants.CustomerConstants.CUSTOMER_ADDRESS_TYPE_CODE_ALTERNATE);
    }

    @Override
    public AccountsReceivableCustomer getAccountsReceivableCustomer() {
        return customer;
    }

    @Override
    public void refresh() {
        super.refresh();
    }

    @Override
    public String getCustomerInvoiceTemplateCode() {
        return customerInvoiceTemplateCode;
    }

    public void setCustomerInvoiceTemplateCode(String customerInvoiceTemplateCode) {
        this.customerInvoiceTemplateCode = customerInvoiceTemplateCode;
    }

    public InvoiceTemplate getCustomerInvoiceTemplate() {
        return customerInvoiceTemplate;
    }

    public void setCustomerInvoiceTemplate(InvoiceTemplate customerInvoiceTemplate) {
        this.customerInvoiceTemplate = customerInvoiceTemplate;
    }

    public InvoiceTransmissionMethod getInvoiceTransmissionMethod() {
        return invoiceTransmissionMethod;
    }

    public void setInvoiceTransmissionMethod(InvoiceTransmissionMethod invoiceTransmissionMethod) {
        this.invoiceTransmissionMethod = invoiceTransmissionMethod;
    }

    @Override
    public Integer getCustomerCopiesToPrint() {
        return customerCopiesToPrint;
    }

    public void setCustomerCopiesToPrint(Integer customerCopiesToPrint) {
        this.customerCopiesToPrint = customerCopiesToPrint;
    }

    @Override
    public Integer getCustomerEnvelopesToPrintQuantity() {
        return customerEnvelopesToPrintQuantity;
    }

    public void setCustomerEnvelopesToPrintQuantity(Integer customerEnvelopesToPrintQuantity) {
        this.customerEnvelopesToPrintQuantity = customerEnvelopesToPrintQuantity;
    }
}
