/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.integration.ar.Billable;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class BillingFrequencyEnumTest {
    @Mock
    private ContractsAndGrantsBillingAward cgbAwardMock;
    @Mock
    private InvoiceGeneralDetail invoiceDetailMock;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void milestoneAward() {
        Mockito.when((Object)this.cgbAwardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isMilestone should be true of awards with milestone", (boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)this.cgbAwardMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of awards with milestones", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)this.cgbAwardMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of awards with milestones", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)this.cgbAwardMock));
    }

    @Test
    public void predeterminedBillingAward() {
        Mockito.when((Object)this.cgbAwardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isPredeterminedBilling should be true of awards with predetermined billing", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)this.cgbAwardMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isMilestone should not be true of awards with predetermined billing", (boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)this.cgbAwardMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of awards with predetermined billing", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)this.cgbAwardMock));
    }

    @Test
    public void letterOfCreditAward() {
        Mockito.when((Object)this.cgbAwardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT.getCode());
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isLetterOfCredit should be true of awards with letter of credit", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)this.cgbAwardMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isMilestone should not be true of awards with letter of credit", (boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)this.cgbAwardMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of awards with letter of credit", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)this.cgbAwardMock));
    }

    @Test
    public void milestoneInvoiceGeneralDetail() {
        Mockito.when((Object)this.invoiceDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isMilestone should be true of invoice general details with milestone", (boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)this.invoiceDetailMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of invoice general details with milestones", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)this.invoiceDetailMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of invoice general details with milestones", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)this.invoiceDetailMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isTimeBased should not be true of invoice general details with milestones", (boolean)ArConstants.BillingFrequencyValues.isTimeBased((Billable)this.invoiceDetailMock));
    }

    @Test
    public void predeterminedBillingInvoiceGeneralDetail() {
        Mockito.when((Object)this.invoiceDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isPredeterminedBilling should be true of invoice general details with predetermined billing", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)this.invoiceDetailMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isMilestone should not be true of invoice general details with predetermined billing", (boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)this.invoiceDetailMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of invoice general details with predetermined billing", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)this.invoiceDetailMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isTimeBased should not be true of invoice general details with predetermined billing", (boolean)ArConstants.BillingFrequencyValues.isTimeBased((Billable)this.invoiceDetailMock));
    }

    @Test
    public void letterOfCreditInvoiceGeneralDetail() {
        Mockito.when((Object)this.invoiceDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT.getCode());
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of invoice general details with letter of credit billing", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)this.invoiceDetailMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isMilestone should not be true of invoice general details with letter of credit billing", (boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)this.invoiceDetailMock));
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isLetterOfCredit should be true of invoice general details with letter of credit billing", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)this.invoiceDetailMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isTimeBased should not be true of invoice general details with letter of credit billing", (boolean)ArConstants.BillingFrequencyValues.isTimeBased((Billable)this.invoiceDetailMock));
    }

    @Test
    public void annuallyInvoiceGeneralDetail() {
        Mockito.when((Object)this.invoiceDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.ANNUALLY.getCode());
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isPredeterminedBilling should be not true of invoice general details with annual billing", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)this.invoiceDetailMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isMilestone should not be true of invoice general details with annual billing", (boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)this.invoiceDetailMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of invoice general details with annual billing", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)this.invoiceDetailMock));
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isTimeBased should be true of invoice general details with annual billing", (boolean)ArConstants.BillingFrequencyValues.isTimeBased((Billable)this.invoiceDetailMock));
    }

    @Test
    public void semiAnnuallyInvoiceGeneralDetail() {
        Mockito.when((Object)this.invoiceDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.SEMI_ANNUALLY.getCode());
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of invoice general details with semi-annual billing", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)this.invoiceDetailMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isMilestone should not be true of invoice general details with semi-annual billing", (boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)this.invoiceDetailMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of invoice general details with semi-annual billing", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)this.invoiceDetailMock));
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isTimeBased should be true of invoice general details with semi-annual billing", (boolean)ArConstants.BillingFrequencyValues.isTimeBased((Billable)this.invoiceDetailMock));
    }

    @Test
    public void quarterlyInvoiceGeneralDetail() {
        Mockito.when((Object)this.invoiceDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.QUARTERLY.getCode());
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of invoice general details with quarterly billing", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)this.invoiceDetailMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isMilestone should not be true of invoice general details with quarterly billing", (boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)this.invoiceDetailMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of invoice general details with quarterly billing", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)this.invoiceDetailMock));
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isTimeBased should be true of invoice general details with quarterly billing", (boolean)ArConstants.BillingFrequencyValues.isTimeBased((Billable)this.invoiceDetailMock));
    }

    @Test
    public void monthlyInvoiceGeneralDetail() {
        Mockito.when((Object)this.invoiceDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isPredeterminedBilling should not be true of invoice general details with monthly billing", (boolean)ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)this.invoiceDetailMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isMilestone should not be true of invoice general details with monthly billing", (boolean)ArConstants.BillingFrequencyValues.isMilestone((Billable)this.invoiceDetailMock));
        Assert.assertFalse((String)"ArConstants.BillingFrequency.isLetterOfCredit should not be true of invoice general details with monthly billing", (boolean)ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)this.invoiceDetailMock));
        Assert.assertTrue((String)"ArConstants.BillingFrequency.isTimeBased should be true of invoice general details with monthly billing", (boolean)ArConstants.BillingFrequencyValues.isTimeBased((Billable)this.invoiceDetailMock));
    }
}

