/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.InputStream;
import java.net.URL;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.kfs.module.ar.batch.CustomerInvoiceWriteoffBatchInputFileType;
import org.kuali.kfs.module.ar.batch.vo.CustomerInvoiceWriteoffBatchVO;
import org.kuali.kfs.sys.batch.BatchInputFileType;
import org.kuali.kfs.sys.batch.service.impl.BatchInputFileServiceImpl;
import org.mockito.Mockito;

public class CustomerInvoiceWriteoffBatchDigesterTest {
    private static final String XML_SAMPLE_FILE = "org/kuali/kfs/module/ar/batch/sample/CustomerInvoiceWriteoffBatch-Sample-Good.xml";
    private static final String SCHEMA_FILE = "org/kuali/kfs/module/ar/batch/customerInvoiceWriteoffBatch.xsd";
    private static final String WRITEOFF_DIGESTER_RULE_FILE = "org/kuali/kfs/module/ar/batch/digester/customerInvoiceWriteoffBatchDigesterRules.xml";
    private CustomerInvoiceWriteoffBatchVO parsedBatchVO;

    @Test
    public void testCustomerInvoiceWriteoffBatchDigesterRules() throws Exception {
        CustomerInvoiceWriteoffBatchInputFileType cut = (CustomerInvoiceWriteoffBatchInputFileType)Mockito.spy((Object)new CustomerInvoiceWriteoffBatchInputFileType());
        BatchInputFileServiceImpl batchInputFileService = new BatchInputFileServiceImpl();
        cut.setDigestorRulesFileName(WRITEOFF_DIGESTER_RULE_FILE);
        cut.setSchemaLocation(SCHEMA_FILE);
        URL schemaUrl = this.getClass().getClassLoader().getResource(SCHEMA_FILE);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(schemaUrl);
        ((CustomerInvoiceWriteoffBatchInputFileType)Mockito.doReturn((Object)schema).when((Object)cut)).getSchema(SCHEMA_FILE);
        InputStream sampleFileStream = ClassLoader.getSystemResourceAsStream(XML_SAMPLE_FILE);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)sampleFileStream);
        this.parsedBatchVO = (CustomerInvoiceWriteoffBatchVO)batchInputFileService.parse((BatchInputFileType)cut, fileByteContent);
        Assert.assertTrue((String)"SubmittedBy PersonUserID should not be blank.", (boolean)StringUtils.isNotBlank((CharSequence)this.parsedBatchVO.getSubmittedByPrincipalName()));
        Assert.assertTrue((String)"SubmittedOn should not be blank.", (boolean)StringUtils.isNotBlank((CharSequence)this.parsedBatchVO.getSubmittedOn()));
        Assert.assertNotNull((String)"InvoiceNumbers should not be null.", (Object)this.parsedBatchVO.getInvoiceNumbers());
        Assert.assertFalse((String)"InvoiceNumbers should not be empty.", (boolean)this.parsedBatchVO.getInvoiceNumbers().isEmpty());
        Assert.assertTrue((String)"InvoiceNumbers should have 3 elements in the set.", (this.parsedBatchVO.getInvoiceNumbers().size() == 3 ? 1 : 0) != 0);
    }
}

