/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service;

import java.sql.Date;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsFundManager;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorLog;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorMessage;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.fixture.ARAgencyMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardMockFixture;
import org.kuali.kfs.module.ar.fixture.ContractsGrantsInvoiceDocumentFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceAccountDetailFixture;
import org.kuali.kfs.module.ar.identity.FundsManagerDerivedRoleTypeServiceImpl;
import org.kuali.kfs.module.ar.service.ContractsGrantsInvoiceCreateTestBase;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@ConfigureContext(session=UserNameFixture.khuntley)
public class ContractsGrantsInvoiceCreateDocumentServiceTest
extends ContractsGrantsInvoiceCreateTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        ArrayList<ContractsAndGrantsFundManager> fundManagers = new ArrayList<ContractsAndGrantsFundManager>();
        ContractsAndGrantsFundManager awardFundManager = (ContractsAndGrantsFundManager)Mockito.mock(ContractsAndGrantsFundManager.class);
        Mockito.when((Object)awardFundManager.getPrincipalId()).thenReturn((Object)UserNameFixture.wklykins.getPerson().getPrincipalId());
        fundManagers.add(awardFundManager);
        ModuleService moduleSvcMock = (ModuleService)Mockito.mock(ModuleService.class);
        Mockito.when((Object)moduleSvcMock.getExternalizableBusinessObjectsList((Class)ArgumentMatchers.eq(ContractsAndGrantsFundManager.class), ArgumentMatchers.anyMap())).thenReturn(fundManagers);
        KualiModuleService kualiModuleSvcMock = (KualiModuleService)Mockito.mock(KualiModuleService.class);
        Mockito.when((Object)kualiModuleSvcMock.getResponsibleModuleService(ContractsAndGrantsFundManager.class)).thenReturn((Object)moduleSvcMock);
        FundsManagerDerivedRoleTypeServiceImpl fundsManagerDerivedRoleTypeService = (FundsManagerDerivedRoleTypeServiceImpl)SpringContext.getBean(KimTypeService.class, (String)"fundsManagerDerivedRoleTypeService");
        fundsManagerDerivedRoleTypeService.setKualiModuleService(kualiModuleSvcMock);
    }

    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testCreateCGInvoiceDocumentByAwardInfo() {
        String coaCode = "BL";
        String orgCode = "UGCS";
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument_1 = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument();
        contractsGrantsInvoiceDocument_1.setBillByChartOfAccountCode(coaCode);
        contractsGrantsInvoiceDocument_1.setBilledByOrganizationCode(orgCode);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = new AccountsReceivableDocumentHeader();
        accountsReceivableDocumentHeader.setDocumentNumber(contractsGrantsInvoiceDocument_1.getDocumentNumber());
        List procCodes = this.contractsGrantsInvoiceDocumentService.getProcessingFromBillingCodes(coaCode, orgCode);
        accountsReceivableDocumentHeader.setProcessingChartOfAccountCode((String)procCodes.get(0));
        accountsReceivableDocumentHeader.setProcessingOrganizationCode((String)procCodes.get(1));
        contractsGrantsInvoiceDocument_1.setAccountsReceivableDocumentHeader(accountsReceivableDocumentHeader);
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD_MONTHLY_BILLED_DATE_NULL.createAwardMock();
        ContractsAndGrantsBillingAwardAccount awardAccountMock = ARAwardAccountMockFixture.AWD_ACCT_1.createAwardAccountMock();
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        ContractsAndGrantsBillingAgency agencyMock = ARAgencyMockFixture.CG_AGENCY1.createAgencyMock();
        Mockito.when((Object)awardMock.getAgency()).thenReturn((Object)agencyMock);
        String agencyNumber = agencyMock.getAgencyNumber();
        Mockito.when((Object)awardMock.getAgencyNumber()).thenReturn((Object)agencyNumber);
        contractsGrantsInvoiceDocument_1.getInvoiceGeneralDetail().setAward(awardMock);
        InvoiceAccountDetail invoiceAccountDetail_1 = InvoiceAccountDetailFixture.INV_ACCT_DTL3.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail_1);
        contractsGrantsInvoiceDocument_1.setAccountDetails(accountDetails);
        ArrayList errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument_2 = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentByAwardInfo(awardMock, awardAccountMocks, coaCode, orgCode, errorMessages, null, null);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)contractsGrantsInvoiceDocument_1.getInvoiceGeneralDetail().getProposalNumber(), (String)contractsGrantsInvoiceDocument_2.getInvoiceGeneralDetail().getProposalNumber());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)((InvoiceAccountDetail)contractsGrantsInvoiceDocument_1.getAccountDetails().get(0)).getAccountNumber(), (String)((InvoiceAccountDetail)contractsGrantsInvoiceDocument_2.getAccountDetails().get(0)).getAccountNumber());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)((InvoiceAccountDetail)contractsGrantsInvoiceDocument_1.getAccountDetails().get(0)).getChartOfAccountsCode(), (String)((InvoiceAccountDetail)contractsGrantsInvoiceDocument_2.getAccountDetails().get(0)).getChartOfAccountsCode());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)contractsGrantsInvoiceDocument_1.getAccountsReceivableDocumentHeader().getProcessingChartOfAccountCode(), (String)contractsGrantsInvoiceDocument_2.getAccountsReceivableDocumentHeader().getProcessingChartOfAccountCode());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)contractsGrantsInvoiceDocument_1.getAccountsReceivableDocumentHeader().getProcessingOrganizationCode(), (String)contractsGrantsInvoiceDocument_2.getAccountsReceivableDocumentHeader().getProcessingOrganizationCode());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)contractsGrantsInvoiceDocument_1.getBillByChartOfAccountCode(), (String)contractsGrantsInvoiceDocument_2.getBillByChartOfAccountCode());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)contractsGrantsInvoiceDocument_1.getBilledByOrganizationCode(), (String)contractsGrantsInvoiceDocument_2.getBilledByOrganizationCode());
    }

    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testManualCreateCGInvoiceDocumentsByAwardsOneValid() {
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.buildMockUniversityDateService());
        List<ContractsAndGrantsBillingAward> awards = this.setupBillableAwardMocks();
        List errorMessages = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"errorMessages should be empty.", (int)0, (int)errorMessages.size());
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"no errors should be persisted", (int)0, (int)persistedErrors.size());
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.originalUniversityDateService);
    }

    public void testManualCreateCGInvoiceDocumentsByAwardsEmptyAwardsList() {
        ArrayList awards = new ArrayList();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        this.contractsGrantsInvoiceCreateDocumentService.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((int)0, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.no.award");
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"errorMessages should not be empty.", (int)1, (int)errorMessages.size());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should contain the error we're expecting.", (boolean)this.messagesContainsExpectedError(errorMessages, errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"process type should be manual", (String)persistedError.getCreationProcessTypeCode(), (String)ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"error message text should match", (String)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText(), (String)errorMessage);
        }
    }

    public void testManualCreateCGInvoiceDocumentsByAwardsNullAwardsList() {
        List errorMessages = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentsByAwards(null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.no.award");
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"errorMessages should not be empty.", (int)1, (int)errorMessages.size());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should contain the error we're expecting.", (boolean)this.messagesContainsExpectedError(errorMessages, errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"process type should be manual", (String)persistedError.getCreationProcessTypeCode(), (String)ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"error message text should match", (String)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText(), (String)errorMessage);
        }
    }

    public void testManualCreateCGInvoiceDocumentsByAwardsNoOrg() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks();
        ContractsAndGrantsBillingAward award = awards.get(0);
        Mockito.when((Object)award.getPrimaryAwardOrganization()).thenReturn(null);
        List errorMessages = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.no.organization.on.award");
        errorMessage = MessageFormat.format(errorMessage, award.getProposalNumber());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"errorMessages should not be empty.", (int)1, (int)errorMessages.size());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should contain the error we're expecting.", (boolean)this.messagesContainsExpectedError(errorMessages, errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"process type should be manual", (String)persistedError.getCreationProcessTypeCode(), (String)ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"error message text should match", (String)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText(), (String)errorMessage);
        }
    }

    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testManualCreateCGInvoiceDocumentsByAccountNonBillable() throws WorkflowException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks();
        ContractsAndGrantsBillingAward award = awards.get(0);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        List<ErrorMessage> errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentByAwardInfo(award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        this.setupBills(cgInvoice);
        this.documentService.saveDocument((Document)cgInvoice);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwardMocks();
        ContractsAndGrantsBillingAward award2 = awards2.get(0);
        Mockito.when((Object)award2.getInvoicingOptionCode()).thenReturn((Object)"2");
        errorMessages = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentsByAwards(awards2, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.non.billable");
        errorMessage = MessageFormat.format(errorMessage, ((ContractsAndGrantsBillingAwardAccount)award2.getActiveAwardAccounts().get(0)).getAccountNumber(), award.getProposalNumber());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"errorMessages should not be empty.", (int)1, (int)errorMessages.size());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should contain the error we're expecting.", (boolean)this.messagesContainsExpectedError(errorMessages, errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"process type should be manual", (String)persistedError.getCreationProcessTypeCode(), (String)ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"error message text should match", (String)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText(), (String)errorMessage);
        }
    }

    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testManualCreateCGInvoiceDocumentsByScheduleNonBillable() throws WorkflowException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks();
        ContractsAndGrantsBillingAward award = awards.get(0);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        List<ErrorMessage> errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentByAwardInfo(award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        this.setupBills(cgInvoice);
        this.documentService.saveDocument((Document)cgInvoice);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwardMocks();
        ContractsAndGrantsBillingAward award2 = awards2.get(0);
        Mockito.when((Object)award2.getInvoicingOptionCode()).thenReturn((Object)"4");
        errorMessages = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentsByAwards(awards2, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.non.billable");
        errorMessage = MessageFormat.format(errorMessage, ((ContractsAndGrantsBillingAwardAccount)award2.getActiveAwardAccounts().get(0)).getAccountNumber(), award.getProposalNumber());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"errorMessages should not be empty.", (int)1, (int)errorMessages.size());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should contain the error we're expecting.", (boolean)this.messagesContainsExpectedError(errorMessages, errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"process type should be manual", (String)persistedError.getCreationProcessTypeCode(), (String)ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"error message text should match", (String)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText(), (String)errorMessage);
        }
    }

    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testManualCreateCGInvoiceDocumentsByAccountOneBillableOneNonBillable() {
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.buildMockUniversityDateService());
        List<ContractsAndGrantsBillingAward> awards = this.setupBillableAwardMocks();
        ContractsAndGrantsBillingAward award = awards.get(0);
        Mockito.when((Object)award.getInvoicingOptionCode()).thenReturn((Object)"2");
        ContractsAndGrantsBillingAwardAccount awardAccountMock = ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_2.createAwardAccountMock();
        Mockito.when((Object)awardAccountMock.getCurrentLastBilledDate()).thenReturn((Object)new Date(System.currentTimeMillis()));
        HashMap<String, String> primaryKeys = new HashMap<String, String>(2);
        String chartOfAccountsCode = awardAccountMock.getChartOfAccountsCode();
        primaryKeys.put("chartOfAccountsCode", chartOfAccountsCode);
        String accountNumber = awardAccountMock.getAccountNumber();
        primaryKeys.put("accountNumber", accountNumber);
        Account account = (Account)this.businessObjectService.findByPrimaryKey(Account.class, primaryKeys);
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)account);
        List awardAccountMocks = award.getActiveAwardAccounts();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)award.getActiveAwardAccounts()).thenReturn((Object)awardAccountMocks);
        List errorMessages = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.non.billable");
        errorMessage = MessageFormat.format(errorMessage, awardAccountMock.getAccountNumber(), award.getProposalNumber());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"errorMessages should contain one message", (int)1, (int)errorMessages.size());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should contain the error we're expecting.", (boolean)this.messagesContainsExpectedError(errorMessages, errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"process type should be manual", (String)persistedError.getCreationProcessTypeCode(), (String)ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"error message text should match", (String)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText(), (String)errorMessage);
        }
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.originalUniversityDateService);
    }

    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testManualCreateCGInvoiceDocumentsByCCAContractAccountNotBillable() throws WorkflowException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks();
        ContractsAndGrantsBillingAward award = awards.get(0);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        List<ErrorMessage> errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentByAwardInfo(award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        this.setupBills(cgInvoice);
        this.documentService.saveDocument((Document)cgInvoice);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwardMocks();
        ContractsAndGrantsBillingAward award2 = awards2.get(0);
        Mockito.when((Object)award2.getInvoicingOptionCode()).thenReturn((Object)"3");
        errorMessages = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentsByAwards(awards2, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.control.account.non.billable");
        errorMessage = MessageFormat.format(errorMessage, ((ContractsAndGrantsBillingAwardAccount)award2.getActiveAwardAccounts().get(0)).getAccount().getContractControlAccount().getAccountNumber(), award.getProposalNumber());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"errorMessages should not be empty.", (int)1, (int)errorMessages.size());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should contain the error we're expecting.", (boolean)this.messagesContainsExpectedError(errorMessages, errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"process type should be manual", (String)persistedError.getCreationProcessTypeCode(), (String)ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"error message text should match", (String)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText(), (String)errorMessage);
        }
    }

    @ConfigureContext(session=UserNameFixture.wklykins)
    public void testManualCreateCGInvoiceDocumentsByAwardNotAllBillableAccounts() throws WorkflowException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks();
        ContractsAndGrantsBillingAward award = awards.get(0);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        List<ErrorMessage> errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentByAwardInfo(award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        this.setupBills(cgInvoice);
        this.documentService.saveDocument((Document)cgInvoice);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwardMocks();
        ContractsAndGrantsBillingAward award2 = awards2.get(0);
        Mockito.when((Object)award2.getInvoicingOptionCode()).thenReturn((Object)"1");
        errorMessages = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentsByAwards(awards2, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.not.all.billable.accounts");
        errorMessage = MessageFormat.format(errorMessage, award2.getProposalNumber());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"errorMessages should not be empty.", (int)1, (int)errorMessages.size());
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertTrue((String)"errorMessages should contain the error we're expecting.", (boolean)this.messagesContainsExpectedError(errorMessages, errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"process type should be manual", (String)persistedError.getCreationProcessTypeCode(), (String)ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL.getCode());
            ContractsGrantsInvoiceCreateDocumentServiceTest.assertEquals((String)"error message text should match", (String)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText(), (String)errorMessage);
        }
    }

    private boolean messagesContainsExpectedError(List<ErrorMessage> errorMessages, String expectedErrorMessage) {
        ErrorMessage errorMessage = errorMessages.get(0);
        String errorMessageString = MessageFormat.format(this.configurationService.getPropertyValueAsString(errorMessage.getErrorKey()), errorMessage.getMessageParameters());
        return StringUtils.equals((CharSequence)errorMessageString, (CharSequence)expectedErrorMessage);
    }
}

