/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.vo;

import java.util.ArrayList;
import java.util.Map;
import org.kuali.kfs.module.ar.batch.report.CustomerLoadBatchErrors;
import org.kuali.kfs.module.ar.batch.vo.CustomerDigesterAdapter;
import org.kuali.kfs.module.ar.batch.vo.CustomerDigesterVO;
import org.kuali.kfs.module.ar.batch.vo.CustomerLoadVOGenerator;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;

@ConfigureContext
public class CustomerLoadDigesterConverterTest
extends KualiTestBase {
    public void testConvertVOToCustomer_ValidBatchFile() {
        ArrayList<Map<String, String>> addresses = new ArrayList<Map<String, String>>();
        addresses.add(CustomerLoadVOGenerator.getValidAddressVO1());
        CustomerDigesterVO customerVO = CustomerLoadVOGenerator.generateCustomerVO(CustomerLoadVOGenerator.getValidCustomerVO1(), addresses);
        boolean errors = false;
        CustomerDigesterAdapter adapter = new CustomerDigesterAdapter();
        CustomerLoadBatchErrors batchErrors = new CustomerLoadBatchErrors();
        Customer customer = null;
        try {
            customer = adapter.convert(customerVO, batchErrors);
        }
        catch (Exception e) {
            errors = true;
        }
        CustomerLoadDigesterConverterTest.assertFalse((String)"No errors should have occurred on conversion from VO to BO.", (boolean)(errors |= !batchErrors.isEmpty()));
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer object should not be null.", (Object)customer);
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer name should not be null.", (Object)customer.getCustomerName());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Parent Company Number should be null.", (Object)customer.getCustomerParentCompanyNumber());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Type Code should not be null.", (Object)customer.getCustomerTypeCode());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Last Activity Date should not be null.", (Object)customer.getCustomerLastActivityDate());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Tax Type Code should not be null.", (Object)customer.getCustomerTaxTypeCode());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Tax Number should not be null.", (Object)customer.getCustomerTaxNbr());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Active Indicator should not be null.", (Object)customer.isActive());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Phone Number should not be null.", (Object)customer.getCustomerPhoneNumber());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer 800 Phone Number should not be null.", (Object)customer.getCustomer800PhoneNumber());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Contact Name should not be null.", (Object)customer.getCustomerContactName());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Contact Phone Number should not be null.", (Object)customer.getCustomerContactPhoneNumber());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Fax Number should not be null.", (Object)customer.getCustomerFaxNumber());
        CustomerLoadDigesterConverterTest.assertNull((String)"Customer Birth Date should be null.", (Object)customer.getCustomerBirthDate());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Tax Exempt Indicator should not be null.", (Object)customer.isCustomerTaxExemptIndicator());
        CustomerLoadDigesterConverterTest.assertNull((String)"Customer Credit Limit Amount should be null.", (Object)customer.getCustomerCreditLimitAmount());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Credit Approved By Name should not be null.", (Object)customer.getCustomerCreditApprovedByName());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Email Address should not be null.", (Object)customer.getCustomerEmailAddress());
        CustomerAddress address = (CustomerAddress)customer.getCustomerAddresses().get(0);
        CustomerLoadDigesterConverterTest.assertNotNull((String)"The first address should not be null.", (Object)address);
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Address Name should not be null.", (Object)address.getCustomerAddressName());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Line1 Street Address should not be null.", (Object)address.getCustomerLine1StreetAddress());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Line2 Street Address should not be null.", (Object)address.getCustomerLine2StreetAddress());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer City Name should not be null.", (Object)address.getCustomerCityName());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer State Code should not be null.", (Object)address.getCustomerStateCode());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Zip Code should not be null.", (Object)address.getCustomerZipCode());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Country Code should not be null.", (Object)address.getCustomerCountryCode());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Address International Province Name should be null.", (Object)address.getCustomerAddressInternationalProvinceName());
        CustomerLoadDigesterConverterTest.assertEquals((String)"Customer Address International Province Name should be empty string.", (String)"", (String)address.getCustomerAddressInternationalProvinceName());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer International Mail Code should be null.", (Object)address.getCustomerInternationalMailCode());
        CustomerLoadDigesterConverterTest.assertEquals((String)"Customer International Mail Code should be empty string.", (String)"", (String)address.getCustomerInternationalMailCode());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Email Address should not be null.", (Object)address.getCustomerEmailAddress());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Address Type Code should not be null.", (Object)address.getCustomerAddressTypeCode());
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer Address End Date should not be null.", (Object)address.getCustomerAddressEndDate());
    }

    public void testConvertVOToCustomer_InvalidDates() {
        ArrayList<Map<String, String>> addresses = new ArrayList<Map<String, String>>();
        addresses.add(CustomerLoadVOGenerator.getBadAddressVO_InvalidDates_01());
        CustomerDigesterVO customerVO = CustomerLoadVOGenerator.generateCustomerVO(CustomerLoadVOGenerator.getBadCustomerVO_InvalidDates_01(), addresses);
        boolean exception = false;
        CustomerDigesterAdapter adapter = new CustomerDigesterAdapter();
        CustomerLoadBatchErrors batchErrors = new CustomerLoadBatchErrors();
        Customer customer = null;
        try {
            customer = adapter.convert(customerVO, batchErrors);
        }
        catch (Exception e) {
            exception = true;
        }
        CustomerLoadDigesterConverterTest.assertFalse((String)"No exceptions should have occurred on conversion from VO to BO.", (boolean)exception);
        CustomerLoadDigesterConverterTest.assertNotNull((String)"Customer object should not be null.", (Object)customer);
        CustomerLoadDigesterConverterTest.assertFalse((String)"Batch Errors should not be empty.", (boolean)batchErrors.isEmpty());
        CustomerLoadDigesterConverterTest.assertEquals((String)"Should be one companyName with errors.", (int)1, (int)batchErrors.getCompaniesWithErrors());
        CustomerLoadDigesterConverterTest.assertEquals((String)"Should be two errors total.", (int)2, (int)batchErrors.getTotalErrors());
        CustomerLoadDigesterConverterTest.assertNull((String)"The failed customer birthDate should be null.", (Object)customer.getCustomerBirthDate());
        CustomerLoadDigesterConverterTest.assertNull((String)"The address should have a null end-date.", (Object)((CustomerAddress)customer.getCustomerAddresses().get(0)).getCustomerAddressEndDate());
    }
}

