/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;
import java.time.LocalDate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class BillBuilderTest {
    private Bill.BillBuilder cut;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        this.cut = new Bill.BillBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").setActive(true).setBillNumber("1").setBillDescription("bill 1").setBillDate(Date.valueOf(LocalDate.now())).setEstimatedAmount(new KualiDecimal(100.0));
    }

    @Test
    public void milestoneBuilder_build_allFieldsPopulated_valid() {
        Bill milestone = this.cut.build();
        Assert.assertNotNull((Object)milestone);
    }

    @Test
    public void milestoneBuilder_build_onlyRequiredFieldsPopulated_valid() {
        this.cut.setBillDescription(null);
        Bill bill = this.cut.build();
        Assert.assertNotNull((Object)bill);
    }

    @Test
    public void milestoneBuilder_build_MissingProposalNumber_validateThrowsException() {
        this.cut.setProposalNumber("");
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Proposal Number is required.");
        Bill bill = this.cut.build();
        Assert.assertNull((Object)bill);
    }

    @Test
    public void milestoneBuilder_build_MissingChartOfAccountsCode_validateThrowsException() {
        this.cut.setChartOfAccountsCode("");
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Chart of Accounts Code is required.");
        Bill bill = this.cut.build();
        Assert.assertNull((Object)bill);
    }

    @Test
    public void milestoneBuilder_build_MissingAccountNumber_validateThrowsException() {
        this.cut.setAccountNumber("");
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Account Number is required.");
        Bill bill = this.cut.build();
        Assert.assertNull((Object)bill);
    }

    @Test
    public void milestoneBuilder_build_MissingBillNumber_validateThrowsException() {
        this.cut.setBillNumber("");
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Bill Number is required.");
        Bill bill = this.cut.build();
        Assert.assertNull((Object)bill);
    }

    @Test
    public void milestoneBuilder_build_MissingEstimatedAmount_validateThrowsException() {
        this.cut.setEstimatedAmount(null);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Estimated Amount is required.");
        Bill milestone = this.cut.build();
        Assert.assertNull((Object)milestone);
    }

    @Test
    public void milestoneBuilder_build_MissingBillDate_validateThrowsException() {
        this.cut.setBillDate(null);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Bill Date is required.");
        Bill milestone = this.cut.build();
        Assert.assertNull((Object)milestone);
    }
}

