/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;
import java.time.LocalDate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class MilestoneScheduleBuilderTest {
    private MilestoneSchedule.MilestoneScheduleBuilder cut;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        this.cut = new MilestoneSchedule.MilestoneScheduleBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400");
    }

    @Test
    public void milestoneScheduleBuilder_build_withoutMilestones_valid() {
        MilestoneSchedule milestoneSchedule = this.cut.build();
        Assert.assertNotNull((Object)milestoneSchedule);
    }

    @Test
    public void milestoneScheduleBuilder_build_withOneMilestone_valid() {
        Milestone milestone = new Milestone.MilestoneBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").setMilestoneExpectedCompletionDate(Date.valueOf(LocalDate.now().minusDays(1L))).setActive(true).setMilestoneNumber("1").setMilestoneAmount(new KualiDecimal(100.0)).build();
        this.cut.addMilestone(milestone);
        MilestoneSchedule milestoneSchedule = this.cut.build();
        Assert.assertNotNull((Object)milestoneSchedule);
    }

    @Test
    public void milestoneScheduleBuilder_build_withMultipleMilestone_valid() {
        Milestone milestone1 = new Milestone.MilestoneBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").setMilestoneExpectedCompletionDate(Date.valueOf(LocalDate.now().minusDays(1L))).setActive(true).setMilestoneNumber("1").setMilestoneAmount(new KualiDecimal(100.0)).build();
        Milestone milestone2 = new Milestone.MilestoneBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").setMilestoneExpectedCompletionDate(Date.valueOf(LocalDate.now().minusDays(1L))).setActive(true).setMilestoneNumber("2").setMilestoneAmount(new KualiDecimal(200.0)).build();
        this.cut.addMilestone(milestone1).addMilestone(milestone2);
        MilestoneSchedule milestoneSchedule = this.cut.build();
        Assert.assertNotNull((Object)milestoneSchedule);
    }

    @Test
    public void milestoneScheduleBuilder_build_MissingProposalNumber_validateThrowsException() {
        this.cut.setProposalNumber("");
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Proposal Number is required.");
        MilestoneSchedule milestoneSchedule = this.cut.build();
        Assert.assertNull((Object)milestoneSchedule);
    }

    @Test
    public void milestoneScheduleBuilder_build_MissingChartOfAccountsCode_validateThrowsException() {
        this.cut.setChartOfAccountsCode("");
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Chart of Accounts Code is required.");
        MilestoneSchedule milestoneSchedule = this.cut.build();
        Assert.assertNull((Object)milestoneSchedule);
    }

    @Test
    public void milestoneScheduleBuilder_build_MissingAccountNumber_validateThrowsException() {
        this.cut.setAccountNumber("");
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Account Number is required.");
        MilestoneSchedule milestoneSchedule = this.cut.build();
        Assert.assertNull((Object)milestoneSchedule);
    }
}

