/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.service.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.kns.util.FieldUtils;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsAgingOpenInvoicesReport;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.businessobject.lookup.ContractsGrantsAgingOpenInvoicesReportLookupableHelperServiceImpl;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsAgingOpenInvoicesReportService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsAgingOpenInvoicesReportServiceImpl;
import org.kuali.kfs.module.ar.document.service.impl.CustomerInvoiceDocumentServiceImpl;
import org.kuali.kfs.module.ar.fixture.ARAgencyMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardMockFixture;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsAgingReportService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.report.service.impl.ContractsGrantsReportHelperServiceImpl;
import org.kuali.kfs.module.ar.web.struts.ContractsGrantsAgingOpenInvoicesReportForm;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={GlobalVariables.class, KRADServiceLocatorWeb.class})
public class ContractsGrantsAgingOpenInvoicesReportLookupableHelperServiceImplTest {
    private static final String CHART_CODE = "BL";
    private static final String ORG_CODE = "UGCS";
    private static final String CUSTOMER_NAME = "WOODS CORPORATION";
    private static final String CUSTOMER_NUMBER = "ABB2";
    private ContractsGrantsAgingOpenInvoicesReportLookupableHelperServiceImpl cut;
    private Map<String, String> fieldValues;
    @Mock
    private BusinessObjectDictionaryService businessObjectDictionaryService;
    @Mock
    private BusinessObjectMetaDataService businessObjectMetaDataSvcMock;
    @Mock
    private BusinessObjectService businessObjectService;
    @Mock
    private ConfigurationService configurationSvcMock;
    @Mock
    private ContractsGrantsAgingReportService contractsGrantsAgingReportSvcMock;
    @Mock
    private DataDictionary dataDictionaryMock;
    @Mock
    private org.kuali.kfs.kns.service.DataDictionaryService dataDictionarySvcMock;
    @Mock
    private KualiModuleService kualiModuleSvcMock;
    @Mock
    private ModuleService moduleSvcMock;
    private ContractsAndGrantsBillingAgency agencyMock;
    private ContractsAndGrantsBillingAward awardMock;
    @Mock
    private ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.setupAwardMock();
        this.setupAgencyMock();
        this.setupContractsGrantsInvoiceDocumentMock();
        FieldUtils.setDataDictionaryService((DataDictionaryService)this.dataDictionarySvcMock);
        BusinessObjectEntry businessObjectEntryMock = (BusinessObjectEntry)Mockito.mock(BusinessObjectEntry.class);
        Mockito.when((Object)businessObjectEntryMock.hasLookupDefinition()).thenReturn((Object)false);
        Mockito.when((Object)this.dataDictionaryMock.getBusinessObjectEntry(ContractsGrantsAgingOpenInvoicesReport.class.getName())).thenReturn((Object)businessObjectEntryMock);
        Mockito.when((Object)this.dataDictionarySvcMock.getDataDictionary()).thenReturn((Object)this.dataDictionaryMock);
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.isLookupable(ContractsGrantsAgingOpenInvoicesReport.class)).thenReturn((Object)true);
        PowerMockito.mockStatic(KRADServiceLocatorWeb.class, (Class[])new Class[0]);
        Mockito.when((Object)KRADServiceLocatorWeb.getDataDictionaryService()).thenReturn((Object)this.dataDictionarySvcMock);
        ContractsGrantsReportHelperServiceImpl contractsGrantsReportHelperService = new ContractsGrantsReportHelperServiceImpl();
        contractsGrantsReportHelperService.setConfigurationService(this.configurationSvcMock);
        contractsGrantsReportHelperService.setDataDictionaryService(this.dataDictionarySvcMock);
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.isLookupable(ContractsGrantsAgingOpenInvoicesReport.class)).thenReturn((Object)true);
        ArrayList lookupFieldAttributeList = new ArrayList();
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.getLookupableFieldNames(ContractsGrantsAgingOpenInvoicesReport.class)).thenReturn(lookupFieldAttributeList);
        ContractsGrantsAgingOpenInvoicesReportServiceImpl contractsGrantsAgingOpenInvoicesReportService = this.setupContractsGrantsAgingOpenInvoicesReportService();
        this.cut = new ContractsGrantsAgingOpenInvoicesReportLookupableHelperServiceImpl();
        this.cut.setBusinessObjectDictionaryService(this.businessObjectDictionaryService);
        this.cut.setBusinessObjectService(this.businessObjectService);
        this.cut.setBusinessObjectMetaDataService(this.businessObjectMetaDataSvcMock);
        this.cut.setContractsGrantsAgingOpenInvoicesReportService((ContractsGrantsAgingOpenInvoicesReportService)contractsGrantsAgingOpenInvoicesReportService);
        this.cut.setContractsGrantsReportHelperService((ContractsGrantsReportHelperService)contractsGrantsReportHelperService);
        this.cut.setBusinessObjectClass(ContractsGrantsAgingOpenInvoicesReport.class);
        LinkedHashMap<String, String[]> parameters = new LinkedHashMap<String, String[]>();
        parameters.put("customerNumber", new String[]{CUSTOMER_NUMBER});
        parameters.put("customerName", new String[]{CUSTOMER_NAME});
        this.cut.setParameters(parameters);
        this.setupFieldValues();
    }

    private void setupAwardMock() {
        this.awardMock = ARAwardMockFixture.CG_AWARD_MONTHLY_BILLED_DATE_NULL.createAwardMock();
        ContractsAndGrantsBillingAwardAccount awardAccountMock = ARAwardAccountMockFixture.AWD_ACCT_1.createAwardAccountMock();
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
    }

    private void setupAgencyMock() {
        this.agencyMock = ARAgencyMockFixture.CG_AGENCY1.createAgencyMock();
        Mockito.when((Object)this.awardMock.getAgency()).thenReturn((Object)this.agencyMock);
        String agencyNumber = this.agencyMock.getAgencyNumber();
        Mockito.when((Object)this.awardMock.getAgencyNumber()).thenReturn((Object)agencyNumber);
    }

    private void setupContractsGrantsInvoiceDocumentMock() {
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)workflowDocumentMock.getDocumentTypeName()).thenReturn((Object)"CINV");
        FinancialSystemDocumentHeader documentHeader = new FinancialSystemDocumentHeader();
        documentHeader.setFinancialDocumentStatusCode("A");
        documentHeader.setFinancialDocumentTotalAmount(new KualiDecimal(1000.0));
        documentHeader.setWorkflowDocument(workflowDocumentMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getFinancialSystemDocumentHeader()).thenReturn((Object)documentHeader);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = new AccountsReceivableDocumentHeader();
        accountsReceivableDocumentHeader.setCustomerNumber(CUSTOMER_NUMBER);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)accountsReceivableDocumentHeader);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeader);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getBillingDate()).thenReturn((Object)Date.valueOf(LocalDate.now()));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceDueDate()).thenReturn((Object)Date.valueOf(LocalDate.now().plusDays(30L)));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getCustomerName()).thenReturn((Object)CUSTOMER_NAME);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"1");
        InvoiceGeneralDetail invoiceGeneralDetailMock = (InvoiceGeneralDetail)Mockito.mock(InvoiceGeneralDetail.class);
        Mockito.when((Object)invoiceGeneralDetailMock.getAward()).thenReturn((Object)this.awardMock);
        String proposalNumber = this.awardMock.getProposalNumber();
        Mockito.when((Object)invoiceGeneralDetailMock.getProposalNumber()).thenReturn((Object)proposalNumber);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetailMock);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        InvoiceAddressDetail invoiceAddressDetail = new InvoiceAddressDetail();
        invoiceAddressDetail.setCustomerInvoiceTemplateCode("STD");
        invoiceAddressDetail.setInvoiceTransmissionMethodCode("MAIL");
        invoiceAddressDetails.add(invoiceAddressDetail);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceAddressDetails()).thenReturn(invoiceAddressDetails);
        ArrayList<CustomerInvoiceDetail> customerInvoiceDetails = new ArrayList<CustomerInvoiceDetail>();
        CustomerInvoiceDetail customerInvoiceDetailMock = (CustomerInvoiceDetail)Mockito.mock(CustomerInvoiceDetail.class);
        Mockito.when((Object)customerInvoiceDetailMock.getAccountNumber()).thenReturn((Object)"1031400");
        customerInvoiceDetails.add(customerInvoiceDetailMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getSourceAccountingLines()).thenReturn(customerInvoiceDetails);
    }

    private ContractsGrantsAgingOpenInvoicesReportServiceImpl setupContractsGrantsAgingOpenInvoicesReportService() throws ParseException {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("customerNumber", CUSTOMER_NUMBER);
        Mockito.when((Object)this.moduleSvcMock.getExternalizableBusinessObject(ContractsAndGrantsBillingAgency.class, args)).thenReturn((Object)this.agencyMock);
        Mockito.when((Object)this.kualiModuleSvcMock.getResponsibleModuleService(ContractsAndGrantsBillingAgency.class)).thenReturn((Object)this.moduleSvcMock);
        ArrayList<ContractsGrantsInvoiceDocument> contractsGrantsInvoiceDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        contractsGrantsInvoiceDocuments.add(this.contractsGrantsInvoiceDocumentMock);
        LinkedHashMap<String, ArrayList<ContractsGrantsInvoiceDocument>> invoiceMap = new LinkedHashMap<String, ArrayList<ContractsGrantsInvoiceDocument>>();
        invoiceMap.put("ABB2-WOODS CORPORATION", contractsGrantsInvoiceDocuments);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put("customerNumber", CUSTOMER_NUMBER);
        fieldValues.put("customerName", CUSTOMER_NAME);
        Mockito.when((Object)this.contractsGrantsAgingReportSvcMock.filterContractsGrantsAgingReport(fieldValues, null, null)).thenReturn(invoiceMap);
        ContractsGrantsAgingOpenInvoicesReportServiceImpl contractsGrantsAgingOpenInvoicesReportService = new ContractsGrantsAgingOpenInvoicesReportServiceImpl();
        contractsGrantsAgingOpenInvoicesReportService.setContractsGrantsAgingReportService(this.contractsGrantsAgingReportSvcMock);
        contractsGrantsAgingOpenInvoicesReportService.setCustomerInvoiceDocumentService((CustomerInvoiceDocumentService)new CustomerInvoiceDocumentServiceImpl());
        contractsGrantsAgingOpenInvoicesReportService.setKualiModuleService(this.kualiModuleSvcMock);
        return contractsGrantsAgingOpenInvoicesReportService;
    }

    private void setupFieldValues() {
        this.fieldValues = new LinkedHashMap<String, String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        this.fieldValues.put("backLocation", null);
        this.fieldValues.put("reportRunDate", dateFormat.format(new java.util.Date()));
        this.fieldValues.put("organizationCode", ORG_CODE);
        this.fieldValues.put("billingChartCode", CHART_CODE);
        this.fieldValues.put("docFormKey", null);
        this.fieldValues.put("customerNumber", CUSTOMER_NUMBER);
        this.fieldValues.put("customerName", CUSTOMER_NAME);
        this.fieldValues.put("businessObjectClassName", ContractsGrantsAgingOpenInvoicesReport.class.getName());
    }

    @Test
    public void getSearchResults() {
        List searchResults = this.cut.getSearchResults(this.fieldValues);
        Assert.assertNotNull((String)"search results not null", (Object)searchResults);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        ContractsGrantsAgingOpenInvoicesReport contractsGrantsAgingOpenInvoicesReport = (ContractsGrantsAgingOpenInvoicesReport)searchResults.get(0);
        Assert.assertEquals((Object)"No", (Object)contractsGrantsAgingOpenInvoicesReport.getFinalInvoice());
        Assert.assertEquals((Object)this.agencyMock.getAgencyNumber(), (Object)contractsGrantsAgingOpenInvoicesReport.getAgencyNumber());
        Assert.assertEquals((Object)"CINV", (Object)contractsGrantsAgingOpenInvoicesReport.getDocumentType());
        Assert.assertEquals((Object)"1", (Object)contractsGrantsAgingOpenInvoicesReport.getDocumentNumber());
        Assert.assertEquals((Object)"", (Object)contractsGrantsAgingOpenInvoicesReport.getDocumentDescription());
        Assert.assertEquals((Object)this.awardMock.getProposalNumber(), (Object)contractsGrantsAgingOpenInvoicesReport.getProposalNumber());
        Assert.assertEquals((Object)"1031400", (Object)contractsGrantsAgingOpenInvoicesReport.getAccountNumber());
        Assert.assertEquals((Object)this.contractsGrantsInvoiceDocumentMock.getBillingDate(), (Object)contractsGrantsAgingOpenInvoicesReport.getBillingDate());
        Assert.assertEquals((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceDueDate(), (Object)contractsGrantsAgingOpenInvoicesReport.getDueApprovedDate());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsGrantsAgingOpenInvoicesReport.getUnpaidUnappliedAmount());
        Assert.assertEquals((Object)new KualiDecimal(1000.0), (Object)contractsGrantsAgingOpenInvoicesReport.getDocumentPaymentAmount());
    }

    @Test
    public void getSearchResults_NoInvoiceFound() throws ParseException {
        Mockito.when((Object)this.contractsGrantsAgingReportSvcMock.filterContractsGrantsAgingReport(ArgumentMatchers.anyMap(), (Date)ArgumentMatchers.eq(null), (Date)ArgumentMatchers.eq(null))).thenReturn(Collections.emptyMap());
        List searchResults = this.cut.getSearchResults(this.fieldValues);
        Assert.assertNotNull((String)"search results not null", (Object)searchResults);
        Assert.assertEquals((long)0L, (long)searchResults.size());
    }

    @Test
    public void performLookup() {
        ContractsGrantsAgingOpenInvoicesReportForm agingOpenInvoicesReportForm = new ContractsGrantsAgingOpenInvoicesReportForm();
        agingOpenInvoicesReportForm.setFieldsForLookup(this.fieldValues);
        Collection lookupResults = this.cut.performLookup((LookupForm)agingOpenInvoicesReportForm, new ArrayList(), true);
        Assert.assertNotNull((Object)lookupResults);
        Assert.assertEquals((long)1L, (long)lookupResults.size());
        ContractsGrantsAgingOpenInvoicesReport contractsGrantsAgingOpenInvoicesReport = (ContractsGrantsAgingOpenInvoicesReport)lookupResults.iterator().next();
        Assert.assertEquals((Object)"No", (Object)contractsGrantsAgingOpenInvoicesReport.getFinalInvoice());
        Assert.assertEquals((Object)this.agencyMock.getAgencyNumber(), (Object)contractsGrantsAgingOpenInvoicesReport.getAgencyNumber());
        Assert.assertEquals((Object)"CINV", (Object)contractsGrantsAgingOpenInvoicesReport.getDocumentType());
        Assert.assertEquals((Object)"1", (Object)contractsGrantsAgingOpenInvoicesReport.getDocumentNumber());
        Assert.assertEquals((Object)"", (Object)contractsGrantsAgingOpenInvoicesReport.getDocumentDescription());
        Assert.assertEquals((Object)this.awardMock.getProposalNumber(), (Object)contractsGrantsAgingOpenInvoicesReport.getProposalNumber());
        Assert.assertEquals((Object)"1031400", (Object)contractsGrantsAgingOpenInvoicesReport.getAccountNumber());
        Assert.assertEquals((Object)this.contractsGrantsInvoiceDocumentMock.getBillingDate(), (Object)contractsGrantsAgingOpenInvoicesReport.getBillingDate());
        Assert.assertEquals((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceDueDate(), (Object)contractsGrantsAgingOpenInvoicesReport.getDueApprovedDate());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)contractsGrantsAgingOpenInvoicesReport.getUnpaidUnappliedAmount());
        Assert.assertEquals((Object)new KualiDecimal(1000.0), (Object)contractsGrantsAgingOpenInvoicesReport.getDocumentPaymentAmount());
    }

    @Test
    public void performLookup_NoInvoiceFound() throws ParseException {
        Mockito.when((Object)this.contractsGrantsAgingReportSvcMock.filterContractsGrantsAgingReport(ArgumentMatchers.anyMap(), (Date)ArgumentMatchers.eq(null), (Date)ArgumentMatchers.eq(null))).thenReturn(Collections.emptyMap());
        ContractsGrantsAgingOpenInvoicesReportForm agingOpenInvoicesReportForm = new ContractsGrantsAgingOpenInvoicesReportForm();
        agingOpenInvoicesReportForm.setFieldsForLookup(Collections.emptyMap());
        Collection lookupResults = this.cut.performLookup((LookupForm)agingOpenInvoicesReportForm, new ArrayList(), true);
        Assert.assertNotNull((Object)lookupResults);
        Assert.assertEquals((long)0L, (long)lookupResults.size());
    }
}

