/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.inquiry.AccountInquirable;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kns.service.BusinessObjectAuthorizationService;
import org.kuali.kfs.kns.service.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.kns.service.SecurityLoggingService;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.DunningCampaign;
import org.kuali.kfs.module.ar.businessobject.DunningLetterDistribution;
import org.kuali.kfs.module.ar.businessobject.DunningLetterTemplate;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.businessobject.lookup.GenerateDunningLettersLookupableHelperServiceImpl;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.DunningLetterService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsInvoiceDocumentServiceImpl;
import org.kuali.kfs.module.ar.document.service.impl.DunningLetterServiceImpl;
import org.kuali.kfs.module.ar.fixture.ARAwardMockFixture;
import org.kuali.kfs.module.ar.fixture.DunningCampaignFixture;
import org.kuali.kfs.module.ar.fixture.DunningLetterDistributionFixture;
import org.kuali.kfs.module.ar.fixture.DunningLetterTemplateFixture;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.report.service.impl.ContractsGrantsReportHelperServiceImpl;
import org.kuali.kfs.module.ar.web.struts.GenerateDunningLettersLookupForm;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kim.api.identity.Person;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={GlobalVariables.class, KNSServiceLocator.class})
public class DunningLetterDistributionLookupableHelperServiceImplTest {
    private GenerateDunningLettersLookupableHelperServiceImpl cut;
    private GenerateDunningLettersLookupForm generateDunningLettersLookupForm;
    @Mock
    private AccountService accountSvcMock;
    @Mock
    private BusinessObjectAuthorizationService businessObjectAuthorizationSvcMock;
    @Mock
    private BusinessObjectDictionaryService businessObjectDictionarySvcMock;
    @Mock
    private BusinessObjectMetaDataService businessObjectMetaDataSvcMock;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private ConfigurationService configurationSvcMock;
    @Mock
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentSvcMock;
    @Mock
    private MaintenanceDocumentDictionaryService maintenanceDocumentDictionarySvcMock;
    @Mock
    private ParameterService parameterSvcMck;
    @Mock
    private SecurityLoggingService securityLoggingSvcMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(GlobalVariables.class, (Class[])new Class[0]);
        UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
        Mockito.when((Object)GlobalVariables.getUserSession()).thenReturn((Object)userSessionMock);
        Mockito.when((Object)userSessionMock.getPerson()).thenReturn(Mockito.mock(Person.class));
        PowerMockito.mockStatic(KNSServiceLocator.class, (Class[])new Class[0]);
        Mockito.when((Object)KNSServiceLocator.getSecurityLoggingService()).thenReturn((Object)this.securityLoggingSvcMock);
        Mockito.when((Object)this.parameterSvcMck.getParameterValueAsString(DunningCampaign.class, "DUNNING_LETTERS_FINAL_DAYS_PAST_DUE", "0")).thenReturn((Object)"150");
        Mockito.when((Object)this.parameterSvcMck.getParameterValueAsString(DunningCampaign.class, "DUNNING_LETTERS_STATE_AGENCY_FINAL_DAYS_PAST_DUE", "0")).thenReturn((Object)"150");
        Mockito.when((Object)this.businessObjectDictionarySvcMock.getLookupDefaultSortFieldNames(null)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.listPrimaryKeyFieldNames(null)).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("title.return.url.value.prependtext")).thenReturn((Object)"return value");
        DunningLetterServiceImpl dunningLetterService = new DunningLetterServiceImpl();
        dunningLetterService.setContractsGrantsInvoiceDocumentService((ContractsGrantsInvoiceDocumentService)new ContractsGrantsInvoiceDocumentServiceImpl());
        this.generateDunningLettersLookupForm = new GenerateDunningLettersLookupForm();
        this.cut = new GenerateDunningLettersLookupableHelperServiceImpl();
        this.cut.setAccountService(this.accountSvcMock);
        this.cut.setBusinessObjectAuthorizationService(this.businessObjectAuthorizationSvcMock);
        this.cut.setBusinessObjectDictionaryService(this.businessObjectDictionarySvcMock);
        this.cut.setBusinessObjectMetaDataService(this.businessObjectMetaDataSvcMock);
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setConfigurationService(this.configurationSvcMock);
        this.cut.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentSvcMock);
        this.cut.setContractsGrantsReportHelperService((ContractsGrantsReportHelperService)new ContractsGrantsReportHelperServiceImpl());
        this.cut.setDataDictionaryService(this.dataDictionarySvcMock);
        this.cut.setDunningLetterService((DunningLetterService)dunningLetterService);
        this.cut.setMaintenanceDocumentDictionaryService(this.maintenanceDocumentDictionarySvcMock);
        this.cut.setParameterService(this.parameterSvcMck);
        this.setupMockDocumentAndBusinessObjects();
    }

    private void setupMockDocumentAndBusinessObjects() {
        ArrayList<ContractsGrantsInvoiceDocument> contractsGrantsInvoiceDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock = (ContractsGrantsInvoiceDocument)Mockito.mock(ContractsGrantsInvoiceDocument.class);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentSvcMock.canViewInvoice(contractsGrantsInvoiceDocumentMock, null)).thenReturn((Object)true);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAge()).thenReturn((Object)10);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = new AccountsReceivableDocumentHeader();
        accountsReceivableDocumentHeader.setCustomerNumber("C1");
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)accountsReceivableDocumentHeader);
        InvoiceGeneralDetail invoiceGeneralDetailMock = (InvoiceGeneralDetail)Mockito.mock(InvoiceGeneralDetail.class);
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD_MONTHLY_BILLED_DATE_NULL.createAwardMock();
        DunningCampaign dunningCampaign = DunningCampaignFixture.AR_DUNC1.createDunningCampaign();
        DunningLetterDistribution dunningLetterDistribution = DunningLetterDistributionFixture.AR_DLD1.createDunningLetterDistribution();
        dunningLetterDistribution.setActiveIndicator(true);
        dunningLetterDistribution.setSendDunningLetterIndicator(true);
        DunningLetterTemplate dunningLetterTemplate = DunningLetterTemplateFixture.CG_DLTS1.createDunningLetterTemplate();
        dunningLetterDistribution.setDunningLetterTemplate(dunningLetterTemplate.getDunningLetterTemplateCode());
        dunningCampaign.getDunningLetterDistributions().add(dunningLetterDistribution);
        Mockito.when((Object)awardMock.getDunningCampaign()).thenReturn((Object)dunningCampaign.getCampaignID());
        Mockito.when((Object)invoiceGeneralDetailMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetailMock);
        contractsGrantsInvoiceDocuments.add(contractsGrantsInvoiceDocumentMock);
        Mockito.when((Object)this.businessObjectSvcMock.findBySinglePrimaryKey(DunningCampaign.class, (Object)dunningCampaign.getCampaignID())).thenReturn((Object)dunningCampaign);
        Mockito.when((Object)this.businessObjectSvcMock.findBySinglePrimaryKey(DunningLetterTemplate.class, (Object)dunningLetterDistribution.getDunningLetterTemplate())).thenReturn((Object)dunningLetterTemplate);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put("documentNumber", "1");
        fieldValues.put("documentHeader.financialDocumentStatusCode", "A");
        fieldValues.put("openInvoiceIndicator", "true");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentSvcMock.retrieveAllCGInvoicesByCriteria(fieldValues)).thenReturn(contractsGrantsInvoiceDocuments);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = new InvoiceAccountDetail();
        invoiceAccountDetail.setChartOfAccountsCode("BL");
        invoiceAccountDetail.setAccountNumber("2336320");
        invoiceAccountDetails.add(invoiceAccountDetail);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(invoiceAccountDetails);
        Account accountMock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)accountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)accountMock.getAccountNumber()).thenReturn((Object)"2336320");
        Mockito.when((Object)this.accountSvcMock.getByPrimaryId("BL", "2336320")).thenReturn((Object)accountMock);
        Mockito.when((Object)this.businessObjectDictionarySvcMock.getInquirableClass(accountMock.getClass())).thenReturn(AccountInquirable.class);
        Mockito.when((Object)this.businessObjectDictionarySvcMock.noLookupResultFieldInquiry(contractsGrantsInvoiceDocumentMock.getClass(), "age")).thenReturn(null);
    }

    @Test
    public void performLookup_InvoiceFound() {
        LinkedHashMap<String, String> fieldsForLookup = new LinkedHashMap<String, String>();
        fieldsForLookup.put("invoiceDocumentNumber", "1");
        this.generateDunningLettersLookupForm.setFieldsForLookup(fieldsForLookup);
        Collection lookupResults = this.cut.performLookup((LookupForm)this.generateDunningLettersLookupForm, new ArrayList(), true);
        Assert.assertEquals((long)1L, (long)lookupResults.size());
    }

    @Test
    public void performLookup_InvoiceNotFound() {
        LinkedHashMap<String, String> fieldsForLookup = new LinkedHashMap<String, String>();
        fieldsForLookup.put("invoiceDocumentNumber", "2");
        this.generateDunningLettersLookupForm.setFieldsForLookup(fieldsForLookup);
        Collection lookupResults = this.cut.performLookup((LookupForm)this.generateDunningLettersLookupForm, (Collection)Collections.EMPTY_LIST, true);
        Assert.assertEquals((long)0L, (long)lookupResults.size());
    }
}

