/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import org.kuali.kfs.coa.businessobject.defaultvalue.CurrentUserChartValueFinder;
import org.kuali.kfs.coa.businessobject.defaultvalue.CurrentUserOrgValueFinder;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.InvoiceTemplate;
import org.kuali.kfs.module.ar.businessobject.lookup.InvoiceTemplateLookupableHelperServiceImpl;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.rice.kim.api.identity.Person;

@ConfigureContext(session=UserNameFixture.khuntley)
public class InvoiceTemplateTest
extends KualiTestBase {
    public static final String TYPE_CODE = "1115";
    public static final String TYPE_DESCRIPTION = "Federal SF-1115";
    public static final boolean ACTIVE = true;
    private InvoiceTemplate invoiceTemplate;

    protected void setUp() throws Exception {
        super.setUp();
        this.invoiceTemplate = new InvoiceTemplate();
        this.invoiceTemplate.setInvoiceTemplateCode(TYPE_CODE);
        this.invoiceTemplate.setInvoiceTemplateDescription(TYPE_DESCRIPTION);
        this.invoiceTemplate.setActive(true);
    }

    public void testValidOrganization() {
        InvoiceTemplateLookupableHelperServiceImpl invoiceTemplateLookupable = new InvoiceTemplateLookupableHelperServiceImpl();
        invoiceTemplateLookupable.setFinancialSystemUserService((FinancialSystemUserService)SpringContext.getBean(FinancialSystemUserService.class));
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        InvoiceTemplateTest.assertFalse((boolean)invoiceTemplateLookupable.isTemplateValidForUser(this.invoiceTemplate, currentUser));
        this.invoiceTemplate.setBillByChartOfAccountCode(new CurrentUserChartValueFinder().getValue());
        this.invoiceTemplate.setBilledByOrganizationCode(new CurrentUserOrgValueFinder().getValue());
        InvoiceTemplateTest.assertTrue((boolean)invoiceTemplateLookupable.isTemplateValidForUser(this.invoiceTemplate, currentUser));
    }

    public void testIsTemplateValidForContractsGrantsInvoiceDocument() {
        ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService = (ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class);
        String billByChartOfAccountCode = new CurrentUserChartValueFinder().getValue();
        String billedByOrganizationCode = new CurrentUserOrgValueFinder().getValue();
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = new ContractsGrantsInvoiceDocument();
        contractsGrantsInvoiceDocument.setBillByChartOfAccountCode(billByChartOfAccountCode);
        contractsGrantsInvoiceDocument.setBilledByOrganizationCode(billedByOrganizationCode);
        InvoiceTemplateTest.assertFalse((boolean)contractsGrantsInvoiceDocumentService.isTemplateValidForContractsGrantsInvoiceDocument(this.invoiceTemplate, contractsGrantsInvoiceDocument));
        this.invoiceTemplate.setBillByChartOfAccountCode(billByChartOfAccountCode);
        this.invoiceTemplate.setBilledByOrganizationCode(billedByOrganizationCode);
        InvoiceTemplateTest.assertTrue((boolean)contractsGrantsInvoiceDocumentService.isTemplateValidForContractsGrantsInvoiceDocument(this.invoiceTemplate, contractsGrantsInvoiceDocument));
    }
}

