/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.lang.reflect.Field;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.kuali.kfs.integration.cg.businessobject.Award;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.kfs.module.ar.businessobject.lookup.ScheduleLookupableHelperServiceImpl;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.impl.datetime.DateTimeServiceImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.springframework.util.AutoPopulatingList;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={org.kuali.kfs.krad.lookup.LookupUtils.class, LookupUtils.class})
public class ScheduleLookupableHelperServiceImplTest {
    private ScheduleLookupableHelperServiceImpl cutSpy;
    @Mock
    private BusinessObjectMetaDataService businessObjectMetaDataSvcMock;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private LookupService lookupSvcMock;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private Map<String, String> fieldValues = new HashMap<String, String>();
    private List<MilestoneSchedule> milestoneSchedules;
    private List<PredeterminedBillingSchedule> predeterminedBillingSchedules;
    private DateTimeServiceImpl dateTimeService;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(org.kuali.kfs.krad.lookup.LookupUtils.class, (Class[])new Class[0]);
        Mockito.when((Object)org.kuali.kfs.krad.lookup.LookupUtils.forceUppercase(MilestoneSchedule.class, this.fieldValues)).thenReturn(this.fieldValues);
        PowerMockito.mockStatic(LookupUtils.class, (Class[])new Class[0]);
        Mockito.when((Object)LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)200);
        this.setupDateTimeService();
        this.setupFieldValues();
        this.setupMilestoneSchedulesList();
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(MilestoneSchedule.class, "award.awardEndingDate")).thenReturn((Object)"Award Ending Date");
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.isLookupable(MilestoneSchedule.class)).thenReturn((Object)true);
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.getLookupableFieldNames(MilestoneSchedule.class)).thenReturn(Collections.emptyList());
        this.cutSpy = (ScheduleLookupableHelperServiceImpl)PowerMockito.spy((Object)new ScheduleLookupableHelperServiceImpl());
        this.cutSpy.setBusinessObjectMetaDataService(this.businessObjectMetaDataSvcMock);
        this.cutSpy.setDataDictionaryService(this.dataDictionarySvcMock);
        this.cutSpy.setDateTimeService((DateTimeService)this.dateTimeService);
        this.cutSpy.setLookupService(this.lookupSvcMock);
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(MilestoneSchedule.class);
        PowerMockito.doReturn(this.milestoneSchedules).when((Object)this.cutSpy, "getSearchResultsHelper", new Object[]{ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true)});
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    private void setupDateTimeService() throws NoSuchFieldException, IllegalAccessException {
        this.dateTimeService = new DateTimeServiceImpl();
        Field field = DateTimeServiceImpl.class.getDeclaredField("stringToDateFormats");
        field.setAccessible(true);
        field.set(this.dateTimeService, new String[]{"MM/dd/yyyy"});
    }

    private void setupFieldValues() {
        this.fieldValues.put("chartOfAccountsCode", "");
        this.fieldValues.put("award.awardEndingDate", "");
        this.fieldValues.put("proposalNumber", "");
        this.fieldValues.put("agencyNumber", "");
        this.fieldValues.put("accountNumber", "");
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "");
    }

    private void setupMilestoneSchedulesList() {
        this.milestoneSchedules = new ArrayList<MilestoneSchedule>();
        this.milestoneSchedules.add(this.setupMilestoneSchedule("80078", "0211603", "55078", Date.valueOf("2017-02-05")));
        this.milestoneSchedules.add(this.setupMilestoneSchedule("80080", "0211802", "55120", Date.valueOf("2018-02-05")));
        this.milestoneSchedules.add(this.setupMilestoneSchedule("80090", "0211910", "55078", Date.valueOf("2019-12-01")));
    }

    private MilestoneSchedule setupMilestoneSchedule(String proposalNumber, String accountNumber, String agencyNumber, Date awardEndingDate) {
        MilestoneSchedule milestoneScheduleMock = (MilestoneSchedule)Mockito.mock(MilestoneSchedule.class);
        Mockito.when((Object)milestoneScheduleMock.getProposalNumber()).thenReturn((Object)proposalNumber);
        Mockito.when((Object)milestoneScheduleMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)milestoneScheduleMock.getAccountNumber()).thenReturn((Object)accountNumber);
        Award awardMock = (Award)Mockito.mock(Award.class);
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)proposalNumber);
        Mockito.when((Object)awardMock.getAgencyNumber()).thenReturn((Object)agencyNumber);
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)awardEndingDate);
        Mockito.when((Object)milestoneScheduleMock.getAward()).thenReturn((Object)awardMock);
        return milestoneScheduleMock;
    }

    @Test
    public void getSearchResults() {
        List searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        Assert.assertEquals((long)3L, (long)searchResults.size());
        Assert.assertEquals(this.milestoneSchedules, (Object)searchResults);
    }

    @Test
    public void getSearchResults_moreThanLimitReturned_listTruncated() {
        Mockito.when((Object)LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)2);
        List searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        List<MilestoneSchedule> expectedSearchResults = this.milestoneSchedules.subList(0, 2);
        Assert.assertEquals((long)2L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
    }

    @Test
    public void getSearchResults_filterOnAgency() {
        this.fieldValues.put("agencyNumber", "55120");
        List expectedSearchResults = this.milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55120")).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assert.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assert.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assert.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    public void getSearchResults_filterOnAgencyWithWildcardAsterisks() {
        this.fieldValues.put("agencyNumber", "*551*");
        List expectedSearchResults = this.milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55120")).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assert.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assert.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assert.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    public void getSearchResults_filterOnAgencyWithWildcardPercents() {
        this.fieldValues.put("agencyNumber", "%551%");
        List expectedSearchResults = this.milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55120")).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assert.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assert.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assert.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    public void getSearchResults_filterOnAgencyWithWildcardQuestionMark() {
        this.fieldValues.put("agencyNumber", "551?0");
        List expectedSearchResults = this.milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55120")).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assert.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assert.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assert.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    public void getSearchResults_filterOnAgencyWithLogicalAnd() {
        this.fieldValues.put("agencyNumber", "55078&&55120");
        List expectedSearchResults = Collections.emptyList();
        List searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        Assert.assertEquals((long)0L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
    }

    @Test
    public void getSearchResults_filterOnAgencyWithLogicalOr() {
        this.fieldValues.put("agencyNumber", "55078|55120");
        ArrayList<MilestoneSchedule> expectedSearchResults = new ArrayList<MilestoneSchedule>(this.milestoneSchedules);
        List searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        Assert.assertEquals((long)3L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
    }

    @Test
    public void getSearchResults_filterOnAwardExpirationDateFrom() {
        this.fieldValues.put("award.awardEndingDate", ">=01/10/2019");
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "01/10/2019");
        List expectedSearchResults = this.milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAwardEndingDate().after(Date.valueOf("2019-01-10"))).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assert.assertEquals((Object)"80090", (Object)milestoneSchedule2.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"0211910", (Object)milestoneSchedule2.getAccountNumber());
        Assert.assertEquals((Object)"55078", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assert.assertEquals((Object)Date.valueOf("2019-12-01"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    public void getSearchResults_filterOnAwardExpirationDateTo() {
        this.fieldValues.put("award.awardEndingDate", "<=01/10/2018");
        List expectedSearchResults = this.milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAwardEndingDate().before(Date.valueOf("2018-01-10"))).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assert.assertEquals((Object)"80078", (Object)milestoneSchedule2.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"0211603", (Object)milestoneSchedule2.getAccountNumber());
        Assert.assertEquals((Object)"55078", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assert.assertEquals((Object)Date.valueOf("2017-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    public void getSearchResults_filterOnAwardExpirationDateFromAndTo() {
        this.fieldValues.put("award.awardEndingDate", "01/10/2018..01/10/2019");
        List expectedSearchResults = this.milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAwardEndingDate().after(Date.valueOf("2018-01-10")) && milestoneSchedule.getAward().getAwardEndingDate().before(Date.valueOf("2019-01-10"))).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assert.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assert.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assert.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    public void getSearchResults_filterOnAgencyAndAwardExpirationDateFromAndTo() {
        this.fieldValues.put("agencyNumber", "55078");
        this.fieldValues.put("award.awardEndingDate", "01/10/2016..01/10/2019");
        List expectedSearchResults = this.milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55078")).filter(milestoneSchedule -> milestoneSchedule.getAward().getAwardEndingDate().before(Date.valueOf("2019-01-10"))).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assert.assertEquals((Object)"80078", (Object)milestoneSchedule2.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"0211603", (Object)milestoneSchedule2.getAccountNumber());
        Assert.assertEquals((Object)"55078", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assert.assertEquals((Object)Date.valueOf("2017-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    public void getSearchResultsUnbounded() {
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assert.assertEquals((long)3L, (long)searchResults.size());
        Assert.assertEquals(this.milestoneSchedules, (Object)searchResults);
    }

    @Test
    public void getSearchResultsUnbounded_moreThanLimitReturned_listNotTruncated() {
        Mockito.when((Object)LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)2);
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assert.assertEquals((long)3L, (long)searchResults.size());
        Assert.assertEquals(this.milestoneSchedules, (Object)searchResults);
    }

    @Test
    public void getSearchResultsUnbounded_filterOnAgency() {
        this.fieldValues.put("agencyNumber", "55120");
        List expectedSearchResults = this.milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55120")).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assert.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assert.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assert.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    public void getSearchResultsUnbounded_filterOnAgencyWithWildcardAsterisks() {
        this.fieldValues.put("agencyNumber", "*551*");
        List expectedSearchResults = this.milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55120")).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assert.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assert.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assert.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    public void getSearchResultsUnbounded_filterOnAgencyWithWildcardPercents() {
        this.fieldValues.put("agencyNumber", "%551%");
        List expectedSearchResults = this.milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55120")).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assert.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assert.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assert.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    public void getSearchResultsUnbounded_filterOnAgencyWithWildcardQuestionMark() {
        this.fieldValues.put("agencyNumber", "551?0");
        List expectedSearchResults = this.milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55120")).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assert.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assert.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assert.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    public void getSearchResultsUnbounded_filterOnAgencyWithLogicalAnd() {
        this.fieldValues.put("agencyNumber", "55078&&55120");
        List expectedSearchResults = Collections.emptyList();
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assert.assertEquals((long)0L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
    }

    @Test
    public void getSearchResultsUnbounded_filterOnAgencyWithLogicalOr() {
        this.fieldValues.put("agencyNumber", "55078|55120");
        ArrayList<MilestoneSchedule> expectedSearchResults = new ArrayList<MilestoneSchedule>(this.milestoneSchedules);
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assert.assertEquals((long)3L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
    }

    @Test
    public void getSearchResultsUnbounded_filterOnAwardExpirationDateFrom() {
        this.fieldValues.put("award.awardEndingDate", ">=01/10/2019");
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "01/10/2019");
        List expectedSearchResults = this.milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAwardEndingDate().after(Date.valueOf("2019-01-10"))).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assert.assertEquals((Object)"80090", (Object)milestoneSchedule2.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"0211910", (Object)milestoneSchedule2.getAccountNumber());
        Assert.assertEquals((Object)"55078", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assert.assertEquals((Object)Date.valueOf("2019-12-01"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    public void getSearchResultsUnbounded_filterOnAwardExpirationDateTo() {
        this.fieldValues.put("award.awardEndingDate", "<=01/10/2018");
        List expectedSearchResults = this.milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAwardEndingDate().before(Date.valueOf("2018-01-10"))).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assert.assertEquals((Object)"80078", (Object)milestoneSchedule2.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"0211603", (Object)milestoneSchedule2.getAccountNumber());
        Assert.assertEquals((Object)"55078", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assert.assertEquals((Object)Date.valueOf("2017-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    public void getSearchResultsUnbounded_filterOnAwardExpirationDateFromAndTo() {
        this.fieldValues.put("award.awardEndingDate", "01/10/2018..01/10/2019");
        List expectedSearchResults = this.milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAwardEndingDate().after(Date.valueOf("2018-01-10")) && milestoneSchedule.getAward().getAwardEndingDate().before(Date.valueOf("2019-01-10"))).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assert.assertEquals((Object)"80080", (Object)milestoneSchedule2.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"0211802", (Object)milestoneSchedule2.getAccountNumber());
        Assert.assertEquals((Object)"55120", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assert.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    public void getSearchResultsUnbounded_filterOnAgencyAndAwardExpirationDateFromAndTo() {
        this.fieldValues.put("agencyNumber", "55078");
        this.fieldValues.put("award.awardEndingDate", "01/10/2016..01/10/2019");
        List expectedSearchResults = this.milestoneSchedules.stream().filter(milestoneSchedule -> milestoneSchedule.getAward().getAgencyNumber().equals("55078")).filter(milestoneSchedule -> milestoneSchedule.getAward().getAwardEndingDate().before(Date.valueOf("2019-01-10"))).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResultsUnbounded(this.fieldValues);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
        MilestoneSchedule milestoneSchedule2 = (MilestoneSchedule)searchResults.get(0);
        Assert.assertEquals((Object)"80078", (Object)milestoneSchedule2.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)milestoneSchedule2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"0211603", (Object)milestoneSchedule2.getAccountNumber());
        Assert.assertEquals((Object)"55078", (Object)milestoneSchedule2.getAward().getAgencyNumber());
        Assert.assertEquals((Object)Date.valueOf("2017-02-05"), (Object)milestoneSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    public void validateSearchParameters_emptyAwardEndingDate() {
        this.cutSpy.validateSearchParameters(this.fieldValues);
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void validateSearchParameters_validAwardEndingDateFrom() {
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "01/10/2019");
        this.cutSpy.validateSearchParameters(this.fieldValues);
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void validateSearchParameters_validAwardEndingDateTo() {
        this.fieldValues.put("award.awardEndingDate", "01/10/2019");
        this.cutSpy.validateSearchParameters(this.fieldValues);
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void validateSearchParameters_validAwardEndingDateFromAndTo() {
        this.fieldValues.put("award.awardEndingDate", "01/10/2018");
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "01/10/2019");
        this.cutSpy.validateSearchParameters(this.fieldValues);
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void validateSearchParameters_validAwardEndingDateFromAndInvalidAwardEndingDateTo() {
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "01/10/2019");
        this.fieldValues.put("award.awardEndingDate", "abc");
        this.expectedException.expect(ValidationException.class);
        this.expectedException.expectMessage("errors in search criteria");
        try {
            this.cutSpy.validateSearchParameters(this.fieldValues);
        }
        finally {
            Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
            ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("award.awardEndingDate")).get(0);
            Assert.assertEquals((Object)"error.invalidDateTime", (Object)errorMessage.getErrorKey());
            Assert.assertEquals((long)1L, (long)errorMessage.getMessageParameters().length);
            Assert.assertEquals((Object)"Award Ending Date To", (Object)errorMessage.getMessageParameters()[0]);
        }
    }

    @Test
    public void validateSearchParameters_invalidAwardEndingDateFromAndValidEndingDateTo() {
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "xyz");
        this.fieldValues.put("award.awardEndingDate", "01/10/2018");
        this.expectedException.expect(ValidationException.class);
        this.expectedException.expectMessage("errors in search criteria");
        try {
            this.cutSpy.validateSearchParameters(this.fieldValues);
        }
        finally {
            Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
            ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("rangeLowerBoundKeyPrefix_award.awardEndingDate")).get(0);
            Assert.assertEquals((Object)"error.invalidDateTime", (Object)errorMessage.getErrorKey());
            Assert.assertEquals((long)1L, (long)errorMessage.getMessageParameters().length);
            Assert.assertEquals((Object)"Award Ending Date From", (Object)errorMessage.getMessageParameters()[0]);
        }
    }

    @Test
    public void validateSearchParameters_invalidAwardEndingDateFromAndTo() {
        this.fieldValues.put("rangeLowerBoundKeyPrefix_award.awardEndingDate", "xyz");
        this.fieldValues.put("award.awardEndingDate", "abc");
        this.expectedException.expect(ValidationException.class);
        this.expectedException.expectMessage("errors in search criteria");
        try {
            this.cutSpy.validateSearchParameters(this.fieldValues);
        }
        finally {
            Assert.assertEquals((long)2L, (long)GlobalVariables.getMessageMap().getErrorCount());
            ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("award.awardEndingDate")).get(0);
            Assert.assertEquals((Object)"error.invalidDateTime", (Object)errorMessage.getErrorKey());
            Assert.assertEquals((long)1L, (long)errorMessage.getMessageParameters().length);
            Assert.assertEquals((Object)"Award Ending Date To", (Object)errorMessage.getMessageParameters()[0]);
            errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("rangeLowerBoundKeyPrefix_award.awardEndingDate")).get(0);
            Assert.assertEquals((Object)"error.invalidDateTime", (Object)errorMessage.getErrorKey());
            Assert.assertEquals((long)1L, (long)errorMessage.getMessageParameters().length);
            Assert.assertEquals((Object)"Award Ending Date From", (Object)errorMessage.getMessageParameters()[0]);
        }
    }

    @Test
    public void getSearchResults_moreThanLimitReturned_listTruncated_PDBS() throws Exception {
        this.setupPredeterminedBillingScheduleSupport();
        Mockito.when((Object)LookupUtils.getSearchResultsLimit(null)).thenReturn((Object)2);
        List searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        List<PredeterminedBillingSchedule> expectedSearchResults = this.predeterminedBillingSchedules.subList(0, 2);
        Assert.assertEquals((long)2L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
    }

    private void setupPredeterminedBillingScheduleSupport() throws Exception {
        this.setupPredeterminedBillingSchedulesList();
        Mockito.when((Object)this.cutSpy.getBusinessObjectClass()).thenReturn(PredeterminedBillingSchedule.class);
        PowerMockito.doReturn(this.predeterminedBillingSchedules).when((Object)this.cutSpy, "getSearchResultsHelper", new Object[]{ArgumentMatchers.anyMap(), ArgumentMatchers.eq((boolean)true)});
    }

    private void setupPredeterminedBillingSchedulesList() {
        this.predeterminedBillingSchedules = new ArrayList<PredeterminedBillingSchedule>();
        this.predeterminedBillingSchedules.add(this.setupPredeterminedBillingSchedule("80078", "0211603", "55078", Date.valueOf("2017-02-05")));
        this.predeterminedBillingSchedules.add(this.setupPredeterminedBillingSchedule("80080", "0211802", "55120", Date.valueOf("2018-02-05")));
        this.predeterminedBillingSchedules.add(this.setupPredeterminedBillingSchedule("80090", "0211910", "55078", Date.valueOf("2019-12-01")));
    }

    private PredeterminedBillingSchedule setupPredeterminedBillingSchedule(String proposalNumber, String accountNumber, String agencyNumber, Date awardEndingDate) {
        PredeterminedBillingSchedule predeterminedBillingScheduleMock = (PredeterminedBillingSchedule)Mockito.mock(PredeterminedBillingSchedule.class);
        Mockito.when((Object)predeterminedBillingScheduleMock.getProposalNumber()).thenReturn((Object)proposalNumber);
        Mockito.when((Object)predeterminedBillingScheduleMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)predeterminedBillingScheduleMock.getAccountNumber()).thenReturn((Object)accountNumber);
        Award awardMock = (Award)Mockito.mock(Award.class);
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)proposalNumber);
        Mockito.when((Object)awardMock.getAgencyNumber()).thenReturn((Object)agencyNumber);
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)awardEndingDate);
        Mockito.when((Object)predeterminedBillingScheduleMock.getAward()).thenReturn((Object)awardMock);
        return predeterminedBillingScheduleMock;
    }

    @Test
    public void getSearchResults_filterOnAgency_PDBS() throws Exception {
        this.setupPredeterminedBillingScheduleSupport();
        this.fieldValues.put("agencyNumber", "55120");
        List expectedSearchResults = this.predeterminedBillingSchedules.stream().filter(predeterminedBillingSchedule -> predeterminedBillingSchedule.getAward().getAgencyNumber().equals("55120")).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
        PredeterminedBillingSchedule predeterminedBillingSchedule2 = (PredeterminedBillingSchedule)searchResults.get(0);
        Assert.assertEquals((Object)"80080", (Object)predeterminedBillingSchedule2.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)predeterminedBillingSchedule2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"0211802", (Object)predeterminedBillingSchedule2.getAccountNumber());
        Assert.assertEquals((Object)"55120", (Object)predeterminedBillingSchedule2.getAward().getAgencyNumber());
        Assert.assertEquals((Object)Date.valueOf("2018-02-05"), (Object)predeterminedBillingSchedule2.getAward().getAwardEndingDate());
    }

    @Test
    public void getSearchResults_filterOnAgencyAndAwardExpirationDateFromAndTo_PDBS() throws Exception {
        this.setupPredeterminedBillingScheduleSupport();
        this.fieldValues.put("agencyNumber", "55078");
        this.fieldValues.put("award.awardEndingDate", "01/10/2016..01/10/2019");
        List expectedSearchResults = this.predeterminedBillingSchedules.stream().filter(predeterminedBillingSchedule -> predeterminedBillingSchedule.getAward().getAgencyNumber().equals("55078")).filter(predeterminedBillingSchedule -> predeterminedBillingSchedule.getAward().getAwardEndingDate().before(Date.valueOf("2019-01-10"))).collect(Collectors.toList());
        List searchResults = this.cutSpy.getSearchResults(this.fieldValues);
        Assert.assertEquals((long)1L, (long)searchResults.size());
        Assert.assertEquals(expectedSearchResults, (Object)searchResults);
        PredeterminedBillingSchedule predeterminedBillingSchedule2 = (PredeterminedBillingSchedule)searchResults.get(0);
        Assert.assertEquals((Object)"80078", (Object)predeterminedBillingSchedule2.getProposalNumber());
        Assert.assertEquals((Object)"BL", (Object)predeterminedBillingSchedule2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"0211603", (Object)predeterminedBillingSchedule2.getAccountNumber());
        Assert.assertEquals((Object)"55078", (Object)predeterminedBillingSchedule2.getAward().getAgencyNumber());
        Assert.assertEquals((Object)Date.valueOf("2017-02-05"), (Object)predeterminedBillingSchedule2.getAward().getAwardEndingDate());
    }
}

