/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.CostCategory;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectCode;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.dataaccess.AwardAccountObjectCodeTotalBilledDao;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsInvoiceDocumentServiceImpl;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardMockFixture;
import org.kuali.kfs.module.ar.fixture.ContractsGrantsInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceAccountDetailFixture;
import org.kuali.kfs.module.ar.fixture.InvoiceGeneralDetailFixture;
import org.kuali.kfs.module.ar.service.CostCategoryService;
import org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentServiceImpl;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.util.ReflectionMap;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mockito;

@ConfigureContext(session=UserNameFixture.khuntley)
public class ContractsGrantsInvoiceDocumentTest
extends KualiTestBase {
    private ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument;
    private ContractsGrantsInvoiceDocumentServiceImpl contractsGrantsInvoiceDocumentServiceImpl;
    private ContractsGrantsInvoiceCreateDocumentServiceImpl cut;

    protected void setUp() throws Exception {
        super.setUp();
        BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.contractsGrantsInvoiceDocumentServiceImpl = new ContractsGrantsInvoiceDocumentServiceImpl();
        this.contractsGrantsInvoiceDocumentServiceImpl.setBusinessObjectService(businessObjectService);
        this.contractsGrantsInvoiceDocumentServiceImpl.setObjectCodeService((ObjectCodeService)SpringContext.getBean(ObjectCodeService.class));
        this.contractsGrantsInvoiceDocumentServiceImpl.setUniversityDateService((UniversityDateService)SpringContext.getBean(UniversityDateService.class));
        this.contractsGrantsInvoiceDocumentServiceImpl.setOptionsService((OptionsService)SpringContext.getBean(OptionsService.class));
        this.cut = new ContractsGrantsInvoiceCreateDocumentServiceImpl();
        this.cut.setAccountingPeriodService((AccountingPeriodService)SpringContext.getBean(AccountingPeriodService.class));
        this.cut.setAwardAccountObjectCodeTotalBilledDao((AwardAccountObjectCodeTotalBilledDao)SpringContext.getBean(AwardAccountObjectCodeTotalBilledDao.class));
        this.cut.setBusinessObjectService(businessObjectService);
        this.cut.setDateTimeService((DateTimeService)SpringContext.getBean(DateTimeService.class));
        this.cut.setUniversityDateService((UniversityDateService)SpringContext.getBean(UniversityDateService.class));
        this.cut.setContractsGrantsInvoiceDocumentService((ContractsGrantsInvoiceDocumentService)this.contractsGrantsInvoiceDocumentServiceImpl);
        this.cut.setCostCategoryService((CostCategoryService)SpringContext.getBean(CostCategoryService.class));
        this.cut.setOptionsService((OptionsService)SpringContext.getBean(OptionsService.class));
        CostCategory category = new CostCategory();
        category.setCategoryCode("testCode");
        category.setCategoryName("testName");
        CostCategoryObjectCode costCategoryObjectCode = new CostCategoryObjectCode();
        costCategoryObjectCode.setCategoryCode("testCode");
        costCategoryObjectCode.setChartOfAccountsCode("BL");
        costCategoryObjectCode.setFinancialObjectCode("5000");
        category.setObjectCodes(new ArrayList());
        category.getObjectCodes().add(costCategoryObjectCode);
        this.contractsGrantsInvoiceDocument = new ContractsGrantsInvoiceDocument();
    }

    public void testInvoiceDetails() {
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD1.createAwardMock();
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(awardMock);
        invoiceGeneralDetail.setProposalNumber(awardMock.getProposalNumber());
        this.contractsGrantsInvoiceDocument.setInvoiceGeneralDetail(invoiceGeneralDetail);
        ContractsGrantsInvoiceDetail invoiceDetail_1 = ContractsGrantsInvoiceDetailFixture.INV_DTL4.createInvoiceDetail();
        ContractsGrantsInvoiceDetail invoiceDetail_2 = ContractsGrantsInvoiceDetailFixture.INV_DTL5.createInvoiceDetail();
        ContractsGrantsInvoiceDetail invoiceDetail_3 = ContractsGrantsInvoiceDetailFixture.INV_DTL6.createInvoiceDetail();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        invoiceDetails.add(invoiceDetail_1);
        invoiceDetails.add(invoiceDetail_2);
        invoiceDetails.add(invoiceDetail_3);
        this.contractsGrantsInvoiceDocument.setInvoiceDetails(invoiceDetails);
        List generatedInvoiceDetails = this.cut.generateValuesForCategories(this.contractsGrantsInvoiceDocument.getDocumentNumber(), this.contractsGrantsInvoiceDocument.getInvoiceDetailAccountObjectCodes(), new HashMap(), new ArrayList());
        this.contractsGrantsInvoiceDocument.getInvoiceDetails().addAll(generatedInvoiceDetails);
        List allInvoiceDetails = this.contractsGrantsInvoiceDocument.getInvoiceDetails();
        List invoiceDetailsWithoutIdc = this.contractsGrantsInvoiceDocument.getDirectCostInvoiceDetails();
        List invoiceDetailsIdcOnly = this.contractsGrantsInvoiceDocument.getIndirectCostInvoiceDetails();
        List invoiceDetailsWithIdc = this.contractsGrantsInvoiceDocument.getInvoiceDetails();
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)12, (int)allInvoiceDetails.size());
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)11, (int)invoiceDetailsWithoutIdc.size());
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)1, (int)invoiceDetailsIdcOnly.size());
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)12, (int)invoiceDetailsWithIdc.size());
        ContractsGrantsInvoiceDetail totalCostInvoiceDetail = this.contractsGrantsInvoiceDocument.getTotalCostInvoiceDetail();
        ContractsGrantsInvoiceDetail totalDirectCostInvoiceDetail = this.contractsGrantsInvoiceDocument.getTotalDirectCostInvoiceDetail();
        ContractsGrantsInvoiceDetail totalInDirectCostInvoiceDetail = this.contractsGrantsInvoiceDocument.getTotalIndirectCostInvoiceDetail();
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)totalCostInvoiceDetail);
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(960.0), (Object)totalCostInvoiceDetail.getTotalBudget());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(1020.0), (Object)totalCostInvoiceDetail.getCumulativeExpenditures());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(-60.0), (Object)totalCostInvoiceDetail.getBudgetRemaining());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(0.0), (Object)totalCostInvoiceDetail.getTotalPreviouslyBilled());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(0.0), (Object)totalCostInvoiceDetail.getTotalAmountBilledToDate());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(960.0), (Object)totalCostInvoiceDetail.getAmountRemainingToBill());
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)totalDirectCostInvoiceDetail);
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(640.0), (Object)totalDirectCostInvoiceDetail.getTotalBudget());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(680.0), (Object)totalDirectCostInvoiceDetail.getCumulativeExpenditures());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(-40.0), (Object)totalDirectCostInvoiceDetail.getBudgetRemaining());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(0.0), (Object)totalDirectCostInvoiceDetail.getTotalPreviouslyBilled());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(0.0), (Object)totalDirectCostInvoiceDetail.getTotalAmountBilledToDate());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(640.0), (Object)totalDirectCostInvoiceDetail.getAmountRemainingToBill());
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)totalInDirectCostInvoiceDetail);
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(320.0), (Object)totalInDirectCostInvoiceDetail.getTotalBudget());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(340.0), (Object)totalInDirectCostInvoiceDetail.getCumulativeExpenditures());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(-20.0), (Object)totalInDirectCostInvoiceDetail.getBudgetRemaining());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(0.0), (Object)totalInDirectCostInvoiceDetail.getTotalPreviouslyBilled());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(0.0), (Object)totalInDirectCostInvoiceDetail.getTotalAmountBilledToDate());
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)new KualiDecimal(320.0), (Object)totalInDirectCostInvoiceDetail.getAmountRemainingToBill());
    }

    public void testCheckAwardContractControlAccounts_ValidNoInvoicingOption() {
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD1.createAwardMock();
        List errorString = this.contractsGrantsInvoiceDocumentServiceImpl.checkAwardContractControlAccounts(awardMock);
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)errorString);
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)0, (int)errorString.size());
    }

    public void testCheckAwardContractControlAccounts_ValidInvoicingByAccount() {
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD_INV_ACCOUNT.createAwardMock();
        List errorString = this.contractsGrantsInvoiceDocumentServiceImpl.checkAwardContractControlAccounts(awardMock);
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)errorString);
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)0, (int)errorString.size());
    }

    public void testCheckAwardContractControlAccounts_ValidInvoicingByContractControlAccount() {
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD_INV_CCA.createAwardMock();
        ContractsAndGrantsBillingAwardAccount awardAccountMock1 = ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1.createAwardAccountMock();
        ContractsAndGrantsBillingAwardAccount awardAccountMock2 = ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_2.createAwardAccountMock();
        Account account1Mock = (Account)Mockito.mock(Account.class);
        Account account2Mock = (Account)Mockito.mock(Account.class);
        Account ccaMock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)account1Mock.getContractControlAccount()).thenReturn((Object)ccaMock);
        Mockito.when((Object)account2Mock.getContractControlAccount()).thenReturn((Object)ccaMock);
        Mockito.when((Object)awardAccountMock1.getAccount()).thenReturn((Object)account1Mock);
        Mockito.when((Object)awardAccountMock2.getAccount()).thenReturn((Object)account2Mock);
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock1);
        awardAccountMocks.add(awardAccountMock2);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        List errorString = this.contractsGrantsInvoiceDocumentServiceImpl.checkAwardContractControlAccounts(awardMock);
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)errorString);
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)0, (int)errorString.size());
    }

    public void testCheckAwardContractControlAccounts_InvalidInvoicingByContractControlAccountNoCCA() {
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD_INV_CCA.createAwardMock();
        List errorString = this.contractsGrantsInvoiceDocumentServiceImpl.checkAwardContractControlAccounts(awardMock);
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)errorString);
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)2, (int)errorString.size());
        ContractsGrantsInvoiceDocumentTest.assertTrue((boolean)errorString.contains("error.cg.no.control.account"));
        ContractsGrantsInvoiceDocumentTest.assertTrue((boolean)errorString.contains(awardMock.getInvoicingOptionDescription()));
    }

    public void testCheckAwardContractControlAccounts_ValidInvoicingByAward() {
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD_INV_AWARD.createAwardMock();
        ContractsAndGrantsBillingAwardAccount awardAccountMock1 = ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1.createAwardAccountMock();
        ContractsAndGrantsBillingAwardAccount awardAccountMock2 = ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_2.createAwardAccountMock();
        Account account1Mock = (Account)Mockito.mock(Account.class);
        Account account2Mock = (Account)Mockito.mock(Account.class);
        Account ccaMock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)account1Mock.getContractControlAccount()).thenReturn((Object)ccaMock);
        Mockito.when((Object)account2Mock.getContractControlAccount()).thenReturn((Object)ccaMock);
        Mockito.when((Object)awardAccountMock1.getAccount()).thenReturn((Object)account1Mock);
        Mockito.when((Object)awardAccountMock2.getAccount()).thenReturn((Object)account2Mock);
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock1);
        awardAccountMocks.add(awardAccountMock2);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        List errorString = this.contractsGrantsInvoiceDocumentServiceImpl.checkAwardContractControlAccounts(awardMock);
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)errorString);
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)0, (int)errorString.size());
    }

    public void testCheckAwardContractControlAccounts_InvalidInvoicingByAwardNoCCA() {
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD_INV_AWARD.createAwardMock();
        List errorString = this.contractsGrantsInvoiceDocumentServiceImpl.checkAwardContractControlAccounts(awardMock);
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)errorString);
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)2, (int)errorString.size());
        ContractsGrantsInvoiceDocumentTest.assertTrue((boolean)errorString.contains("error.cg.no.control.account"));
        ContractsGrantsInvoiceDocumentTest.assertTrue((boolean)errorString.contains(awardMock.getInvoicingOptionDescription()));
    }

    public void testCheckAwardContractControlAccounts_InvalidInvoicingByAwardMultipleCCAs() {
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD_INV_AWARD.createAwardMock();
        ContractsAndGrantsBillingAwardAccount awardAccountMock1 = ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1.createAwardAccountMock();
        ContractsAndGrantsBillingAwardAccount awardAccountMock2 = ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_3.createAwardAccountMock();
        Account account1Mock = (Account)Mockito.mock(Account.class);
        Account account2Mock = (Account)Mockito.mock(Account.class);
        Account cca1Mock = (Account)Mockito.mock(Account.class);
        Account cca2Mock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)account1Mock.getContractControlAccount()).thenReturn((Object)cca1Mock);
        Mockito.when((Object)account2Mock.getContractControlAccount()).thenReturn((Object)cca2Mock);
        Mockito.when((Object)awardAccountMock1.getAccount()).thenReturn((Object)account1Mock);
        Mockito.when((Object)awardAccountMock2.getAccount()).thenReturn((Object)account2Mock);
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock1);
        awardAccountMocks.add(awardAccountMock2);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        List errorString = this.contractsGrantsInvoiceDocumentServiceImpl.checkAwardContractControlAccounts(awardMock);
        ContractsGrantsInvoiceDocumentTest.assertNotNull((Object)errorString);
        ContractsGrantsInvoiceDocumentTest.assertEquals((int)2, (int)errorString.size());
        ContractsGrantsInvoiceDocumentTest.assertTrue((boolean)errorString.contains("error.cg.multiple.control.account"));
        ContractsGrantsInvoiceDocumentTest.assertTrue((boolean)errorString.contains(awardMock.getInvoicingOptionDescription()));
    }

    public void testBeanMapVersionOfDocument() {
        ContractsGrantsInvoiceDocument cinvDoc = new ContractsGrantsInvoiceDocument();
        InvoiceGeneralDetail invoiceGeneralDetail = InvoiceGeneralDetailFixture.INV_GNRL_DTL1.createInvoiceGeneralDetail();
        invoiceGeneralDetail.setProposalNumber("80075");
        cinvDoc.setInvoiceGeneralDetail(invoiceGeneralDetail);
        InvoiceAccountDetail invoiceAccountDetail = InvoiceAccountDetailFixture.INV_ACCT_DTL1.createInvoiceAccountDetail();
        ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
        accountDetails.add(invoiceAccountDetail);
        cinvDoc.setAccountDetails(accountDetails);
        ReflectionMap map = new ReflectionMap((Object)cinvDoc);
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)"80075", map.get("invoiceGeneralDetail.proposalNumber"));
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)"MILE", map.get("invoiceGeneralDetail.billingFrequencyCode"));
        ContractsGrantsInvoiceDocumentTest.assertEquals((Object)"9000000", map.get("accountDetails[0].accountNumber"));
        ContractsGrantsInvoiceDocumentTest.assertNull(map.get("zebra"));
        ContractsGrantsInvoiceDocumentTest.assertNull(map.get("invoiceGeneralDetail.zebra"));
        ContractsGrantsInvoiceDocumentTest.assertNull(map.get("accountDetails[2].accountNumber"));
    }
}

