/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.document.validation.impl.AccountingDocumentRuleBaseConstants;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerInvoiceDocumentGeneralLedgerPostingTest
extends KualiTestBase {
    public void testGenerateGeneralLedgerPendingEntries_ReceivableChart() throws WorkflowException {
        CustomerInvoiceDocument doc = this.getCustomerInvoiceDocumentWithGLPEs(CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER, CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_CHART_RECEIVABLE);
        CustomerInvoiceDetail testCustomerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_CHART_RECEIVABLE.createCustomerInvoiceDetail();
        testCustomerInvoiceDetail.refreshReferenceObject("chart");
        String receivableChartOfAccountsCode = testCustomerInvoiceDetail.getChartOfAccountsCode();
        String receivableAccountNumber = testCustomerInvoiceDetail.getAccountNumber();
        String receivableSubAccountNumber = testCustomerInvoiceDetail.getSubAccountNumber();
        String receivableFinancialObjectCode = testCustomerInvoiceDetail.getChart().getFinAccountsReceivableObjCode();
        String receivableFinancialSubObjectCode = AccountingDocumentRuleBaseConstants.GENERAL_LEDGER_PENDING_ENTRY_CODE.getBlankFinancialSubObjectCode();
        String receivableProjectCode = testCustomerInvoiceDetail.getProjectCode();
        String receivableOrgRefId = testCustomerInvoiceDetail.getOrganizationReferenceId();
        this.checkReceivableGeneralLedgerPendingEntries(doc, receivableChartOfAccountsCode, receivableAccountNumber, receivableSubAccountNumber, receivableFinancialObjectCode, receivableFinancialSubObjectCode, receivableProjectCode, receivableOrgRefId);
    }

    public CustomerInvoiceDocument getCustomerInvoiceDocumentWithGLPEs(CustomerInvoiceDocumentFixture customerInvoiceDocumentFixture, CustomerInvoiceDetailFixture customerInvoiceDetailFixture) throws WorkflowException {
        CustomerInvoiceDetailFixture[] customerInvoiceDetailFixtures = new CustomerInvoiceDetailFixture[]{customerInvoiceDetailFixture};
        CustomerInvoiceDocument doc = customerInvoiceDocumentFixture.createCustomerInvoiceDocument(customerInvoiceDetailFixtures);
        ((GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class)).generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)doc);
        return doc;
    }

    public void checkBasicGeneralLedgerPendingEntries(CustomerInvoiceDocument doc, CustomerInvoiceDetail testCustomerInvoiceDetail) {
        GeneralLedgerPendingEntry income = (GeneralLedgerPendingEntry)doc.getGeneralLedgerPendingEntries().get(1);
        CustomerInvoiceDocumentGeneralLedgerPostingTest.assertEquals((String)("Income Chart of Accounts Code should be " + testCustomerInvoiceDetail.getChartOfAccountsCode() + " but is actually " + income.getChartOfAccountsCode()), (String)testCustomerInvoiceDetail.getChartOfAccountsCode(), (String)income.getChartOfAccountsCode());
        CustomerInvoiceDocumentGeneralLedgerPostingTest.assertEquals((String)("Income Account Number should be " + testCustomerInvoiceDetail.getAccountNumber() + " but is actually " + income.getAccountNumber()), (String)testCustomerInvoiceDetail.getAccountNumber(), (String)income.getAccountNumber());
        CustomerInvoiceDocumentGeneralLedgerPostingTest.assertEquals((String)("Income Sub Account Number should be " + testCustomerInvoiceDetail.getSubAccountNumber() + " but is actually " + income.getSubAccountNumber()), (String)testCustomerInvoiceDetail.getSubAccountNumber(), (String)income.getSubAccountNumber());
        CustomerInvoiceDocumentGeneralLedgerPostingTest.assertEquals((String)("Income Financial Object Code should be " + testCustomerInvoiceDetail.getFinancialObjectCode() + " but is actually " + income.getFinancialObjectCode()), (String)testCustomerInvoiceDetail.getFinancialObjectCode(), (String)income.getFinancialObjectCode());
        CustomerInvoiceDocumentGeneralLedgerPostingTest.assertEquals((String)("Income Financial Sub Object Code should be " + testCustomerInvoiceDetail.getFinancialSubObjectCode() + " but is actually " + income.getFinancialSubObjectCode()), (String)testCustomerInvoiceDetail.getFinancialSubObjectCode(), (String)income.getFinancialSubObjectCode());
        CustomerInvoiceDocumentGeneralLedgerPostingTest.assertEquals((String)("Income Project Code should be " + testCustomerInvoiceDetail.getProjectCode() + " but is actually " + income.getProjectCode()), (String)testCustomerInvoiceDetail.getProjectCode(), (String)income.getProjectCode());
        CustomerInvoiceDocumentGeneralLedgerPostingTest.assertEquals((String)("Income Org Ref Id should be " + testCustomerInvoiceDetail.getOrganizationReferenceId() + " but is actually " + income.getOrganizationReferenceId()), (String)testCustomerInvoiceDetail.getOrganizationReferenceId(), (String)income.getOrganizationReferenceId());
    }

    public void checkReceivableGeneralLedgerPendingEntries(CustomerInvoiceDocument doc, String expectedReceivableChartOfAccountsCode, String expectedReceivableAccountNumber, String expectedReceivableSubAccountNumber, String expectedReceivableFinancialObjectCode, String expectedReceivableFinancialSubObjectCode, String expectedReceivableProjectCode, String expectedReceivableOrgRefId) {
        GeneralLedgerPendingEntry receivable = (GeneralLedgerPendingEntry)doc.getGeneralLedgerPendingEntries().get(0);
        CustomerInvoiceDocumentGeneralLedgerPostingTest.assertEquals((String)("Receivable Chart of Accounts Code should be " + expectedReceivableChartOfAccountsCode + " but is actually " + receivable.getChartOfAccountsCode()), (String)expectedReceivableChartOfAccountsCode, (String)receivable.getChartOfAccountsCode());
        CustomerInvoiceDocumentGeneralLedgerPostingTest.assertEquals((String)("Receivable Account Number should be " + expectedReceivableChartOfAccountsCode + " but is actually " + receivable.getAccountNumber()), (String)expectedReceivableAccountNumber, (String)receivable.getAccountNumber());
        CustomerInvoiceDocumentGeneralLedgerPostingTest.assertEquals((String)("Receivable Financial Object Code should be " + expectedReceivableFinancialObjectCode + " but is actually " + receivable.getFinancialObjectCode()), (String)expectedReceivableFinancialObjectCode, (String)receivable.getFinancialObjectCode());
        CustomerInvoiceDocumentGeneralLedgerPostingTest.assertEquals((String)("Receivable Sub Account Number should be " + expectedReceivableSubAccountNumber + " but is actually " + receivable.getSubAccountNumber()), (String)expectedReceivableSubAccountNumber, (String)receivable.getSubAccountNumber());
        CustomerInvoiceDocumentGeneralLedgerPostingTest.assertEquals((String)("Receivable Financial Sub Object Code should be " + expectedReceivableFinancialSubObjectCode + " but is actually " + receivable.getFinancialSubObjectCode()), (String)expectedReceivableFinancialSubObjectCode, (String)receivable.getFinancialSubObjectCode());
        CustomerInvoiceDocumentGeneralLedgerPostingTest.assertEquals((String)("Receivable Org Ref Id should be " + expectedReceivableOrgRefId + " but is actually " + receivable.getOrganizationReferenceId()), (String)expectedReceivableOrgRefId, (String)receivable.getOrganizationReferenceId());
    }
}

