/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.ar.businessobject.FinalBilledIndicatorEntry;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.FinalBilledIndicatorDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.fixture.ARAwardMockFixture;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={KRADServiceLocatorWeb.class})
public class FinalBilledIndicatorDocumentTest {
    @Mock
    private ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock;
    @Mock
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentSvcMock;
    @Mock
    private DocumentService documentSvcMock;
    private FinalBilledIndicatorDocument cut;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(KRADServiceLocatorWeb.class, (Class[])new Class[0]);
        DocumentHeaderService docHeaderSvcMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
        Mockito.when((Object)KRADServiceLocatorWeb.getDocumentHeaderService()).thenReturn((Object)docHeaderSvcMock);
        Class<FinancialSystemDocumentHeader> clazz = FinancialSystemDocumentHeader.class;
        Mockito.when((Object)docHeaderSvcMock.getDocumentHeaderBaseClass()).thenReturn(clazz);
        this.cut = new FinalBilledIndicatorDocument();
        this.cut.setDocumentService(this.documentSvcMock);
        this.cut.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentSvcMock);
    }

    @Test
    public void updateContractsGrantsInvoiceDocument() throws WorkflowException {
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD_INV_ACCOUNT.createAwardMock();
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(awardMock);
        invoiceGeneralDetail.setFinalBillIndicator(true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        FinalBilledIndicatorEntry entry = new FinalBilledIndicatorEntry();
        entry.setInvoiceDocumentNumber(this.contractsGrantsInvoiceDocumentMock.getDocumentNumber());
        ArrayList<FinalBilledIndicatorEntry> invoiceEntries = new ArrayList<FinalBilledIndicatorEntry>();
        invoiceEntries.add(entry);
        this.cut.setInvoiceEntries(invoiceEntries);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId(entry.getInvoiceDocumentNumber())).thenReturn((Object)this.contractsGrantsInvoiceDocumentMock);
        this.cut.updateContractsGrantsInvoiceDocument();
        Assert.assertFalse((boolean)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().isFinalBillIndicator());
        ((ContractsGrantsInvoiceDocumentService)Mockito.verify((Object)this.contractsGrantsInvoiceDocumentSvcMock)).updateUnfinalizationToAwardAccount(this.contractsGrantsInvoiceDocumentMock.getAccountDetails(), this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getProposalNumber());
    }
}

