/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.NonAppliedHolding;
import org.kuali.kfs.module.ar.businessobject.NonInvoiced;
import org.kuali.kfs.module.ar.document.CashControlDetailSpec;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.service.CashControlDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentTestUtil;
import org.kuali.kfs.module.ar.document.service.PaymentApplicationDocumentService;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.DocumentTestUtils;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.khuntley)
public class PaymentApplicationDocumentTest
extends KualiTestBase {
    private static final String TESTING = "PaymentApplicationDocument testing";
    protected DocumentService documentService;
    protected BusinessObjectService businessObjectService;
    protected CashControlDocumentService cashControlDocumentService;
    protected PaymentApplicationDocumentService paymentApplicationDocumentService;
    protected DateTimeService dateTimeService;
    protected UniversityDateService universityDateService;

    protected void setUp() throws Exception {
        super.setUp();
        this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.cashControlDocumentService = (CashControlDocumentService)SpringContext.getBean(CashControlDocumentService.class);
        this.paymentApplicationDocumentService = (PaymentApplicationDocumentService)SpringContext.getBean(PaymentApplicationDocumentService.class);
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        this.universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
    }

    public void testCreatedUponApprovingCashControlDocument() throws Exception {
        ArrayList<CashControlDetailSpec> specs = new ArrayList<CashControlDetailSpec>();
        specs.add(new CashControlDetailSpec("ABB2", "9999", new Date(System.currentTimeMillis()), new KualiDecimal(1000)));
        CashControlDocument cashControlDocument = this.createAndSaveNewCashControlDocument(specs);
        for (CashControlDetail detail : cashControlDocument.getCashControlDetails()) {
            PaymentApplicationDocumentTest.assertNotNull((String)("Reference financial document should not have been null on line: " + detail), (Object)detail.getReferenceFinancialDocument());
        }
    }

    public void testExactlyApplyingSucceeds() throws Exception {
        CustomerInvoiceDetailFixture[] invoiceDetailFixtures = new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.ONE_DOLLAR_INVOICE_DETAIL};
        CashControlDetailSpec[] cashControlDetailSpecs = new CashControlDetailSpec[]{CashControlDetailSpec.specFor(new KualiDecimal(1))};
        KualiDecimal[] amountsToApply = new KualiDecimal[]{new KualiDecimal(1)};
        PaymentApplicationDocumentTest.assertTrue((boolean)this.applyFundsToPaymentApplication(invoiceDetailFixtures, cashControlDetailSpecs, amountsToApply, null, null));
    }

    public void testUnderApplyingFailsWithoutUnapplied() throws Exception {
        CustomerInvoiceDetailFixture[] invoiceDetailFixtures = new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.TEN_DOLLAR_INVOICE_DETAIL};
        CashControlDetailSpec[] cashControlDetailSpecs = new CashControlDetailSpec[]{CashControlDetailSpec.specFor(new KualiDecimal(10))};
        KualiDecimal[] amountsToApply = new KualiDecimal[]{new KualiDecimal(1)};
        PaymentApplicationDocumentTest.assertTrue((boolean)this.applyFundsToPaymentApplication(invoiceDetailFixtures, cashControlDetailSpecs, amountsToApply, null, null));
        PaymentApplicationDocumentTest.assertFalse((boolean)this.applyFundsToPaymentApplication(invoiceDetailFixtures, cashControlDetailSpecs, amountsToApply, null, null, true, false));
    }

    public void testUnderApplyingSucceedsWithUnapplied() throws Exception {
        CustomerInvoiceDetailFixture[] invoiceDetailFixtures = new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.TEN_DOLLAR_INVOICE_DETAIL};
        CashControlDetailSpec[] cashControlDetailSpecs = new CashControlDetailSpec[]{CashControlDetailSpec.specFor(new KualiDecimal(10))};
        KualiDecimal[] amountsToApply = new KualiDecimal[]{new KualiDecimal(1)};
        PaymentApplicationDocumentTest.assertTrue((boolean)this.applyFundsToPaymentApplication(invoiceDetailFixtures, cashControlDetailSpecs, amountsToApply, null, null));
    }

    public void testOverApplyingFails() throws Exception {
        CustomerInvoiceDetailFixture[] invoiceDetailFixtures = new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.ONE_DOLLAR_INVOICE_DETAIL};
        CashControlDetailSpec[] cashControlDetailSpecs = new CashControlDetailSpec[]{CashControlDetailSpec.specFor(new KualiDecimal(2))};
        KualiDecimal[] amountsToApply = new KualiDecimal[]{new KualiDecimal(2)};
        PaymentApplicationDocumentTest.assertFalse((boolean)this.applyFundsToPaymentApplication(invoiceDetailFixtures, cashControlDetailSpecs, amountsToApply, null, null));
    }

    public void testAddingNonInvoicedLinesSucceedsWhenBalanced() throws Exception {
        CustomerInvoiceDetailFixture[] invoiceDetailFixtures = new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.TEN_DOLLAR_INVOICE_DETAIL};
        CashControlDetailSpec[] cashControlDetailSpecs = new CashControlDetailSpec[]{CashControlDetailSpec.specFor(new KualiDecimal(2))};
        NonInvoiced[] nonInvoiceds = new NonInvoiced[]{this.buildNonInvoiced("BL", "0212002", "0795", new KualiDecimal(2))};
        PaymentApplicationDocumentTest.assertTrue((boolean)this.applyFundsToPaymentApplication(invoiceDetailFixtures, cashControlDetailSpecs, null, null, nonInvoiceds));
    }

    protected void changeCurrentUser(UserNameFixture sessionUser) {
        GlobalVariables.setUserSession((UserSession)new UserSession(sessionUser.toString()));
    }

    protected CashControlDocument createAndSaveNewCashControlDocument(CashControlDetailSpec[] specs) throws WorkflowException {
        ArrayList<CashControlDetailSpec> _specs = new ArrayList<CashControlDetailSpec>();
        _specs.addAll(Arrays.asList(specs));
        return this.createAndSaveNewCashControlDocument(_specs);
    }

    protected CashControlDocument createAndSaveNewCashControlDocument(List<CashControlDetailSpec> specs) throws WorkflowException {
        CashControlDocument cashControlDocument = this.createNewCashControlDocument(specs);
        this.documentService.saveDocument((Document)cashControlDocument);
        return cashControlDocument;
    }

    protected CashControlDocument createNewCashControlDocument(List<CashControlDetailSpec> specs) throws WorkflowException {
        CashControlDocument cashControlDocument = (CashControlDocument)DocumentTestUtils.createDocument((DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)), CashControlDocument.class);
        cashControlDocument.getDocumentHeader().setDocumentDescription(TESTING);
        cashControlDocument.setUniversityFiscalYear(this.universityDateService.getCurrentFiscalYear());
        cashControlDocument.setCustomerPaymentMediumCode("CK");
        AccountsReceivableDocumentHeader arDocumentHeader = cashControlDocument.getAccountsReceivableDocumentHeader();
        arDocumentHeader.setDocumentNumber(cashControlDocument.getDocumentNumber());
        UserSession userSession = GlobalVariables.getUserSession();
        ChartOrgHolder organization = ((FinancialSystemUserService)SpringContext.getBean(FinancialSystemUserService.class)).getPrimaryOrganization(userSession.getPerson(), "KFS-AR");
        arDocumentHeader.setProcessingChartOfAccountCode(organization.getChartOfAccountsCode());
        arDocumentHeader.setProcessingOrganizationCode(organization.getOrganizationCode());
        try {
            this.documentService.saveDocument((Document)cashControlDocument);
        }
        catch (Exception t) {
            PaymentApplicationDocumentTest.fail((String)("Document save failed: " + t.getClass().getName() + " : " + t.getMessage() + "\n" + TestUtils.dumpMessageMapErrors() + "\n" + cashControlDocument));
        }
        for (CashControlDetailSpec spec : specs) {
            CashControlDetail cashControlDetail = this.buildCashControlDetail(cashControlDocument, spec);
            this.cashControlDocumentService.addNewCashControlDetail(TESTING, cashControlDocument, cashControlDetail);
            PaymentApplicationDocument paymentApplicationDocument = this.cashControlDocumentService.createAndSavePaymentApplicationDocument(TESTING, cashControlDocument, cashControlDetail);
            cashControlDetail.setReferenceFinancialDocumentNumber(paymentApplicationDocument.getDocumentNumber());
        }
        return cashControlDocument;
    }

    protected CashControlDetail buildCashControlDetail(CashControlDocument cashControlDocument, CashControlDetailSpec spec) {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setCashControlDocument(cashControlDocument);
        cashControlDetail.setDocumentNumber(cashControlDocument.getDocumentNumber());
        cashControlDetail.setCustomerNumber(spec.customerNumber);
        cashControlDetail.setCustomerPaymentMediumIdentifier(spec.customerPaymentMediumIdentifier);
        cashControlDetail.setCustomerPaymentDate(spec.customerPaymentDate);
        cashControlDetail.setFinancialDocumentLineAmount(spec.financialDocumentLineAmount);
        return cashControlDetail;
    }

    public InvoiceAndCashControlDocumentPair createCashControlDocument(CustomerInvoiceDetailFixture[] invoiceDetailFixtures, CashControlDetailSpec[] cashControlDetailSpecs) throws WorkflowException {
        CustomerInvoiceDocument invoice = CustomerInvoiceDocumentTestUtil.submitNewCustomerInvoiceDocumentAndReturnIt(CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER, invoiceDetailFixtures);
        CashControlDocument cashControlDocument = this.createAndSaveNewCashControlDocument(cashControlDetailSpecs);
        return new InvoiceAndCashControlDocumentPair(invoice, cashControlDocument);
    }

    public boolean applyFundsToPaymentApplication(CustomerInvoiceDetailFixture[] invoiceDetailFixtures, CashControlDetailSpec[] cashControlDetailSpecs, KualiDecimal[] amountsToApply, KualiDecimal[] unappliedAmounts, NonInvoiced[] nonInvoiceds) throws Exception {
        return this.applyFundsToPaymentApplication(invoiceDetailFixtures, cashControlDetailSpecs, amountsToApply, unappliedAmounts, nonInvoiceds, false, false);
    }

    public boolean applyFundsToPaymentApplication(CustomerInvoiceDetailFixture[] invoiceDetailFixtures, CashControlDetailSpec[] cashControlDetailSpecs, KualiDecimal[] amountsToApply, KualiDecimal[] unappliedAmounts, NonInvoiced[] nonInvoiceds, boolean routeDocument, boolean approveDocument) throws Exception {
        if (null != amountsToApply && cashControlDetailSpecs.length != amountsToApply.length) {
            throw new Exception("The number of cash control detail specs must equal the number of amounts to apply.");
        }
        if (null != unappliedAmounts && cashControlDetailSpecs.length != unappliedAmounts.length) {
            throw new Exception("The number of cash control detail specs must equal the number of unapplied amounts.");
        }
        if (null != nonInvoiceds && cashControlDetailSpecs.length != nonInvoiceds.length) {
            throw new Exception("The number of cash control detail specs must equal the number of non-invoiced lines.");
        }
        InvoiceAndCashControlDocumentPair pair = this.createCashControlDocument(invoiceDetailFixtures, cashControlDetailSpecs);
        CashControlDocument cashControlDocument = pair.cashControlDocument;
        CustomerInvoiceDocument invoice = pair.invoiceDocument;
        PaymentApplicationDocumentTest.assertNotNull((String)"invoiceDocument of the InvoiceAndCashControlDocumentPair must not be null", (Object)invoice);
        List cashControlDetails = cashControlDocument.getCashControlDetails();
        List customerInvoiceDetails = invoice.getSourceAccountingLines();
        CustomerInvoiceDetail sampleInvoiceDetail = (CustomerInvoiceDetail)customerInvoiceDetails.iterator().next();
        int counter = 0;
        boolean aggregateOperationSucceeds = true;
        for (CashControlDetail cashControlDetail : cashControlDetails) {
            PaymentApplicationDocument paymentApplicationDocument = cashControlDetail.getReferenceFinancialDocument();
            if (null != amountsToApply && counter < amountsToApply.length && null != amountsToApply[counter]) {
                InvoicePaidApplied invoicePaidApplied = new InvoicePaidApplied();
                invoicePaidApplied.setDocumentNumber(paymentApplicationDocument.getDocumentNumber());
                invoicePaidApplied.setFinancialDocumentReferenceInvoiceNumber(invoice.getDocumentNumber());
                invoicePaidApplied.setInvoiceItemNumber(sampleInvoiceDetail.getInvoiceItemNumber());
                invoicePaidApplied.setInvoiceItemAppliedAmount(amountsToApply[counter]);
                invoicePaidApplied.setUniversityFiscalYear(this.universityDateService.getCurrentFiscalYear());
                invoicePaidApplied.setUniversityFiscalPeriodCode(this.universityDateService.getCurrentUniversityDate().getUniversityFiscalAccountingPeriod());
                invoicePaidApplied.setPaidAppliedItemNumber(Integer.valueOf(cashControlDetailSpecs.length));
                if (invoicePaidApplied != null) {
                    paymentApplicationDocument.getInvoicePaidApplieds().add(invoicePaidApplied);
                }
            }
            if (null != unappliedAmounts && counter < unappliedAmounts.length && null != unappliedAmounts[counter]) {
                NonAppliedHolding nonAppliedHolding = new NonAppliedHolding();
                nonAppliedHolding.setFinancialDocumentLineAmount(unappliedAmounts[counter]);
                nonAppliedHolding.setReferenceFinancialDocumentNumber(paymentApplicationDocument.getDocumentNumber());
                paymentApplicationDocument.setNonAppliedHolding(nonAppliedHolding);
            }
            int nonInvoicedLineCounter = 1;
            if (null != nonInvoiceds && counter < nonInvoiceds.length && null != nonInvoiceds[counter]) {
                NonInvoiced nonInvoiced = nonInvoiceds[counter];
                nonInvoiced.setFinancialDocumentPostingYear(paymentApplicationDocument.getPostingYear());
                nonInvoiced.setDocumentNumber(paymentApplicationDocument.getDocumentNumber());
                nonInvoiced.setFinancialDocumentLineNumber(Integer.valueOf(nonInvoicedLineCounter++));
                paymentApplicationDocument.getNonInvoiceds().add(nonInvoiced);
            }
            try {
                this.documentService.saveDocument((Document)paymentApplicationDocument);
            }
            catch (ValidationException validationException) {
                aggregateOperationSucceeds = false;
            }
            if (routeDocument) {
                try {
                    this.documentService.routeDocument((Document)paymentApplicationDocument, "Unit tests", new ArrayList());
                }
                catch (ValidationException validationException) {
                    aggregateOperationSucceeds = false;
                }
            }
            if (!approveDocument) continue;
            try {
                this.documentService.approveDocument((Document)paymentApplicationDocument, "Unit tests", new ArrayList());
            }
            catch (ValidationException validationException) {
                aggregateOperationSucceeds = false;
            }
        }
        return aggregateOperationSucceeds;
    }

    protected NonInvoiced buildNonInvoiced(String chartOfAccountsCode, String accountNumber, String financialObjectCode, KualiDecimal financialDocumentLineAmount) {
        NonInvoiced nonInvoiced = new NonInvoiced();
        nonInvoiced.setChartOfAccountsCode(chartOfAccountsCode);
        nonInvoiced.setAccountNumber(accountNumber);
        nonInvoiced.setFinancialObjectCode(financialObjectCode);
        nonInvoiced.setFinancialDocumentLineAmount(financialDocumentLineAmount);
        return nonInvoiced;
    }

    protected class InvoiceAndCashControlDocumentPair {
        CashControlDocument cashControlDocument;
        CustomerInvoiceDocument invoiceDocument;

        InvoiceAndCashControlDocumentPair(CustomerInvoiceDocument invoice, CashControlDocument cashControl) {
            this.invoiceDocument = invoice;
            this.cashControlDocument = cashControl;
        }
    }
}

