/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.authorization.CashControlDocumentPresentationController;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class CashControlDocumentPresentationControllerTest {
    private CashControlDocumentPresentationController cut;
    @Mock
    private CashControlDocument cashControlDocMock;
    @Mock
    private WorkflowDocument workflowDocumentMock;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        DocumentHeader documentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocumentMock);
        PaymentApplicationDocument paymentApplicationDocMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)paymentApplicationDocMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        CashControlDetail cashControlDetailMock = (CashControlDetail)Mockito.mock(CashControlDetail.class);
        Mockito.when((Object)cashControlDetailMock.getReferenceFinancialDocument()).thenReturn((Object)paymentApplicationDocMock);
        List<CashControlDetail> cashControlDetails = Collections.singletonList(cashControlDetailMock);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(cashControlDetails);
        this.cut = new CashControlDocumentPresentationController();
    }

    @Test
    public void canApprove_NoAppDocs_True() {
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(new ArrayList());
        Assert.assertTrue((boolean)this.cut.canApprove((Document)this.cashControlDocMock));
    }

    @Test
    public void canApprove_ApprovedAppDoc_True() {
        Mockito.when((Object)this.workflowDocumentMock.isApproved()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cut.canApprove((Document)this.cashControlDocMock));
    }

    @Test
    public void canApprove_FinalAppDoc_True() {
        Mockito.when((Object)this.workflowDocumentMock.isFinal()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cut.canApprove((Document)this.cashControlDocMock));
    }

    @Test
    public void canApprove_CanceledAppDoc_True() {
        Mockito.when((Object)this.workflowDocumentMock.isCanceled()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cut.canApprove((Document)this.cashControlDocMock));
    }

    @Test
    public void canApprove_DisapprovedAppDoc_True() {
        Mockito.when((Object)this.workflowDocumentMock.isDisapproved()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.cut.canApprove((Document)this.cashControlDocMock));
    }
}

