/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.kfs.krad.bo.DataObjectAuthorizerBase;
import org.kuali.kfs.module.ar.document.authorization.PredeterminedBillingScheduleMaintenanceDocumentAuthorizer;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class PredeterminedBillingScheduleMaintenanceDocumentAuthorizerTest {
    private String wklykinsPrincipalId = "2191506168";
    private String khuntleyPrincipalId = "6162502038";
    private PredeterminedBillingScheduleMaintenanceDocumentAuthorizer cut;
    @Mock
    private PermissionService permissionSvcMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new PredeterminedBillingScheduleMaintenanceDocumentAuthorizer();
        DataObjectAuthorizerBase.setPermissionService((PermissionService)this.permissionSvcMock);
    }

    @After
    public void tearDown() {
        DataObjectAuthorizerBase.setPermissionService(null);
    }

    @Test
    public void conditionallyHideBillCollectionEditing_DoHide() {
        MaintainableCollectionDefinition maintainableCollectionDefinition = new MaintainableCollectionDefinition();
        Mockito.when((Object)this.permissionSvcMock.isAuthorizedByTemplate((String)ArgumentMatchers.eq((Object)this.wklykinsPrincipalId), (String)ArgumentMatchers.eq((Object)"KR-NS"), (String)ArgumentMatchers.eq((Object)"Add Line"), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any())).thenReturn((Object)false);
        Assert.assertTrue((boolean)maintainableCollectionDefinition.getIncludeAddLine());
        Assert.assertTrue((boolean)maintainableCollectionDefinition.isIncludeMultipleLookupLine());
        this.cut.conditionallyHideBillCollectionEditing(this.wklykinsPrincipalId, maintainableCollectionDefinition);
        Assert.assertFalse((boolean)maintainableCollectionDefinition.getIncludeAddLine());
        Assert.assertFalse((boolean)maintainableCollectionDefinition.isIncludeMultipleLookupLine());
    }

    @Test
    public void conditionallyHideBillCollectionEditing_DoNotHide() {
        MaintainableCollectionDefinition maintainableCollectionDefinition = new MaintainableCollectionDefinition();
        Mockito.when((Object)this.permissionSvcMock.isAuthorizedByTemplate((String)ArgumentMatchers.eq((Object)this.khuntleyPrincipalId), (String)ArgumentMatchers.eq((Object)"KR-NS"), (String)ArgumentMatchers.eq((Object)"Add Line"), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any())).thenReturn((Object)true);
        Assert.assertTrue((boolean)maintainableCollectionDefinition.getIncludeAddLine());
        Assert.assertTrue((boolean)maintainableCollectionDefinition.isIncludeMultipleLookupLine());
        this.cut.conditionallyHideBillCollectionEditing(this.khuntleyPrincipalId, maintainableCollectionDefinition);
        Assert.assertTrue((boolean)maintainableCollectionDefinition.getIncludeAddLine());
        Assert.assertTrue((boolean)maintainableCollectionDefinition.isIncludeMultipleLookupLine());
    }
}

