/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation;

import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.module.ar.document.service.MilestoneScheduleMaintenanceService;
import org.kuali.kfs.module.ar.document.validation.MilestoneScheduleRule;
import org.kuali.kfs.module.ar.service.impl.AccountsReceivableModuleBillingServiceImpl;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.springframework.util.AutoPopulatingList;

public class MilestoneScheduleRuleTest {
    private final String CHART_CODE = "BL";
    private final String ACCT_NUM = "1234567";
    private final String PROPOSAL_NUM = "1";
    @Spy
    private MilestoneScheduleRule cutSpy = new MilestoneScheduleRule();
    @Mock
    private AccountsReceivableModuleBillingServiceImpl accountsReceivableModuleBillingSvcMock;
    @Mock
    private ContractsAndGrantsBillingAward awardMock;
    @Mock
    private ContractsAndGrantsBillingAwardAccount awardAccountMock;
    @Mock
    private MaintenanceDocument milestoneScheduleMaintDocMock;
    @Mock
    private Milestone milestone1Mock;
    @Mock
    private Milestone milestone2Mock;
    @Mock
    private MilestoneSchedule milestoneScheduleMock;
    @Mock
    private MilestoneScheduleMaintenanceService milestoneScheduleMaintenanceSvcMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.awardMock.getProposalNumber()).thenReturn((Object)"1");
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Mockito.when((Object)this.awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(Collections.singletonList(this.awardAccountMock));
        Mockito.when((Object)this.awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)this.awardAccountMock.getAccountNumber()).thenReturn((Object)"1234567");
        Mockito.when((Object)this.milestoneScheduleMock.getAward()).thenReturn((Object)this.awardMock);
        Mockito.when((Object)this.milestoneScheduleMock.getProposalNumber()).thenReturn((Object)"1");
        Mockito.when((Object)this.milestoneScheduleMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)this.milestoneScheduleMock.getAccountNumber()).thenReturn((Object)"1234567");
        this.setupMilestoneMocks();
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getMilestonesTotalAmountForOtherSchedules("1", "BL", "1234567")).thenReturn((Object)new KualiDecimal(48000.0));
        ((MilestoneScheduleRule)Mockito.doReturn((Object)this.accountsReceivableModuleBillingSvcMock).when((Object)this.cutSpy)).getAccountsReceivableModuleBillingService();
        ((MilestoneScheduleRule)Mockito.doReturn((Object)this.milestoneScheduleMaintenanceSvcMock).when((Object)this.cutSpy)).getMilestoneScheduleMaintenanceService();
        this.cutSpy.newMilestoneScheduleCopy = this.milestoneScheduleMock;
        GlobalVariables.getMessageMap().getErrorMessages().clear();
    }

    private void setupMilestoneMocks() {
        this.setupMilestoneMock(this.milestone1Mock, 1L, "test*1");
        this.setupMilestoneMock(this.milestone2Mock, 2L, "test*2");
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        milestones.add(this.milestone1Mock);
        milestones.add(this.milestone2Mock);
        Mockito.when((Object)this.milestoneScheduleMock.getMilestones()).thenReturn(milestones);
    }

    private void setupMilestoneMock(Milestone milestoneMock, long milestoneIdentifier, String milestoneNumber) {
        Mockito.when((Object)milestoneMock.getMilestoneIdentifier()).thenReturn((Object)milestoneIdentifier);
        Mockito.when((Object)milestoneMock.getMilestoneNumber()).thenReturn((Object)milestoneNumber);
        Mockito.when((Object)milestoneMock.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)milestoneMock.isActive()).thenReturn((Object)true);
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_Valid() {
        Assert.assertTrue((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
    }

    @Test
    public void processCustomAddCollectionLineBusinessRules_Valid() {
        Milestone newMilestoneMock = (Milestone)Mockito.mock(Milestone.class);
        Mockito.when((Object)newMilestoneMock.getMilestoneIdentifier()).thenReturn((Object)3L);
        Mockito.when((Object)newMilestoneMock.getMilestoneNumber()).thenReturn((Object)"test*3");
        Mockito.when((Object)newMilestoneMock.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Assert.assertTrue((boolean)this.cutSpy.processCustomAddCollectionLineBusinessRules(null, "Milestones", (PersistableBusinessObject)newMilestoneMock));
    }

    @Test
    public void processCustomAddCollectionLineBusinessRules_DuplicateMilestoneNumber() {
        Milestone newMilestoneMock = (Milestone)Mockito.mock(Milestone.class);
        Mockito.when((Object)newMilestoneMock.getMilestoneIdentifier()).thenReturn((Object)3L);
        Mockito.when((Object)newMilestoneMock.getMilestoneNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)newMilestoneMock.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(2000.0));
        Assert.assertFalse((boolean)this.cutSpy.processCustomAddCollectionLineBusinessRules(null, "Milestones", (PersistableBusinessObject)newMilestoneMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.Milestones")).get(0);
        Assert.assertEquals((Object)"error.duplicate.milestone.number", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assert.assertEquals((long)0L, (long)messageParameters.length);
    }

    @Test
    public void processCustomAddCollectionLineBusinessRules_ActualCompletionDateInFuture() {
        Milestone newMilestoneMock = (Milestone)Mockito.mock(Milestone.class);
        Mockito.when((Object)newMilestoneMock.getMilestoneIdentifier()).thenReturn((Object)3L);
        Mockito.when((Object)newMilestoneMock.getMilestoneNumber()).thenReturn((Object)"test*3");
        Mockito.when((Object)newMilestoneMock.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(2000.0));
        Mockito.when((Object)newMilestoneMock.getMilestoneActualCompletionDate()).thenReturn((Object)Date.valueOf(LocalDate.now().plusDays(1L)));
        Assert.assertFalse((boolean)this.cutSpy.processCustomAddCollectionLineBusinessRules(null, "Milestones", (PersistableBusinessObject)newMilestoneMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.Milestones")).get(0);
        Assert.assertEquals((Object)"error.milestone.actual.completion.date.in.future", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assert.assertEquals((long)0L, (long)messageParameters.length);
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_BillingFrequencyNotMilestone() {
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Assert.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.proposalNumberForAwardAccountLookup")).get(0);
        Assert.assertEquals((Object)"error.cg.award.milestone.schedule.incorrect.billing.frequency", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assert.assertEquals((long)1L, (long)messageParameters.length);
        Assert.assertEquals((Object)"1", (Object)messageParameters[0]);
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_DuplicateMilestoneNumbers_OneCopiedToInvoice() {
        Mockito.when((Object)this.milestone2Mock.getMilestoneNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)this.milestoneScheduleMaintenanceSvcMock.hasMilestoneBeenCopiedToInvoice("1", this.milestone1Mock.getMilestoneIdentifier().toString())).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assert.assertEquals((long)2L, (long)GlobalVariables.getMessageMap().getErrorCount());
        String errorPath = "milestones[1].milestoneNumber";
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject." + errorPath)).get(0);
        Assert.assertEquals((Object)"error.duplicate.milestone.number", (Object)errorMessage.getErrorKey());
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_DuplicateMilestoneNumbers_NoneCopiedToInvoice() {
        Mockito.when((Object)this.milestone2Mock.getMilestoneNumber()).thenReturn((Object)"test*1");
        Assert.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assert.assertEquals((long)2L, (long)GlobalVariables.getMessageMap().getErrorCount());
        String errorPath = "milestones[0].milestoneNumber";
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject." + errorPath)).get(0);
        Assert.assertEquals((Object)"error.duplicate.milestone.number", (Object)errorMessage.getErrorKey());
        errorPath = "milestones[1].milestoneNumber";
        errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject." + errorPath)).get(0);
        Assert.assertEquals((Object)"error.duplicate.milestone.number", (Object)errorMessage.getErrorKey());
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_MilestoneAmountGreaterThanAwardAmount_CurrentSchedule() {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getMilestonesTotalAmountForOtherSchedules("1", "BL", "1234567")).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)this.milestone1Mock.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Assert.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.totalScheduledAccount");
        Assert.assertNotNull((Object)errorMessages);
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.milestone.total.exceeds.award.total", (Object)errorMessage.getErrorKey());
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_MilestoneInactiveWithLargeAmount_CurrentSchedule() {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getMilestonesTotalAmountForOtherSchedules("1", "BL", "1234567")).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)this.milestone1Mock.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)this.milestone1Mock.isActive()).thenReturn((Object)false);
        Assert.assertTrue((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_MilestoneAmountGreaterThanAwardAmount_AllSchedules() {
        Mockito.when((Object)this.milestone1Mock.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(5000.0));
        Assert.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.totalScheduledAccount");
        Assert.assertNotNull((Object)errorMessages);
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.milestone.total.exceeds.award.total", (Object)errorMessage.getErrorKey());
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_MilestoneInactiveWithLargeAmount_AllSchedules() {
        Mockito.when((Object)this.milestone1Mock.getMilestoneAmount()).thenReturn((Object)new KualiDecimal(5000.0));
        Mockito.when((Object)this.milestone1Mock.isActive()).thenReturn((Object)false);
        Assert.assertTrue((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_MilestoneWithNullAmount() {
        Mockito.when((Object)this.milestone1Mock.getMilestoneAmount()).thenReturn(null);
        Mockito.when((Object)this.milestone1Mock.isActive()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_ChartAccountDoesNotExistOnAward() {
        Mockito.when((Object)this.milestoneScheduleMock.getAccountNumber()).thenReturn((Object)"9876543");
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getMilestonesTotalAmountForOtherSchedules("1", "BL", "9876543")).thenReturn((Object)KualiDecimal.ZERO);
        Assert.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.accountNumber");
        Assert.assertNotNull((Object)errorMessages);
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.milestone.schedule.account.does.not.exist.on.award", (Object)errorMessage.getErrorKey());
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_AwardDoesNotExist_NullAward() {
        Mockito.when((Object)this.milestoneScheduleMock.getAward()).thenReturn(null);
        Assert.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.proposalNumberForAwardAccountLookup");
        Assert.assertNotNull((Object)errorMessages);
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.award.does.not.exist", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assert.assertEquals((long)1L, (long)messageParameters.length);
        Assert.assertEquals((Object)"1", (Object)messageParameters[0]);
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_AwardDoesNotExist_NullProposalNumber() {
        Mockito.when((Object)this.awardMock.getProposalNumber()).thenReturn(null);
        Assert.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.proposalNumberForAwardAccountLookup");
        Assert.assertNotNull((Object)errorMessages);
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.award.does.not.exist", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assert.assertEquals((long)1L, (long)messageParameters.length);
        Assert.assertEquals((Object)"1", (Object)messageParameters[0]);
    }

    @Test
    public void processCustomRouteDocumentBusinessRules_ActualCompletionDateInFuture() {
        Mockito.when((Object)this.milestone2Mock.getMilestoneActualCompletionDate()).thenReturn((Object)Date.valueOf(LocalDate.now().plusDays(1L)));
        Assert.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.milestoneScheduleMaintDocMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.milestones[1].milestoneActualCompletionDate");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.milestone.actual.completion.date.in.future", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assert.assertEquals((long)0L, (long)messageParameters.length);
    }
}

