/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DictionaryValidationService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.businessobject.PaymentMedium;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.validation.impl.CashControlDocumentRule;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.util.AutoPopulatingList;

public class CashControlDocumentRuleTest {
    private CashControlDocumentRule cut;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private CashControlDocument cashControlDocMock;
    @Mock
    private DictionaryValidationService dictionaryValidationSvcMock;
    @Mock
    private DocumentService documentSvcMock;
    private static final KualiDecimal NEGATIVE_AMOUNT = new KualiDecimal(-1);
    private static final KualiDecimal POSITIVE_AMOUNT = new KualiDecimal(2);
    private static final String CUSTOMER_PAYMENT_MEDIUM_NOT_VALID_CODE = "MEH";
    private List<CashControlDetail> cashControlDetails = new ArrayList<CashControlDetail>();

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.cashControlDocMock.getCustomerPaymentMediumCode()).thenReturn((Object)"CK");
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(this.cashControlDetails);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetail(ArgumentMatchers.anyInt())).thenAnswer(invocation -> this.cashControlDetails.get((Integer)invocation.getArgument(0)));
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("customerPaymentMediumCode", "CA");
        Mockito.when((Object)this.businessObjectSvcMock.findByPrimaryKey(PaymentMedium.class, criteria)).thenReturn(Mockito.mock(PaymentMedium.class));
        this.cut = new CashControlDocumentRule();
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setDictionaryValidationService(this.dictionaryValidationSvcMock);
        this.cut.setDocumentService(this.documentSvcMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    public void validateCashControlDetails_ValidLineAmount_True() {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(POSITIVE_AMOUNT);
        this.cashControlDetails.add(cashControlDetail);
        Assert.assertTrue((String)("Document should have passed validation. " + GlobalVariables.getMessageMap()), (boolean)this.cut.validateCashControlDetails(this.cashControlDocMock));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void validateCashControlDetails_NegativeLineAmount_False() {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(NEGATIVE_AMOUNT);
        this.cashControlDetails.add(cashControlDetail);
        Assert.assertFalse((boolean)this.cut.validateCashControlDetails(this.cashControlDocMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.cashControlDetail[0].financialDocumentLineAmount")).get(0);
        Assert.assertEquals((Object)"error.ar.LineAmountCannotBeNegative", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }

    @Test
    public void validateCashControlDetails_ZeroLineAmount_False() {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(KualiDecimal.ZERO);
        this.cashControlDetails.add(cashControlDetail);
        Assert.assertFalse((boolean)this.cut.validateCashControlDetails(this.cashControlDocMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.cashControlDetail[0].financialDocumentLineAmount")).get(0);
        Assert.assertEquals((Object)"error.ar.LineAmountCannotBeZero", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }

    @Test
    public void validateCashControlDetails_ZeroLineAmount_CanceledPaymentApplication_True() {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(KualiDecimal.ZERO);
        PaymentApplicationDocument paymentApplicationDocMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)workflowDocumentMock.isCanceled()).thenReturn((Object)true);
        FinancialSystemDocumentHeader financialSystemDocumentHeaderMock = (FinancialSystemDocumentHeader)Mockito.mock(FinancialSystemDocumentHeader.class);
        Mockito.when((Object)financialSystemDocumentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        Mockito.when((Object)paymentApplicationDocMock.getFinancialSystemDocumentHeader()).thenReturn((Object)financialSystemDocumentHeaderMock);
        cashControlDetail.setReferenceFinancialDocument(paymentApplicationDocMock);
        this.cashControlDetails.add(cashControlDetail);
        Assert.assertTrue((boolean)this.cut.validateCashControlDetails(this.cashControlDocMock));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void checkGLPEsCreated_NotNull_True() {
        GeneralLedgerPendingEntry tempEntry = new GeneralLedgerPendingEntry();
        Mockito.when((Object)this.cashControlDocMock.getGeneralLedgerPendingEntries()).thenReturn(Collections.singletonList(tempEntry));
        Assert.assertTrue((String)("GLPE's should have been created: " + TestUtils.dumpMessageMapErrors()), (boolean)this.cut.checkGLPEsCreated(this.cashControlDocMock));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void checkGLPEsCreated_Null_False() {
        Mockito.when((Object)this.cashControlDocMock.getGeneralLedgerPendingEntries()).thenReturn(null);
        Assert.assertFalse((String)"GLPE's should not have been created", (boolean)this.cut.checkGLPEsCreated(this.cashControlDocMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.generalLedgerPendingEntr*")).get(0);
        Assert.assertEquals((Object)"error.ar.GLPEsNotCreated", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }

    @Test
    public void testCheckPaymentMedium_Valid_True() {
        Mockito.when((Object)this.cashControlDocMock.getCustomerPaymentMediumCode()).thenReturn((Object)"CA");
        Assert.assertTrue((String)("Business Rules should not have failed: " + TestUtils.dumpMessageMapErrors()), (boolean)this.cut.checkPaymentMedium(this.cashControlDocMock));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void checkPaymentMedium_NotValid_False() {
        this.cashControlDocMock.setCustomerPaymentMediumCode(CUSTOMER_PAYMENT_MEDIUM_NOT_VALID_CODE);
        Assert.assertFalse((boolean)this.cut.checkPaymentMedium(this.cashControlDocMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.customerPaymentMediumCode")).get(0);
        Assert.assertEquals((Object)"error.ar.CustomerPaymentMediumIsNotValid", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }

    @Test
    public void checkPaymentMedium_Null_False() {
        this.cashControlDocMock.setCustomerPaymentMediumCode(null);
        Assert.assertFalse((boolean)this.cut.checkPaymentMedium(this.cashControlDocMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.customerPaymentMediumCode")).get(0);
        Assert.assertEquals((Object)"error.ar.CustomerPaymentMediumIsNotValid", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }

    @Test
    public void checkRefDocNumber_Valid_Cash_True() {
        Mockito.when((Object)this.cashControlDocMock.getCustomerPaymentMediumCode()).thenReturn((Object)"CA");
        Mockito.when((Object)this.cashControlDocMock.getReferenceFinancialDocumentNumber()).thenReturn((Object)"12345");
        Mockito.when((Object)this.documentSvcMock.documentExists("12345")).thenReturn((Object)true);
        Assert.assertTrue((String)("Business Rules should not have failed: " + TestUtils.dumpMessageMapErrors()), (boolean)this.cut.checkRefDocNumber(this.cashControlDocMock));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void checkRefDocNumber_Null_Cash_False() {
        Mockito.when((Object)this.cashControlDocMock.getCustomerPaymentMediumCode()).thenReturn((Object)"CA");
        Mockito.when((Object)this.cashControlDocMock.getReferenceFinancialDocumentNumber()).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.checkRefDocNumber(this.cashControlDocMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.referenceFinancialDocumentNumber")).get(0);
        Assert.assertEquals((Object)"error.ar.ReferenceDocNumberMustBeValidforPaymentMediumCash", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }

    @Test
    public void getGeneralLedgerPendingEntries_True() {
        Mockito.when((Object)this.cashControlDocMock.getGeneralLedgerPendingEntries()).thenReturn(null);
        Assert.assertTrue((String)("Business Rules should not have failed: " + TestUtils.dumpMessageMapErrors()), (boolean)this.cut.checkGLPEsNotGenerated(this.cashControlDocMock));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void checkGLPEsNotGenerated_False() {
        GeneralLedgerPendingEntry tempEntry = new GeneralLedgerPendingEntry();
        Mockito.when((Object)this.cashControlDocMock.getGeneralLedgerPendingEntries()).thenReturn(Collections.singletonList(tempEntry));
        Assert.assertFalse((boolean)this.cut.checkGLPEsNotGenerated(this.cashControlDocMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.generalLedgerPendingEntr*")).get(0);
        Assert.assertEquals((Object)"error.ar.AddApplicationDocNotAllowedAfterGLPEsGenerated", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }

    @Test
    public void checkAllAppDocsApproved_NoAppDocs_True() {
        Assert.assertTrue((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
    }

    @Test
    public void checkAllAppDocsApproved_ApprovedAppDoc_True() {
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)workflowDocumentMock.isApproved()).thenReturn((Object)true);
        CashControlDetail cashControlDetail = this.setupCashControlDetailWithWorkflowDocument(workflowDocumentMock);
        this.cashControlDetails.add(cashControlDetail);
        Assert.assertTrue((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
    }

    private CashControlDetail setupCashControlDetailWithWorkflowDocument(WorkflowDocument workflowDocumentMock) {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(KualiDecimal.ZERO);
        PaymentApplicationDocument paymentApplicationDocMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        DocumentHeader documentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        Mockito.when((Object)paymentApplicationDocMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        cashControlDetail.setReferenceFinancialDocument(paymentApplicationDocMock);
        return cashControlDetail;
    }

    @Test
    public void checkAllAppDocsApproved_FinalAppDoc_True() {
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)workflowDocumentMock.isFinal()).thenReturn((Object)true);
        CashControlDetail cashControlDetail = this.setupCashControlDetailWithWorkflowDocument(workflowDocumentMock);
        this.cashControlDetails.add(cashControlDetail);
        Assert.assertTrue((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
    }

    @Test
    public void checkAllAppDocsApproved_CanceledAppDoc_True() {
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)workflowDocumentMock.isCanceled()).thenReturn((Object)true);
        CashControlDetail cashControlDetail = this.setupCashControlDetailWithWorkflowDocument(workflowDocumentMock);
        this.cashControlDetails.add(cashControlDetail);
        Assert.assertTrue((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
    }

    @Test
    public void checkAllAppDocsApproved_DisapprovedAppDoc_False() {
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)workflowDocumentMock.isDisapproved()).thenReturn((Object)true);
        CashControlDetail cashControlDetail = this.setupCashControlDetailWithWorkflowDocument(workflowDocumentMock);
        this.cashControlDetails.add(cashControlDetail);
        Assert.assertFalse((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.cashControlDetail[0].status")).get(0);
        Assert.assertEquals((Object)"error.ar.AllApplicationDocumentsMustBeApprovedOrCanceled", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }
}

