/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.document.CustomerCreditMemoDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerCreditMemoDocumentRule;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={GlobalVariables.class, WorkflowDocumentFactory.class})
public class CustomerCreditMemoDocumentRuleTest {
    private static final String INVOICE_DOCUMENT_NUMBER = "KLM0456";
    private static final String PRINCIPAL_ID = "khuntley";
    private CustomerCreditMemoDocumentRule cut;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private CustomerCreditMemoDocument customerCreditMemoDocumentMock;
    @Mock
    private CustomerInvoiceDocument customerInvoiceDocumentMock;
    @Mock
    private CustomerInvoiceDocumentService customerInvoiceDocumentSvcMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(WorkflowDocumentFactory.class, (Class[])new Class[0]);
        PowerMockito.mockStatic(GlobalVariables.class, (Answer)Mockito.CALLS_REAL_METHODS);
        UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
        Mockito.when((Object)userSessionMock.getPrincipalId()).thenReturn((Object)PRINCIPAL_ID);
        Mockito.when((Object)GlobalVariables.getUserSession()).thenReturn((Object)userSessionMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.cut = new CustomerCreditMemoDocumentRule();
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setCustomerInvoiceDocumentService(this.customerInvoiceDocumentSvcMock);
    }

    @Test
    public void isQtyOrItemAmountEntered_EmptyString_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        Assert.assertEquals((Object)"", (Object)this.cut.isQtyOrItemAmountEntered(detail));
    }

    @Test
    public void isQtyOrItemAmountEntered_OnlyQty_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemQuantity(new BigDecimal(1));
        Assert.assertEquals((Object)"qty", (Object)this.cut.isQtyOrItemAmountEntered(detail));
    }

    @Test
    public void isQtyOrItemAmountEntered_OnlyAmount_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(1));
        Assert.assertEquals((Object)"itemAmount", (Object)this.cut.isQtyOrItemAmountEntered(detail));
    }

    @Test
    public void isQtyOrItemAmountEntered_AmountAndQty_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(1));
        detail.setCreditMemoItemQuantity(new BigDecimal(1));
        Assert.assertEquals((Object)"both", (Object)this.cut.isQtyOrItemAmountEntered(detail));
    }

    @Test
    public void isValueGreaterThanZero_Valid_True() {
        Assert.assertTrue((boolean)this.cut.isValueGreaterThanZero(BigDecimal.ONE));
    }

    @Test
    public void isValueGreaterThanZero_Zero_False() {
        Assert.assertFalse((boolean)this.cut.isValueGreaterThanZero(BigDecimal.ZERO));
    }

    @Test
    public void tisValueGreaterThanZero_ValidKualiDecimal_True() {
        Assert.assertTrue((boolean)this.cut.isValueGreaterThanZero(new KualiDecimal(1)));
    }

    @Test
    public void isValueGreaterThanZero_ZeroKualiDecimal_False() {
        Assert.assertFalse((boolean)this.cut.isValueGreaterThanZero(KualiDecimal.ZERO));
    }

    @Test
    public void isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount_AmountEqual_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemAmount(new KualiDecimal(2));
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(2));
        Assert.assertTrue((boolean)this.cut.isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount(this.customerCreditMemoDocumentMock, detail));
    }

    @Test
    public void isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount_CreditMemoLessThanInvoice_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemAmount(new KualiDecimal(2));
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(1));
        Assert.assertTrue((boolean)this.cut.isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount(this.customerCreditMemoDocumentMock, detail));
    }

    @Test
    public void isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount_CreditMemoGreaterThanInvoiceFalse() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemAmount(new KualiDecimal(1));
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(2));
        Assert.assertFalse((boolean)this.cut.isCustomerCreditMemoItemAmountLessThanEqualToInvoiceOpenItemAmount(this.customerCreditMemoDocumentMock, detail));
    }

    @Test
    public void isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty_QtyEqual_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemQuantity(new BigDecimal(2));
        detail.setCreditMemoItemQuantity(new BigDecimal(2));
        Assert.assertTrue((boolean)this.cut.isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty(detail));
    }

    @Test
    public void isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty_CreditMemoLessThanInvoice_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemQuantity(new BigDecimal(2));
        detail.setCreditMemoItemQuantity(new BigDecimal(1));
        Assert.assertTrue((boolean)this.cut.isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty(detail));
    }

    @Test
    public void isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty_CreditMemoGreaterThanInvoice_False() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setInvoiceOpenItemQuantity(new BigDecimal(1));
        detail.setCreditMemoItemQuantity(new BigDecimal(2));
        Assert.assertFalse((boolean)this.cut.isCustomerCreditMemoQtyLessThanEqualToInvoiceOpenQty(detail));
    }

    @Test
    public void checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_ExactMatch_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(4));
        detail.setCreditMemoItemQuantity(new BigDecimal(2));
        Assert.assertTrue((boolean)this.cut.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(2)));
    }

    @Test
    public void checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_FarOff_False() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(50));
        detail.setCreditMemoItemQuantity(new BigDecimal(10));
        Assert.assertFalse((boolean)this.cut.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(10)));
    }

    @Test
    public void checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_JustAboveAllowedDeviation_False() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(50));
        detail.setCreditMemoItemQuantity(new BigDecimal(5.6));
        Assert.assertFalse((boolean)this.cut.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(10)));
    }

    @Test
    public void checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_ExactlyAllowedDeviation_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(50));
        detail.setCreditMemoItemQuantity(new BigDecimal(5.5));
        Assert.assertTrue((boolean)this.cut.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(10)));
    }

    @Test
    public void checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid_JustBelowAllowedDeviation_True() {
        CustomerCreditMemoDetail detail = new CustomerCreditMemoDetail();
        detail.setCreditMemoItemTotalAmount(new KualiDecimal(50));
        detail.setCreditMemoItemQuantity(new BigDecimal(5.4));
        Assert.assertTrue((boolean)this.cut.checkIfCustomerCreditMemoQtyAndCustomerCreditMemoItemAmountValid(detail, new BigDecimal(10)));
    }

    @Test
    public void checkIfInvoiceNumberIsFinal_blankInvoiceNumber_False() {
        Assert.assertFalse((boolean)this.cut.checkIfInvoiceNumberIsFinal(""));
    }

    @Test
    public void checkIfInvoiceNumberIsFinal_invalidInvoiceNumber_False() {
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.getInvoiceByInvoiceDocumentNumber(INVOICE_DOCUMENT_NUMBER)).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.checkIfInvoiceNumberIsFinal(INVOICE_DOCUMENT_NUMBER));
    }

    @Test
    public void checkIfInvoiceNumberIsFinal_validInvoiceNumberFinal_True() {
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.getInvoiceByInvoiceDocumentNumber(INVOICE_DOCUMENT_NUMBER)).thenReturn((Object)this.customerInvoiceDocumentMock);
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.checkIfInvoiceNumberIsFinal(INVOICE_DOCUMENT_NUMBER)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cut.checkIfInvoiceNumberIsFinal(INVOICE_DOCUMENT_NUMBER));
    }

    @Test
    public void checkIfInvoiceNumberIsFinal_validInvoiceNumberNotFinal_False() {
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.getInvoiceByInvoiceDocumentNumber(INVOICE_DOCUMENT_NUMBER)).thenReturn((Object)this.customerInvoiceDocumentMock);
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.checkIfInvoiceNumberIsFinal(INVOICE_DOCUMENT_NUMBER)).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.cut.checkIfInvoiceNumberIsFinal(INVOICE_DOCUMENT_NUMBER));
    }

    @Test
    public void checkIfThereIsNoAnotherCRMInRouteForTheInvoice_NoOtherCRMsForInvoiceFound_True() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("financialDocumentReferenceInvoiceNumber", INVOICE_DOCUMENT_NUMBER);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(CustomerCreditMemoDocument.class, fieldValues)).thenReturn(Collections.emptyList());
        Assert.assertTrue((boolean)this.cut.checkIfThereIsNoAnotherCRMInRouteForTheInvoice(INVOICE_DOCUMENT_NUMBER));
    }

    @Test
    public void checkIfThereIsNoAnotherCRMInRouteForTheInvoice_OtherEnrouteCRMsForInvoiceFound_False() {
        ArrayList<CustomerCreditMemoDocument> mockCustomerCreditMemoDocuments = new ArrayList<CustomerCreditMemoDocument>();
        mockCustomerCreditMemoDocuments.add(this.createMockCustomerCreditMemoDocument("1000"));
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("financialDocumentReferenceInvoiceNumber", INVOICE_DOCUMENT_NUMBER);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(CustomerCreditMemoDocument.class, fieldValues)).thenReturn(mockCustomerCreditMemoDocuments);
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)workflowDocumentMock.isEnroute()).thenReturn((Object)true);
        Mockito.when((Object)WorkflowDocumentFactory.loadDocument((String)PRINCIPAL_ID, (String)"1000")).thenReturn((Object)workflowDocumentMock);
        Assert.assertFalse((boolean)this.cut.checkIfThereIsNoAnotherCRMInRouteForTheInvoice(INVOICE_DOCUMENT_NUMBER));
    }

    @Test
    public void checkIfThereIsNoAnotherCRMInRouteForTheInvoice_OtherNonEnrouteCRMsForInvoiceFound_True() {
        ArrayList<CustomerCreditMemoDocument> mockCustomerCreditMemoDocuments = new ArrayList<CustomerCreditMemoDocument>();
        mockCustomerCreditMemoDocuments.add(this.createMockCustomerCreditMemoDocument("1001"));
        mockCustomerCreditMemoDocuments.add(this.createMockCustomerCreditMemoDocument("1002"));
        mockCustomerCreditMemoDocuments.add(this.createMockCustomerCreditMemoDocument("1003"));
        mockCustomerCreditMemoDocuments.add(this.createMockCustomerCreditMemoDocument("1004"));
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("financialDocumentReferenceInvoiceNumber", INVOICE_DOCUMENT_NUMBER);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(CustomerCreditMemoDocument.class, fieldValues)).thenReturn(mockCustomerCreditMemoDocuments);
        WorkflowDocument approvedWorkflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)approvedWorkflowDocumentMock.isApproved()).thenReturn((Object)true);
        WorkflowDocument processedWorkflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)processedWorkflowDocumentMock.isProcessed()).thenReturn((Object)true);
        WorkflowDocument cancelledWorkflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)cancelledWorkflowDocumentMock.isCanceled()).thenReturn((Object)true);
        WorkflowDocument disapprovedWorkflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)disapprovedWorkflowDocumentMock.isDisapproved()).thenReturn((Object)true);
        Mockito.when((Object)WorkflowDocumentFactory.loadDocument((String)PRINCIPAL_ID, (String)"1001")).thenReturn((Object)approvedWorkflowDocumentMock);
        Mockito.when((Object)WorkflowDocumentFactory.loadDocument((String)PRINCIPAL_ID, (String)"1002")).thenReturn((Object)processedWorkflowDocumentMock);
        Mockito.when((Object)WorkflowDocumentFactory.loadDocument((String)PRINCIPAL_ID, (String)"1003")).thenReturn((Object)cancelledWorkflowDocumentMock);
        Mockito.when((Object)WorkflowDocumentFactory.loadDocument((String)PRINCIPAL_ID, (String)"1004")).thenReturn((Object)disapprovedWorkflowDocumentMock);
        Assert.assertTrue((boolean)this.cut.checkIfThereIsNoAnotherCRMInRouteForTheInvoice(INVOICE_DOCUMENT_NUMBER));
    }

    private CustomerCreditMemoDocument createMockCustomerCreditMemoDocument(String documentNumber) {
        CustomerCreditMemoDocument mockCustomerCreditMemoDocument1 = (CustomerCreditMemoDocument)Mockito.mock(CustomerCreditMemoDocument.class);
        Mockito.when((Object)mockCustomerCreditMemoDocument1.getDocumentNumber()).thenReturn((Object)documentNumber);
        return mockCustomerCreditMemoDocument1;
    }
}

