/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceItemCode;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceDetailItemCodeValidation;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class CustomerInvoiceDetailItemCodeValidationTest {
    private static final String VALID_ITEM_CODE = "CAR";
    private static final String VALID_BILLING_CHART_OF_ACCOUNTS_CODE = "BA";
    private static final String VALID_BILLING_ORGANIZATION_CODE = "MOTR";
    private static final String INVALID_ITEM_CODE = "XXXX";
    private CustomerInvoiceDetailItemCodeValidation cut;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private CustomerInvoiceDocument customerInvoiceDocumentMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getBillByChartOfAccountCode()).thenReturn((Object)VALID_BILLING_CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getBilledByOrganizationCode()).thenReturn((Object)VALID_BILLING_ORGANIZATION_CODE);
        this.cut = new CustomerInvoiceDetailItemCodeValidation();
        this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
        this.cut.setCustomerInvoiceDetail(new CustomerInvoiceDetail());
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
    }

    @Test
    public void validate_ValidDetailItemCode() {
        this.cut.getCustomerInvoiceDetail().setInvoiceItemCode(VALID_ITEM_CODE);
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("invoiceItemCode", VALID_ITEM_CODE);
        criteria.put("chartOfAccountsCode", VALID_BILLING_CHART_OF_ACCOUNTS_CODE);
        criteria.put("organizationCode", VALID_BILLING_ORGANIZATION_CODE);
        Mockito.when((Object)this.businessObjectSvcMock.findByPrimaryKey(CustomerInvoiceItemCode.class, criteria)).thenReturn((Object)new CustomerInvoiceItemCode());
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_InvalidDetailItemCode() {
        this.cut.getCustomerInvoiceDetail().setInvoiceItemCode(INVALID_ITEM_CODE);
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("invoiceItemCode", INVALID_ITEM_CODE);
        criteria.put("chartOfAccountsCode", VALID_BILLING_CHART_OF_ACCOUNTS_CODE);
        criteria.put("organizationCode", VALID_BILLING_ORGANIZATION_CODE);
        Mockito.when((Object)this.businessObjectSvcMock.findByPrimaryKey(CustomerInvoiceItemCode.class, criteria)).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.validate(null));
    }
}

