/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceDetailSystemInformationDiscountValidation;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class CustomerInvoiceDetailSystemInformationDiscountValidationTest {
    private static final String PROCESSING_CHART_OF_ACCOUNTS_CODE = "UA";
    private static final String PROCESSING_ORGANIZATION_CODE = "ARCG";
    private static final String DISCOUNT_OBJECT_CODE = "1999";
    private static final int FISCAL_YEAR = 2018;
    private CustomerInvoiceDetailSystemInformationDiscountValidation cut;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private CustomerInvoiceDocument customerInvoiceDocumentMock;
    @Mock
    private UniversityDateService universityDateSvcMock;
    private AccountsReceivableDocumentHeader accountsReceivableDocumentHeader;
    private Map<String, Object> criteria;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.criteria = new HashMap<String, Object>();
        this.criteria.put("universityFiscalYear", 2018);
        this.criteria.put("processingChartOfAccountCode", PROCESSING_CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)this.universityDateSvcMock.getCurrentFiscalYear()).thenReturn((Object)2018);
        this.accountsReceivableDocumentHeader = new AccountsReceivableDocumentHeader();
        this.accountsReceivableDocumentHeader.setProcessingChartOfAccountCode(PROCESSING_CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)this.accountsReceivableDocumentHeader);
        this.cut = new CustomerInvoiceDetailSystemInformationDiscountValidation();
        this.cut.setUniversityDateService(this.universityDateSvcMock);
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
    }

    @Test
    public void validate_SystemInformationWithDiscount() {
        this.accountsReceivableDocumentHeader.setProcessingOrganizationCode(PROCESSING_ORGANIZATION_CODE);
        this.criteria.put("processingOrganizationCode", PROCESSING_ORGANIZATION_CODE);
        SystemInformation systemInformation = new SystemInformation();
        systemInformation.setDiscountObjectCode(DISCOUNT_OBJECT_CODE);
        Mockito.when((Object)this.businessObjectSvcMock.findByPrimaryKey(SystemInformation.class, this.criteria)).thenReturn((Object)systemInformation);
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_NoSystemInformation() {
        Assert.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_SystemInformationWithoutDiscount() {
        this.criteria.put("processingOrganizationCode", null);
        Mockito.when((Object)this.businessObjectSvcMock.findByPrimaryKey(SystemInformation.class, this.criteria)).thenReturn((Object)new SystemInformation());
        Assert.assertFalse((boolean)this.cut.validate(null));
    }
}

