/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.math.BigDecimal;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceItemCode;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceItemCodeRule;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.document.validation.MaintenanceRuleTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CustomerInvoiceItemCodeRuleTest
extends MaintenanceRuleTestBase {
    CustomerInvoiceItemCode customerInvoiceItemCode;
    private static String CHART_CODE = "BA";
    private static String ORGANIZATION_CODE = "ACAC";
    private static String INVOICE_ITEM_CODE = "TRE";
    private static String INVOICE_ITEM_DESCRIPTION = "TEST";
    private static String POSITIVE_VALUE = "1";
    private static String NON_POSITIVE_VALUE = "0";
    private static boolean ACTIVE_INDEX = true;
    private static String INCOME_OBJECT_CODE = "0110";
    private static String EXPENSE_OBJECT_CODE = "2000";

    protected void setUp() throws Exception {
        super.setUp();
        this.customerInvoiceItemCode = new CustomerInvoiceItemCode();
        this.customerInvoiceItemCode.setChartOfAccountsCode(CHART_CODE);
        this.customerInvoiceItemCode.setOrganizationCode(ORGANIZATION_CODE);
        this.customerInvoiceItemCode.setInvoiceItemCode(INVOICE_ITEM_CODE);
        this.customerInvoiceItemCode.setInvoiceItemDescription(INVOICE_ITEM_DESCRIPTION);
        this.customerInvoiceItemCode.setActive(ACTIVE_INDEX);
    }

    public void testIsCustomerInvoiceItemCodeObjectValid_True() {
        this.customerInvoiceItemCode.setDefaultInvoiceFinancialObjectCode(INCOME_OBJECT_CODE);
        this.customerInvoiceItemCode.setDefaultInvoiceChartOfAccountsCode(CHART_CODE);
        this.customerInvoiceItemCode.refreshReferenceObject("defaultInvoiceFinancialObject");
        CustomerInvoiceItemCodeRule rule = (CustomerInvoiceItemCodeRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.customerInvoiceItemCode), CustomerInvoiceItemCodeRule.class);
        boolean result = rule.isCustomerInvoiceItemCodeObjectValid(this.customerInvoiceItemCode);
        CustomerInvoiceItemCodeRuleTest.assertTrue((String)("When default invoice financial  is " + INCOME_OBJECT_CODE + ", isDefaultInvoiceFinancialObjectValidIncome should return true. "), (boolean)result);
    }

    public void testIsCustomerInvoiceItemCodeObjectValid_False() {
        this.customerInvoiceItemCode.setDefaultInvoiceFinancialObjectCode(EXPENSE_OBJECT_CODE);
        this.customerInvoiceItemCode.setDefaultInvoiceChartOfAccountsCode(CHART_CODE);
        this.customerInvoiceItemCode.refreshReferenceObject("defaultInvoiceFinancialObject");
        CustomerInvoiceItemCodeRule rule = (CustomerInvoiceItemCodeRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.customerInvoiceItemCode), CustomerInvoiceItemCodeRule.class);
        boolean result = rule.isCustomerInvoiceItemCodeObjectValid(this.customerInvoiceItemCode);
        CustomerInvoiceItemCodeRuleTest.assertFalse((String)("When default invoice financial  is " + EXPENSE_OBJECT_CODE + ", isDefaultInvoiceFinancialObjectValidIncome should return false. "), (boolean)result);
    }

    public void testValidateItemDefaultPrice_True() {
        this.customerInvoiceItemCode.setItemDefaultPrice(new KualiDecimal(POSITIVE_VALUE));
        CustomerInvoiceItemCodeRule rule = (CustomerInvoiceItemCodeRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.customerInvoiceItemCode), CustomerInvoiceItemCodeRule.class);
        boolean result = rule.validateItemDefaultPrice(this.customerInvoiceItemCode);
        CustomerInvoiceItemCodeRuleTest.assertTrue((String)("When item default price is " + POSITIVE_VALUE + ", validateItemDefaultPrice should return true. "), (boolean)result);
    }

    public void testValidateItemDefaultPrice_False() {
        this.customerInvoiceItemCode.setItemDefaultPrice(new KualiDecimal(NON_POSITIVE_VALUE));
        CustomerInvoiceItemCodeRule rule = (CustomerInvoiceItemCodeRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.customerInvoiceItemCode), CustomerInvoiceItemCodeRule.class);
        boolean result = rule.validateItemDefaultPrice(this.customerInvoiceItemCode);
        CustomerInvoiceItemCodeRuleTest.assertFalse((String)("When item default price is " + NON_POSITIVE_VALUE + ", validateItemDefaultPrice should return false. "), (boolean)result);
    }

    public void testValidItemDefaultQuantity_True() {
        this.customerInvoiceItemCode.setItemDefaultQuantity(new BigDecimal(POSITIVE_VALUE));
        CustomerInvoiceItemCodeRule rule = (CustomerInvoiceItemCodeRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.customerInvoiceItemCode), CustomerInvoiceItemCodeRule.class);
        boolean result = rule.validateItemDefaultQuantity(this.customerInvoiceItemCode);
        CustomerInvoiceItemCodeRuleTest.assertTrue((String)("When item default quantity is " + POSITIVE_VALUE + ", validItemDefaultQuantity should return true. "), (boolean)result);
    }

    public void testValidItemDefaultQuantity_False() {
        this.customerInvoiceItemCode.setItemDefaultQuantity(new BigDecimal(NON_POSITIVE_VALUE));
        CustomerInvoiceItemCodeRule rule = (CustomerInvoiceItemCodeRule)this.setupMaintDocRule(this.newMaintDoc((PersistableBusinessObject)this.customerInvoiceItemCode), CustomerInvoiceItemCodeRule.class);
        boolean result = rule.validateItemDefaultQuantity(this.customerInvoiceItemCode);
        CustomerInvoiceItemCodeRuleTest.assertFalse((String)("When item default quantity is " + NON_POSITIVE_VALUE + ", validateItemDefaultQuantity should return false. "), (boolean)result);
    }
}

