/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.CustomerType;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerTypeRule;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;

public class CustomerTypeRuleTest {
    private static String CUSTOMER_TYPE_CODE = "XY";
    private static String CUSTOMER_TYPE_CODE_FEDERAL = "01";
    private static String CUSTOMER_TYPE_DESC_FEDERAL = "Federal";
    private static String CUSTOMER_TYPE_DESC_MISC = "Whatever";
    private CustomerTypeRule cut;
    private CustomerType customerType;
    @Mock
    private BusinessObjectService businessObjectSvcMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.setupExistingCustomerType();
        this.cut = new CustomerTypeRule();
        this.cut.setBoService(this.businessObjectSvcMock);
        this.customerType = new CustomerType();
    }

    private void setupExistingCustomerType() {
        CustomerType customerType = new CustomerType();
        customerType.setCustomerTypeCode(CUSTOMER_TYPE_CODE_FEDERAL);
        customerType.setCustomerTypeDescription(CUSTOMER_TYPE_DESC_FEDERAL);
        List<CustomerType> customerTypes = Arrays.asList(customerType);
        PowerMockito.when((Object)this.businessObjectSvcMock.findAll(CustomerType.class)).thenReturn(customerTypes);
    }

    @Test
    public void validateCustomerTypeDescription_DoesNotExist() {
        this.customerType.setCustomerTypeCode(CUSTOMER_TYPE_CODE);
        this.customerType.setCustomerTypeDescription(CUSTOMER_TYPE_DESC_MISC);
        boolean result = this.cut.validateCustomerTypeDescription(this.customerType);
        Assert.assertTrue((String)("When customer type desc is " + CUSTOMER_TYPE_DESC_MISC + ", validateCustomerTypeDescription should return true. "), (boolean)result);
    }

    @Test
    public void validateCustomerTypeDescription_AlreadyExists() {
        this.customerType.setCustomerTypeCode(CUSTOMER_TYPE_CODE);
        this.customerType.setCustomerTypeDescription(CUSTOMER_TYPE_DESC_FEDERAL);
        boolean result = this.cut.validateCustomerTypeDescription(this.customerType);
        Assert.assertFalse((String)("When customer type desc is " + CUSTOMER_TYPE_DESC_FEDERAL + ", validateCustomerTypeDescription should return false. "), (boolean)result);
    }
}

