/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.module.ar.document.validation.impl.MilestoneScheduleRuleUtil;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class MilestoneScheduleRuleUtilTest {
    private static final String PROPOSAL_NUMBER = "39928";
    private static final String CHART_CODE = "BL";
    private static final String ACCOUNT_NUMBER = "1031400";
    @Mock
    private BusinessObjectService businessObjectSvcMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        MilestoneSchedule milestoneSchedule = new MilestoneSchedule();
        milestoneSchedule.setProposalNumber(PROPOSAL_NUMBER);
        milestoneSchedule.setChartOfAccountsCode(CHART_CODE);
        milestoneSchedule.setAccountNumber(ACCOUNT_NUMBER);
        milestoneSchedule.setObjectId("a different objectId");
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalNumber", PROPOSAL_NUMBER);
        primaryKeys.put("chartOfAccountsCode", CHART_CODE);
        primaryKeys.put("accountNumber", ACCOUNT_NUMBER);
        Mockito.when((Object)this.businessObjectSvcMock.findByPrimaryKey(MilestoneSchedule.class, primaryKeys)).thenReturn((Object)milestoneSchedule);
        MilestoneScheduleRuleUtil.setBusinessObjectService((BusinessObjectService)this.businessObjectSvcMock);
    }

    @Test
    public void checkIfMilestonesExists_NullMilestoneSchedule() {
        Assert.assertFalse((boolean)MilestoneScheduleRuleUtil.checkIfMilestonesExists(null));
    }

    @Test
    public void checkIfMilestonesExists_MissingMilestoneSchedule() {
        MilestoneSchedule milestoneSchedule = new MilestoneSchedule();
        Assert.assertFalse((boolean)MilestoneScheduleRuleUtil.checkIfMilestonesExists((MilestoneSchedule)milestoneSchedule));
    }

    @Test
    public void checkIfMilestonesExists_ValidMilestoneSchedule() {
        MilestoneSchedule milestoneSchedule = new MilestoneSchedule();
        milestoneSchedule.setProposalNumber(PROPOSAL_NUMBER);
        milestoneSchedule.setChartOfAccountsCode(CHART_CODE);
        milestoneSchedule.setAccountNumber(ACCOUNT_NUMBER);
        milestoneSchedule.setObjectId("objectId");
        Assert.assertTrue((boolean)MilestoneScheduleRuleUtil.checkIfMilestonesExists((MilestoneSchedule)milestoneSchedule));
    }
}

