/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.kfs.module.ar.document.validation.impl.PredeterminedBillingScheduleRuleUtil;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class PredeterminedBillingScheduleRuleUtilTest {
    private static final String PROPOSAL_NUMBER = "39928";
    private static final String CHART_CODE = "BL";
    private static final String ACCOUNT_NUMBER = "1031400";
    @Mock
    private BusinessObjectService businessObjectSvcMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        PredeterminedBillingSchedule predeterminedBillingSchedule = new PredeterminedBillingSchedule();
        predeterminedBillingSchedule.setProposalNumber(PROPOSAL_NUMBER);
        predeterminedBillingSchedule.setChartOfAccountsCode(CHART_CODE);
        predeterminedBillingSchedule.setAccountNumber(ACCOUNT_NUMBER);
        predeterminedBillingSchedule.setObjectId("a different objectId");
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalNumber", PROPOSAL_NUMBER);
        primaryKeys.put("chartOfAccountsCode", CHART_CODE);
        primaryKeys.put("accountNumber", ACCOUNT_NUMBER);
        Mockito.when((Object)this.businessObjectSvcMock.findByPrimaryKey(PredeterminedBillingSchedule.class, primaryKeys)).thenReturn((Object)predeterminedBillingSchedule);
        PredeterminedBillingScheduleRuleUtil.setBusinessObjectService((BusinessObjectService)this.businessObjectSvcMock);
    }

    @Test
    public void checkIfBillsExist_NullPredeterminedBillingSchedule() {
        Assert.assertFalse((boolean)PredeterminedBillingScheduleRuleUtil.checkIfBillsExist(null));
    }

    @Test
    public void checkIfBillsExist_MissingPredeterminedBillingSchedule() {
        PredeterminedBillingSchedule predeterminedBillingSchedule = new PredeterminedBillingSchedule();
        Assert.assertFalse((boolean)PredeterminedBillingScheduleRuleUtil.checkIfBillsExist((PredeterminedBillingSchedule)predeterminedBillingSchedule));
    }

    @Test
    public void checkIfBillsExist_ValidPredeterminedBillingSchedule() {
        PredeterminedBillingSchedule predeterminedBillingSchedule = new PredeterminedBillingSchedule();
        predeterminedBillingSchedule.setProposalNumber(PROPOSAL_NUMBER);
        predeterminedBillingSchedule.setChartOfAccountsCode(CHART_CODE);
        predeterminedBillingSchedule.setAccountNumber(ACCOUNT_NUMBER);
        predeterminedBillingSchedule.setObjectId("objectId");
        Assert.assertTrue((boolean)PredeterminedBillingScheduleRuleUtil.checkIfBillsExist((PredeterminedBillingSchedule)predeterminedBillingSchedule));
    }
}

