/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.fixture;

import java.sql.Date;
import java.util.ArrayList;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.BillingFrequency;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountMockFixture;
import org.kuali.kfs.module.ar.fixture.BillingFrequencyFixture;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mockito;

public enum ARAwardMockFixture {
    CG_AWARD1("11", "2011-10-01", "2011-09-22", null, new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, null, true, null),
    CG_AWARD2("11", "2011-07-01", "1969-06-30", Date.valueOf("1969-01-01"), new KualiDecimal(7708.0), new KualiDecimal(2016.0), KualiDecimal.ZERO, false, null, true, null),
    CG_AWARD3("11", "2011-07-01", new Date(System.currentTimeMillis() + 604800000L).toString(), Date.valueOf("1969-01-01"), new KualiDecimal(7708.0), new KualiDecimal(2016.0), KualiDecimal.ZERO, false, "1", true, BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency()),
    CG_AWARD4("11", "2011-07-01", new Date(System.currentTimeMillis() + 604800000L).toString(), Date.valueOf("1969-01-01"), new KualiDecimal(7708.0), new KualiDecimal(2016.0), new KualiDecimal(1000000.0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency()),
    CG_AWARD5("11", "2011-07-01", "1969-06-30", Date.valueOf("1969-01-01"), new KualiDecimal(7708.0), new KualiDecimal(2016.0), KualiDecimal.ZERO, false, "1", true, null),
    CG_AWARD6("11", "2011-07-01", new Date(System.currentTimeMillis() + 604800000L).toString(), Date.valueOf("1969-01-01"), new KualiDecimal(100000.0), KualiDecimal.ZERO, KualiDecimal.ZERO, false, "1", true, BillingFrequencyFixture.BILL_FREQ_LOCB.createBillingFrequency()),
    CG_AWARD_INV_AWARD("11", "2011-10-01", "2011-09-22", Date.valueOf("2011-10-01"), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, null),
    CG_AWARD_INV_ACCOUNT("11", "2011-10-01", "2011-09-22", Date.valueOf("2011-10-01"), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "Income", true, BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency()),
    CG_AWARD_INV_CCA("11", "2011-10-01", "2011-09-22", Date.valueOf("2011-10-01"), null, null, null, false, "3", true, null),
    CG_AWARD_MONTHLY_BILLED_DATE_NULL("11", "2011-01-01", "2011-09-22", null, new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency()),
    CG_AWARD_MILESTONE_BILLED_DATE_NULL("111", "2011-01-01", "2011-09-22", null, new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_MS.createBillingFrequency()),
    CG_AWARD_PREDETERMINED_BILLED_DATE_NULL("111", "2011-01-01", "2011-09-22", null, new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency()),
    CG_AWARD_QUAR_BILLED_DATE_NULL("111", "2011-01-01", "2011-09-22", null, new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_QUAR.createBillingFrequency()),
    CG_AWARD_SEMI_ANN_BILLED_DATE_NULL("111", "2011-01-01", "2011-09-22", null, new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_SEMI_ANN.createBillingFrequency()),
    CG_AWARD_ANNUAL_BILLED_DATE_NULL("111", "2011-01-01", "2011-09-22", null, new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_ANNUALLY.createBillingFrequency()),
    CG_AWARD_LOCB_BILLED_DATE_NULL("111", "2011-01-01", "2011-09-22", null, new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_LOCB.createBillingFrequency()),
    CG_AWARD_MONTHLY_BILLED_DATE_VALID("111", "2011-01-01", "2011-09-22", Date.valueOf("2011-09-30"), new KualiDecimal(1000), new KualiDecimal(1000), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency()),
    CG_AWARD_MILESTONE_BILLED_DATE_VALID("111", "2011-01-01", "2011-09-22", Date.valueOf("2011-09-30"), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_MS.createBillingFrequency()),
    CG_AWARD_PREDETERMINED_BILLED_DATE_VALID("111", "2011-01-01", "2011-09-22", Date.valueOf("2011-09-30"), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency()),
    CG_AWARD_QUAR_BILLED_DATE_VALID("111", "2011-01-01", "2011-09-22", Date.valueOf("2011-06-30"), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_QUAR.createBillingFrequency()),
    CG_AWARD_SEMI_ANN_BILLED_DATE_VALID("111", "2011-01-01", "2011-09-22", Date.valueOf("2011-06-30"), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_SEMI_ANN.createBillingFrequency()),
    CG_AWARD_ANNUAL_BILLED_DATE_VALID("111", "2011-01-01", "2011-09-22", Date.valueOf("2010-06-30"), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_ANNUALLY.createBillingFrequency()),
    CG_AWARD_LOCB_BILLED_DATE_VALID("111", "2011-01-01", "2011-09-22", Date.valueOf("2010-12-13"), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_LOCB.createBillingFrequency()),
    CG_AWARD_MONTHLY_INVALID_DATES("11", "2012-01-01", "2011-09-22", new Date(System.currentTimeMillis() + 604800000L), new KualiDecimal(0), new KualiDecimal(0), new KualiDecimal(0), false, "1", true, BillingFrequencyFixture.BILL_FREQ_MON.createBillingFrequency());

    private String proposalNumber;
    private String awardBeginningDate;
    private String awardEndingDate;
    private Date lastBilledDate;
    private KualiDecimal awardDirectCostAmount;
    private KualiDecimal awardIndirectCostAmount;
    private KualiDecimal minInvoiceAmount;
    private boolean excludedFromInvoicing;
    private String invoicingOptionCode;
    private boolean active;
    private BillingFrequency billingFrequency;

    private ARAwardMockFixture(String proposalNumber, String awardBeginningDate, String awardEndingDate, Date lastBilledDate, KualiDecimal awardDirectCostAmount, KualiDecimal awardIndirectCostAmount, KualiDecimal minInvoiceAmount, boolean excludedFromInvoicing, String invoicingOptionCode, boolean active, BillingFrequency billingFrequency) {
        this.proposalNumber = proposalNumber;
        this.awardBeginningDate = awardBeginningDate;
        this.awardEndingDate = awardEndingDate;
        this.lastBilledDate = lastBilledDate;
        this.awardDirectCostAmount = awardDirectCostAmount;
        this.awardIndirectCostAmount = awardIndirectCostAmount;
        this.minInvoiceAmount = minInvoiceAmount;
        this.excludedFromInvoicing = excludedFromInvoicing;
        this.invoicingOptionCode = invoicingOptionCode;
        this.active = active;
        this.billingFrequency = billingFrequency;
    }

    public ContractsAndGrantsBillingAward createAwardMock() {
        ContractsAndGrantsBillingAward awardMock = (ContractsAndGrantsBillingAward)Mockito.mock(ContractsAndGrantsBillingAward.class);
        this.populateAwardMockFromFixture(awardMock);
        return awardMock;
    }

    public ContractsAndGrantsBillingAward createAwardMockWithLastBillingDate() {
        ContractsAndGrantsBillingAward awardMock = (ContractsAndGrantsBillingAward)Mockito.mock(ContractsAndGrantsBillingAward.class);
        this.populateAwardMockFromFixture(awardMock);
        Mockito.when((Object)awardMock.getLastBilledDate()).thenReturn((Object)this.lastBilledDate);
        return awardMock;
    }

    protected void populateAwardMockFromFixture(ContractsAndGrantsBillingAward awardMock) {
        Mockito.when((Object)awardMock.getProposalNumber()).thenReturn((Object)this.proposalNumber);
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)Date.valueOf(this.awardBeginningDate));
        Mockito.when((Object)awardMock.getAwardEndingDate()).thenReturn((Object)Date.valueOf(this.awardEndingDate));
        Mockito.when((Object)awardMock.getLastBilledDate()).thenReturn((Object)this.lastBilledDate);
        Mockito.when((Object)awardMock.getAwardDirectCostAmount()).thenReturn((Object)this.awardDirectCostAmount);
        Mockito.when((Object)awardMock.getAwardIndirectCostAmount()).thenReturn((Object)this.awardIndirectCostAmount);
        KualiDecimal awardTotalAmount = ObjectUtils.isNotNull((Object)this.awardDirectCostAmount) ? this.awardDirectCostAmount : KualiDecimal.ZERO;
        awardTotalAmount.add((AbstractKualiDecimal)(ObjectUtils.isNotNull((Object)this.awardIndirectCostAmount) ? this.awardIndirectCostAmount : KualiDecimal.ZERO));
        Mockito.when((Object)awardMock.getAwardTotalAmount()).thenReturn((Object)awardTotalAmount);
        Mockito.when((Object)awardMock.getMinInvoiceAmount()).thenReturn((Object)this.minInvoiceAmount);
        Mockito.when((Object)awardMock.isExcludedFromInvoicing()).thenReturn((Object)this.excludedFromInvoicing);
        Mockito.when((Object)awardMock.getInvoicingOptionCode()).thenReturn((Object)this.invoicingOptionCode);
        Mockito.when((Object)awardMock.isActive()).thenReturn((Object)this.active);
        Mockito.when((Object)awardMock.getBillingFrequency()).thenReturn((Object)this.billingFrequency);
        if (ObjectUtils.isNotNull((Object)this.billingFrequency)) {
            Mockito.when((Object)awardMock.getBillingFrequencyCode()).thenReturn((Object)this.billingFrequency.getFrequency());
        }
        ContractsAndGrantsBillingAwardAccount awardAccountMock1 = ARAwardAccountMockFixture.AWD_ACCT_1.createAwardAccountMock();
        ContractsAndGrantsBillingAwardAccount awardAccountMock2 = ARAwardAccountMockFixture.AWD_ACCT_2.createAwardAccountMock();
        if (ObjectUtils.isNotNull((Object)this.lastBilledDate)) {
            Mockito.when((Object)awardAccountMock1.getCurrentLastBilledDate()).thenReturn((Object)this.lastBilledDate);
            Mockito.when((Object)awardAccountMock2.getCurrentLastBilledDate()).thenReturn((Object)this.lastBilledDate);
        }
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock1);
        awardAccountMocks.add(awardAccountMock2);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        BillingFrequencyFixture.BILL_FREQ_LOCB.createBillingFrequency();
        Mockito.when((Object)awardMock.getAutoApproveIndicator()).thenReturn((Object)true);
    }
}

