/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsInstrumentType;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceLookupResult;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceLookupResultAward;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsBillingAwardVerificationService;
import org.kuali.kfs.module.ar.fixture.ARAgencyMockFixture;
import org.kuali.kfs.module.ar.report.service.impl.ContractsGrantsInvoiceReportServiceImpl;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ContractsGrantsInvoiceReportServiceImplTest {
    private ContractsGrantsInvoiceReportServiceImpl cut;
    private Date awardBeginningDate;
    private Date awardEndingDate;
    private Date secondAwardBeginningDate;
    private Date secondAwardEndingDate;
    private Date thirdAwardBeginningDate;
    private Date thirdAwardEndingDate;
    private ContractsAndGrantsBillingAgency contractsAndGrantsBillingAgencyMock1;
    private ContractsAndGrantsBillingAgency contractsAndGrantsBillingAgencyMock2;
    private ContractsAndGrantsBillingAward contractsAndGrantsBillingAwardMock1;
    private ContractsAndGrantsBillingAward contractsAndGrantsBillingAwardMock2;
    private ContractsAndGrantsBillingAward contractsAndGrantsBillingAwardMock3;
    private ContractsAndGrantsBillingAwardAccount awardAccountMock1;
    private ContractsAndGrantsBillingAwardAccount awardAccountMock2;
    private ContractsAndGrantsBillingAwardAccount awardAccountMock3;
    private ContractsAndGrantsBillingAwardAccount awardAccountMock4;
    @Mock
    private ContractsGrantsBillingAwardVerificationService contractsGrantsBillingAwardVerificationSvcMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new ContractsGrantsInvoiceReportServiceImpl();
        this.cut.setContractsGrantsBillingAwardVerificationService(this.contractsGrantsBillingAwardVerificationSvcMock);
        this.setupDates();
        this.setupMockBos();
    }

    private void setupDates() {
        this.awardBeginningDate = Date.valueOf(LocalDate.now());
        this.awardEndingDate = Date.valueOf(LocalDate.now().plusYears(1L));
        this.secondAwardBeginningDate = Date.valueOf(LocalDate.now().minusMonths(1L));
        this.secondAwardEndingDate = Date.valueOf(LocalDate.now().plusYears(1L));
        this.thirdAwardBeginningDate = Date.valueOf(LocalDate.now().plusMonths(1L));
        this.thirdAwardEndingDate = Date.valueOf(LocalDate.now().plusYears(1L));
    }

    private void setupMockBos() {
        this.contractsAndGrantsBillingAgencyMock1 = ARAgencyMockFixture.CG_AGENCY2.createAgencyMock();
        this.contractsAndGrantsBillingAgencyMock2 = ARAgencyMockFixture.CG_AGENCY3.createAgencyMock();
        this.contractsAndGrantsBillingAwardMock1 = this.setupContractsAndGrantsBillingAwardMock("1", ArConstants.BillingFrequencyValues.MONTHLY.getCode(), this.awardBeginningDate, this.awardEndingDate, "ITC1", "Invoicing Option Description 1", 1000.0, this.contractsAndGrantsBillingAgencyMock1);
        this.contractsAndGrantsBillingAwardMock2 = this.setupContractsAndGrantsBillingAwardMock("2", ArConstants.BillingFrequencyValues.MILESTONE.getCode(), this.secondAwardBeginningDate, this.secondAwardEndingDate, "ITC2", "Invoicing Option Description 2", 2000.0, this.contractsAndGrantsBillingAgencyMock1);
        this.contractsAndGrantsBillingAwardMock3 = this.setupContractsAndGrantsBillingAwardMock("3", ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode(), this.thirdAwardBeginningDate, this.thirdAwardEndingDate, "ITC3", "Invoicing Option Description 3", 3000.0, this.contractsAndGrantsBillingAgencyMock2);
        this.awardAccountMock1 = this.setupAwardAccountMock("C1", "A1", this.contractsAndGrantsBillingAwardMock1);
        this.awardAccountMock2 = this.setupAwardAccountMock("C2", "A2", this.contractsAndGrantsBillingAwardMock1);
        this.awardAccountMock3 = this.setupAwardAccountMock("C3", "A3", this.contractsAndGrantsBillingAwardMock2);
        this.awardAccountMock4 = this.setupAwardAccountMock("C4", "A4", this.contractsAndGrantsBillingAwardMock3);
        Mockito.when((Object)this.contractsAndGrantsBillingAwardMock1.getActiveAwardAccounts()).thenReturn(Arrays.asList(this.awardAccountMock1, this.awardAccountMock2));
        Mockito.when((Object)this.contractsAndGrantsBillingAwardMock2.getActiveAwardAccounts()).thenReturn(Collections.singletonList(this.awardAccountMock3));
        Mockito.when((Object)this.contractsAndGrantsBillingAwardMock3.getActiveAwardAccounts()).thenReturn(Collections.singletonList(this.awardAccountMock4));
    }

    private ContractsAndGrantsBillingAward setupContractsAndGrantsBillingAwardMock(String proposalNumber, String billingFrequencyCode, Date awardBeginningDate, Date awardEndingDate, String instrumentTypeCode, String invoicingOptionDescription, double awardTotalAmount, ContractsAndGrantsBillingAgency contractsAndGrantsBillingAgency) {
        ContractsAndGrantsBillingAward contractsAndGrantsBillingAwardMock = (ContractsAndGrantsBillingAward)Mockito.mock(ContractsAndGrantsBillingAward.class);
        ContractsAndGrantsInstrumentType instrumentTypeMock = (ContractsAndGrantsInstrumentType)Mockito.mock(ContractsAndGrantsInstrumentType.class);
        Mockito.when((Object)instrumentTypeMock.getInstrumentTypeCode()).thenReturn((Object)instrumentTypeCode);
        String instrumentTypeDescription = instrumentTypeCode + "-Description";
        Mockito.when((Object)instrumentTypeMock.getInstrumentTypeCode()).thenReturn((Object)instrumentTypeCode);
        Mockito.when((Object)instrumentTypeMock.getInstrumentTypeDescription()).thenReturn((Object)instrumentTypeDescription);
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getProposalNumber()).thenReturn((Object)proposalNumber);
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getBillingFrequencyCode()).thenReturn((Object)billingFrequencyCode);
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getAwardBeginningDate()).thenReturn((Object)awardBeginningDate);
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getAwardEndingDate()).thenReturn((Object)awardEndingDate);
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getInstrumentType()).thenReturn((Object)instrumentTypeMock);
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getInvoicingOptionDescription()).thenReturn((Object)invoicingOptionDescription);
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(awardTotalAmount));
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getAgency()).thenReturn((Object)contractsAndGrantsBillingAgency);
        String agencyNumber = contractsAndGrantsBillingAgency.getAgencyNumber();
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getAgencyNumber()).thenReturn((Object)agencyNumber);
        return contractsAndGrantsBillingAwardMock;
    }

    private ContractsAndGrantsBillingAwardAccount setupAwardAccountMock(String chartOfAccountsCode, String accountNumber, ContractsAndGrantsBillingAward award) {
        ContractsAndGrantsBillingAwardAccount awardAccountMock = (ContractsAndGrantsBillingAwardAccount)Mockito.mock(ContractsAndGrantsBillingAwardAccount.class);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)chartOfAccountsCode);
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)accountNumber);
        Mockito.when((Object)awardAccountMock.getAward()).thenReturn((Object)award);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationSvcMock.isAwardAccountValidToInvoiceBasedOnSchedule(awardAccountMock)).thenReturn((Object)true);
        return awardAccountMock;
    }

    @Test
    public void getPopulatedContractsGrantsInvoiceLookupResults_NoAwards() {
        ArrayList awards = new ArrayList();
        Collection contractsGrantsInvoiceLookupResults = this.cut.getPopulatedContractsGrantsInvoiceLookupResults(awards);
        Assert.assertEquals((long)0L, (long)contractsGrantsInvoiceLookupResults.size());
    }

    @Test
    public void getPopulatedContractsGrantsInvoiceLookupResults_OneAwardTwoAwardAccounts() {
        List<ContractsAndGrantsBillingAward> awards = Collections.singletonList(this.contractsAndGrantsBillingAwardMock1);
        Collection contractsGrantsInvoiceLookupResults = this.cut.getPopulatedContractsGrantsInvoiceLookupResults(awards);
        Assert.assertEquals((long)1L, (long)contractsGrantsInvoiceLookupResults.size());
        ContractsGrantsInvoiceLookupResult contractsGrantsInvoiceLookupResult = (ContractsGrantsInvoiceLookupResult)contractsGrantsInvoiceLookupResults.iterator().next();
        Assert.assertEquals((Object)"A1", (Object)contractsGrantsInvoiceLookupResult.getAgencyNumber());
        Assert.assertEquals((Object)"Agency Reporting Name", (Object)contractsGrantsInvoiceLookupResult.getAgencyReportingName());
        Assert.assertEquals((Object)"Agency Full Name", (Object)contractsGrantsInvoiceLookupResult.getAgencyFullName());
        Assert.assertEquals((Object)"C1", (Object)contractsGrantsInvoiceLookupResult.getCustomerNumber());
        Assert.assertEquals((long)2L, (long)contractsGrantsInvoiceLookupResult.getLookupResultAwards().size());
        int lookupResultAwardCount = 1;
        for (ContractsGrantsInvoiceLookupResultAward contractsGrantsInvoiceLookupResultAward : contractsGrantsInvoiceLookupResult.getLookupResultAwards()) {
            Assert.assertEquals((Object)"1", (Object)contractsGrantsInvoiceLookupResultAward.getProposalNumber());
            Assert.assertEquals((Object)("C" + lookupResultAwardCount), (Object)contractsGrantsInvoiceLookupResultAward.getChartOfAccountsCode());
            Assert.assertEquals((Object)("A" + lookupResultAwardCount), (Object)contractsGrantsInvoiceLookupResultAward.getAccountNumber());
            Assert.assertEquals((Object)this.awardBeginningDate, (Object)contractsGrantsInvoiceLookupResultAward.getAwardBeginningDate());
            Assert.assertEquals((Object)this.awardEndingDate, (Object)contractsGrantsInvoiceLookupResultAward.getAwardEndingDate());
            Assert.assertEquals((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode(), (Object)contractsGrantsInvoiceLookupResultAward.getBillingFrequencyCode());
            Assert.assertEquals((Object)"ITC1-Description", (Object)contractsGrantsInvoiceLookupResultAward.getInstrumentTypeDescription());
            Assert.assertEquals((Object)"Invoicing Option Description 1", (Object)contractsGrantsInvoiceLookupResultAward.getInvoicingOptionDescription());
            Assert.assertEquals((Object)new KualiDecimal(1000.0), (Object)contractsGrantsInvoiceLookupResultAward.getAwardTotalAmount());
            ++lookupResultAwardCount;
        }
    }

    @Test
    public void getPopulatedContractsGrantsInvoiceLookupResults_MultipleAgenciesAwardsAndAwardAccounts() {
        ContractsGrantsInvoiceLookupResultAward contractsGrantsInvoiceLookupResultAward2;
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAwardAccount awardAccountMock5 = this.setupAwardAccountMock("C5", "A5", this.contractsAndGrantsBillingAwardMock2);
        ContractsAndGrantsBillingAwardAccount awardAccountMock6 = this.setupAwardAccountMock("C6", "A6", this.contractsAndGrantsBillingAwardMock3);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationSvcMock.isAwardAccountValidToInvoiceBasedOnSchedule(awardAccountMock5)).thenReturn((Object)false);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationSvcMock.isAwardAccountValidToInvoiceBasedOnSchedule(awardAccountMock6)).thenReturn((Object)false);
        Mockito.when((Object)this.contractsAndGrantsBillingAwardMock2.getActiveAwardAccounts()).thenReturn(Arrays.asList(this.awardAccountMock3, awardAccountMock5));
        Mockito.when((Object)this.contractsAndGrantsBillingAwardMock3.getActiveAwardAccounts()).thenReturn(Arrays.asList(this.awardAccountMock4, awardAccountMock6));
        awards.add(this.contractsAndGrantsBillingAwardMock1);
        awards.add(this.contractsAndGrantsBillingAwardMock2);
        awards.add(this.contractsAndGrantsBillingAwardMock3);
        Collection contractsGrantsInvoiceLookupResults = this.cut.getPopulatedContractsGrantsInvoiceLookupResults(awards);
        Assert.assertEquals((long)2L, (long)contractsGrantsInvoiceLookupResults.size());
        Iterator iter = contractsGrantsInvoiceLookupResults.iterator();
        ContractsGrantsInvoiceLookupResult contractsGrantsInvoiceLookupResult = (ContractsGrantsInvoiceLookupResult)iter.next();
        Assert.assertEquals((Object)"A1", (Object)contractsGrantsInvoiceLookupResult.getAgencyNumber());
        Assert.assertEquals((Object)"Agency Reporting Name", (Object)contractsGrantsInvoiceLookupResult.getAgencyReportingName());
        Assert.assertEquals((Object)"Agency Full Name", (Object)contractsGrantsInvoiceLookupResult.getAgencyFullName());
        Assert.assertEquals((Object)"C1", (Object)contractsGrantsInvoiceLookupResult.getCustomerNumber());
        Assert.assertEquals((long)3L, (long)contractsGrantsInvoiceLookupResult.getLookupResultAwards().size());
        String[] expectedProposalNumbers = new String[]{"1", "1", "2"};
        Date[] expectedAwardBeginningDates = new Date[]{this.awardBeginningDate, this.awardBeginningDate, this.secondAwardBeginningDate};
        Date[] expectedAwardEndingDates = new Date[]{this.awardEndingDate, this.awardEndingDate, this.secondAwardEndingDate};
        String[] expectedBillingFrequencyCodes = new String[]{ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ArConstants.BillingFrequencyValues.MILESTONE.getCode()};
        String[] expectedInstrumentTypeDescriptions = new String[]{"ITC1-Description", "ITC1-Description", "ITC2-Description"};
        String[] expectedInvoicingOptionDescriptions = new String[]{"Invoicing Option Description 1", "Invoicing Option Description 1", "Invoicing Option Description 2"};
        KualiDecimal[] expectedAwardTotalAmounts = new KualiDecimal[]{new KualiDecimal(1000.0), new KualiDecimal(1000.0), new KualiDecimal(2000.0)};
        int lookupResultAwardCount = 1;
        for (ContractsGrantsInvoiceLookupResultAward contractsGrantsInvoiceLookupResultAward2 : contractsGrantsInvoiceLookupResult.getLookupResultAwards()) {
            Assert.assertEquals((Object)expectedProposalNumbers[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward2.getProposalNumber());
            Assert.assertEquals((Object)("C" + lookupResultAwardCount), (Object)contractsGrantsInvoiceLookupResultAward2.getChartOfAccountsCode());
            Assert.assertEquals((Object)("A" + lookupResultAwardCount), (Object)contractsGrantsInvoiceLookupResultAward2.getAccountNumber());
            Assert.assertEquals((Object)expectedAwardBeginningDates[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward2.getAwardBeginningDate());
            Assert.assertEquals((Object)expectedAwardEndingDates[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward2.getAwardEndingDate());
            Assert.assertEquals((Object)expectedBillingFrequencyCodes[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward2.getBillingFrequencyCode());
            Assert.assertEquals((Object)expectedInstrumentTypeDescriptions[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward2.getInstrumentTypeDescription());
            Assert.assertEquals((Object)expectedInvoicingOptionDescriptions[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward2.getInvoicingOptionDescription());
            Assert.assertEquals((Object)expectedAwardTotalAmounts[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward2.getAwardTotalAmount());
            ++lookupResultAwardCount;
        }
        ContractsGrantsInvoiceLookupResult contractsGrantsInvoiceLookupResult2 = (ContractsGrantsInvoiceLookupResult)iter.next();
        Assert.assertEquals((Object)"A2", (Object)contractsGrantsInvoiceLookupResult2.getAgencyNumber());
        Assert.assertEquals((Object)"Agency Reporting Name 2", (Object)contractsGrantsInvoiceLookupResult2.getAgencyReportingName());
        Assert.assertEquals((Object)"Agency Full Name 2", (Object)contractsGrantsInvoiceLookupResult2.getAgencyFullName());
        Assert.assertEquals((Object)"C2", (Object)contractsGrantsInvoiceLookupResult2.getCustomerNumber());
        Assert.assertEquals((long)1L, (long)contractsGrantsInvoiceLookupResult2.getLookupResultAwards().size());
        contractsGrantsInvoiceLookupResultAward2 = (ContractsGrantsInvoiceLookupResultAward)contractsGrantsInvoiceLookupResult2.getLookupResultAwards().iterator().next();
        Assert.assertEquals((Object)"3", (Object)contractsGrantsInvoiceLookupResultAward2.getProposalNumber());
        Assert.assertEquals((Object)"C4", (Object)contractsGrantsInvoiceLookupResultAward2.getChartOfAccountsCode());
        Assert.assertEquals((Object)"A4", (Object)contractsGrantsInvoiceLookupResultAward2.getAccountNumber());
        Assert.assertEquals((Object)this.thirdAwardBeginningDate, (Object)contractsGrantsInvoiceLookupResultAward2.getAwardBeginningDate());
        Assert.assertEquals((Object)this.thirdAwardEndingDate, (Object)contractsGrantsInvoiceLookupResultAward2.getAwardEndingDate());
        Assert.assertEquals((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode(), (Object)contractsGrantsInvoiceLookupResultAward2.getBillingFrequencyCode());
        Assert.assertEquals((Object)"ITC3-Description", (Object)contractsGrantsInvoiceLookupResultAward2.getInstrumentTypeDescription());
        Assert.assertEquals((Object)"Invoicing Option Description 3", (Object)contractsGrantsInvoiceLookupResultAward2.getInvoicingOptionDescription());
        Assert.assertEquals((Object)new KualiDecimal(3000.0), (Object)contractsGrantsInvoiceLookupResultAward2.getAwardTotalAmount());
    }

    @Test
    public void getPopulatedContractsGrantsInvoiceLookupResultsFromAwardAccounts_NoAwardAccounts() {
        ArrayList awardAccounts = new ArrayList();
        Collection contractsGrantsInvoiceLookupResults = this.cut.getPopulatedContractsGrantsInvoiceLookupResultsFromAwardAccounts(awardAccounts);
        Assert.assertEquals((long)0L, (long)contractsGrantsInvoiceLookupResults.size());
    }

    @Test
    public void getPopulatedContractsGrantsInvoiceLookupResultsFromAwardAccounts_TwoAwardAccounts() {
        List<ContractsAndGrantsBillingAwardAccount> awardAccounts = Arrays.asList(this.awardAccountMock1, this.awardAccountMock2);
        Collection contractsGrantsInvoiceLookupResults = this.cut.getPopulatedContractsGrantsInvoiceLookupResultsFromAwardAccounts(awardAccounts);
        Assert.assertEquals((long)1L, (long)contractsGrantsInvoiceLookupResults.size());
        ContractsGrantsInvoiceLookupResult contractsGrantsInvoiceLookupResult = (ContractsGrantsInvoiceLookupResult)contractsGrantsInvoiceLookupResults.iterator().next();
        Assert.assertEquals((Object)"A1", (Object)contractsGrantsInvoiceLookupResult.getAgencyNumber());
        Assert.assertEquals((Object)"Agency Reporting Name", (Object)contractsGrantsInvoiceLookupResult.getAgencyReportingName());
        Assert.assertEquals((Object)"Agency Full Name", (Object)contractsGrantsInvoiceLookupResult.getAgencyFullName());
        Assert.assertEquals((Object)"C1", (Object)contractsGrantsInvoiceLookupResult.getCustomerNumber());
        Assert.assertEquals((long)2L, (long)contractsGrantsInvoiceLookupResult.getLookupResultAwards().size());
        int lookupResultAwardCount = 1;
        for (ContractsGrantsInvoiceLookupResultAward contractsGrantsInvoiceLookupResultAward : contractsGrantsInvoiceLookupResult.getLookupResultAwards()) {
            Assert.assertEquals((Object)"1", (Object)contractsGrantsInvoiceLookupResultAward.getProposalNumber());
            Assert.assertEquals((Object)("C" + lookupResultAwardCount), (Object)contractsGrantsInvoiceLookupResultAward.getChartOfAccountsCode());
            Assert.assertEquals((Object)("A" + lookupResultAwardCount), (Object)contractsGrantsInvoiceLookupResultAward.getAccountNumber());
            Assert.assertEquals((Object)this.awardBeginningDate, (Object)contractsGrantsInvoiceLookupResultAward.getAwardBeginningDate());
            Assert.assertEquals((Object)this.awardEndingDate, (Object)contractsGrantsInvoiceLookupResultAward.getAwardEndingDate());
            Assert.assertEquals((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode(), (Object)contractsGrantsInvoiceLookupResultAward.getBillingFrequencyCode());
            Assert.assertEquals((Object)"ITC1-Description", (Object)contractsGrantsInvoiceLookupResultAward.getInstrumentTypeDescription());
            Assert.assertEquals((Object)"Invoicing Option Description 1", (Object)contractsGrantsInvoiceLookupResultAward.getInvoicingOptionDescription());
            Assert.assertEquals((Object)new KualiDecimal(1000.0), (Object)contractsGrantsInvoiceLookupResultAward.getAwardTotalAmount());
            ++lookupResultAwardCount;
        }
        Assert.assertEquals((long)1L, (long)contractsGrantsInvoiceLookupResult.getAwards().size());
        ContractsAndGrantsBillingAward awardToCompare = (ContractsAndGrantsBillingAward)contractsGrantsInvoiceLookupResult.getAwards().iterator().next();
        Assert.assertEquals((Object)"1", (Object)awardToCompare.getProposalNumber());
        Assert.assertEquals((Object)this.awardBeginningDate, (Object)awardToCompare.getAwardBeginningDate());
        Assert.assertEquals((Object)this.awardEndingDate, (Object)awardToCompare.getAwardEndingDate());
        Assert.assertEquals((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode(), (Object)awardToCompare.getBillingFrequencyCode());
        Assert.assertEquals((Object)"ITC1-Description", (Object)awardToCompare.getInstrumentType().getInstrumentTypeDescription());
        Assert.assertEquals((Object)"Invoicing Option Description 1", (Object)awardToCompare.getInvoicingOptionDescription());
        Assert.assertEquals((Object)new KualiDecimal(1000.0), (Object)awardToCompare.getAwardTotalAmount());
    }

    @Test
    public void getPopulatedContractsGrantsInvoiceLookupResultsFromAwardAccounts_MultipleAgenciesAwardsAndAwardAccounts() {
        List<ContractsAndGrantsBillingAwardAccount> awardAccounts = Arrays.asList(this.awardAccountMock1, this.awardAccountMock2, this.awardAccountMock3, this.awardAccountMock4);
        Collection contractsGrantsInvoiceLookupResults = this.cut.getPopulatedContractsGrantsInvoiceLookupResultsFromAwardAccounts(awardAccounts);
        Assert.assertEquals((long)1L, (long)contractsGrantsInvoiceLookupResults.size());
        Iterator iter = contractsGrantsInvoiceLookupResults.iterator();
        ContractsGrantsInvoiceLookupResult contractsGrantsInvoiceLookupResult = (ContractsGrantsInvoiceLookupResult)iter.next();
        Assert.assertEquals((Object)"A1", (Object)contractsGrantsInvoiceLookupResult.getAgencyNumber());
        Assert.assertEquals((Object)"Agency Reporting Name", (Object)contractsGrantsInvoiceLookupResult.getAgencyReportingName());
        Assert.assertEquals((Object)"Agency Full Name", (Object)contractsGrantsInvoiceLookupResult.getAgencyFullName());
        Assert.assertEquals((Object)"C1", (Object)contractsGrantsInvoiceLookupResult.getCustomerNumber());
        Assert.assertEquals((long)4L, (long)contractsGrantsInvoiceLookupResult.getLookupResultAwards().size());
        String[] expectedProposalNumbers = new String[]{"1", "1", "2", "3"};
        Date[] expectedAwardBeginningDates = new Date[]{this.awardBeginningDate, this.awardBeginningDate, this.secondAwardBeginningDate, this.thirdAwardBeginningDate};
        Date[] expectedAwardEndingDates = new Date[]{this.awardEndingDate, this.awardEndingDate, this.secondAwardEndingDate, this.thirdAwardEndingDate};
        String[] expectedBillingFrequencyCodes = new String[]{ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ArConstants.BillingFrequencyValues.MILESTONE.getCode(), ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode()};
        String[] expectedInstrumentTypeDescriptions = new String[]{"ITC1-Description", "ITC1-Description", "ITC2-Description", "ITC3-Description"};
        String[] expectedInvoicingOptionDescriptions = new String[]{"Invoicing Option Description 1", "Invoicing Option Description 1", "Invoicing Option Description 2", "Invoicing Option Description 3"};
        KualiDecimal[] expectedAwardTotalAmounts = new KualiDecimal[]{new KualiDecimal(1000.0), new KualiDecimal(1000.0), new KualiDecimal(2000.0), new KualiDecimal(3000.0)};
        int lookupResultAwardCount = 1;
        for (ContractsGrantsInvoiceLookupResultAward contractsGrantsInvoiceLookupResultAward : contractsGrantsInvoiceLookupResult.getLookupResultAwards()) {
            Assert.assertEquals((Object)expectedProposalNumbers[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward.getProposalNumber());
            Assert.assertEquals((Object)("C" + lookupResultAwardCount), (Object)contractsGrantsInvoiceLookupResultAward.getChartOfAccountsCode());
            Assert.assertEquals((Object)("A" + lookupResultAwardCount), (Object)contractsGrantsInvoiceLookupResultAward.getAccountNumber());
            Assert.assertEquals((Object)expectedAwardBeginningDates[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward.getAwardBeginningDate());
            Assert.assertEquals((Object)expectedAwardEndingDates[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward.getAwardEndingDate());
            Assert.assertEquals((Object)expectedBillingFrequencyCodes[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward.getBillingFrequencyCode());
            Assert.assertEquals((Object)expectedInstrumentTypeDescriptions[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward.getInstrumentTypeDescription());
            Assert.assertEquals((Object)expectedInvoicingOptionDescriptions[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward.getInvoicingOptionDescription());
            Assert.assertEquals((Object)expectedAwardTotalAmounts[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward.getAwardTotalAmount());
            ++lookupResultAwardCount;
        }
        Collection awards = contractsGrantsInvoiceLookupResult.getAwards();
        Assert.assertEquals((long)3L, (long)awards.size());
        for (ContractsAndGrantsBillingAward contractsAndGrantsBillingAward : awards) {
            int expectedIndex = Integer.parseInt(contractsAndGrantsBillingAward.getProposalNumber());
            Assert.assertEquals((Object)expectedProposalNumbers[expectedIndex], (Object)contractsAndGrantsBillingAward.getProposalNumber());
            Assert.assertEquals((Object)expectedAwardBeginningDates[expectedIndex], (Object)contractsAndGrantsBillingAward.getAwardBeginningDate());
            Assert.assertEquals((Object)expectedAwardEndingDates[expectedIndex], (Object)contractsAndGrantsBillingAward.getAwardEndingDate());
            Assert.assertEquals((Object)expectedBillingFrequencyCodes[expectedIndex], (Object)contractsAndGrantsBillingAward.getBillingFrequencyCode());
            Assert.assertEquals((Object)expectedInstrumentTypeDescriptions[expectedIndex], (Object)contractsAndGrantsBillingAward.getInstrumentType().getInstrumentTypeDescription());
            Assert.assertEquals((Object)expectedInvoicingOptionDescriptions[expectedIndex], (Object)contractsAndGrantsBillingAward.getInvoicingOptionDescription());
            Assert.assertEquals((Object)expectedAwardTotalAmounts[expectedIndex], (Object)contractsAndGrantsBillingAward.getAwardTotalAmount());
        }
    }
}

