/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.kfs.module.ar.service.impl.AccountsReceivableModuleBillingServiceImpl;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AccountsReceivableModuleBillingServiceTest {
    private AccountsReceivableModuleBillingServiceImpl cut;
    @Mock
    private BusinessObjectService businessObjectSvcMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.setupMilestoneSchedule("1", "BL", "0211801", false, true);
        this.setupMilestoneSchedule("1", "BL", "0211802", true, false);
        this.setupMilestoneSchedule("2", "BA", "0211801", true, true);
        this.setupMilestoneSchedule("2", "BA", "0211802", false, false);
        this.setupPredeterminedBillingSchedule("3", "BL", "0211801", false, true);
        this.setupPredeterminedBillingSchedule("3", "BL", "0211802", true, false);
        this.setupPredeterminedBillingSchedule("4", "BA", "0211801", true, true);
        this.setupPredeterminedBillingSchedule("4", "BA", "0211802", false, false);
        this.cut = new AccountsReceivableModuleBillingServiceImpl();
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
    }

    private void setupMilestoneSchedule(String proposalNumber, String chartOfAccountsCode, String accountNumber, boolean billed, boolean active) {
        Milestone milestone = new Milestone();
        milestone.setProposalNumber(proposalNumber);
        milestone.setMilestoneNumber(proposalNumber);
        milestone.setMilestoneIdentifier(Long.valueOf(Long.parseLong(proposalNumber) + 1000L));
        milestone.setBilled(billed);
        milestone.setActive(active);
        MilestoneSchedule milestoneSchedule = new MilestoneSchedule();
        milestoneSchedule.setProposalNumber(proposalNumber);
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        milestones.add(milestone);
        milestoneSchedule.setMilestones(milestones);
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalNumber", proposalNumber);
        primaryKeys.put("chartOfAccountsCode", chartOfAccountsCode);
        primaryKeys.put("accountNumber", accountNumber);
        Mockito.when((Object)this.businessObjectSvcMock.findByPrimaryKey(MilestoneSchedule.class, primaryKeys)).thenReturn((Object)milestoneSchedule);
    }

    private void setupPredeterminedBillingSchedule(String proposalNumber, String chartOfAccountsCode, String accountNumber, boolean billed, boolean active) {
        Bill bill = new Bill();
        bill.setProposalNumber(proposalNumber);
        bill.setBillNumber(proposalNumber);
        bill.setBillIdentifier(Long.valueOf(Long.parseLong(proposalNumber) + 1000L));
        bill.setBilled(billed);
        bill.setActive(active);
        PredeterminedBillingSchedule predeterminedBillingSchedule = new PredeterminedBillingSchedule();
        predeterminedBillingSchedule.setProposalNumber(proposalNumber);
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(bill);
        predeterminedBillingSchedule.setBills(bills);
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalNumber", proposalNumber);
        primaryKeys.put("chartOfAccountsCode", chartOfAccountsCode);
        primaryKeys.put("accountNumber", accountNumber);
        Mockito.when((Object)this.businessObjectSvcMock.findByPrimaryKey(PredeterminedBillingSchedule.class, primaryKeys)).thenReturn((Object)predeterminedBillingSchedule);
    }

    @Test
    public void hasActiveUnbilledBills() {
        TestCase.assertTrue((boolean)this.cut.hasActiveUnbilledBills("3", "BL", "0211801"));
        Assert.assertFalse((boolean)this.cut.hasActiveUnbilledBills("3", "BL", "0211802"));
        Assert.assertFalse((boolean)this.cut.hasActiveUnbilledBills("4", "BA", "0211801"));
        Assert.assertFalse((boolean)this.cut.hasActiveUnbilledBills("4", "BA", "0211802"));
        Assert.assertFalse((boolean)this.cut.hasActiveUnbilledBills("111", "XX", "1234567"));
    }

    @Test
    public void hasPredeterminedBillingSchedule() {
        TestCase.assertTrue((boolean)this.cut.hasPredeterminedBillingSchedule("3", "BL", "0211801"));
        TestCase.assertTrue((boolean)this.cut.hasPredeterminedBillingSchedule("4", "BA", "0211802"));
        Assert.assertFalse((boolean)this.cut.hasPredeterminedBillingSchedule("111", "XX", "1234567"));
    }

    @Test
    public void hasActiveUnbilledMilestones() {
        TestCase.assertTrue((boolean)this.cut.hasActiveUnbilledMilestones("1", "BL", "0211801"));
        Assert.assertFalse((boolean)this.cut.hasActiveUnbilledMilestones("1", "BL", "0211802"));
        Assert.assertFalse((boolean)this.cut.hasActiveUnbilledMilestones("2", "BA", "0211801"));
        Assert.assertFalse((boolean)this.cut.hasActiveUnbilledMilestones("2", "BA", "0211802"));
        Assert.assertFalse((boolean)this.cut.hasActiveUnbilledMilestones("111", "XX", "1234567"));
    }

    @Test
    public void hasMilestoneSchedule() {
        TestCase.assertTrue((boolean)this.cut.hasMilestoneSchedule("1", "BL", "0211801"));
        TestCase.assertTrue((boolean)this.cut.hasMilestoneSchedule("2", "BA", "0211802"));
        Assert.assertFalse((boolean)this.cut.hasMilestoneSchedule("111", "XX", "1234567"));
    }

    @Test
    public void getMilestoneTotalAmount_HasNoMilestones() {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Milestone.class, fieldValues)).thenReturn(Collections.emptyList());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)this.cut.getMilestonesTotalAmount("1"));
    }

    @Test
    public void getMilestoneTotalAmount_HasMilestones() {
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        milestones.add(this.setupMilestone(new KualiDecimal(1000), "BL", "1234567"));
        milestones.add(this.setupMilestone(new KualiDecimal(2000), "BL", "2345678"));
        milestones.add(this.setupMilestone(new KualiDecimal(500), "BA", "1234567"));
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Milestone.class, fieldValues)).thenReturn(milestones);
        Assert.assertEquals((Object)new KualiDecimal(3500.0), (Object)this.cut.getMilestonesTotalAmount("1"));
    }

    @Test
    public void getMilestonesTotalAmountForOtherSchedules_HasNoOtherMilestones_CurrentScheduleNotPersisted() {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Milestone.class, fieldValues)).thenReturn(Collections.emptyList());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)this.cut.getMilestonesTotalAmountForOtherSchedules("1", "BL", "1234567"));
    }

    @Test
    public void getMilestonesTotalAmountForOtherSchedules_HasNoOtherMilestones_CurrentSchedulePersisted() {
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        milestones.add(this.setupMilestone(new KualiDecimal(1000), "BL", "1234567"));
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Milestone.class, fieldValues)).thenReturn(milestones);
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)this.cut.getMilestonesTotalAmountForOtherSchedules("1", "BL", "1234567"));
    }

    @Test
    public void getMilestonesTotalAmountForOtherSchedules_HasOtherMilestones() {
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        milestones.add(this.setupMilestone(new KualiDecimal(1000), "BL", "1234567"));
        milestones.add(this.setupMilestone(new KualiDecimal(2000), "BL", "2345678"));
        milestones.add(this.setupMilestone(new KualiDecimal(500), "BA", "1234567"));
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Milestone.class, fieldValues)).thenReturn(milestones);
        Assert.assertEquals((Object)new KualiDecimal(2500.0), (Object)this.cut.getMilestonesTotalAmountForOtherSchedules("1", "BL", "1234567"));
    }

    @Test
    public void getMilestonesTotalAmountForOtherSchedules_HasOtherMilestones_OneWithNullAmount_DoesNotThrowException() {
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        milestones.add(this.setupMilestone(new KualiDecimal(1000), "BL", "1234567"));
        milestones.add(this.setupMilestone(new KualiDecimal(2000), "BL", "2345678"));
        milestones.add(this.setupMilestone(null, "BA", "1234567"));
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Milestone.class, fieldValues)).thenReturn(milestones);
        Assert.assertEquals((Object)new KualiDecimal(2000.0), (Object)this.cut.getMilestonesTotalAmountForOtherSchedules("1", "BL", "1234567"));
    }

    private Milestone setupMilestone(KualiDecimal milestoneAmount, String chartOfAccountsCode, String accountNumber) {
        Milestone milestone = new Milestone();
        milestone.setMilestoneAmount(milestoneAmount);
        milestone.setChartOfAccountsCode(chartOfAccountsCode);
        milestone.setAccountNumber(accountNumber);
        return milestone;
    }

    @Test
    public void getBillTotalAmount_HasNoBills() {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Bill.class, fieldValues)).thenReturn(Collections.emptyList());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)this.cut.getBillsTotalAmount("1"));
    }

    @Test
    public void getBillTotalAmount_HasBills() {
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(this.setupBill(new KualiDecimal(1000), "BL", "1234567"));
        bills.add(this.setupBill(new KualiDecimal(2000), "BL", "2345678"));
        bills.add(this.setupBill(new KualiDecimal(500), "BA", "1234567"));
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Bill.class, fieldValues)).thenReturn(bills);
        Assert.assertEquals((Object)new KualiDecimal(3500.0), (Object)this.cut.getBillsTotalAmount("1"));
    }

    @Test
    public void getBillsTotalAmountForOtherSchedules_HasNoOtherBills_CurrentScheduleNotPersisted() {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Bill.class, fieldValues)).thenReturn(Collections.emptyList());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)this.cut.getBillsTotalAmountForOtherSchedules("1", "BL", "1234567"));
    }

    @Test
    public void getBillsTotalAmountForOtherSchedules_HasNoOtherBills_CurrentSchedulePersisted() {
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(this.setupBill(new KualiDecimal(1000), "BL", "1234567"));
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Bill.class, fieldValues)).thenReturn(bills);
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)this.cut.getBillsTotalAmountForOtherSchedules("1", "BL", "1234567"));
    }

    @Test
    public void getBillsTotalAmountForOtherSchedules_HasOtherBills() {
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(this.setupBill(new KualiDecimal(1000), "BL", "1234567"));
        bills.add(this.setupBill(new KualiDecimal(2000), "BL", "2345678"));
        bills.add(this.setupBill(new KualiDecimal(500), "BA", "1234567"));
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Bill.class, fieldValues)).thenReturn(bills);
        Assert.assertEquals((Object)new KualiDecimal(2500.0), (Object)this.cut.getBillsTotalAmountForOtherSchedules("1", "BL", "1234567"));
    }

    @Test
    public void getBillsTotalAmountForOtherSchedules_HasOtherBills_OneWithNullAmount_DoesNotThrowException() {
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(this.setupBill(new KualiDecimal(1000), "BL", "1234567"));
        bills.add(this.setupBill(new KualiDecimal(2000), "BL", "2345678"));
        bills.add(this.setupBill(null, "BA", "1234567"));
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", "1");
        fieldValues.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Bill.class, fieldValues)).thenReturn(bills);
        Assert.assertEquals((Object)new KualiDecimal(2000.0), (Object)this.cut.getBillsTotalAmountForOtherSchedules("1", "BL", "1234567"));
    }

    private Bill setupBill(KualiDecimal estimatedAmount, String chartOfAccountsCode, String accountNumber) {
        Bill bill = new Bill();
        bill.setEstimatedAmount(estimatedAmount);
        bill.setChartOfAccountsCode(chartOfAccountsCode);
        bill.setAccountNumber(accountNumber);
        return bill;
    }
}

