/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service;

import org.kuali.kfs.module.ar.businessobject.CostCategory;
import org.kuali.kfs.module.ar.businessobject.CostCategoryDetail;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectCode;
import org.kuali.kfs.module.ar.businessobject.CostCategoryObjectLevel;
import org.kuali.kfs.module.ar.dataaccess.CostCategoryDao;
import org.kuali.kfs.module.ar.service.CostCategoryService;
import org.kuali.kfs.module.ar.service.impl.CostCategoryServiceImpl;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CostCategoryServiceTest
extends KualiTestBase {
    protected CostCategoryService costCategoryService;

    public void setUp() {
        this.costCategoryService = new CostCategoryServiceImpl();
        ((CostCategoryServiceImpl)this.costCategoryService).setCostCategoryDao((CostCategoryDao)SpringContext.getBean(CostCategoryDao.class));
    }

    public void testObjectCodeUniqueness() {
        CostCategoryObjectCode test1 = this.buildCostCategoryObjectCode("4000");
        CostCategoryDetail test1ConflictingDetail = this.costCategoryService.isCostCategoryObjectCodeUnique(test1);
        CostCategoryServiceTest.assertNotNull((String)"YYYY-BL-4000 should not be unique", (Object)test1ConflictingDetail);
        CostCategoryObjectCode test2 = this.buildCostCategoryObjectCode("2000");
        CostCategoryDetail test2ConflictingDetail = this.costCategoryService.isCostCategoryObjectCodeUnique(test2);
        CostCategoryServiceTest.assertNotNull((String)"YYYY-BL-2000 should not be unique", (Object)test2ConflictingDetail);
        CostCategoryObjectCode test3 = this.buildCostCategoryObjectCode("9041");
        CostCategoryDetail test3ConflictingDetail = this.costCategoryService.isCostCategoryObjectCodeUnique(test3);
        CostCategoryServiceTest.assertNull((String)"YYYY-BL-9041 should be unique", (Object)test3ConflictingDetail);
    }

    protected CostCategoryObjectCode buildCostCategoryObjectCode(String financialObjectCode) {
        CostCategoryObjectCode test = new CostCategoryObjectCode();
        test.setCategoryCode("YYYY");
        test.setChartOfAccountsCode("BL");
        test.setFinancialObjectCode(financialObjectCode);
        test.refreshReferenceObject("objectCodeCurrent");
        return test;
    }

    public void testObjectLevelUniqueness() {
        CostCategoryObjectLevel test1 = this.buildCostCategoryObjectLevel("ACSA");
        CostCategoryDetail test1ConflictingDetail = this.costCategoryService.isCostCategoryObjectLevelUnique(test1);
        CostCategoryServiceTest.assertNotNull((String)"Cost Category Object Level YYYY-BL-ACSA is not unique", (Object)test1ConflictingDetail);
        CostCategoryObjectLevel test2 = this.buildCostCategoryObjectLevel("TAX");
        CostCategoryDetail test2ConflictingDetail = this.costCategoryService.isCostCategoryObjectLevelUnique(test2);
        CostCategoryServiceTest.assertNull((String)"Cost Category Object Level YYYY-BL-TAX is unique", (Object)test2ConflictingDetail);
    }

    protected CostCategoryObjectLevel buildCostCategoryObjectLevel(String objectLevelCode) {
        CostCategoryObjectLevel test = new CostCategoryObjectLevel();
        test.setCategoryCode("YYYY");
        test.setChartOfAccountsCode("BL");
        test.setFinancialObjectLevelCode(objectLevelCode);
        return test;
    }

    public void testFindCostCategory() {
        CostCategory costCategory1 = this.costCategoryService.getCostCategoryForObjectCode(TestUtils.getFiscalYearForTesting(), "BL", "4000");
        CostCategoryServiceTest.assertNotNull((String)("There should be a cost category for object code " + TestUtils.getFiscalYearForTesting() + "-BL-4000"), (Object)costCategory1);
        CostCategory costCategory2 = this.costCategoryService.getCostCategoryForObjectCode(TestUtils.getFiscalYearForTesting(), "BL", "ZZZZ");
        CostCategoryServiceTest.assertNull((String)("There should NOT be a cost category for object code " + TestUtils.getFiscalYearForTesting() + "-BL-ZZZZ"), (Object)costCategory2);
    }
}

